// services/device/public/mojom/nfc.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/device/public/mojom/nfc.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('device.mojom');


  var NDEFErrorType = {};
  NDEFErrorType.NOT_ALLOWED = 0;
  NDEFErrorType.NOT_SUPPORTED = 1;
  NDEFErrorType.NOT_READABLE = 2;
  NDEFErrorType.INVALID_MESSAGE = 3;
  NDEFErrorType.OPERATION_CANCELLED = 4;
  NDEFErrorType.IO_ERROR = 5;
  NDEFErrorType.MIN_VALUE = 0;
  NDEFErrorType.MAX_VALUE = 5;

  NDEFErrorType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  NDEFErrorType.toKnownEnumValue = function(value) {
    return value;
  };

  NDEFErrorType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var NDEFRecordTypeCategory = {};
  NDEFRecordTypeCategory.kStandardized = 0;
  NDEFRecordTypeCategory.kExternal = 1;
  NDEFRecordTypeCategory.kLocal = 2;
  NDEFRecordTypeCategory.MIN_VALUE = 0;
  NDEFRecordTypeCategory.MAX_VALUE = 2;

  NDEFRecordTypeCategory.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  NDEFRecordTypeCategory.toKnownEnumValue = function(value) {
    return value;
  };

  NDEFRecordTypeCategory.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function NDEFError(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NDEFError.prototype.initDefaults_ = function() {
    this.errorType = 0;
    this.errorMessage = null;
  };
  NDEFError.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NDEFError.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NDEFError.errorType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, NDEFErrorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NDEFError.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NDEFError.encodedSize = codec.kStructHeaderSize + 16;

  NDEFError.decode = function(decoder) {
    var packed;
    var val = new NDEFError();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorType =
        decoder.decodeStruct(new codec.Enum(NDEFErrorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  NDEFError.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NDEFError.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.errorType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };
  function NDEFRecord(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NDEFRecord.prototype.initDefaults_ = function() {
    this.category = 0;
    this.recordType = null;
    this.mediaType = null;
    this.id = null;
    this.encoding = null;
    this.lang = null;
    this.data = null;
    this.payloadMessage = null;
  };
  NDEFRecord.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NDEFRecord.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NDEFRecord.category
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, NDEFRecordTypeCategory);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NDEFRecord.recordType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NDEFRecord.mediaType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NDEFRecord.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NDEFRecord.encoding
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NDEFRecord.lang
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NDEFRecord.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NDEFRecord.payloadMessage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, NDEFMessage, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NDEFRecord.encodedSize = codec.kStructHeaderSize + 64;

  NDEFRecord.decode = function(decoder) {
    var packed;
    var val = new NDEFRecord();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.category =
        decoder.decodeStruct(new codec.Enum(NDEFRecordTypeCategory));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.recordType =
        decoder.decodeStruct(codec.String);
    val.mediaType =
        decoder.decodeStruct(codec.String);
    val.id =
        decoder.decodeStruct(codec.String);
    val.encoding =
        decoder.decodeStruct(codec.String);
    val.lang =
        decoder.decodeStruct(codec.String);
    val.data =
        decoder.decodeArrayPointer(codec.Uint8);
    val.payloadMessage =
        decoder.decodeStructPointer(NDEFMessage);
    return val;
  };

  NDEFRecord.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NDEFRecord.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.category);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.recordType);
    encoder.encodeStruct(codec.String, val.mediaType);
    encoder.encodeStruct(codec.String, val.id);
    encoder.encodeStruct(codec.String, val.encoding);
    encoder.encodeStruct(codec.String, val.lang);
    encoder.encodeArrayPointer(codec.Uint8, val.data);
    encoder.encodeStructPointer(NDEFMessage, val.payloadMessage);
  };
  function NDEFMessage(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NDEFMessage.prototype.initDefaults_ = function() {
    this.data = null;
  };
  NDEFMessage.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NDEFMessage.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NDEFMessage.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(NDEFRecord), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NDEFMessage.encodedSize = codec.kStructHeaderSize + 8;

  NDEFMessage.decode = function(decoder) {
    var packed;
    var val = new NDEFMessage();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeArrayPointer(new codec.PointerTo(NDEFRecord));
    return val;
  };

  NDEFMessage.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NDEFMessage.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(NDEFRecord), val.data);
  };
  function NDEFWriteOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NDEFWriteOptions.prototype.initDefaults_ = function() {
    this.overwrite = false;
  };
  NDEFWriteOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NDEFWriteOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NDEFWriteOptions.encodedSize = codec.kStructHeaderSize + 8;

  NDEFWriteOptions.decode = function(decoder) {
    var packed;
    var val = new NDEFWriteOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.overwrite = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NDEFWriteOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NDEFWriteOptions.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.overwrite & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NFC_SetClient_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFC_SetClient_Params.prototype.initDefaults_ = function() {
    this.client = new NFCClientPtr();
  };
  NFC_SetClient_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFC_SetClient_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NFC_SetClient_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NFC_SetClient_Params.encodedSize = codec.kStructHeaderSize + 8;

  NFC_SetClient_Params.decode = function(decoder) {
    var packed;
    var val = new NFC_SetClient_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(new codec.Interface(NFCClientPtr));
    return val;
  };

  NFC_SetClient_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFC_SetClient_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(NFCClientPtr), val.client);
  };
  function NFC_Push_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFC_Push_Params.prototype.initDefaults_ = function() {
    this.message = null;
    this.options = null;
  };
  NFC_Push_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFC_Push_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NFC_Push_Params.message
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, NDEFMessage, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NFC_Push_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, NDEFWriteOptions, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NFC_Push_Params.encodedSize = codec.kStructHeaderSize + 16;

  NFC_Push_Params.decode = function(decoder) {
    var packed;
    var val = new NFC_Push_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.message =
        decoder.decodeStructPointer(NDEFMessage);
    val.options =
        decoder.decodeStructPointer(NDEFWriteOptions);
    return val;
  };

  NFC_Push_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFC_Push_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(NDEFMessage, val.message);
    encoder.encodeStructPointer(NDEFWriteOptions, val.options);
  };
  function NFC_Push_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFC_Push_ResponseParams.prototype.initDefaults_ = function() {
    this.error = null;
  };
  NFC_Push_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFC_Push_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NFC_Push_ResponseParams.error
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, NDEFError, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NFC_Push_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NFC_Push_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NFC_Push_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStructPointer(NDEFError);
    return val;
  };

  NFC_Push_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFC_Push_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(NDEFError, val.error);
  };
  function NFC_CancelPush_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFC_CancelPush_Params.prototype.initDefaults_ = function() {
  };
  NFC_CancelPush_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFC_CancelPush_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NFC_CancelPush_Params.encodedSize = codec.kStructHeaderSize + 0;

  NFC_CancelPush_Params.decode = function(decoder) {
    var packed;
    var val = new NFC_CancelPush_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NFC_CancelPush_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFC_CancelPush_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NFC_MakeReadOnly_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFC_MakeReadOnly_Params.prototype.initDefaults_ = function() {
  };
  NFC_MakeReadOnly_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFC_MakeReadOnly_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NFC_MakeReadOnly_Params.encodedSize = codec.kStructHeaderSize + 0;

  NFC_MakeReadOnly_Params.decode = function(decoder) {
    var packed;
    var val = new NFC_MakeReadOnly_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NFC_MakeReadOnly_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFC_MakeReadOnly_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NFC_MakeReadOnly_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFC_MakeReadOnly_ResponseParams.prototype.initDefaults_ = function() {
    this.error = null;
  };
  NFC_MakeReadOnly_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFC_MakeReadOnly_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NFC_MakeReadOnly_ResponseParams.error
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, NDEFError, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NFC_MakeReadOnly_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NFC_MakeReadOnly_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NFC_MakeReadOnly_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStructPointer(NDEFError);
    return val;
  };

  NFC_MakeReadOnly_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFC_MakeReadOnly_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(NDEFError, val.error);
  };
  function NFC_CancelMakeReadOnly_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFC_CancelMakeReadOnly_Params.prototype.initDefaults_ = function() {
  };
  NFC_CancelMakeReadOnly_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFC_CancelMakeReadOnly_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NFC_CancelMakeReadOnly_Params.encodedSize = codec.kStructHeaderSize + 0;

  NFC_CancelMakeReadOnly_Params.decode = function(decoder) {
    var packed;
    var val = new NFC_CancelMakeReadOnly_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NFC_CancelMakeReadOnly_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFC_CancelMakeReadOnly_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NFC_Watch_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFC_Watch_Params.prototype.initDefaults_ = function() {
    this.id = 0;
  };
  NFC_Watch_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFC_Watch_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NFC_Watch_Params.encodedSize = codec.kStructHeaderSize + 8;

  NFC_Watch_Params.decode = function(decoder) {
    var packed;
    var val = new NFC_Watch_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NFC_Watch_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFC_Watch_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.id);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NFC_Watch_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFC_Watch_ResponseParams.prototype.initDefaults_ = function() {
    this.error = null;
  };
  NFC_Watch_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFC_Watch_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NFC_Watch_ResponseParams.error
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, NDEFError, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NFC_Watch_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NFC_Watch_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NFC_Watch_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStructPointer(NDEFError);
    return val;
  };

  NFC_Watch_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFC_Watch_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(NDEFError, val.error);
  };
  function NFC_CancelWatch_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFC_CancelWatch_Params.prototype.initDefaults_ = function() {
    this.id = 0;
  };
  NFC_CancelWatch_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFC_CancelWatch_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NFC_CancelWatch_Params.encodedSize = codec.kStructHeaderSize + 8;

  NFC_CancelWatch_Params.decode = function(decoder) {
    var packed;
    var val = new NFC_CancelWatch_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NFC_CancelWatch_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFC_CancelWatch_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.id);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NFCClient_OnWatch_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFCClient_OnWatch_Params.prototype.initDefaults_ = function() {
    this.watchIds = null;
    this.serialNumber = null;
    this.message = null;
  };
  NFCClient_OnWatch_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFCClient_OnWatch_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NFCClient_OnWatch_Params.watchIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NFCClient_OnWatch_Params.serialNumber
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NFCClient_OnWatch_Params.message
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, NDEFMessage, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NFCClient_OnWatch_Params.encodedSize = codec.kStructHeaderSize + 24;

  NFCClient_OnWatch_Params.decode = function(decoder) {
    var packed;
    var val = new NFCClient_OnWatch_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.watchIds =
        decoder.decodeArrayPointer(codec.Uint32);
    val.serialNumber =
        decoder.decodeStruct(codec.String);
    val.message =
        decoder.decodeStructPointer(NDEFMessage);
    return val;
  };

  NFCClient_OnWatch_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFCClient_OnWatch_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint32, val.watchIds);
    encoder.encodeStruct(codec.String, val.serialNumber);
    encoder.encodeStructPointer(NDEFMessage, val.message);
  };
  function NFCClient_OnError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFCClient_OnError_Params.prototype.initDefaults_ = function() {
    this.error = null;
  };
  NFCClient_OnError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFCClient_OnError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NFCClient_OnError_Params.error
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, NDEFError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NFCClient_OnError_Params.encodedSize = codec.kStructHeaderSize + 8;

  NFCClient_OnError_Params.decode = function(decoder) {
    var packed;
    var val = new NFCClient_OnError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStructPointer(NDEFError);
    return val;
  };

  NFCClient_OnError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFCClient_OnError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(NDEFError, val.error);
  };
  var kNFC_SetClient_Name = 0;
  var kNFC_Push_Name = 1;
  var kNFC_CancelPush_Name = 2;
  var kNFC_MakeReadOnly_Name = 3;
  var kNFC_CancelMakeReadOnly_Name = 4;
  var kNFC_Watch_Name = 5;
  var kNFC_CancelWatch_Name = 6;

  function NFCPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(NFC,
                                                   handleOrPtrInfo);
  }

  function NFCAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        NFC, associatedInterfacePtrInfo);
  }

  NFCAssociatedPtr.prototype =
      Object.create(NFCPtr.prototype);
  NFCAssociatedPtr.prototype.constructor =
      NFCAssociatedPtr;

  function NFCProxy(receiver) {
    this.receiver_ = receiver;
  }
  NFCPtr.prototype.setClient = function() {
    return NFCProxy.prototype.setClient
        .apply(this.ptr.getProxy(), arguments);
  };

  NFCProxy.prototype.setClient = function(client) {
    var params_ = new NFC_SetClient_Params();
    params_.client = client;
    var builder = new codec.MessageV0Builder(
        kNFC_SetClient_Name,
        codec.align(NFC_SetClient_Params.encodedSize));
    builder.encodeStruct(NFC_SetClient_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NFCPtr.prototype.push = function() {
    return NFCProxy.prototype.push
        .apply(this.ptr.getProxy(), arguments);
  };

  NFCProxy.prototype.push = function(message, options) {
    var params_ = new NFC_Push_Params();
    params_.message = message;
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNFC_Push_Name,
          codec.align(NFC_Push_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NFC_Push_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NFC_Push_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NFCPtr.prototype.cancelPush = function() {
    return NFCProxy.prototype.cancelPush
        .apply(this.ptr.getProxy(), arguments);
  };

  NFCProxy.prototype.cancelPush = function() {
    var params_ = new NFC_CancelPush_Params();
    var builder = new codec.MessageV0Builder(
        kNFC_CancelPush_Name,
        codec.align(NFC_CancelPush_Params.encodedSize));
    builder.encodeStruct(NFC_CancelPush_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NFCPtr.prototype.makeReadOnly = function() {
    return NFCProxy.prototype.makeReadOnly
        .apply(this.ptr.getProxy(), arguments);
  };

  NFCProxy.prototype.makeReadOnly = function() {
    var params_ = new NFC_MakeReadOnly_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNFC_MakeReadOnly_Name,
          codec.align(NFC_MakeReadOnly_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NFC_MakeReadOnly_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NFC_MakeReadOnly_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NFCPtr.prototype.cancelMakeReadOnly = function() {
    return NFCProxy.prototype.cancelMakeReadOnly
        .apply(this.ptr.getProxy(), arguments);
  };

  NFCProxy.prototype.cancelMakeReadOnly = function() {
    var params_ = new NFC_CancelMakeReadOnly_Params();
    var builder = new codec.MessageV0Builder(
        kNFC_CancelMakeReadOnly_Name,
        codec.align(NFC_CancelMakeReadOnly_Params.encodedSize));
    builder.encodeStruct(NFC_CancelMakeReadOnly_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NFCPtr.prototype.watch = function() {
    return NFCProxy.prototype.watch
        .apply(this.ptr.getProxy(), arguments);
  };

  NFCProxy.prototype.watch = function(id) {
    var params_ = new NFC_Watch_Params();
    params_.id = id;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNFC_Watch_Name,
          codec.align(NFC_Watch_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NFC_Watch_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NFC_Watch_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NFCPtr.prototype.cancelWatch = function() {
    return NFCProxy.prototype.cancelWatch
        .apply(this.ptr.getProxy(), arguments);
  };

  NFCProxy.prototype.cancelWatch = function(id) {
    var params_ = new NFC_CancelWatch_Params();
    params_.id = id;
    var builder = new codec.MessageV0Builder(
        kNFC_CancelWatch_Name,
        codec.align(NFC_CancelWatch_Params.encodedSize));
    builder.encodeStruct(NFC_CancelWatch_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function NFCStub(delegate) {
    this.delegate_ = delegate;
  }
  NFCStub.prototype.setClient = function(client) {
    return this.delegate_ && this.delegate_.setClient && this.delegate_.setClient(client);
  }
  NFCStub.prototype.push = function(message, options) {
    return this.delegate_ && this.delegate_.push && this.delegate_.push(message, options);
  }
  NFCStub.prototype.cancelPush = function() {
    return this.delegate_ && this.delegate_.cancelPush && this.delegate_.cancelPush();
  }
  NFCStub.prototype.makeReadOnly = function() {
    return this.delegate_ && this.delegate_.makeReadOnly && this.delegate_.makeReadOnly();
  }
  NFCStub.prototype.cancelMakeReadOnly = function() {
    return this.delegate_ && this.delegate_.cancelMakeReadOnly && this.delegate_.cancelMakeReadOnly();
  }
  NFCStub.prototype.watch = function(id) {
    return this.delegate_ && this.delegate_.watch && this.delegate_.watch(id);
  }
  NFCStub.prototype.cancelWatch = function(id) {
    return this.delegate_ && this.delegate_.cancelWatch && this.delegate_.cancelWatch(id);
  }

  NFCStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNFC_SetClient_Name:
      var params = reader.decodeStruct(NFC_SetClient_Params);
      this.setClient(params.client);
      return true;
    case kNFC_CancelPush_Name:
      var params = reader.decodeStruct(NFC_CancelPush_Params);
      this.cancelPush();
      return true;
    case kNFC_CancelMakeReadOnly_Name:
      var params = reader.decodeStruct(NFC_CancelMakeReadOnly_Params);
      this.cancelMakeReadOnly();
      return true;
    case kNFC_CancelWatch_Name:
      var params = reader.decodeStruct(NFC_CancelWatch_Params);
      this.cancelWatch(params.id);
      return true;
    default:
      return false;
    }
  };

  NFCStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNFC_Push_Name:
      var params = reader.decodeStruct(NFC_Push_Params);
      this.push(params.message, params.options).then(function(response) {
        var responseParams =
            new NFC_Push_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kNFC_Push_Name,
            codec.align(NFC_Push_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NFC_Push_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNFC_MakeReadOnly_Name:
      var params = reader.decodeStruct(NFC_MakeReadOnly_Params);
      this.makeReadOnly().then(function(response) {
        var responseParams =
            new NFC_MakeReadOnly_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kNFC_MakeReadOnly_Name,
            codec.align(NFC_MakeReadOnly_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NFC_MakeReadOnly_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNFC_Watch_Name:
      var params = reader.decodeStruct(NFC_Watch_Params);
      this.watch(params.id).then(function(response) {
        var responseParams =
            new NFC_Watch_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kNFC_Watch_Name,
            codec.align(NFC_Watch_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NFC_Watch_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateNFCRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kNFC_SetClient_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NFC_SetClient_Params;
      break;
      case kNFC_Push_Name:
        if (message.expectsResponse())
          paramsClass = NFC_Push_Params;
      break;
      case kNFC_CancelPush_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NFC_CancelPush_Params;
      break;
      case kNFC_MakeReadOnly_Name:
        if (message.expectsResponse())
          paramsClass = NFC_MakeReadOnly_Params;
      break;
      case kNFC_CancelMakeReadOnly_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NFC_CancelMakeReadOnly_Params;
      break;
      case kNFC_Watch_Name:
        if (message.expectsResponse())
          paramsClass = NFC_Watch_Params;
      break;
      case kNFC_CancelWatch_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NFC_CancelWatch_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateNFCResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kNFC_Push_Name:
        if (message.isResponse())
          paramsClass = NFC_Push_ResponseParams;
        break;
      case kNFC_MakeReadOnly_Name:
        if (message.isResponse())
          paramsClass = NFC_MakeReadOnly_ResponseParams;
        break;
      case kNFC_Watch_Name:
        if (message.isResponse())
          paramsClass = NFC_Watch_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var NFC = {
    name: 'device.mojom.NFC',
    kVersion: 0,
    ptrClass: NFCPtr,
    proxyClass: NFCProxy,
    stubClass: NFCStub,
    validateRequest: validateNFCRequest,
    validateResponse: validateNFCResponse,
  };
  NFCStub.prototype.validator = validateNFCRequest;
  NFCProxy.prototype.validator = validateNFCResponse;
  var kNFCClient_OnWatch_Name = 0;
  var kNFCClient_OnError_Name = 1;

  function NFCClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(NFCClient,
                                                   handleOrPtrInfo);
  }

  function NFCClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        NFCClient, associatedInterfacePtrInfo);
  }

  NFCClientAssociatedPtr.prototype =
      Object.create(NFCClientPtr.prototype);
  NFCClientAssociatedPtr.prototype.constructor =
      NFCClientAssociatedPtr;

  function NFCClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  NFCClientPtr.prototype.onWatch = function() {
    return NFCClientProxy.prototype.onWatch
        .apply(this.ptr.getProxy(), arguments);
  };

  NFCClientProxy.prototype.onWatch = function(watchIds, serialNumber, message) {
    var params_ = new NFCClient_OnWatch_Params();
    params_.watchIds = watchIds;
    params_.serialNumber = serialNumber;
    params_.message = message;
    var builder = new codec.MessageV0Builder(
        kNFCClient_OnWatch_Name,
        codec.align(NFCClient_OnWatch_Params.encodedSize));
    builder.encodeStruct(NFCClient_OnWatch_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NFCClientPtr.prototype.onError = function() {
    return NFCClientProxy.prototype.onError
        .apply(this.ptr.getProxy(), arguments);
  };

  NFCClientProxy.prototype.onError = function(error) {
    var params_ = new NFCClient_OnError_Params();
    params_.error = error;
    var builder = new codec.MessageV0Builder(
        kNFCClient_OnError_Name,
        codec.align(NFCClient_OnError_Params.encodedSize));
    builder.encodeStruct(NFCClient_OnError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function NFCClientStub(delegate) {
    this.delegate_ = delegate;
  }
  NFCClientStub.prototype.onWatch = function(watchIds, serialNumber, message) {
    return this.delegate_ && this.delegate_.onWatch && this.delegate_.onWatch(watchIds, serialNumber, message);
  }
  NFCClientStub.prototype.onError = function(error) {
    return this.delegate_ && this.delegate_.onError && this.delegate_.onError(error);
  }

  NFCClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNFCClient_OnWatch_Name:
      var params = reader.decodeStruct(NFCClient_OnWatch_Params);
      this.onWatch(params.watchIds, params.serialNumber, params.message);
      return true;
    case kNFCClient_OnError_Name:
      var params = reader.decodeStruct(NFCClient_OnError_Params);
      this.onError(params.error);
      return true;
    default:
      return false;
    }
  };

  NFCClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateNFCClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kNFCClient_OnWatch_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NFCClient_OnWatch_Params;
      break;
      case kNFCClient_OnError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NFCClient_OnError_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateNFCClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var NFCClient = {
    name: 'device.mojom.NFCClient',
    kVersion: 0,
    ptrClass: NFCClientPtr,
    proxyClass: NFCClientProxy,
    stubClass: NFCClientStub,
    validateRequest: validateNFCClientRequest,
    validateResponse: null,
  };
  NFCClientStub.prototype.validator = validateNFCClientRequest;
  NFCClientProxy.prototype.validator = null;
  exports.NDEFErrorType = NDEFErrorType;
  exports.NDEFRecordTypeCategory = NDEFRecordTypeCategory;
  exports.NDEFError = NDEFError;
  exports.NDEFRecord = NDEFRecord;
  exports.NDEFMessage = NDEFMessage;
  exports.NDEFWriteOptions = NDEFWriteOptions;
  exports.NFC = NFC;
  exports.NFCPtr = NFCPtr;
  exports.NFCAssociatedPtr = NFCAssociatedPtr;
  exports.NFCClient = NFCClient;
  exports.NFCClientPtr = NFCClientPtr;
  exports.NFCClientAssociatedPtr = NFCClientAssociatedPtr;
})();