// services/device/public/mojom/geoposition.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/geoposition.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/geoposition.mojom-params-data.h"
#include "services/device/public/mojom/geoposition.mojom-shared-message-ids.h"

#include "services/device/public/mojom/geoposition.mojom-import-headers.h"
#include "services/device/public/mojom/geoposition.mojom-test-utils.h"


namespace device::mojom {
Geoposition::Geoposition()
    : latitude(kBadLatitudeLongitude),
      longitude(kBadLatitudeLongitude),
      altitude(kBadAltitude),
      accuracy(kBadAccuracy),
      altitude_accuracy(kBadAccuracy),
      heading(kBadHeading),
      speed(kBadSpeed),
      timestamp(),
      is_precise(true) {}

Geoposition::Geoposition(
    double latitude_in,
    double longitude_in,
    double altitude_in,
    double accuracy_in,
    double altitude_accuracy_in,
    double heading_in,
    double speed_in,
    ::base::Time timestamp_in,
    bool is_precise_in)
    : latitude(std::move(latitude_in)),
      longitude(std::move(longitude_in)),
      altitude(std::move(altitude_in)),
      accuracy(std::move(accuracy_in)),
      altitude_accuracy(std::move(altitude_accuracy_in)),
      heading(std::move(heading_in)),
      speed(std::move(speed_in)),
      timestamp(std::move(timestamp_in)),
      is_precise(std::move(is_precise_in)) {}

Geoposition::~Geoposition() = default;

void Geoposition::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latitude"), this->latitude,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "longitude"), this->longitude,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "altitude"), this->altitude,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accuracy"), this->accuracy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "altitude_accuracy"), this->altitude_accuracy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "heading"), this->heading,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "speed"), this->speed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_precise"), this->is_precise,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Geoposition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GeopositionError::GeopositionError()
    : error_code(),
      error_message(),
      error_technical() {}

GeopositionError::GeopositionError(
    GeopositionErrorCode error_code_in,
    const std::string& error_message_in,
    const std::string& error_technical_in)
    : error_code(std::move(error_code_in)),
      error_message(std::move(error_message_in)),
      error_technical(std::move(error_technical_in)) {}

GeopositionError::~GeopositionError() = default;
size_t GeopositionError::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->error_code);
  seed = mojo::internal::Hash(seed, this->error_message);
  seed = mojo::internal::Hash(seed, this->error_technical);
  return seed;
}

void GeopositionError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_code"), this->error_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GeopositionErrorCode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_message"), this->error_message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_technical"), this->error_technical,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GeopositionError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GeopositionResultPtr
GeopositionResult::NewPosition(
    GeopositionPtr value) {
  return GeopositionResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPosition)>,
      std::move(value));
}

GeopositionResultPtr
GeopositionResult::NewError(
    GeopositionErrorPtr value) {
  return GeopositionResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

GeopositionResult::GeopositionResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kPosition)>,
    GeopositionPtr value)
    : tag_(Tag::kPosition),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPosition)>,
            std::move(value)) {}

GeopositionResult::GeopositionResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    GeopositionErrorPtr value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}
GeopositionResult::~GeopositionResult() {
  DestroyActive();
}

void GeopositionResult::set_position(GeopositionPtr position) {
  if (tag_ == Tag::kPosition) {
    data_.position = std::move(position);
  } else {
    DestroyActive();
    tag_ = Tag::kPosition;
    new (&data_.position) GeopositionPtr(
        std::move(position));
  }
}

void GeopositionResult::set_error(GeopositionErrorPtr error) {
  if (tag_ == Tag::kError) {
    data_.error = std::move(error);
  } else {
    DestroyActive();
    tag_ = Tag::kError;
    new (&data_.error) GeopositionErrorPtr(
        std::move(error));
  }
}


GeopositionResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPosition)>,
    GeopositionPtr value)
    : position(std::move(value)) {}

GeopositionResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    GeopositionErrorPtr value)
    : error(std::move(value)) {}

void GeopositionResult::DestroyActive() {
  switch (tag_) {

    case Tag::kPosition:
      std::destroy_at(&data_.position);
      break;
    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
  }
}

bool GeopositionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // device::mojom


namespace mojo {


// static
bool StructTraits<::device::mojom::Geoposition::DataView, ::device::mojom::GeopositionPtr>::Read(
    ::device::mojom::Geoposition::DataView input,
    ::device::mojom::GeopositionPtr* output) {
  bool success = true;
  ::device::mojom::GeopositionPtr result(::device::mojom::Geoposition::New());
  
      if (success)
        result->latitude = input.latitude();
      if (success)
        result->longitude = input.longitude();
      if (success)
        result->altitude = input.altitude();
      if (success)
        result->accuracy = input.accuracy();
      if (success)
        result->altitude_accuracy = input.altitude_accuracy();
      if (success)
        result->heading = input.heading();
      if (success)
        result->speed = input.speed();
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success)
        result->is_precise = input.is_precise();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::GeopositionError::DataView, ::device::mojom::GeopositionErrorPtr>::Read(
    ::device::mojom::GeopositionError::DataView input,
    ::device::mojom::GeopositionErrorPtr* output) {
  bool success = true;
  ::device::mojom::GeopositionErrorPtr result(::device::mojom::GeopositionError::New());
  
      if (success && !input.ReadErrorCode(&result->error_code))
        success = false;
      if (success && !input.ReadErrorMessage(&result->error_message))
        success = false;
      if (success && !input.ReadErrorTechnical(&result->error_technical))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::device::mojom::GeopositionResult::DataView, ::device::mojom::GeopositionResultPtr>::Read(
    ::device::mojom::GeopositionResult::DataView input,
    ::device::mojom::GeopositionResultPtr* output) {
  using UnionType = ::device::mojom::GeopositionResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPosition: {
      ::device::mojom::GeopositionPtr result_position{};
      if (!input.ReadPosition(&result_position))
        return false;

      *output = UnionType::NewPosition(
          std::move(result_position));
      break;
    }
    case Tag::kError: {
      ::device::mojom::GeopositionErrorPtr result_error{};
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(
          std::move(result_error));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {




}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif