// services/device/public/mojom/geolocation_context.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_CONTEXT_MOJOM_PARAMS_DATA_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_CONTEXT_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace device::mojom {
namespace internal {
class  GeolocationContext_BindGeolocation_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  int32_t client_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> requesting_url;
  uint8_t has_precise_permission : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<GeolocationContext_BindGeolocation_Params_Data>;

  GeolocationContext_BindGeolocation_Params_Data();
  ~GeolocationContext_BindGeolocation_Params_Data() = delete;
};
static_assert(sizeof(GeolocationContext_BindGeolocation_Params_Data) == 32,
              "Bad sizeof(GeolocationContext_BindGeolocation_Params_Data)");
class  GeolocationContext_OnPermissionUpdated_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> origin;
  int32_t permission_level;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<GeolocationContext_OnPermissionUpdated_Params_Data>;

  GeolocationContext_OnPermissionUpdated_Params_Data();
  ~GeolocationContext_OnPermissionUpdated_Params_Data() = delete;
};
static_assert(sizeof(GeolocationContext_OnPermissionUpdated_Params_Data) == 24,
              "Bad sizeof(GeolocationContext_OnPermissionUpdated_Params_Data)");
class  GeolocationContext_SetOverride_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::device::mojom::internal::GeopositionResult_Data result;

 private:
  friend class mojo::internal::MessageFragment<GeolocationContext_SetOverride_Params_Data>;

  GeolocationContext_SetOverride_Params_Data();
  ~GeolocationContext_SetOverride_Params_Data() = delete;
};
static_assert(sizeof(GeolocationContext_SetOverride_Params_Data) == 24,
              "Bad sizeof(GeolocationContext_SetOverride_Params_Data)");
class  GeolocationContext_ClearOverride_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GeolocationContext_ClearOverride_Params_Data>;

  GeolocationContext_ClearOverride_Params_Data();
  ~GeolocationContext_ClearOverride_Params_Data() = delete;
};
static_assert(sizeof(GeolocationContext_ClearOverride_Params_Data) == 8,
              "Bad sizeof(GeolocationContext_ClearOverride_Params_Data)");

}  // namespace internal


class GeolocationContext_BindGeolocation_ParamsDataView {
 public:
  GeolocationContext_BindGeolocation_ParamsDataView() = default;

  GeolocationContext_BindGeolocation_ParamsDataView(
      internal::GeolocationContext_BindGeolocation_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::device::mojom::GeolocationInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetRequestingUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestingUrl(UserType* output) {
    
    auto* pointer = data_->requesting_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadClientId(UserType* output) const {
    auto data_value = data_->client_id;
    return mojo::internal::Deserialize<::device::mojom::GeolocationClientId>(
        data_value, output);
  }
  ::device::mojom::GeolocationClientId client_id() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::GeolocationClientId>(data_->client_id));
  }
  bool has_precise_permission() const {
    return data_->has_precise_permission;
  }
 private:
  internal::GeolocationContext_BindGeolocation_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GeolocationContext_OnPermissionUpdated_ParamsDataView {
 public:
  GeolocationContext_OnPermissionUpdated_ParamsDataView() = default;

  GeolocationContext_OnPermissionUpdated_ParamsDataView(
      internal::GeolocationContext_OnPermissionUpdated_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPermissionLevel(UserType* output) const {
    auto data_value = data_->permission_level;
    return mojo::internal::Deserialize<::device::mojom::GeolocationPermissionLevel>(
        data_value, output);
  }
  GeolocationPermissionLevel permission_level() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::GeolocationPermissionLevel>(data_->permission_level));
  }
 private:
  internal::GeolocationContext_OnPermissionUpdated_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GeolocationContext_SetOverride_ParamsDataView {
 public:
  GeolocationContext_SetOverride_ParamsDataView() = default;

  GeolocationContext_SetOverride_ParamsDataView(
      internal::GeolocationContext_SetOverride_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      ::device::mojom::GeopositionResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::device::mojom::GeopositionResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::GeolocationContext_SetOverride_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GeolocationContext_ClearOverride_ParamsDataView {
 public:
  GeolocationContext_ClearOverride_ParamsDataView() = default;

  GeolocationContext_ClearOverride_ParamsDataView(
      internal::GeolocationContext_ClearOverride_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GeolocationContext_ClearOverride_Params_Data* data_ = nullptr;
};

inline void GeolocationContext_BindGeolocation_ParamsDataView::GetRequestingUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->requesting_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void GeolocationContext_OnPermissionUpdated_ParamsDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void GeolocationContext_SetOverride_ParamsDataView::GetResultDataView(
    ::device::mojom::GeopositionResultDataView* output) {
  auto pointer = &data_->result;
  *output = ::device::mojom::GeopositionResultDataView(pointer, message_);
}





}  // device::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_CONTEXT_MOJOM_PARAMS_DATA_H_