// services/device/public/mojom/fingerprint.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_BLINK_TEST_UTILS_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_BLINK_TEST_UTILS_H_

#include "services/device/public/mojom/fingerprint.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace device::mojom::blink {


class BLINK_PLATFORM_EXPORT FingerprintObserverInterceptorForTesting : public FingerprintObserver {
  virtual FingerprintObserver* GetForwardingInterface() = 0;
  void OnRestarted() override;
  void OnStatusChanged(BiometricsManagerStatus status) override;
  void OnEnrollScanDone(ScanResult scan_result, bool is_complete, int32_t percent_complete) override;
  void OnAuthScanDone(FingerprintMessagePtr msg, const ::blink::HashMap<::blink::String, ::blink::Vector<::blink::String>>& matches) override;
  void OnSessionFailed() override;
};
class BLINK_PLATFORM_EXPORT FingerprintObserverAsyncWaiter {
 public:
  explicit FingerprintObserverAsyncWaiter(FingerprintObserver* proxy);

  FingerprintObserverAsyncWaiter(const FingerprintObserverAsyncWaiter&) = delete;
  FingerprintObserverAsyncWaiter& operator=(const FingerprintObserverAsyncWaiter&) = delete;

  ~FingerprintObserverAsyncWaiter();

 private:
  FingerprintObserver* const proxy_;
};


class BLINK_PLATFORM_EXPORT FingerprintInterceptorForTesting : public Fingerprint {
  virtual Fingerprint* GetForwardingInterface() = 0;
  void GetRecordsForUser(const ::blink::String& user_id, GetRecordsForUserCallback callback) override;
  void StartEnrollSession(const ::blink::String& user_id, const ::blink::String& label) override;
  void CancelCurrentEnrollSession(CancelCurrentEnrollSessionCallback callback) override;
  void RequestRecordLabel(const ::blink::String& record_path, RequestRecordLabelCallback callback) override;
  void SetRecordLabel(const ::blink::String& record_path, const ::blink::String& new_label, SetRecordLabelCallback callback) override;
  void RemoveRecord(const ::blink::String& record_path, RemoveRecordCallback callback) override;
  void StartAuthSession() override;
  void EndCurrentAuthSession(EndCurrentAuthSessionCallback callback) override;
  void DestroyAllRecords(DestroyAllRecordsCallback callback) override;
  void AddFingerprintObserver(::mojo::PendingRemote<FingerprintObserver> observer) override;
  void RequestType(RequestTypeCallback callback) override;
};
class BLINK_PLATFORM_EXPORT FingerprintAsyncWaiter {
 public:
  explicit FingerprintAsyncWaiter(Fingerprint* proxy);

  FingerprintAsyncWaiter(const FingerprintAsyncWaiter&) = delete;
  FingerprintAsyncWaiter& operator=(const FingerprintAsyncWaiter&) = delete;

  ~FingerprintAsyncWaiter();
  void GetRecordsForUser(
      const ::blink::String& user_id, ::blink::HashMap<::blink::String, ::blink::String>* out_records, bool* out_success);
  
  void CancelCurrentEnrollSession(
      bool* out_success);
  bool CancelCurrentEnrollSession();
  void RequestRecordLabel(
      const ::blink::String& record_path, ::blink::String* out_label);
  ::blink::String RequestRecordLabel(const ::blink::String& record_path);
  void SetRecordLabel(
      const ::blink::String& record_path, const ::blink::String& new_label, bool* out_success);
  bool SetRecordLabel(const ::blink::String& record_path, const ::blink::String& new_label);
  void RemoveRecord(
      const ::blink::String& record_path, bool* out_success);
  bool RemoveRecord(const ::blink::String& record_path);
  void EndCurrentAuthSession(
      bool* out_success);
  bool EndCurrentAuthSession();
  void DestroyAllRecords(
      bool* out_success);
  bool DestroyAllRecords();
  void RequestType(
      BiometricType* out_type);
  BiometricType RequestType();

 private:
  Fingerprint* const proxy_;
};




}  // device::mojom::blink

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_BLINK_TEST_UTILS_H_