// services/device/public/mojom/battery_monitor.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  BatteryStatus as device_mojom_BatteryStatus,
  BatteryStatusSpec as device_mojom_BatteryStatusSpec
} from './battery_status.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BatteryMonitorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.BatteryMonitor', scope);
  }
}

/** @interface */
export class BatteryMonitorInterface {
  
  /**
   * @return {!Promise<{
        status: !device_mojom_BatteryStatus,
   *  }>}
   */

  queryNextStatus() {}
}

/**
 * @implements { BatteryMonitorInterface }
 */
export class BatteryMonitorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BatteryMonitorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BatteryMonitorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BatteryMonitorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        status: !device_mojom_BatteryStatus,
   *  }>}
   */

  queryNextStatus() {
    return this.proxy.sendMessage(
        0,
        BatteryMonitor_QueryNextStatus_ParamsSpec.$,
        BatteryMonitor_QueryNextStatus_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BatteryMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BatteryMonitorReceiver {
  /**
   * @param {!BatteryMonitorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BatteryMonitorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BatteryMonitorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BatteryMonitorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BatteryMonitor_QueryNextStatus_ParamsSpec.$,
        BatteryMonitor_QueryNextStatus_ResponseParamsSpec.$,
        impl.queryNextStatus.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BatteryMonitor {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.BatteryMonitor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BatteryMonitorRemote}
   */
  static getRemote() {
    let remote = new BatteryMonitorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BatteryMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BatteryMonitorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BatteryMonitorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BatteryMonitorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queryNextStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BatteryMonitor_QueryNextStatus_ParamsSpec.$,
        BatteryMonitor_QueryNextStatus_ResponseParamsSpec.$,
        this.queryNextStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BatteryMonitor_QueryNextStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BatteryMonitor_QueryNextStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    BatteryMonitor_QueryNextStatus_ParamsSpec.$,
    'BatteryMonitor_QueryNextStatus_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BatteryMonitor_QueryNextStatus_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    BatteryMonitor_QueryNextStatus_ResponseParamsSpec.$,
    'BatteryMonitor_QueryNextStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        device_mojom_BatteryStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BatteryMonitor_QueryNextStatus_ResponseParams {
  constructor() {
    /** @type { !device_mojom_BatteryStatus } */
    this.status;
  }
}

