// services/accessibility/public/mojom/accessibility_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_ACCESSIBILITY_PUBLIC_MOJOM_ACCESSIBILITY_SERVICE_MOJOM_H_
#define SERVICES_ACCESSIBILITY_PUBLIC_MOJOM_ACCESSIBILITY_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/accessibility/public/mojom/accessibility_service.mojom-features.h"  // IWYU pragma: export
#include "services/accessibility/public/mojom/accessibility_service.mojom-shared.h"  // IWYU pragma: export
#include "services/accessibility/public/mojom/accessibility_service.mojom-forward.h"  // IWYU pragma: export
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "services/accessibility/public/mojom/automation.mojom-forward.h"
#include "services/accessibility/public/mojom/automation_client.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace ax::mojom {

class AccessibilityServiceProxy;

template <typename ImplRefTraits>
class AccessibilityServiceStub;

class AccessibilityServiceRequestValidator;


class AccessibilityService
    : public AccessibilityServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ax.mojom.AccessibilityService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kService;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AccessibilityServiceInterfaceBase;
  using Proxy_ = AccessibilityServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = AccessibilityServiceStub<ImplRefTraits>;

  using RequestValidator_ = AccessibilityServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindAccessibilityServiceClientMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindAccessibilityServiceClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AccessibilityService() = default;

  virtual void BindAccessibilityServiceClient(::mojo::PendingRemote<AccessibilityServiceClient> accessibility_service_client) = 0;
};

class AccessibilityServiceClientProxy;

template <typename ImplRefTraits>
class AccessibilityServiceClientStub;

class AccessibilityServiceClientRequestValidator;


class AccessibilityServiceClient
    : public AccessibilityServiceClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ax.mojom.AccessibilityServiceClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AccessibilityServiceClientInterfaceBase;
  using Proxy_ = AccessibilityServiceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = AccessibilityServiceClientStub<ImplRefTraits>;

  using RequestValidator_ = AccessibilityServiceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindAutomationMinVersion = 0,
    kBindAutomationClientMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindAutomation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindAutomationClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AccessibilityServiceClient() = default;

  virtual void BindAutomation(::mojo::PendingAssociatedRemote<::ax::mojom::Automation> automation) = 0;

  virtual void BindAutomationClient(::mojo::PendingReceiver<::ax::mojom::AutomationClient> automation_client) = 0;
};



class  AccessibilityServiceProxy
    : public AccessibilityService {
 public:
  using InterfaceType = AccessibilityService;

  explicit AccessibilityServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindAccessibilityServiceClient(::mojo::PendingRemote<AccessibilityServiceClient> accessibility_service_client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AccessibilityServiceClientProxy
    : public AccessibilityServiceClient {
 public:
  using InterfaceType = AccessibilityServiceClient;

  explicit AccessibilityServiceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindAutomation(::mojo::PendingAssociatedRemote<::ax::mojom::Automation> automation) final;
  
  void BindAutomationClient(::mojo::PendingReceiver<::ax::mojom::AutomationClient> automation_client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AccessibilityServiceStubDispatch {
 public:
  static bool Accept(AccessibilityService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AccessibilityService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AccessibilityService>>
class AccessibilityServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AccessibilityServiceStub() = default;
  ~AccessibilityServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AccessibilityServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AccessibilityServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AccessibilityServiceClientStubDispatch {
 public:
  static bool Accept(AccessibilityServiceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AccessibilityServiceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AccessibilityServiceClient>>
class AccessibilityServiceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AccessibilityServiceClientStub() = default;
  ~AccessibilityServiceClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AccessibilityServiceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AccessibilityServiceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AccessibilityServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AccessibilityServiceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // ax::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_ACCESSIBILITY_PUBLIC_MOJOM_ACCESSIBILITY_SERVICE_MOJOM_H_