// printing/mojom/printing_context.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "printing/mojom/printing_context.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "printing/mojom/printing_context.mojom-params-data.h"
namespace printing {
namespace mojom {

namespace internal {


// static
bool PageMargins_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageMargins_Data* object =
      static_cast<const PageMargins_Data*>(data);

  return true;
}

PageMargins_Data::PageMargins_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageSetup_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageSetup_Data* object =
      static_cast<const PageSetup_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->physical_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->physical_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printable_area, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->printable_area, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->overlay_area, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->overlay_area, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_area, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->content_area, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->effective_margins, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->effective_margins, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requested_margins, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->requested_margins, validation_context))
    return false;

  return true;
}

PageSetup_Data::PageSetup_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RequestedMedia_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RequestedMedia_Data* object =
      static_cast<const RequestedMedia_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size_microns, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size_microns, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->vendor_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& vendor_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->vendor_id, validation_context,
                                         &vendor_id_validate_params)) {
    return false;
  }

  return true;
}

RequestedMedia_Data::RequestedMedia_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintSettings_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 120, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintSettings_Data* object =
      static_cast<const PrintSettings_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ranges, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ranges_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ranges, validation_context,
                                         &ranges_validate_params)) {
    return false;
  }


  if (!::printing::mojom::internal::MarginType_Data
        ::Validate(object->margin_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::printing::mojom::internal::ColorModel_Data
        ::Validate(object->color, validation_context))
    return false;


  if (!::printing::mojom::internal::DuplexMode_Data
        ::Validate(object->duplex_mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_name, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requested_media, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->requested_media, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_setup_device_units, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_setup_device_units, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_type, 16, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_type, validation_context,
                                         &media_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dpi, 17, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dpi, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requested_custom_margins_in_microns, 22, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->requested_custom_margins_in_microns, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->system_print_dialog_data, 24, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->system_print_dialog_data, validation_context))
    return false;

  return true;
}

PrintSettings_Data::PrintSettings_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace printing