// printing/backend/mojom/print_backend.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PRINTING_BACKEND_MOJOM_PRINT_BACKEND_MOJOM_SEND_VALIDATION_H_
#define PRINTING_BACKEND_MOJOM_PRINT_BACKEND_MOJOM_SEND_VALIDATION_H_

#include "printing/backend/mojom/print_backend.mojom-shared-internal.h"
#include "printing/mojom/print.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "printing/backend/mojom/print_backend.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::PrinterBasicInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrinterBasicInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrinterBasicInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::printer_name(input)) in_printer_name = Traits::printer_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->printer_name)::BaseType> printer_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_printer_name,
        printer_name_fragment);

      fragment->printer_name.Set(
          printer_name_fragment.is_null() ? nullptr : printer_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->printer_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printer_name in PrinterBasicInfo struct");

      decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_name)::BaseType> display_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_display_name,
        display_name_fragment);

      fragment->display_name.Set(
          display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_name in PrinterBasicInfo struct");

      decltype(Traits::printer_description(input)) in_printer_description = Traits::printer_description(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->printer_description)::BaseType> printer_description_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_printer_description,
        printer_description_fragment);

      fragment->printer_description.Set(
          printer_description_fragment.is_null() ? nullptr : printer_description_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->printer_description.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printer_description in PrinterBasicInfo struct");

      decltype(Traits::options(input)) in_options = Traits::options(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->options)::BaseType>
          options_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& options_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>, send_validation>(
        in_options,
        options_fragment,
        &options_validate_params);

      fragment->options.Set(
          options_fragment.is_null() ? nullptr : options_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->options.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null options in PrinterBasicInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::PaperDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PaperDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::Paper_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_name)::BaseType> display_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_display_name,
        display_name_fragment);

      fragment->display_name.Set(
          display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_name in Paper struct");

      decltype(Traits::vendor_id(input)) in_vendor_id = Traits::vendor_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->vendor_id)::BaseType> vendor_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_vendor_id,
        vendor_id_fragment);

      fragment->vendor_id.Set(
          vendor_id_fragment.is_null() ? nullptr : vendor_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->vendor_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null vendor_id in Paper struct");

      decltype(Traits::size_um(input)) in_size_um = Traits::size_um(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->size_um)::BaseType> size_um_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_size_um,
        size_um_fragment);

      fragment->size_um.Set(
          size_um_fragment.is_null() ? nullptr : size_um_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->size_um.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null size_um in Paper struct");

      decltype(Traits::printable_area_um(input)) in_printable_area_um = Traits::printable_area_um(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->printable_area_um)::BaseType> printable_area_um_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_printable_area_um,
        printable_area_um_fragment);

      fragment->printable_area_um.Set(
          printable_area_um_fragment.is_null() ? nullptr : printable_area_um_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->printable_area_um.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printable_area_um in Paper struct");

      fragment->max_height_um = Traits::max_height_um(input);

      fragment->has_borderless_variant = Traits::has_borderless_variant(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::MediaTypeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::MediaTypeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::MediaType_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_name)::BaseType> display_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_display_name,
        display_name_fragment);

      fragment->display_name.Set(
          display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_name in MediaType struct");

      decltype(Traits::vendor_id(input)) in_vendor_id = Traits::vendor_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->vendor_id)::BaseType> vendor_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_vendor_id,
        vendor_id_fragment);

      fragment->vendor_id.Set(
          vendor_id_fragment.is_null() ? nullptr : vendor_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->vendor_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null vendor_id in MediaType struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::printing::mojom::PrinterSemanticCapsAndDefaultsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrinterSemanticCapsAndDefaultsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrinterSemanticCapsAndDefaults_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->collate_capable = Traits::collate_capable(input);

      fragment->collate_default = Traits::collate_default(input);

      fragment->copies_max = Traits::copies_max(input);

      decltype(Traits::duplex_modes(input)) in_duplex_modes = Traits::duplex_modes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->duplex_modes)::BaseType>
          duplex_modes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& duplex_modes_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::printing::mojom::internal::DuplexMode_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::printing::mojom::DuplexMode>, send_validation>(
        in_duplex_modes,
        duplex_modes_fragment,
        &duplex_modes_validate_params);

      fragment->duplex_modes.Set(
          duplex_modes_fragment.is_null() ? nullptr : duplex_modes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->duplex_modes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null duplex_modes in PrinterSemanticCapsAndDefaults struct");

      
      mojo::internal::Serialize<::printing::mojom::DuplexMode>(
        Traits::duplex_default(input),
        &fragment->duplex_default);

      fragment->color_changeable = Traits::color_changeable(input);

      fragment->color_default = Traits::color_default(input);

      
      mojo::internal::Serialize<::printing::mojom::ColorModel>(
        Traits::color_model(input),
        &fragment->color_model);

      
      mojo::internal::Serialize<::printing::mojom::ColorModel>(
        Traits::bw_model(input),
        &fragment->bw_model);

      decltype(Traits::papers(input)) in_papers = Traits::papers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->papers)::BaseType>
          papers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& papers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::printing::mojom::PaperDataView>, send_validation>(
        in_papers,
        papers_fragment,
        &papers_validate_params);

      fragment->papers.Set(
          papers_fragment.is_null() ? nullptr : papers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->papers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null papers in PrinterSemanticCapsAndDefaults struct");

      decltype(Traits::user_defined_papers(input)) in_user_defined_papers = Traits::user_defined_papers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->user_defined_papers)::BaseType>
          user_defined_papers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& user_defined_papers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::printing::mojom::PaperDataView>, send_validation>(
        in_user_defined_papers,
        user_defined_papers_fragment,
        &user_defined_papers_validate_params);

      fragment->user_defined_papers.Set(
          user_defined_papers_fragment.is_null() ? nullptr : user_defined_papers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->user_defined_papers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null user_defined_papers in PrinterSemanticCapsAndDefaults struct");

      decltype(Traits::default_paper(input)) in_default_paper = Traits::default_paper(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->default_paper)::BaseType> default_paper_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::printing::mojom::PaperDataView, send_validation>(
        in_default_paper,
        default_paper_fragment);

      fragment->default_paper.Set(
          default_paper_fragment.is_null() ? nullptr : default_paper_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->default_paper.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null default_paper in PrinterSemanticCapsAndDefaults struct");

      decltype(Traits::dpis(input)) in_dpis = Traits::dpis(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dpis)::BaseType>
          dpis_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& dpis_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>, send_validation>(
        in_dpis,
        dpis_fragment,
        &dpis_validate_params);

      fragment->dpis.Set(
          dpis_fragment.is_null() ? nullptr : dpis_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->dpis.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dpis in PrinterSemanticCapsAndDefaults struct");

      decltype(Traits::default_dpi(input)) in_default_dpi = Traits::default_dpi(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->default_dpi)::BaseType> default_dpi_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_default_dpi,
        default_dpi_fragment);

      fragment->default_dpi.Set(
          default_dpi_fragment.is_null() ? nullptr : default_dpi_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->default_dpi.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null default_dpi in PrinterSemanticCapsAndDefaults struct");

      decltype(Traits::media_types(input)) in_media_types = Traits::media_types(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_types)::BaseType>
          media_types_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& media_types_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::printing::mojom::MediaTypeDataView>, send_validation>(
        in_media_types,
        media_types_fragment,
        &media_types_validate_params);

      fragment->media_types.Set(
          media_types_fragment.is_null() ? nullptr : media_types_fragment.data());

      decltype(Traits::default_media_type(input)) in_default_media_type = Traits::default_media_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->default_media_type)::BaseType> default_media_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::printing::mojom::MediaTypeDataView, send_validation>(
        in_default_media_type,
        default_media_type_fragment);

      fragment->default_media_type.Set(
          default_media_type_fragment.is_null() ? nullptr : default_media_type_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // PRINTING_BACKEND_MOJOM_PRINT_BACKEND_MOJOM_SEND_VALIDATION_H_