// owl/mojom/web_view.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_VIEW_MOJOM_H_
#define OWL_MOJOM_WEB_VIEW_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/web_view.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/web_view.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/web_view.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom-forward.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "owl/mojom/address_prompt.mojom-forward.h"
#include "owl/mojom/autofill_popup.mojom-forward.h"
#include "owl/mojom/card_prompt.mojom-forward.h"
#include "owl/mojom/chatgpt_frontend.mojom-forward.h"
#include "owl/mojom/context_menu_params.mojom-forward.h"
#include "owl/mojom/password_prompt.mojom-forward.h"
#include "owl/mojom/permission_prompt.mojom-forward.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-forward.h"
#include "third_party/blink/public/mojom/input/input_event.mojom-forward.h"
#include "third_party/blink/public/mojom/picture_in_picture_window_options/picture_in_picture_window_options.mojom.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom.h"
#include "ui/base/mojom/window_open_disposition.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/image/mojom/image.mojom.h"
#include "url/mojom/url.mojom.h"
#include "components/remote_cocoa/common/application.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class FindClientProxy;

template <typename ImplRefTraits>
class FindClientStub;

class FindClientRequestValidator;


class FindClient
    : public FindClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.FindClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FindClientInterfaceBase;
  using Proxy_ = FindClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = FindClientStub<ImplRefTraits>;

  using RequestValidator_ = FindClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnFindResultMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnFindResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FindClient() = default;

  virtual void OnFindResult(FindResultPtr result) = 0;
};

class DevToolsSessionProxy;

template <typename ImplRefTraits>
class DevToolsSessionStub;

class DevToolsSessionRequestValidator;


class DevToolsSession
    : public DevToolsSessionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.DevToolsSession";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DevToolsSessionInterfaceBase;
  using Proxy_ = DevToolsSessionProxy;

  template <typename ImplRefTraits>
  using Stub_ = DevToolsSessionStub<ImplRefTraits>;

  using RequestValidator_ = DevToolsSessionRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendProtocolMessageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SendProtocolMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DevToolsSession() = default;

  virtual void SendProtocolMessage(const std::string& message) = 0;
};

class DevToolsSessionClientProxy;

template <typename ImplRefTraits>
class DevToolsSessionClientStub;

class DevToolsSessionClientRequestValidator;


class DevToolsSessionClient
    : public DevToolsSessionClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.DevToolsSessionClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DevToolsSessionClientInterfaceBase;
  using Proxy_ = DevToolsSessionClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = DevToolsSessionClientStub<ImplRefTraits>;

  using RequestValidator_ = DevToolsSessionClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnProtocolMessageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnProtocolMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DevToolsSessionClient() = default;

  virtual void OnProtocolMessage(const std::string& message) = 0;
};

class WebViewProxy;

template <typename ImplRefTraits>
class WebViewStub;

class WebViewRequestValidator;
class WebViewResponseValidator;


class WebView
    : public WebViewInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WebView";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebViewInterfaceBase;
  using Proxy_ = WebViewProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebViewStub<ImplRefTraits>;

  using RequestValidator_ = WebViewRequestValidator;
  using ResponseValidator_ = WebViewResponseValidator;
  enum MethodMinVersions : uint32_t {
    kMoveToGroupMinVersion = 0,
    kNavigateToMinVersion = 0,
    kSetStoragePartitionMinVersion = 0,
    kCloseNowMinVersion = 0,
    kGoBackMinVersion = 0,
    kGoForwardMinVersion = 0,
    kGoToNavigationEntryMinVersion = 0,
    kLoadNavigationEntriesMinVersion = 0,
    kClearForwardHistoryMinVersion = 0,
    kStopMinVersion = 0,
    kReloadMinVersion = 0,
    kEvaluateJavaScriptMinVersion = 0,
    kEvaluateJavaScriptWithArgumentsMinVersion = 0,
    kTakeSnapshotMinVersion = 0,
    kFindInPageMinVersion = 0,
    kCancelFindInPageMinVersion = 0,
    kSetAuthenticationURLSchemeMinVersion = 0,
    kCreateDevToolsSessionMinVersion = 0,
    kOpenDevToolsMinVersion = 0,
    kZoomInMinVersion = 0,
    kZoomOutMinVersion = 0,
    kResetZoomMinVersion = 0,
    kMuteMinVersion = 0,
    kUnmuteMinVersion = 0,
    kCopyImageMinVersion = 0,
    kSaveMediaMinVersion = 0,
    kLoopPlaybackMinVersion = 0,
    kShowPlaybackControlsMinVersion = 0,
    kCopyVideoFrameMinVersion = 0,
    kShowInPictureInPictureMinVersion = 0,
    kUndoMinVersion = 0,
    kRedoMinVersion = 0,
    kCutMinVersion = 0,
    kCopyMinVersion = 0,
    kPasteMinVersion = 0,
    kSelectAllMinVersion = 0,
    kReplaceMisspelledWordMinVersion = 0,
    kAddToDictionaryMinVersion = 0,
    kCaptureCopyMinVersion = 0,
    kInsertViaPasteMinVersion = 0,
    kSetCancelOffOriginLinkLoadsMinVersion = 0,
    kForceRendererCrashMinVersion = 0,
    kFetchCertificateChainMinVersion = 0,
    kDisablePasswordManagementMinVersion = 0,
    kExtractAnnotatedTextMinVersion = 0,
    kExtractSerializedDomMinVersion = 0,
    kExtractSerializedDomElementInfoMinVersion = 0,
    kWillExitFullScreenModeMinVersion = 0,
    kRequestPrintPreviewMinVersion = 0,
    kRegisterProtocolHandlerMinVersion = 0,
    kSetBackgroundColorMinVersion = 0,
    kNotifyUserActivationMinVersion = 0,
    kGetDiagnosticsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct MoveToGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NavigateTo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetStoragePartition_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseNow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GoBack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GoForward_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GoToNavigationEntry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadNavigationEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearForwardHistory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Stop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Reload_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EvaluateJavaScript_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EvaluateJavaScriptWithArguments_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TakeSnapshot_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FindInPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelFindInPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAuthenticationURLScheme_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateDevToolsSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenDevTools_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ZoomIn_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ZoomOut_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetZoom_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Mute_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Unmute_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CopyImage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SaveMedia_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoopPlayback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowPlaybackControls_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CopyVideoFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowInPictureInPicture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Undo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Redo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Cut_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Copy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Paste_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SelectAll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReplaceMisspelledWord_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddToDictionary_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CaptureCopy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InsertViaPaste_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCancelOffOriginLinkLoads_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForceRendererCrash_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FetchCertificateChain_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisablePasswordManagement_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExtractAnnotatedText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExtractSerializedDom_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExtractSerializedDomElementInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WillExitFullScreenMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestPrintPreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterProtocolHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBackgroundColor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyUserActivation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDiagnostics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebView() = default;

  virtual void MoveToGroup(const std::string& group_id) = 0;

  virtual void NavigateTo(const ::GURL& url, NavigationType type, const std::string& additional_headers) = 0;

  virtual void SetStoragePartition(StoragePartitionDescriptorPtr partition) = 0;

  virtual void CloseNow() = 0;

  virtual void GoBack() = 0;

  virtual void GoForward() = 0;

  virtual void GoToNavigationEntry(int32_t navigation_entry_id) = 0;

  using LoadNavigationEntriesCallback = base::OnceCallback<void(std::vector<NavigationEntryPtr>, int32_t)>;
  using LoadNavigationEntriesMojoCallback = base::OnceCallback<void(std::vector<NavigationEntryPtr>, int32_t)>;

  virtual void LoadNavigationEntries(LoadNavigationEntriesCallback callback) = 0;

  virtual void ClearForwardHistory() = 0;

  virtual void Stop() = 0;

  virtual void Reload(bool skip_cache) = 0;

  using EvaluateJavaScriptCallback = base::OnceCallback<void(::base::Value)>;
  using EvaluateJavaScriptMojoCallback = base::OnceCallback<void(::base::Value)>;

  virtual void EvaluateJavaScript(const std::string& script, bool use_main_world, EvaluateJavaScriptCallback callback) = 0;

  using EvaluateJavaScriptWithArgumentsCallback = base::OnceCallback<void(::base::Value)>;
  using EvaluateJavaScriptWithArgumentsMojoCallback = base::OnceCallback<void(::base::Value)>;

  virtual void EvaluateJavaScriptWithArguments(const std::string& script, bool use_main_world, base::flat_map<std::string, ::base::Value> arguments, bool should_await, EvaluateJavaScriptWithArgumentsCallback callback) = 0;

  using TakeSnapshotCallback = base::OnceCallback<void(SnapshotResultPtr)>;
  using TakeSnapshotMojoCallback = base::OnceCallback<void(SnapshotResultPtr)>;

  virtual void TakeSnapshot(std::optional<::base::TimeDelta> timeout, TakeSnapshotCallback callback) = 0;

  virtual void FindInPage(const std::string& text, FindDirection direction, ::mojo::PendingAssociatedRemote<FindClient> client) = 0;

  virtual void CancelFindInPage() = 0;

  virtual void SetAuthenticationURLScheme(const std::string& scheme) = 0;

  virtual void CreateDevToolsSession(::mojo::PendingAssociatedReceiver<DevToolsSession> session, ::mojo::PendingAssociatedRemote<DevToolsSessionClient> client) = 0;

  virtual void OpenDevTools(DevToolsPanel panel, DOMElementReferencePtr dom_element) = 0;

  virtual void ZoomIn() = 0;

  virtual void ZoomOut() = 0;

  virtual void ResetZoom() = 0;

  virtual void Mute() = 0;

  virtual void Unmute() = 0;

  virtual void CopyImage(int32_t frame_routing_id, int32_t frame_process_id, int32_t x, int32_t y) = 0;

  virtual void SaveMedia(::owl::mojom::ContextMenuParamsPtr params) = 0;

  virtual void LoopPlayback(::owl::mojom::ContextMenuParamsPtr params, bool loop_playback) = 0;

  virtual void ShowPlaybackControls(::owl::mojom::ContextMenuParamsPtr params, bool show_playback_controls) = 0;

  virtual void CopyVideoFrame(::owl::mojom::ContextMenuParamsPtr params) = 0;

  virtual void ShowInPictureInPicture(::owl::mojom::ContextMenuParamsPtr params, bool show_in_picture_in_picture) = 0;

  virtual void Undo() = 0;

  virtual void Redo() = 0;

  virtual void Cut() = 0;

  virtual void Copy() = 0;

  virtual void Paste() = 0;

  virtual void SelectAll() = 0;

  virtual void ReplaceMisspelledWord(const ::std::u16string& replacement) = 0;

  virtual void AddToDictionary(const ::std::u16string& word) = 0;

  using CaptureCopyCallback = base::OnceCallback<void(ClipboardOverridePtr)>;
  using CaptureCopyMojoCallback = base::OnceCallback<void(ClipboardOverridePtr)>;

  virtual void CaptureCopy(CaptureCopyCallback callback) = 0;

  using InsertViaPasteCallback = base::OnceCallback<void(bool)>;
  using InsertViaPasteMojoCallback = base::OnceCallback<void(bool)>;

  virtual void InsertViaPaste(ClipboardOverridePtr contents, InsertViaPasteCallback callback) = 0;

  virtual void SetCancelOffOriginLinkLoads(bool cancel_off_origin_link_loads) = 0;

  virtual void ForceRendererCrash() = 0;

  using FetchCertificateChainCallback = base::OnceCallback<void(CertificateChainPtr)>;
  using FetchCertificateChainMojoCallback = base::OnceCallback<void(CertificateChainPtr)>;

  virtual void FetchCertificateChain(FetchCertificateChainCallback callback) = 0;

  virtual void DisablePasswordManagement() = 0;

  using ExtractAnnotatedTextCallback = base::OnceCallback<void(const std::string&)>;
  using ExtractAnnotatedTextMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void ExtractAnnotatedText(uint64_t char_count_goal, ExtractAnnotatedTextCallback callback) = 0;

  using ExtractSerializedDomCallback = base::OnceCallback<void(const std::string&)>;
  using ExtractSerializedDomMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void ExtractSerializedDom(ExtractSerializedDomCallback callback) = 0;

  using ExtractSerializedDomElementInfoCallback = base::OnceCallback<void(SerializedDomElementInfoPtr)>;
  using ExtractSerializedDomElementInfoMojoCallback = base::OnceCallback<void(SerializedDomElementInfoPtr)>;

  virtual void ExtractSerializedDomElementInfo(const std::string& id, ExtractSerializedDomElementInfoCallback callback) = 0;

  virtual void WillExitFullScreenMode() = 0;

  virtual void RequestPrintPreview() = 0;

  virtual void RegisterProtocolHandler() = 0;

  virtual void SetBackgroundColor(::SkColor color) = 0;

  virtual void NotifyUserActivation() = 0;

  using GetDiagnosticsCallback = base::OnceCallback<void(WebViewDiagnosticsPtr)>;
  using GetDiagnosticsMojoCallback = base::OnceCallback<void(WebViewDiagnosticsPtr)>;

  virtual void GetDiagnostics(GetDiagnosticsCallback callback) = 0;
};

class TabSharingSessionProxy;

template <typename ImplRefTraits>
class TabSharingSessionStub;

class TabSharingSessionRequestValidator;


class TabSharingSession
    : public TabSharingSessionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.TabSharingSession";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TabSharingSessionInterfaceBase;
  using Proxy_ = TabSharingSessionProxy;

  template <typename ImplRefTraits>
  using Stub_ = TabSharingSessionStub<ImplRefTraits>;

  using RequestValidator_ = TabSharingSessionRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartSharingThisTabMinVersion = 0,
    kStopTabSharingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartSharingThisTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopTabSharing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TabSharingSession() = default;

  virtual void StartSharingThisTab() = 0;

  virtual void StopTabSharing() = 0;
};

class CertSelectionCancellationProxy;

template <typename ImplRefTraits>
class CertSelectionCancellationStub;

class CertSelectionCancellationRequestValidator;


class CertSelectionCancellation
    : public CertSelectionCancellationInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.CertSelectionCancellation";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CertSelectionCancellationInterfaceBase;
  using Proxy_ = CertSelectionCancellationProxy;

  template <typename ImplRefTraits>
  using Stub_ = CertSelectionCancellationStub<ImplRefTraits>;

  using RequestValidator_ = CertSelectionCancellationRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCancelCertSelectionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CancelCertSelection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CertSelectionCancellation() = default;

  virtual void CancelCertSelection() = 0;
};

class WebViewClientProxy;

template <typename ImplRefTraits>
class WebViewClientStub;

class WebViewClientRequestValidator;
class WebViewClientResponseValidator;


class WebViewClient
    : public WebViewClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WebViewClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebViewClientInterfaceBase;
  using Proxy_ = WebViewClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebViewClientStub<ImplRefTraits>;

  using RequestValidator_ = WebViewClientRequestValidator;
  using ResponseValidator_ = WebViewClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCurrentURLChangedMinVersion = 0,
    kCurrentTitleChangedMinVersion = 0,
    kCurrentFaviconChangedMinVersion = 0,
    kCurrentMimeTypeChangedMinVersion = 0,
    kCanGoBackForwardChangedMinVersion = 0,
    kSessionDataChangedMinVersion = 0,
    kDidCommitMinVersion = 0,
    kLoadingStateChangedMinVersion = 0,
    kUpdateTargetURLMinVersion = 0,
    kZoomStateChangedMinVersion = 0,
    kMuteStateChangedMinVersion = 0,
    kOnVisibleSecurityStateChangedMinVersion = 0,
    kShowTabSharingButtonsMinVersion = 0,
    kRemoveTabSharingButtonsMinVersion = 0,
    kOnCloseRequestedByHostMinVersion = 0,
    kActivateContentMinVersion = 0,
    kRenderProcessStatusChangedMinVersion = 0,
    kPrimaryPageChangedMinVersion = 0,
    kSelectClientCertMinVersion = 0,
    kRunJavaScriptDialogMinVersion = 0,
    kRunBeforeUnloadDialogMinVersion = 0,
    kShowRepostFormWarningDialogMinVersion = 0,
    kEnterFullScreenMinVersion = 0,
    kExitFullScreenMinVersion = 0,
    kOnAuthenticationURLSchemeFoundMinVersion = 0,
    kCreatedNewWebViewMinVersion = 0,
    kDevToolsDockSideChangedMinVersion = 0,
    kDevToolsClosedMinVersion = 0,
    kRedispatchKeyEventMinVersion = 0,
    kCreateWindowBridgeMinVersion = 0,
    kBindFrontendHostMinVersion = 0,
    kOnTabRendererDataChangedMinVersion = 0,
    kOnFocusChangedInPageMinVersion = 0,
    kOnOffOriginLinkLoadCanceledMinVersion = 0,
    kGoBackOrLoadNewTabMinVersion = 0,
    kShowPermissionPromptMinVersion = 0,
    kShowSavePasswordPromptMinVersion = 0,
    kShowSaveAddressPromptMinVersion = 0,
    kShowSaveCardPromptMinVersion = 0,
    kShowAutofillPopupMinVersion = 0,
    kSetPreferredSizeFromAutoResizeMinVersion = 0,
    kDeleteBrowsingDataMinVersion = 0,
    kCanDeleteHistoryMinVersion = 0,
    kSetHasPendingProtocolHandlerMinVersion = 0,
    kGoToHistoryItemAtOffsetMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CurrentURLChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CurrentTitleChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CurrentFaviconChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CurrentMimeTypeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CanGoBackForwardChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SessionDataChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidCommit_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadingStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateTargetURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ZoomStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MuteStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnVisibleSecurityStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowTabSharingButtons_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveTabSharingButtons_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCloseRequestedByHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ActivateContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RenderProcessStatusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrimaryPageChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SelectClientCert_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunJavaScriptDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunBeforeUnloadDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowRepostFormWarningDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnterFullScreen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExitFullScreen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAuthenticationURLSchemeFound_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreatedNewWebView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DevToolsDockSideChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DevToolsClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RedispatchKeyEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateWindowBridge_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindFrontendHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTabRendererDataChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFocusChangedInPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnOffOriginLinkLoadCanceled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GoBackOrLoadNewTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowPermissionPrompt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowSavePasswordPrompt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowSaveAddressPrompt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowSaveCardPrompt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowAutofillPopup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPreferredSizeFromAutoResize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteBrowsingData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CanDeleteHistory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetHasPendingProtocolHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GoToHistoryItemAtOffset_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebViewClient() = default;

  virtual void CurrentURLChanged(NavigationEntryUrlPtr entryUrl) = 0;

  virtual void CurrentTitleChanged(const std::optional<::std::u16string>& title) = 0;

  virtual void CurrentFaviconChanged(const std::optional<::GURL>& favicon_url) = 0;

  virtual void CurrentMimeTypeChanged(const std::string& mime_type) = 0;

  virtual void CanGoBackForwardChanged(BackForwardStatePtr back_forward_state) = 0;

  virtual void SessionDataChanged(const std::vector<uint8_t>& session_data) = 0;

  virtual void DidCommit(CommitDetailsPtr details) = 0;

  virtual void LoadingStateChanged(bool is_loading, double progress) = 0;

  virtual void UpdateTargetURL(const std::optional<::GURL>& target_url) = 0;

  virtual void ZoomStateChanged(bool can_zoom_in, bool can_zoom_out, bool can_reset_zoom) = 0;

  virtual void MuteStateChanged(bool is_muted) = 0;

  virtual void OnVisibleSecurityStateChanged(SecurityLevel security_level) = 0;

  virtual void ShowTabSharingButtons(uint64_t shared_tab_id, uint64_t capturer_id, TabSharingTabRole role, TabSharingButtonState share_this_tab_instead_button_state, ::mojo::PendingAssociatedRemote<TabSharingSession> tab_sharing_session) = 0;

  virtual void RemoveTabSharingButtons() = 0;

  virtual void OnCloseRequestedByHost() = 0;

  virtual void ActivateContent() = 0;

  virtual void RenderProcessStatusChanged(RenderProcessStatus status) = 0;

  virtual void PrimaryPageChanged() = 0;

  using SelectClientCertCallback = base::OnceCallback<void(std::optional<uint32_t>)>;
  using SelectClientCertMojoCallback = base::OnceCallback<void(std::optional<uint32_t>)>;

  virtual void SelectClientCert(const std::string& host, uint16_t port, std::vector<ClientCertMetadataPtr> available_certs, ::mojo::PendingAssociatedReceiver<CertSelectionCancellation> cancellation_receiver, SelectClientCertCallback callback) = 0;

  using RunJavaScriptDialogCallback = base::OnceCallback<void(bool, const ::std::u16string&)>;
  using RunJavaScriptDialogMojoCallback = base::OnceCallback<void(bool, const ::std::u16string&)>;

  virtual void RunJavaScriptDialog(const ::GURL& requesting_origin, JavaScriptDialogType dialog_type, const ::std::u16string& message, const ::std::u16string& default_prompt, RunJavaScriptDialogCallback callback) = 0;

  using RunBeforeUnloadDialogCallback = base::OnceCallback<void(bool, const ::std::u16string&)>;
  using RunBeforeUnloadDialogMojoCallback = base::OnceCallback<void(bool, const ::std::u16string&)>;

  virtual void RunBeforeUnloadDialog(bool is_reload, RunBeforeUnloadDialogCallback callback) = 0;

  using ShowRepostFormWarningDialogCallback = base::OnceCallback<void(RepostFormWarningResponse)>;
  using ShowRepostFormWarningDialogMojoCallback = base::OnceCallback<void(RepostFormWarningResponse)>;

  virtual void ShowRepostFormWarningDialog(ShowRepostFormWarningDialogCallback callback) = 0;

  using EnterFullScreenCallback = base::OnceCallback<void(bool)>;
  using EnterFullScreenMojoCallback = base::OnceCallback<void(bool)>;

  virtual void EnterFullScreen(::blink::mojom::FullscreenOptionsPtr options, EnterFullScreenCallback callback) = 0;

  virtual void ExitFullScreen() = 0;

  virtual void OnAuthenticationURLSchemeFound(const ::GURL& url) = 0;

  virtual void CreatedNewWebView(uint64_t web_content_id, WebViewDispositionPtr disposition, ::mojo::PendingAssociatedRemote<WebView> web_view, ::mojo::PendingAssociatedReceiver<WebViewClient> web_view_client, const std::optional<std::string>& group_id) = 0;

  virtual void DevToolsDockSideChanged(DevToolsDockSide dock_side) = 0;

  virtual void DevToolsClosed() = 0;

  virtual void RedispatchKeyEvent(const std::vector<uint8_t>& native_event_data, ::blink::mojom::InputSource original_input_source) = 0;

  virtual void CreateWindowBridge(WindowBridgeSource source, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> receiver) = 0;

  virtual void BindFrontendHost(::mojo::PendingReceiver<::owl::mojom::ChatGPTFrontendHost> receiver) = 0;

  virtual void OnTabRendererDataChanged(TabRendererDataPtr data) = 0;

  virtual void OnFocusChangedInPage(bool focused_element_is_editable, const ::gfx::Rect& node_bounds_in_view) = 0;

  virtual void OnOffOriginLinkLoadCanceled(const ::GURL& link_url) = 0;

  virtual void GoBackOrLoadNewTab() = 0;

  virtual void ShowPermissionPrompt(::owl::mojom::PermissionPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::PermissionPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::PermissionPromptClient> prompt_client) = 0;

  virtual void ShowSavePasswordPrompt(::owl::mojom::SavePasswordPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SavePasswordPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SavePasswordPromptClient> prompt_client) = 0;

  virtual void ShowSaveAddressPrompt(::owl::mojom::SaveAddressPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveAddressPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SaveAddressPromptClient> prompt_client) = 0;

  virtual void ShowSaveCardPrompt(::owl::mojom::SaveCardPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveCardPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SaveCardPromptClient> prompt_client) = 0;

  virtual void ShowAutofillPopup(::owl::mojom::AutofillPopupDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillPopup> popup, ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillPopupClient> popup_client) = 0;

  virtual void SetPreferredSizeFromAutoResize(const ::gfx::Size& new_size) = 0;

  virtual void DeleteBrowsingData() = 0;

  using CanDeleteHistoryCallback = base::OnceCallback<void(bool)>;
  using CanDeleteHistoryMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CanDeleteHistory(int32_t page_count, CanDeleteHistoryCallback callback) = 0;

  virtual void SetHasPendingProtocolHandler(bool value) = 0;

  virtual void GoToHistoryItemAtOffset(int32_t offset) = 0;
};



class  FindClientProxy
    : public FindClient {
 public:
  using InterfaceType = FindClient;

  explicit FindClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnFindResult(FindResultPtr result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DevToolsSessionProxy
    : public DevToolsSession {
 public:
  using InterfaceType = DevToolsSession;

  explicit DevToolsSessionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendProtocolMessage(const std::string& message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DevToolsSessionClientProxy
    : public DevToolsSessionClient {
 public:
  using InterfaceType = DevToolsSessionClient;

  explicit DevToolsSessionClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnProtocolMessage(const std::string& message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebViewProxy
    : public WebView {
 public:
  using InterfaceType = WebView;

  explicit WebViewProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void MoveToGroup(const std::string& group_id) final;
  
  void NavigateTo(const ::GURL& url, NavigationType type, const std::string& additional_headers) final;
  
  void SetStoragePartition(StoragePartitionDescriptorPtr partition) final;
  
  void CloseNow() final;
  
  void GoBack() final;
  
  void GoForward() final;
  
  void GoToNavigationEntry(int32_t navigation_entry_id) final;
  
  void LoadNavigationEntries(LoadNavigationEntriesCallback callback) final;
  
  void ClearForwardHistory() final;
  
  void Stop() final;
  
  void Reload(bool skip_cache) final;
  
  void EvaluateJavaScript(const std::string& script, bool use_main_world, EvaluateJavaScriptCallback callback) final;
  
  void EvaluateJavaScriptWithArguments(const std::string& script, bool use_main_world, base::flat_map<std::string, ::base::Value> arguments, bool should_await, EvaluateJavaScriptWithArgumentsCallback callback) final;
  
  void TakeSnapshot(std::optional<::base::TimeDelta> timeout, TakeSnapshotCallback callback) final;
  
  void FindInPage(const std::string& text, FindDirection direction, ::mojo::PendingAssociatedRemote<FindClient> client) final;
  
  void CancelFindInPage() final;
  
  void SetAuthenticationURLScheme(const std::string& scheme) final;
  
  void CreateDevToolsSession(::mojo::PendingAssociatedReceiver<DevToolsSession> session, ::mojo::PendingAssociatedRemote<DevToolsSessionClient> client) final;
  
  void OpenDevTools(DevToolsPanel panel, DOMElementReferencePtr dom_element) final;
  
  void ZoomIn() final;
  
  void ZoomOut() final;
  
  void ResetZoom() final;
  
  void Mute() final;
  
  void Unmute() final;
  
  void CopyImage(int32_t frame_routing_id, int32_t frame_process_id, int32_t x, int32_t y) final;
  
  void SaveMedia(::owl::mojom::ContextMenuParamsPtr params) final;
  
  void LoopPlayback(::owl::mojom::ContextMenuParamsPtr params, bool loop_playback) final;
  
  void ShowPlaybackControls(::owl::mojom::ContextMenuParamsPtr params, bool show_playback_controls) final;
  
  void CopyVideoFrame(::owl::mojom::ContextMenuParamsPtr params) final;
  
  void ShowInPictureInPicture(::owl::mojom::ContextMenuParamsPtr params, bool show_in_picture_in_picture) final;
  
  void Undo() final;
  
  void Redo() final;
  
  void Cut() final;
  
  void Copy() final;
  
  void Paste() final;
  
  void SelectAll() final;
  
  void ReplaceMisspelledWord(const ::std::u16string& replacement) final;
  
  void AddToDictionary(const ::std::u16string& word) final;
  
  void CaptureCopy(CaptureCopyCallback callback) final;
  
  void InsertViaPaste(ClipboardOverridePtr contents, InsertViaPasteCallback callback) final;
  
  void SetCancelOffOriginLinkLoads(bool cancel_off_origin_link_loads) final;
  
  void ForceRendererCrash() final;
  
  void FetchCertificateChain(FetchCertificateChainCallback callback) final;
  
  void DisablePasswordManagement() final;
  
  void ExtractAnnotatedText(uint64_t char_count_goal, ExtractAnnotatedTextCallback callback) final;
  
  void ExtractSerializedDom(ExtractSerializedDomCallback callback) final;
  
  void ExtractSerializedDomElementInfo(const std::string& id, ExtractSerializedDomElementInfoCallback callback) final;
  
  void WillExitFullScreenMode() final;
  
  void RequestPrintPreview() final;
  
  void RegisterProtocolHandler() final;
  
  void SetBackgroundColor(::SkColor color) final;
  
  void NotifyUserActivation() final;
  
  void GetDiagnostics(GetDiagnosticsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  TabSharingSessionProxy
    : public TabSharingSession {
 public:
  using InterfaceType = TabSharingSession;

  explicit TabSharingSessionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartSharingThisTab() final;
  
  void StopTabSharing() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CertSelectionCancellationProxy
    : public CertSelectionCancellation {
 public:
  using InterfaceType = CertSelectionCancellation;

  explicit CertSelectionCancellationProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CancelCertSelection() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebViewClientProxy
    : public WebViewClient {
 public:
  using InterfaceType = WebViewClient;

  explicit WebViewClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CurrentURLChanged(NavigationEntryUrlPtr entryUrl) final;
  
  void CurrentTitleChanged(const std::optional<::std::u16string>& title) final;
  
  void CurrentFaviconChanged(const std::optional<::GURL>& favicon_url) final;
  
  void CurrentMimeTypeChanged(const std::string& mime_type) final;
  
  void CanGoBackForwardChanged(BackForwardStatePtr back_forward_state) final;
  
  void SessionDataChanged(const std::vector<uint8_t>& session_data) final;
  
  void DidCommit(CommitDetailsPtr details) final;
  
  void LoadingStateChanged(bool is_loading, double progress) final;
  
  void UpdateTargetURL(const std::optional<::GURL>& target_url) final;
  
  void ZoomStateChanged(bool can_zoom_in, bool can_zoom_out, bool can_reset_zoom) final;
  
  void MuteStateChanged(bool is_muted) final;
  
  void OnVisibleSecurityStateChanged(SecurityLevel security_level) final;
  
  void ShowTabSharingButtons(uint64_t shared_tab_id, uint64_t capturer_id, TabSharingTabRole role, TabSharingButtonState share_this_tab_instead_button_state, ::mojo::PendingAssociatedRemote<TabSharingSession> tab_sharing_session) final;
  
  void RemoveTabSharingButtons() final;
  
  void OnCloseRequestedByHost() final;
  
  void ActivateContent() final;
  
  void RenderProcessStatusChanged(RenderProcessStatus status) final;
  
  void PrimaryPageChanged() final;
  
  void SelectClientCert(const std::string& host, uint16_t port, std::vector<ClientCertMetadataPtr> available_certs, ::mojo::PendingAssociatedReceiver<CertSelectionCancellation> cancellation_receiver, SelectClientCertCallback callback) final;
  
  void RunJavaScriptDialog(const ::GURL& requesting_origin, JavaScriptDialogType dialog_type, const ::std::u16string& message, const ::std::u16string& default_prompt, RunJavaScriptDialogCallback callback) final;
  
  void RunBeforeUnloadDialog(bool is_reload, RunBeforeUnloadDialogCallback callback) final;
  
  void ShowRepostFormWarningDialog(ShowRepostFormWarningDialogCallback callback) final;
  
  void EnterFullScreen(::blink::mojom::FullscreenOptionsPtr options, EnterFullScreenCallback callback) final;
  
  void ExitFullScreen() final;
  
  void OnAuthenticationURLSchemeFound(const ::GURL& url) final;
  
  void CreatedNewWebView(uint64_t web_content_id, WebViewDispositionPtr disposition, ::mojo::PendingAssociatedRemote<WebView> web_view, ::mojo::PendingAssociatedReceiver<WebViewClient> web_view_client, const std::optional<std::string>& group_id) final;
  
  void DevToolsDockSideChanged(DevToolsDockSide dock_side) final;
  
  void DevToolsClosed() final;
  
  void RedispatchKeyEvent(const std::vector<uint8_t>& native_event_data, ::blink::mojom::InputSource original_input_source) final;
  
  void CreateWindowBridge(WindowBridgeSource source, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> receiver) final;
  
  void BindFrontendHost(::mojo::PendingReceiver<::owl::mojom::ChatGPTFrontendHost> receiver) final;
  
  void OnTabRendererDataChanged(TabRendererDataPtr data) final;
  
  void OnFocusChangedInPage(bool focused_element_is_editable, const ::gfx::Rect& node_bounds_in_view) final;
  
  void OnOffOriginLinkLoadCanceled(const ::GURL& link_url) final;
  
  void GoBackOrLoadNewTab() final;
  
  void ShowPermissionPrompt(::owl::mojom::PermissionPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::PermissionPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::PermissionPromptClient> prompt_client) final;
  
  void ShowSavePasswordPrompt(::owl::mojom::SavePasswordPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SavePasswordPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SavePasswordPromptClient> prompt_client) final;
  
  void ShowSaveAddressPrompt(::owl::mojom::SaveAddressPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveAddressPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SaveAddressPromptClient> prompt_client) final;
  
  void ShowSaveCardPrompt(::owl::mojom::SaveCardPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveCardPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SaveCardPromptClient> prompt_client) final;
  
  void ShowAutofillPopup(::owl::mojom::AutofillPopupDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillPopup> popup, ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillPopupClient> popup_client) final;
  
  void SetPreferredSizeFromAutoResize(const ::gfx::Size& new_size) final;
  
  void DeleteBrowsingData() final;
  
  void CanDeleteHistory(int32_t page_count, CanDeleteHistoryCallback callback) final;
  
  void SetHasPendingProtocolHandler(bool value) final;
  
  void GoToHistoryItemAtOffset(int32_t offset) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FindClientStubDispatch {
 public:
  static bool Accept(FindClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FindClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FindClient>>
class FindClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FindClientStub() = default;
  ~FindClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FindClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FindClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DevToolsSessionStubDispatch {
 public:
  static bool Accept(DevToolsSession* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DevToolsSession* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DevToolsSession>>
class DevToolsSessionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DevToolsSessionStub() = default;
  ~DevToolsSessionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsSessionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsSessionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DevToolsSessionClientStubDispatch {
 public:
  static bool Accept(DevToolsSessionClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DevToolsSessionClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DevToolsSessionClient>>
class DevToolsSessionClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DevToolsSessionClientStub() = default;
  ~DevToolsSessionClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsSessionClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsSessionClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebViewStubDispatch {
 public:
  static bool Accept(WebView* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebView* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebView>>
class WebViewStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebViewStub() = default;
  ~WebViewStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebViewStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebViewStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TabSharingSessionStubDispatch {
 public:
  static bool Accept(TabSharingSession* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TabSharingSession* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TabSharingSession>>
class TabSharingSessionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TabSharingSessionStub() = default;
  ~TabSharingSessionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TabSharingSessionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TabSharingSessionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CertSelectionCancellationStubDispatch {
 public:
  static bool Accept(CertSelectionCancellation* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CertSelectionCancellation* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CertSelectionCancellation>>
class CertSelectionCancellationStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CertSelectionCancellationStub() = default;
  ~CertSelectionCancellationStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertSelectionCancellationStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertSelectionCancellationStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebViewClientStubDispatch {
 public:
  static bool Accept(WebViewClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebViewClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebViewClient>>
class WebViewClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebViewClientStub() = default;
  ~WebViewClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebViewClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebViewClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FindClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DevToolsSessionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DevToolsSessionClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebViewRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TabSharingSessionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CertSelectionCancellationRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebViewClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebViewResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebViewClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  FindResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FindResult, T>::value>;
  using DataView = FindResultDataView;
  using Data_ = internal::FindResult_Data;

  template <typename... Args>
  static FindResultPtr New(Args&&... args) {
    return FindResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FindResultPtr From(const U& u) {
    return mojo::TypeConverter<FindResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FindResult>::Convert(*this);
  }


  FindResult();

  FindResult(
      int32_t current_match_index,
      int32_t number_of_matches);


  ~FindResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FindResultPtr>
  FindResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FindResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FindResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FindResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FindResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FindResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FindResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FindResult_UnserializedMessageContext<
            UserType, FindResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FindResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FindResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FindResult_UnserializedMessageContext<
            UserType, FindResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FindResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t current_match_index;
  
  int32_t number_of_matches;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FindResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FindResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FindResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FindResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DOMElementReference {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DOMElementReference, T>::value>;
  using DataView = DOMElementReferenceDataView;
  using Data_ = internal::DOMElementReference_Data;

  template <typename... Args>
  static DOMElementReferencePtr New(Args&&... args) {
    return DOMElementReferencePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DOMElementReferencePtr From(const U& u) {
    return mojo::TypeConverter<DOMElementReferencePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DOMElementReference>::Convert(*this);
  }


  DOMElementReference();

  DOMElementReference(
      int32_t frame_routing_id,
      int32_t frame_process_id,
      int32_t x,
      int32_t y);


  ~DOMElementReference();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DOMElementReferencePtr>
  DOMElementReferencePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DOMElementReference::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DOMElementReference::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DOMElementReference::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DOMElementReference::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DOMElementReference::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DOMElementReference::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DOMElementReference_UnserializedMessageContext<
            UserType, DOMElementReference::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DOMElementReference::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DOMElementReference::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DOMElementReference_UnserializedMessageContext<
            UserType, DOMElementReference::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DOMElementReference::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t frame_routing_id;
  
  int32_t frame_process_id;
  
  int32_t x;
  
  int32_t y;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DOMElementReference::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DOMElementReference::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DOMElementReference::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DOMElementReference::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  StoragePartitionDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StoragePartitionDescriptor, T>::value>;
  using DataView = StoragePartitionDescriptorDataView;
  using Data_ = internal::StoragePartitionDescriptor_Data;

  template <typename... Args>
  static StoragePartitionDescriptorPtr New(Args&&... args) {
    return StoragePartitionDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StoragePartitionDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<StoragePartitionDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StoragePartitionDescriptor>::Convert(*this);
  }


  StoragePartitionDescriptor();

  StoragePartitionDescriptor(
      const std::string& partition_domain,
      const std::string& partition_name,
      bool in_memory);


  ~StoragePartitionDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StoragePartitionDescriptorPtr>
  StoragePartitionDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StoragePartitionDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StoragePartitionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StoragePartitionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StoragePartitionDescriptor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StoragePartitionDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StoragePartitionDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StoragePartitionDescriptor_UnserializedMessageContext<
            UserType, StoragePartitionDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StoragePartitionDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StoragePartitionDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StoragePartitionDescriptor_UnserializedMessageContext<
            UserType, StoragePartitionDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StoragePartitionDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string partition_domain;
  
  std::string partition_name;
  
  bool in_memory;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StoragePartitionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StoragePartitionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StoragePartitionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StoragePartitionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ClientCertMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClientCertMetadata, T>::value>;
  using DataView = ClientCertMetadataDataView;
  using Data_ = internal::ClientCertMetadata_Data;

  template <typename... Args>
  static ClientCertMetadataPtr New(Args&&... args) {
    return ClientCertMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClientCertMetadataPtr From(const U& u) {
    return mojo::TypeConverter<ClientCertMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClientCertMetadata>::Convert(*this);
  }


  ClientCertMetadata();

  ClientCertMetadata(
      const std::string& subject,
      const std::string& issuer,
      const std::string& serial);


  ~ClientCertMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClientCertMetadataPtr>
  ClientCertMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClientCertMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClientCertMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClientCertMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClientCertMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClientCertMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClientCertMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClientCertMetadata_UnserializedMessageContext<
            UserType, ClientCertMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClientCertMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClientCertMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClientCertMetadata_UnserializedMessageContext<
            UserType, ClientCertMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClientCertMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string subject;
  
  std::string issuer;
  
  std::string serial;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClientCertMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClientCertMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClientCertMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClientCertMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  ExtensionPopupContext {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExtensionPopupContext, T>::value>;
  using DataView = ExtensionPopupContextDataView;
  using Data_ = internal::ExtensionPopupContext_Data;

  template <typename... Args>
  static ExtensionPopupContextPtr New(Args&&... args) {
    return ExtensionPopupContextPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExtensionPopupContextPtr From(const U& u) {
    return mojo::TypeConverter<ExtensionPopupContextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtensionPopupContext>::Convert(*this);
  }


  ExtensionPopupContext();

  explicit ExtensionPopupContext(
      const std::string& extension_id);


  ~ExtensionPopupContext();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExtensionPopupContextPtr>
  ExtensionPopupContextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExtensionPopupContext::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExtensionPopupContext::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExtensionPopupContext::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionPopupContext::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionPopupContext::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtensionPopupContext::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExtensionPopupContext_UnserializedMessageContext<
            UserType, ExtensionPopupContext::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExtensionPopupContext::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExtensionPopupContext::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExtensionPopupContext_UnserializedMessageContext<
            UserType, ExtensionPopupContext::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExtensionPopupContext::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string extension_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExtensionPopupContext::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExtensionPopupContext::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExtensionPopupContext::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExtensionPopupContext::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DevToolsContext {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DevToolsContext, T>::value>;
  using DataView = DevToolsContextDataView;
  using Data_ = internal::DevToolsContext_Data;

  template <typename... Args>
  static DevToolsContextPtr New(Args&&... args) {
    return DevToolsContextPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DevToolsContextPtr From(const U& u) {
    return mojo::TypeConverter<DevToolsContextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DevToolsContext>::Convert(*this);
  }


  DevToolsContext();

  explicit DevToolsContext(
      DevToolsDockSide dock_side);


  ~DevToolsContext();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DevToolsContextPtr>
  DevToolsContextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DevToolsContext::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DevToolsContext::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DevToolsContext::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DevToolsContext::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DevToolsContext::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DevToolsContext::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DevToolsContext_UnserializedMessageContext<
            UserType, DevToolsContext::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DevToolsContext::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DevToolsContext::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DevToolsContext_UnserializedMessageContext<
            UserType, DevToolsContext::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DevToolsContext::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DevToolsDockSide dock_side;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DevToolsContext::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DevToolsContext::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DevToolsContext::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DevToolsContext::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BackForwardState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackForwardState, T>::value>;
  using DataView = BackForwardStateDataView;
  using Data_ = internal::BackForwardState_Data;

  template <typename... Args>
  static BackForwardStatePtr New(Args&&... args) {
    return BackForwardStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackForwardStatePtr From(const U& u) {
    return mojo::TypeConverter<BackForwardStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackForwardState>::Convert(*this);
  }


  BackForwardState();

  BackForwardState(
      bool can_go_back,
      bool can_go_forward);


  ~BackForwardState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackForwardStatePtr>
  BackForwardStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackForwardState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackForwardState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackForwardState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackForwardState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackForwardState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackForwardState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackForwardState_UnserializedMessageContext<
            UserType, BackForwardState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackForwardState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackForwardState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackForwardState_UnserializedMessageContext<
            UserType, BackForwardState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackForwardState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool can_go_back;
  
  bool can_go_forward;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackForwardState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackForwardState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackForwardState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackForwardState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  SnapshotResult {
 public:
  using DataView = SnapshotResultDataView;
  using Data_ = internal::SnapshotResult_Data;
  using Tag = Data_::SnapshotResult_Tag;

  template <typename... Args>
  static SnapshotResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |image|.
  static SnapshotResultPtr NewImage(
      const ::SkBitmap& value);
  // Construct an instance holding |error|.
  static SnapshotResultPtr NewError(
      const std::string& value);

  template <typename U>
  static SnapshotResultPtr From(const U& u) {
    return mojo::TypeConverter<SnapshotResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SnapshotResult>::Convert(*this);
  }
  ~SnapshotResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SnapshotResult(const SnapshotResult& other) = delete;
  SnapshotResult& operator=(const SnapshotResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SnapshotResultPtr>
  SnapshotResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SnapshotResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SnapshotResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_image() const { return tag_ == Tag::kImage; }
  const ::SkBitmap& get_image() const {
    CHECK(tag_ == Tag::kImage);
    return data_.image;
  }
  ::SkBitmap& get_image() {
    CHECK(tag_ == Tag::kImage);
    return data_.image;
  }
  void set_image(const ::SkBitmap& image);

  bool is_error() const { return tag_ == Tag::kError; }
  const std::string& get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  std::string& get_error() {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(const std::string& error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SnapshotResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SnapshotResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kImage)>,
        const ::SkBitmap& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        const std::string& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::SkBitmap image;
    std::string error;
  };

  SnapshotResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kImage)>,
      const ::SkBitmap& value);
  SnapshotResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      const std::string& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  WebViewDisposition {
 public:
  using DataView = WebViewDispositionDataView;
  using Data_ = internal::WebViewDisposition_Data;
  using Tag = Data_::WebViewDisposition_Tag;

  template <typename... Args>
  static WebViewDispositionPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |window_open|.
  static WebViewDispositionPtr NewWindowOpen(
      WindowOpenContextPtr value);
  // Construct an instance holding |picture_in_picture|.
  static WebViewDispositionPtr NewPictureInPicture(
      PictureInPictureConfigPtr value);
  // Construct an instance holding |print_preview|.
  static WebViewDispositionPtr NewPrintPreview(
      bool value);
  // Construct an instance holding |extension_popup|.
  static WebViewDispositionPtr NewExtensionPopup(
      ExtensionPopupContextPtr value);
  // Construct an instance holding |dev_tools|.
  static WebViewDispositionPtr NewDevTools(
      DevToolsContextPtr value);

  template <typename U>
  static WebViewDispositionPtr From(const U& u) {
    return mojo::TypeConverter<WebViewDispositionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebViewDisposition>::Convert(*this);
  }
  ~WebViewDisposition();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  WebViewDisposition(const WebViewDisposition& other) = delete;
  WebViewDisposition& operator=(const WebViewDisposition& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WebViewDispositionPtr>
  WebViewDispositionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebViewDisposition>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebViewDisposition>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_window_open() const { return tag_ == Tag::kWindowOpen; }
  const WindowOpenContextPtr& get_window_open() const {
    CHECK(tag_ == Tag::kWindowOpen);
    return data_.window_open;
  }
  WindowOpenContextPtr& get_window_open() {
    CHECK(tag_ == Tag::kWindowOpen);
    return data_.window_open;
  }
  void set_window_open(WindowOpenContextPtr window_open);

  bool is_picture_in_picture() const { return tag_ == Tag::kPictureInPicture; }
  const PictureInPictureConfigPtr& get_picture_in_picture() const {
    CHECK(tag_ == Tag::kPictureInPicture);
    return data_.picture_in_picture;
  }
  PictureInPictureConfigPtr& get_picture_in_picture() {
    CHECK(tag_ == Tag::kPictureInPicture);
    return data_.picture_in_picture;
  }
  void set_picture_in_picture(PictureInPictureConfigPtr picture_in_picture);

  bool is_print_preview() const { return tag_ == Tag::kPrintPreview; }
  bool get_print_preview() const {
    CHECK(tag_ == Tag::kPrintPreview);
    return data_.print_preview;
  }
  void set_print_preview(bool print_preview);

  bool is_extension_popup() const { return tag_ == Tag::kExtensionPopup; }
  const ExtensionPopupContextPtr& get_extension_popup() const {
    CHECK(tag_ == Tag::kExtensionPopup);
    return data_.extension_popup;
  }
  ExtensionPopupContextPtr& get_extension_popup() {
    CHECK(tag_ == Tag::kExtensionPopup);
    return data_.extension_popup;
  }
  void set_extension_popup(ExtensionPopupContextPtr extension_popup);

  bool is_dev_tools() const { return tag_ == Tag::kDevTools; }
  const DevToolsContextPtr& get_dev_tools() const {
    CHECK(tag_ == Tag::kDevTools);
    return data_.dev_tools;
  }
  DevToolsContextPtr& get_dev_tools() {
    CHECK(tag_ == Tag::kDevTools);
    return data_.dev_tools;
  }
  void set_dev_tools(DevToolsContextPtr dev_tools);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebViewDisposition::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WebViewDisposition::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kWindowOpen)>,
        WindowOpenContextPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPictureInPicture)>,
        PictureInPictureConfigPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPrintPreview)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kExtensionPopup)>,
        ExtensionPopupContextPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDevTools)>,
        DevToolsContextPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    WindowOpenContextPtr window_open;
    PictureInPictureConfigPtr picture_in_picture;
    bool print_preview;
    ExtensionPopupContextPtr extension_popup;
    DevToolsContextPtr dev_tools;
  };

  WebViewDisposition(
      std::in_place_index_t<static_cast<size_t>(Tag::kWindowOpen)>,
      WindowOpenContextPtr value);
  WebViewDisposition(
      std::in_place_index_t<static_cast<size_t>(Tag::kPictureInPicture)>,
      PictureInPictureConfigPtr value);
  WebViewDisposition(
      std::in_place_index_t<static_cast<size_t>(Tag::kPrintPreview)>,
      bool value);
  WebViewDisposition(
      std::in_place_index_t<static_cast<size_t>(Tag::kExtensionPopup)>,
      ExtensionPopupContextPtr value);
  WebViewDisposition(
      std::in_place_index_t<static_cast<size_t>(Tag::kDevTools)>,
      DevToolsContextPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  WebViewDiagnostics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebViewDiagnostics, T>::value>;
  using DataView = WebViewDiagnosticsDataView;
  using Data_ = internal::WebViewDiagnostics_Data;

  template <typename... Args>
  static WebViewDiagnosticsPtr New(Args&&... args) {
    return WebViewDiagnosticsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebViewDiagnosticsPtr From(const U& u) {
    return mojo::TypeConverter<WebViewDiagnosticsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebViewDiagnostics>::Convert(*this);
  }


  WebViewDiagnostics();

  WebViewDiagnostics(
      bool needs_reload,
      bool has_uncommitted_navigation_in_primary_main_frame,
      bool is_waiting_for_response,
      bool is_deferred,
      std::optional<int32_t> net_load_state,
      const std::string& primary_main_frame_lifecycle,
      const ::GURL& last_committed_url,
      int32_t entry_count,
      int32_t pending_entry_index,
      int32_t current_entry_index,
      bool is_web_contents_visible,
      std::optional<bool> is_rwhv_visible,
      const std::optional<::gfx::Size>& rwhv_size);


  ~WebViewDiagnostics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebViewDiagnosticsPtr>
  WebViewDiagnosticsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebViewDiagnostics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebViewDiagnostics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebViewDiagnostics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebViewDiagnostics::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebViewDiagnostics::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebViewDiagnostics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebViewDiagnostics_UnserializedMessageContext<
            UserType, WebViewDiagnostics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebViewDiagnostics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebViewDiagnostics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebViewDiagnostics_UnserializedMessageContext<
            UserType, WebViewDiagnostics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebViewDiagnostics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool needs_reload;
  
  bool has_uncommitted_navigation_in_primary_main_frame;
  
  bool is_waiting_for_response;
  
  bool is_deferred;
  
  std::optional<int32_t> net_load_state;
  
  std::string primary_main_frame_lifecycle;
  
  ::GURL last_committed_url;
  
  int32_t entry_count;
  
  int32_t pending_entry_index;
  
  int32_t current_entry_index;
  
  bool is_web_contents_visible;
  
  std::optional<bool> is_rwhv_visible;
  
  std::optional<::gfx::Size> rwhv_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebViewDiagnostics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebViewDiagnostics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebViewDiagnostics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebViewDiagnostics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  NavigationEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigationEntry, T>::value>;
  using DataView = NavigationEntryDataView;
  using Data_ = internal::NavigationEntry_Data;

  template <typename... Args>
  static NavigationEntryPtr New(Args&&... args) {
    return NavigationEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigationEntryPtr From(const U& u) {
    return mojo::TypeConverter<NavigationEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigationEntry>::Convert(*this);
  }


  NavigationEntry();

  NavigationEntry(
      int32_t unique_id,
      const ::std::u16string& title,
      const ::GURL& url,
      const std::optional<::GURL>& favicon_url);


  ~NavigationEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigationEntryPtr>
  NavigationEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigationEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NavigationEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NavigationEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigationEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigationEntry_UnserializedMessageContext<
            UserType, NavigationEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NavigationEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NavigationEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigationEntry_UnserializedMessageContext<
            UserType, NavigationEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigationEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t unique_id;
  
  ::std::u16string title;
  
  ::GURL url;
  
  std::optional<::GURL> favicon_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigationEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigationEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigationEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigationEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SerializedDomElementInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerializedDomElementInfo, T>::value>;
  using DataView = SerializedDomElementInfoDataView;
  using Data_ = internal::SerializedDomElementInfo_Data;

  template <typename... Args>
  static SerializedDomElementInfoPtr New(Args&&... args) {
    return SerializedDomElementInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerializedDomElementInfoPtr From(const U& u) {
    return mojo::TypeConverter<SerializedDomElementInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerializedDomElementInfo>::Convert(*this);
  }


  SerializedDomElementInfo();

  SerializedDomElementInfo(
      const std::string& tag,
      const std::string& selector,
      const std::optional<::gfx::Rect>& visible_bounds,
      const std::optional<::gfx::Point>& click_point);


  ~SerializedDomElementInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerializedDomElementInfoPtr>
  SerializedDomElementInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerializedDomElementInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerializedDomElementInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerializedDomElementInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerializedDomElementInfo_UnserializedMessageContext<
            UserType, SerializedDomElementInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SerializedDomElementInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SerializedDomElementInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerializedDomElementInfo_UnserializedMessageContext<
            UserType, SerializedDomElementInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerializedDomElementInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string tag;
  
  std::string selector;
  
  std::optional<::gfx::Rect> visible_bounds;
  
  std::optional<::gfx::Point> click_point;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabRendererData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabRendererData, T>::value>;
  using DataView = TabRendererDataDataView;
  using Data_ = internal::TabRendererData_Data;

  template <typename... Args>
  static TabRendererDataPtr New(Args&&... args) {
    return TabRendererDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabRendererDataPtr From(const U& u) {
    return mojo::TypeConverter<TabRendererDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabRendererData>::Convert(*this);
  }


  TabRendererData();

  TabRendererData(
      bool blocked,
      bool crashed,
      std::vector<TabAlertState> alert_states,
      const ::gfx::ImageSkia& favicon_image,
      TabNetworkState network_state,
      bool should_hide_loading_throbber,
      const ::std::u16string& title,
      const ::GURL& last_committed_url,
      const ::GURL& visible_url);


  ~TabRendererData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabRendererDataPtr>
  TabRendererDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabRendererData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabRendererData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabRendererData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabRendererData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabRendererData_UnserializedMessageContext<
            UserType, TabRendererData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabRendererData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabRendererData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabRendererData_UnserializedMessageContext<
            UserType, TabRendererData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabRendererData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool blocked;
  
  bool crashed;
  
  std::vector<TabAlertState> alert_states;
  
  ::gfx::ImageSkia favicon_image;
  
  TabNetworkState network_state;
  
  bool should_hide_loading_throbber;
  
  ::std::u16string title;
  
  ::GURL last_committed_url;
  
  ::GURL visible_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabRendererData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabRendererData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabRendererData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabRendererData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ClipboardOverride {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClipboardOverride, T>::value>;
  using DataView = ClipboardOverrideDataView;
  using Data_ = internal::ClipboardOverride_Data;

  template <typename... Args>
  static ClipboardOverridePtr New(Args&&... args) {
    return ClipboardOverridePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClipboardOverridePtr From(const U& u) {
    return mojo::TypeConverter<ClipboardOverridePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClipboardOverride>::Convert(*this);
  }


  ClipboardOverride();

  ClipboardOverride(
      const std::optional<::std::u16string>& text,
      const std::optional<::std::u16string>& html);


  ~ClipboardOverride();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClipboardOverridePtr>
  ClipboardOverridePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClipboardOverride::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClipboardOverride::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClipboardOverride::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClipboardOverride::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClipboardOverride::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClipboardOverride::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClipboardOverride_UnserializedMessageContext<
            UserType, ClipboardOverride::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClipboardOverride::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClipboardOverride::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClipboardOverride_UnserializedMessageContext<
            UserType, ClipboardOverride::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClipboardOverride::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::std::u16string> text;
  
  std::optional<::std::u16string> html;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClipboardOverride::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClipboardOverride::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClipboardOverride::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClipboardOverride::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CertificateChain {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CertificateChain, T>::value>;
  using DataView = CertificateChainDataView;
  using Data_ = internal::CertificateChain_Data;

  template <typename... Args>
  static CertificateChainPtr New(Args&&... args) {
    return CertificateChainPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CertificateChainPtr From(const U& u) {
    return mojo::TypeConverter<CertificateChainPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CertificateChain>::Convert(*this);
  }


  CertificateChain();

  explicit CertificateChain(
      std::vector<std::vector<uint8_t>> der_chain);


  ~CertificateChain();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CertificateChainPtr>
  CertificateChainPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CertificateChain::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CertificateChain::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CertificateChain::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertificateChain::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertificateChain::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CertificateChain::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CertificateChain_UnserializedMessageContext<
            UserType, CertificateChain::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CertificateChain::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CertificateChain::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CertificateChain_UnserializedMessageContext<
            UserType, CertificateChain::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CertificateChain::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::vector<uint8_t>> der_chain;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CertificateChain::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CertificateChain::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CertificateChain::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CertificateChain::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  PictureInPictureConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PictureInPictureConfig, T>::value>;
  using DataView = PictureInPictureConfigDataView;
  using Data_ = internal::PictureInPictureConfig_Data;

  template <typename... Args>
  static PictureInPictureConfigPtr New(Args&&... args) {
    return PictureInPictureConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PictureInPictureConfigPtr From(const U& u) {
    return mojo::TypeConverter<PictureInPictureConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PictureInPictureConfig>::Convert(*this);
  }


  PictureInPictureConfig();

  explicit PictureInPictureConfig(
      ::blink::mojom::PictureInPictureWindowOptionsPtr window_options);

PictureInPictureConfig(const PictureInPictureConfig&) = delete;
PictureInPictureConfig& operator=(const PictureInPictureConfig&) = delete;

  ~PictureInPictureConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PictureInPictureConfigPtr>
  PictureInPictureConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PictureInPictureConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PictureInPictureConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PictureInPictureConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PictureInPictureConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PictureInPictureConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PictureInPictureConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PictureInPictureConfig_UnserializedMessageContext<
            UserType, PictureInPictureConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PictureInPictureConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PictureInPictureConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PictureInPictureConfig_UnserializedMessageContext<
            UserType, PictureInPictureConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PictureInPictureConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::PictureInPictureWindowOptionsPtr window_options;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PictureInPictureConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PictureInPictureConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PictureInPictureConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PictureInPictureConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WindowOpenContext {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WindowOpenContext, T>::value>;
  using DataView = WindowOpenContextDataView;
  using Data_ = internal::WindowOpenContext_Data;

  template <typename... Args>
  static WindowOpenContextPtr New(Args&&... args) {
    return WindowOpenContextPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WindowOpenContextPtr From(const U& u) {
    return mojo::TypeConverter<WindowOpenContextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WindowOpenContext>::Convert(*this);
  }


  WindowOpenContext();

  WindowOpenContext(
      ::WindowOpenDisposition disposition,
      ::blink::mojom::WindowFeaturesPtr window_features);

WindowOpenContext(const WindowOpenContext&) = delete;
WindowOpenContext& operator=(const WindowOpenContext&) = delete;

  ~WindowOpenContext();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WindowOpenContextPtr>
  WindowOpenContextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WindowOpenContext::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WindowOpenContext::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WindowOpenContext::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WindowOpenContext::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WindowOpenContext::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WindowOpenContext::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WindowOpenContext_UnserializedMessageContext<
            UserType, WindowOpenContext::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WindowOpenContext::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WindowOpenContext::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WindowOpenContext_UnserializedMessageContext<
            UserType, WindowOpenContext::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WindowOpenContext::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::WindowOpenDisposition disposition;
  
  ::blink::mojom::WindowFeaturesPtr window_features;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WindowOpenContext::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WindowOpenContext::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WindowOpenContext::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WindowOpenContext::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  NavigationEntryState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigationEntryState, T>::value>;
  using DataView = NavigationEntryStateDataView;
  using Data_ = internal::NavigationEntryState_Data;

  template <typename... Args>
  static NavigationEntryStatePtr New(Args&&... args) {
    return NavigationEntryStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigationEntryStatePtr From(const U& u) {
    return mojo::TypeConverter<NavigationEntryStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigationEntryState>::Convert(*this);
  }


  NavigationEntryState();

  NavigationEntryState(
      NavigationEntryUrlPtr url,
      const std::optional<::std::u16string>& title,
      BackForwardStatePtr back_forward_state);

NavigationEntryState(const NavigationEntryState&) = delete;
NavigationEntryState& operator=(const NavigationEntryState&) = delete;

  ~NavigationEntryState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigationEntryStatePtr>
  NavigationEntryStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigationEntryState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NavigationEntryState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NavigationEntryState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationEntryState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationEntryState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigationEntryState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigationEntryState_UnserializedMessageContext<
            UserType, NavigationEntryState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NavigationEntryState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NavigationEntryState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigationEntryState_UnserializedMessageContext<
            UserType, NavigationEntryState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigationEntryState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NavigationEntryUrlPtr url;
  
  std::optional<::std::u16string> title;
  
  BackForwardStatePtr back_forward_state;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigationEntryState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigationEntryState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigationEntryState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigationEntryState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CommitDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CommitDetails, T>::value>;
  using DataView = CommitDetailsDataView;
  using Data_ = internal::CommitDetails_Data;

  template <typename... Args>
  static CommitDetailsPtr New(Args&&... args) {
    return CommitDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CommitDetailsPtr From(const U& u) {
    return mojo::TypeConverter<CommitDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CommitDetails>::Convert(*this);
  }


  CommitDetails();

  CommitDetails(
      TransitionType transition_type,
      bool is_redirect,
      bool is_chatgpt_frontend,
      bool did_replace_entry,
      bool is_same_document,
      int32_t entry_id,
      std::vector<int32_t> removed_entry_ids,
      int64_t main_frame_document_id,
      std::vector<int64_t> removed_main_frame_document_ids,
      NavigationEntryStatePtr entry_state,
      int32_t http_status_code,
      bool is_error_page);

CommitDetails(const CommitDetails&) = delete;
CommitDetails& operator=(const CommitDetails&) = delete;

  ~CommitDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CommitDetailsPtr>
  CommitDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CommitDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CommitDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CommitDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommitDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommitDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CommitDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CommitDetails_UnserializedMessageContext<
            UserType, CommitDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CommitDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CommitDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CommitDetails_UnserializedMessageContext<
            UserType, CommitDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CommitDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TransitionType transition_type;
  
  bool is_redirect;
  
  bool is_chatgpt_frontend;
  
  bool did_replace_entry;
  
  bool is_same_document;
  
  int32_t entry_id;
  
  std::vector<int32_t> removed_entry_ids;
  
  int64_t main_frame_document_id;
  
  std::vector<int64_t> removed_main_frame_document_ids;
  
  NavigationEntryStatePtr entry_state;
  
  int32_t http_status_code;
  
  bool is_error_page;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CommitDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CommitDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CommitDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CommitDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NavigationEntryUrl {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigationEntryUrl, T>::value>;
  using DataView = NavigationEntryUrlDataView;
  using Data_ = internal::NavigationEntryUrl_Data;

  template <typename... Args>
  static NavigationEntryUrlPtr New(Args&&... args) {
    return NavigationEntryUrlPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigationEntryUrlPtr From(const U& u) {
    return mojo::TypeConverter<NavigationEntryUrlPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigationEntryUrl>::Convert(*this);
  }


  NavigationEntryUrl();

  NavigationEntryUrl(
      const ::GURL& url,
      const ::GURL& redirect_chain_start);


  ~NavigationEntryUrl();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigationEntryUrlPtr>
  NavigationEntryUrlPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigationEntryUrl::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NavigationEntryUrl::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NavigationEntryUrl::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationEntryUrl::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationEntryUrl::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigationEntryUrl::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigationEntryUrl_UnserializedMessageContext<
            UserType, NavigationEntryUrl::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NavigationEntryUrl::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NavigationEntryUrl::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigationEntryUrl_UnserializedMessageContext<
            UserType, NavigationEntryUrl::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigationEntryUrl::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  ::GURL redirect_chain_start;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigationEntryUrl::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigationEntryUrl::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigationEntryUrl::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigationEntryUrl::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
SnapshotResultPtr SnapshotResult::Clone() const {
  switch (tag_) {
    case Tag::kImage:
      return NewImage(
          mojo::Clone(data_.image));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SnapshotResult>::value>::type*>
bool SnapshotResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kImage:
      return mojo::Equals(data_.image, other.data_.image);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename UnionPtrType>
WebViewDispositionPtr WebViewDisposition::Clone() const {
  switch (tag_) {
    case Tag::kWindowOpen:
      return NewWindowOpen(
          mojo::Clone(data_.window_open));
    case Tag::kPictureInPicture:
      return NewPictureInPicture(
          mojo::Clone(data_.picture_in_picture));
    case Tag::kPrintPreview:
      return NewPrintPreview(
          mojo::Clone(data_.print_preview));
    case Tag::kExtensionPopup:
      return NewExtensionPopup(
          mojo::Clone(data_.extension_popup));
    case Tag::kDevTools:
      return NewDevTools(
          mojo::Clone(data_.dev_tools));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WebViewDisposition>::value>::type*>
bool WebViewDisposition::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kWindowOpen:
      return mojo::Equals(data_.window_open, other.data_.window_open);
    case Tag::kPictureInPicture:
      return mojo::Equals(data_.picture_in_picture, other.data_.picture_in_picture);
    case Tag::kPrintPreview:
      return mojo::Equals(data_.print_preview, other.data_.print_preview);
    case Tag::kExtensionPopup:
      return mojo::Equals(data_.extension_popup, other.data_.extension_popup);
    case Tag::kDevTools:
      return mojo::Equals(data_.dev_tools, other.data_.dev_tools);
  }

  return false;
}
template <typename StructPtrType>
WebViewDiagnosticsPtr WebViewDiagnostics::Clone() const {
  return New(
      mojo::Clone(needs_reload),
      mojo::Clone(has_uncommitted_navigation_in_primary_main_frame),
      mojo::Clone(is_waiting_for_response),
      mojo::Clone(is_deferred),
      mojo::Clone(net_load_state),
      mojo::Clone(primary_main_frame_lifecycle),
      mojo::Clone(last_committed_url),
      mojo::Clone(entry_count),
      mojo::Clone(pending_entry_index),
      mojo::Clone(current_entry_index),
      mojo::Clone(is_web_contents_visible),
      mojo::Clone(is_rwhv_visible),
      mojo::Clone(rwhv_size)
  );
}

template <typename T, WebViewDiagnostics::EnableIfSame<T>*>
bool WebViewDiagnostics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->needs_reload, other_struct.needs_reload))
    return false;
  if (!mojo::Equals(this->has_uncommitted_navigation_in_primary_main_frame, other_struct.has_uncommitted_navigation_in_primary_main_frame))
    return false;
  if (!mojo::Equals(this->is_waiting_for_response, other_struct.is_waiting_for_response))
    return false;
  if (!mojo::Equals(this->is_deferred, other_struct.is_deferred))
    return false;
  if (!mojo::Equals(this->net_load_state, other_struct.net_load_state))
    return false;
  if (!mojo::Equals(this->primary_main_frame_lifecycle, other_struct.primary_main_frame_lifecycle))
    return false;
  if (!mojo::Equals(this->last_committed_url, other_struct.last_committed_url))
    return false;
  if (!mojo::Equals(this->entry_count, other_struct.entry_count))
    return false;
  if (!mojo::Equals(this->pending_entry_index, other_struct.pending_entry_index))
    return false;
  if (!mojo::Equals(this->current_entry_index, other_struct.current_entry_index))
    return false;
  if (!mojo::Equals(this->is_web_contents_visible, other_struct.is_web_contents_visible))
    return false;
  if (!mojo::Equals(this->is_rwhv_visible, other_struct.is_rwhv_visible))
    return false;
  if (!mojo::Equals(this->rwhv_size, other_struct.rwhv_size))
    return false;
  return true;
}

template <typename T, WebViewDiagnostics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.needs_reload < rhs.needs_reload)
    return true;
  if (rhs.needs_reload < lhs.needs_reload)
    return false;
  if (lhs.has_uncommitted_navigation_in_primary_main_frame < rhs.has_uncommitted_navigation_in_primary_main_frame)
    return true;
  if (rhs.has_uncommitted_navigation_in_primary_main_frame < lhs.has_uncommitted_navigation_in_primary_main_frame)
    return false;
  if (lhs.is_waiting_for_response < rhs.is_waiting_for_response)
    return true;
  if (rhs.is_waiting_for_response < lhs.is_waiting_for_response)
    return false;
  if (lhs.is_deferred < rhs.is_deferred)
    return true;
  if (rhs.is_deferred < lhs.is_deferred)
    return false;
  if (lhs.net_load_state < rhs.net_load_state)
    return true;
  if (rhs.net_load_state < lhs.net_load_state)
    return false;
  if (lhs.primary_main_frame_lifecycle < rhs.primary_main_frame_lifecycle)
    return true;
  if (rhs.primary_main_frame_lifecycle < lhs.primary_main_frame_lifecycle)
    return false;
  if (lhs.last_committed_url < rhs.last_committed_url)
    return true;
  if (rhs.last_committed_url < lhs.last_committed_url)
    return false;
  if (lhs.entry_count < rhs.entry_count)
    return true;
  if (rhs.entry_count < lhs.entry_count)
    return false;
  if (lhs.pending_entry_index < rhs.pending_entry_index)
    return true;
  if (rhs.pending_entry_index < lhs.pending_entry_index)
    return false;
  if (lhs.current_entry_index < rhs.current_entry_index)
    return true;
  if (rhs.current_entry_index < lhs.current_entry_index)
    return false;
  if (lhs.is_web_contents_visible < rhs.is_web_contents_visible)
    return true;
  if (rhs.is_web_contents_visible < lhs.is_web_contents_visible)
    return false;
  if (lhs.is_rwhv_visible < rhs.is_rwhv_visible)
    return true;
  if (rhs.is_rwhv_visible < lhs.is_rwhv_visible)
    return false;
  if (lhs.rwhv_size < rhs.rwhv_size)
    return true;
  if (rhs.rwhv_size < lhs.rwhv_size)
    return false;
  return false;
}
template <typename StructPtrType>
FindResultPtr FindResult::Clone() const {
  return New(
      mojo::Clone(current_match_index),
      mojo::Clone(number_of_matches)
  );
}

template <typename T, FindResult::EnableIfSame<T>*>
bool FindResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->current_match_index, other_struct.current_match_index))
    return false;
  if (!mojo::Equals(this->number_of_matches, other_struct.number_of_matches))
    return false;
  return true;
}

template <typename T, FindResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.current_match_index < rhs.current_match_index)
    return true;
  if (rhs.current_match_index < lhs.current_match_index)
    return false;
  if (lhs.number_of_matches < rhs.number_of_matches)
    return true;
  if (rhs.number_of_matches < lhs.number_of_matches)
    return false;
  return false;
}
template <typename StructPtrType>
DOMElementReferencePtr DOMElementReference::Clone() const {
  return New(
      mojo::Clone(frame_routing_id),
      mojo::Clone(frame_process_id),
      mojo::Clone(x),
      mojo::Clone(y)
  );
}

template <typename T, DOMElementReference::EnableIfSame<T>*>
bool DOMElementReference::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_routing_id, other_struct.frame_routing_id))
    return false;
  if (!mojo::Equals(this->frame_process_id, other_struct.frame_process_id))
    return false;
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  return true;
}

template <typename T, DOMElementReference::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_routing_id < rhs.frame_routing_id)
    return true;
  if (rhs.frame_routing_id < lhs.frame_routing_id)
    return false;
  if (lhs.frame_process_id < rhs.frame_process_id)
    return true;
  if (rhs.frame_process_id < lhs.frame_process_id)
    return false;
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  return false;
}
template <typename StructPtrType>
NavigationEntryPtr NavigationEntry::Clone() const {
  return New(
      mojo::Clone(unique_id),
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(favicon_url)
  );
}

template <typename T, NavigationEntry::EnableIfSame<T>*>
bool NavigationEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->unique_id, other_struct.unique_id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->favicon_url, other_struct.favicon_url))
    return false;
  return true;
}

template <typename T, NavigationEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.unique_id < rhs.unique_id)
    return true;
  if (rhs.unique_id < lhs.unique_id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.favicon_url < rhs.favicon_url)
    return true;
  if (rhs.favicon_url < lhs.favicon_url)
    return false;
  return false;
}
template <typename StructPtrType>
SerializedDomElementInfoPtr SerializedDomElementInfo::Clone() const {
  return New(
      mojo::Clone(tag),
      mojo::Clone(selector),
      mojo::Clone(visible_bounds),
      mojo::Clone(click_point)
  );
}

template <typename T, SerializedDomElementInfo::EnableIfSame<T>*>
bool SerializedDomElementInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tag, other_struct.tag))
    return false;
  if (!mojo::Equals(this->selector, other_struct.selector))
    return false;
  if (!mojo::Equals(this->visible_bounds, other_struct.visible_bounds))
    return false;
  if (!mojo::Equals(this->click_point, other_struct.click_point))
    return false;
  return true;
}

template <typename T, SerializedDomElementInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tag < rhs.tag)
    return true;
  if (rhs.tag < lhs.tag)
    return false;
  if (lhs.selector < rhs.selector)
    return true;
  if (rhs.selector < lhs.selector)
    return false;
  if (lhs.visible_bounds < rhs.visible_bounds)
    return true;
  if (rhs.visible_bounds < lhs.visible_bounds)
    return false;
  if (lhs.click_point < rhs.click_point)
    return true;
  if (rhs.click_point < lhs.click_point)
    return false;
  return false;
}
template <typename StructPtrType>
TabRendererDataPtr TabRendererData::Clone() const {
  return New(
      mojo::Clone(blocked),
      mojo::Clone(crashed),
      mojo::Clone(alert_states),
      mojo::Clone(favicon_image),
      mojo::Clone(network_state),
      mojo::Clone(should_hide_loading_throbber),
      mojo::Clone(title),
      mojo::Clone(last_committed_url),
      mojo::Clone(visible_url)
  );
}

template <typename T, TabRendererData::EnableIfSame<T>*>
bool TabRendererData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->blocked, other_struct.blocked))
    return false;
  if (!mojo::Equals(this->crashed, other_struct.crashed))
    return false;
  if (!mojo::Equals(this->alert_states, other_struct.alert_states))
    return false;
  if (!mojo::Equals(this->favicon_image, other_struct.favicon_image))
    return false;
  if (!mojo::Equals(this->network_state, other_struct.network_state))
    return false;
  if (!mojo::Equals(this->should_hide_loading_throbber, other_struct.should_hide_loading_throbber))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->last_committed_url, other_struct.last_committed_url))
    return false;
  if (!mojo::Equals(this->visible_url, other_struct.visible_url))
    return false;
  return true;
}

template <typename T, TabRendererData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.blocked < rhs.blocked)
    return true;
  if (rhs.blocked < lhs.blocked)
    return false;
  if (lhs.crashed < rhs.crashed)
    return true;
  if (rhs.crashed < lhs.crashed)
    return false;
  if (lhs.alert_states < rhs.alert_states)
    return true;
  if (rhs.alert_states < lhs.alert_states)
    return false;
  if (lhs.favicon_image < rhs.favicon_image)
    return true;
  if (rhs.favicon_image < lhs.favicon_image)
    return false;
  if (lhs.network_state < rhs.network_state)
    return true;
  if (rhs.network_state < lhs.network_state)
    return false;
  if (lhs.should_hide_loading_throbber < rhs.should_hide_loading_throbber)
    return true;
  if (rhs.should_hide_loading_throbber < lhs.should_hide_loading_throbber)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.last_committed_url < rhs.last_committed_url)
    return true;
  if (rhs.last_committed_url < lhs.last_committed_url)
    return false;
  if (lhs.visible_url < rhs.visible_url)
    return true;
  if (rhs.visible_url < lhs.visible_url)
    return false;
  return false;
}
template <typename StructPtrType>
ClipboardOverridePtr ClipboardOverride::Clone() const {
  return New(
      mojo::Clone(text),
      mojo::Clone(html)
  );
}

template <typename T, ClipboardOverride::EnableIfSame<T>*>
bool ClipboardOverride::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->html, other_struct.html))
    return false;
  return true;
}

template <typename T, ClipboardOverride::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.html < rhs.html)
    return true;
  if (rhs.html < lhs.html)
    return false;
  return false;
}
template <typename StructPtrType>
CertificateChainPtr CertificateChain::Clone() const {
  return New(
      mojo::Clone(der_chain)
  );
}

template <typename T, CertificateChain::EnableIfSame<T>*>
bool CertificateChain::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->der_chain, other_struct.der_chain))
    return false;
  return true;
}

template <typename T, CertificateChain::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.der_chain < rhs.der_chain)
    return true;
  if (rhs.der_chain < lhs.der_chain)
    return false;
  return false;
}
template <typename StructPtrType>
StoragePartitionDescriptorPtr StoragePartitionDescriptor::Clone() const {
  return New(
      mojo::Clone(partition_domain),
      mojo::Clone(partition_name),
      mojo::Clone(in_memory)
  );
}

template <typename T, StoragePartitionDescriptor::EnableIfSame<T>*>
bool StoragePartitionDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->partition_domain, other_struct.partition_domain))
    return false;
  if (!mojo::Equals(this->partition_name, other_struct.partition_name))
    return false;
  if (!mojo::Equals(this->in_memory, other_struct.in_memory))
    return false;
  return true;
}

template <typename T, StoragePartitionDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.partition_domain < rhs.partition_domain)
    return true;
  if (rhs.partition_domain < lhs.partition_domain)
    return false;
  if (lhs.partition_name < rhs.partition_name)
    return true;
  if (rhs.partition_name < lhs.partition_name)
    return false;
  if (lhs.in_memory < rhs.in_memory)
    return true;
  if (rhs.in_memory < lhs.in_memory)
    return false;
  return false;
}
template <typename StructPtrType>
ClientCertMetadataPtr ClientCertMetadata::Clone() const {
  return New(
      mojo::Clone(subject),
      mojo::Clone(issuer),
      mojo::Clone(serial)
  );
}

template <typename T, ClientCertMetadata::EnableIfSame<T>*>
bool ClientCertMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->subject, other_struct.subject))
    return false;
  if (!mojo::Equals(this->issuer, other_struct.issuer))
    return false;
  if (!mojo::Equals(this->serial, other_struct.serial))
    return false;
  return true;
}

template <typename T, ClientCertMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.subject < rhs.subject)
    return true;
  if (rhs.subject < lhs.subject)
    return false;
  if (lhs.issuer < rhs.issuer)
    return true;
  if (rhs.issuer < lhs.issuer)
    return false;
  if (lhs.serial < rhs.serial)
    return true;
  if (rhs.serial < lhs.serial)
    return false;
  return false;
}
template <typename StructPtrType>
PictureInPictureConfigPtr PictureInPictureConfig::Clone() const {
  return New(
      mojo::Clone(window_options)
  );
}

template <typename T, PictureInPictureConfig::EnableIfSame<T>*>
bool PictureInPictureConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->window_options, other_struct.window_options))
    return false;
  return true;
}

template <typename T, PictureInPictureConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.window_options < rhs.window_options)
    return true;
  if (rhs.window_options < lhs.window_options)
    return false;
  return false;
}
template <typename StructPtrType>
WindowOpenContextPtr WindowOpenContext::Clone() const {
  return New(
      mojo::Clone(disposition),
      mojo::Clone(window_features)
  );
}

template <typename T, WindowOpenContext::EnableIfSame<T>*>
bool WindowOpenContext::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->disposition, other_struct.disposition))
    return false;
  if (!mojo::Equals(this->window_features, other_struct.window_features))
    return false;
  return true;
}

template <typename T, WindowOpenContext::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.disposition < rhs.disposition)
    return true;
  if (rhs.disposition < lhs.disposition)
    return false;
  if (lhs.window_features < rhs.window_features)
    return true;
  if (rhs.window_features < lhs.window_features)
    return false;
  return false;
}
template <typename StructPtrType>
ExtensionPopupContextPtr ExtensionPopupContext::Clone() const {
  return New(
      mojo::Clone(extension_id)
  );
}

template <typename T, ExtensionPopupContext::EnableIfSame<T>*>
bool ExtensionPopupContext::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->extension_id, other_struct.extension_id))
    return false;
  return true;
}

template <typename T, ExtensionPopupContext::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.extension_id < rhs.extension_id)
    return true;
  if (rhs.extension_id < lhs.extension_id)
    return false;
  return false;
}
template <typename StructPtrType>
DevToolsContextPtr DevToolsContext::Clone() const {
  return New(
      mojo::Clone(dock_side)
  );
}

template <typename T, DevToolsContext::EnableIfSame<T>*>
bool DevToolsContext::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dock_side, other_struct.dock_side))
    return false;
  return true;
}

template <typename T, DevToolsContext::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.dock_side < rhs.dock_side)
    return true;
  if (rhs.dock_side < lhs.dock_side)
    return false;
  return false;
}
template <typename StructPtrType>
BackForwardStatePtr BackForwardState::Clone() const {
  return New(
      mojo::Clone(can_go_back),
      mojo::Clone(can_go_forward)
  );
}

template <typename T, BackForwardState::EnableIfSame<T>*>
bool BackForwardState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->can_go_back, other_struct.can_go_back))
    return false;
  if (!mojo::Equals(this->can_go_forward, other_struct.can_go_forward))
    return false;
  return true;
}

template <typename T, BackForwardState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.can_go_back < rhs.can_go_back)
    return true;
  if (rhs.can_go_back < lhs.can_go_back)
    return false;
  if (lhs.can_go_forward < rhs.can_go_forward)
    return true;
  if (rhs.can_go_forward < lhs.can_go_forward)
    return false;
  return false;
}
template <typename StructPtrType>
NavigationEntryStatePtr NavigationEntryState::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(title),
      mojo::Clone(back_forward_state)
  );
}

template <typename T, NavigationEntryState::EnableIfSame<T>*>
bool NavigationEntryState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->back_forward_state, other_struct.back_forward_state))
    return false;
  return true;
}

template <typename T, NavigationEntryState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.back_forward_state < rhs.back_forward_state)
    return true;
  if (rhs.back_forward_state < lhs.back_forward_state)
    return false;
  return false;
}
template <typename StructPtrType>
CommitDetailsPtr CommitDetails::Clone() const {
  return New(
      mojo::Clone(transition_type),
      mojo::Clone(is_redirect),
      mojo::Clone(is_chatgpt_frontend),
      mojo::Clone(did_replace_entry),
      mojo::Clone(is_same_document),
      mojo::Clone(entry_id),
      mojo::Clone(removed_entry_ids),
      mojo::Clone(main_frame_document_id),
      mojo::Clone(removed_main_frame_document_ids),
      mojo::Clone(entry_state),
      mojo::Clone(http_status_code),
      mojo::Clone(is_error_page)
  );
}

template <typename T, CommitDetails::EnableIfSame<T>*>
bool CommitDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->transition_type, other_struct.transition_type))
    return false;
  if (!mojo::Equals(this->is_redirect, other_struct.is_redirect))
    return false;
  if (!mojo::Equals(this->is_chatgpt_frontend, other_struct.is_chatgpt_frontend))
    return false;
  if (!mojo::Equals(this->did_replace_entry, other_struct.did_replace_entry))
    return false;
  if (!mojo::Equals(this->is_same_document, other_struct.is_same_document))
    return false;
  if (!mojo::Equals(this->entry_id, other_struct.entry_id))
    return false;
  if (!mojo::Equals(this->removed_entry_ids, other_struct.removed_entry_ids))
    return false;
  if (!mojo::Equals(this->main_frame_document_id, other_struct.main_frame_document_id))
    return false;
  if (!mojo::Equals(this->removed_main_frame_document_ids, other_struct.removed_main_frame_document_ids))
    return false;
  if (!mojo::Equals(this->entry_state, other_struct.entry_state))
    return false;
  if (!mojo::Equals(this->http_status_code, other_struct.http_status_code))
    return false;
  if (!mojo::Equals(this->is_error_page, other_struct.is_error_page))
    return false;
  return true;
}

template <typename T, CommitDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.transition_type < rhs.transition_type)
    return true;
  if (rhs.transition_type < lhs.transition_type)
    return false;
  if (lhs.is_redirect < rhs.is_redirect)
    return true;
  if (rhs.is_redirect < lhs.is_redirect)
    return false;
  if (lhs.is_chatgpt_frontend < rhs.is_chatgpt_frontend)
    return true;
  if (rhs.is_chatgpt_frontend < lhs.is_chatgpt_frontend)
    return false;
  if (lhs.did_replace_entry < rhs.did_replace_entry)
    return true;
  if (rhs.did_replace_entry < lhs.did_replace_entry)
    return false;
  if (lhs.is_same_document < rhs.is_same_document)
    return true;
  if (rhs.is_same_document < lhs.is_same_document)
    return false;
  if (lhs.entry_id < rhs.entry_id)
    return true;
  if (rhs.entry_id < lhs.entry_id)
    return false;
  if (lhs.removed_entry_ids < rhs.removed_entry_ids)
    return true;
  if (rhs.removed_entry_ids < lhs.removed_entry_ids)
    return false;
  if (lhs.main_frame_document_id < rhs.main_frame_document_id)
    return true;
  if (rhs.main_frame_document_id < lhs.main_frame_document_id)
    return false;
  if (lhs.removed_main_frame_document_ids < rhs.removed_main_frame_document_ids)
    return true;
  if (rhs.removed_main_frame_document_ids < lhs.removed_main_frame_document_ids)
    return false;
  if (lhs.entry_state < rhs.entry_state)
    return true;
  if (rhs.entry_state < lhs.entry_state)
    return false;
  if (lhs.http_status_code < rhs.http_status_code)
    return true;
  if (rhs.http_status_code < lhs.http_status_code)
    return false;
  if (lhs.is_error_page < rhs.is_error_page)
    return true;
  if (rhs.is_error_page < lhs.is_error_page)
    return false;
  return false;
}
template <typename StructPtrType>
NavigationEntryUrlPtr NavigationEntryUrl::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(redirect_chain_start)
  );
}

template <typename T, NavigationEntryUrl::EnableIfSame<T>*>
bool NavigationEntryUrl::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->redirect_chain_start, other_struct.redirect_chain_start))
    return false;
  return true;
}

template <typename T, NavigationEntryUrl::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.redirect_chain_start < rhs.redirect_chain_start)
    return true;
  if (rhs.redirect_chain_start < lhs.redirect_chain_start)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::WebViewDiagnostics::DataView,
                                         ::owl::mojom::WebViewDiagnosticsPtr> {
  static bool IsNull(const ::owl::mojom::WebViewDiagnosticsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::WebViewDiagnosticsPtr* output) { output->reset(); }

  static decltype(::owl::mojom::WebViewDiagnostics::needs_reload) needs_reload(
      const ::owl::mojom::WebViewDiagnosticsPtr& input) {
    return input->needs_reload;
  }

  static decltype(::owl::mojom::WebViewDiagnostics::has_uncommitted_navigation_in_primary_main_frame) has_uncommitted_navigation_in_primary_main_frame(
      const ::owl::mojom::WebViewDiagnosticsPtr& input) {
    return input->has_uncommitted_navigation_in_primary_main_frame;
  }

  static decltype(::owl::mojom::WebViewDiagnostics::is_waiting_for_response) is_waiting_for_response(
      const ::owl::mojom::WebViewDiagnosticsPtr& input) {
    return input->is_waiting_for_response;
  }

  static decltype(::owl::mojom::WebViewDiagnostics::is_deferred) is_deferred(
      const ::owl::mojom::WebViewDiagnosticsPtr& input) {
    return input->is_deferred;
  }

  static decltype(::owl::mojom::WebViewDiagnostics::net_load_state) net_load_state(
      const ::owl::mojom::WebViewDiagnosticsPtr& input) {
    return input->net_load_state;
  }

  static const decltype(::owl::mojom::WebViewDiagnostics::primary_main_frame_lifecycle)& primary_main_frame_lifecycle(
      const ::owl::mojom::WebViewDiagnosticsPtr& input) {
    return input->primary_main_frame_lifecycle;
  }

  static const decltype(::owl::mojom::WebViewDiagnostics::last_committed_url)& last_committed_url(
      const ::owl::mojom::WebViewDiagnosticsPtr& input) {
    return input->last_committed_url;
  }

  static decltype(::owl::mojom::WebViewDiagnostics::entry_count) entry_count(
      const ::owl::mojom::WebViewDiagnosticsPtr& input) {
    return input->entry_count;
  }

  static decltype(::owl::mojom::WebViewDiagnostics::pending_entry_index) pending_entry_index(
      const ::owl::mojom::WebViewDiagnosticsPtr& input) {
    return input->pending_entry_index;
  }

  static decltype(::owl::mojom::WebViewDiagnostics::current_entry_index) current_entry_index(
      const ::owl::mojom::WebViewDiagnosticsPtr& input) {
    return input->current_entry_index;
  }

  static decltype(::owl::mojom::WebViewDiagnostics::is_web_contents_visible) is_web_contents_visible(
      const ::owl::mojom::WebViewDiagnosticsPtr& input) {
    return input->is_web_contents_visible;
  }

  static decltype(::owl::mojom::WebViewDiagnostics::is_rwhv_visible) is_rwhv_visible(
      const ::owl::mojom::WebViewDiagnosticsPtr& input) {
    return input->is_rwhv_visible;
  }

  static const decltype(::owl::mojom::WebViewDiagnostics::rwhv_size)& rwhv_size(
      const ::owl::mojom::WebViewDiagnosticsPtr& input) {
    return input->rwhv_size;
  }

  static bool Read(::owl::mojom::WebViewDiagnostics::DataView input, ::owl::mojom::WebViewDiagnosticsPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::FindResult::DataView,
                                         ::owl::mojom::FindResultPtr> {
  static bool IsNull(const ::owl::mojom::FindResultPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::FindResultPtr* output) { output->reset(); }

  static decltype(::owl::mojom::FindResult::current_match_index) current_match_index(
      const ::owl::mojom::FindResultPtr& input) {
    return input->current_match_index;
  }

  static decltype(::owl::mojom::FindResult::number_of_matches) number_of_matches(
      const ::owl::mojom::FindResultPtr& input) {
    return input->number_of_matches;
  }

  static bool Read(::owl::mojom::FindResult::DataView input, ::owl::mojom::FindResultPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::DOMElementReference::DataView,
                                         ::owl::mojom::DOMElementReferencePtr> {
  static bool IsNull(const ::owl::mojom::DOMElementReferencePtr& input) { return !input; }
  static void SetToNull(::owl::mojom::DOMElementReferencePtr* output) { output->reset(); }

  static decltype(::owl::mojom::DOMElementReference::frame_routing_id) frame_routing_id(
      const ::owl::mojom::DOMElementReferencePtr& input) {
    return input->frame_routing_id;
  }

  static decltype(::owl::mojom::DOMElementReference::frame_process_id) frame_process_id(
      const ::owl::mojom::DOMElementReferencePtr& input) {
    return input->frame_process_id;
  }

  static decltype(::owl::mojom::DOMElementReference::x) x(
      const ::owl::mojom::DOMElementReferencePtr& input) {
    return input->x;
  }

  static decltype(::owl::mojom::DOMElementReference::y) y(
      const ::owl::mojom::DOMElementReferencePtr& input) {
    return input->y;
  }

  static bool Read(::owl::mojom::DOMElementReference::DataView input, ::owl::mojom::DOMElementReferencePtr* output);
};


template <>
struct  StructTraits<::owl::mojom::NavigationEntry::DataView,
                                         ::owl::mojom::NavigationEntryPtr> {
  static bool IsNull(const ::owl::mojom::NavigationEntryPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::NavigationEntryPtr* output) { output->reset(); }

  static decltype(::owl::mojom::NavigationEntry::unique_id) unique_id(
      const ::owl::mojom::NavigationEntryPtr& input) {
    return input->unique_id;
  }

  static const decltype(::owl::mojom::NavigationEntry::title)& title(
      const ::owl::mojom::NavigationEntryPtr& input) {
    return input->title;
  }

  static const decltype(::owl::mojom::NavigationEntry::url)& url(
      const ::owl::mojom::NavigationEntryPtr& input) {
    return input->url;
  }

  static const decltype(::owl::mojom::NavigationEntry::favicon_url)& favicon_url(
      const ::owl::mojom::NavigationEntryPtr& input) {
    return input->favicon_url;
  }

  static bool Read(::owl::mojom::NavigationEntry::DataView input, ::owl::mojom::NavigationEntryPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::SerializedDomElementInfo::DataView,
                                         ::owl::mojom::SerializedDomElementInfoPtr> {
  static bool IsNull(const ::owl::mojom::SerializedDomElementInfoPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::SerializedDomElementInfoPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::SerializedDomElementInfo::tag)& tag(
      const ::owl::mojom::SerializedDomElementInfoPtr& input) {
    return input->tag;
  }

  static const decltype(::owl::mojom::SerializedDomElementInfo::selector)& selector(
      const ::owl::mojom::SerializedDomElementInfoPtr& input) {
    return input->selector;
  }

  static const decltype(::owl::mojom::SerializedDomElementInfo::visible_bounds)& visible_bounds(
      const ::owl::mojom::SerializedDomElementInfoPtr& input) {
    return input->visible_bounds;
  }

  static const decltype(::owl::mojom::SerializedDomElementInfo::click_point)& click_point(
      const ::owl::mojom::SerializedDomElementInfoPtr& input) {
    return input->click_point;
  }

  static bool Read(::owl::mojom::SerializedDomElementInfo::DataView input, ::owl::mojom::SerializedDomElementInfoPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::TabRendererData::DataView,
                                         ::owl::mojom::TabRendererDataPtr> {
  static bool IsNull(const ::owl::mojom::TabRendererDataPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::TabRendererDataPtr* output) { output->reset(); }

  static decltype(::owl::mojom::TabRendererData::blocked) blocked(
      const ::owl::mojom::TabRendererDataPtr& input) {
    return input->blocked;
  }

  static decltype(::owl::mojom::TabRendererData::crashed) crashed(
      const ::owl::mojom::TabRendererDataPtr& input) {
    return input->crashed;
  }

  static const decltype(::owl::mojom::TabRendererData::alert_states)& alert_states(
      const ::owl::mojom::TabRendererDataPtr& input) {
    return input->alert_states;
  }

  static  decltype(::owl::mojom::TabRendererData::favicon_image)& favicon_image(
       ::owl::mojom::TabRendererDataPtr& input) {
    return input->favicon_image;
  }

  static decltype(::owl::mojom::TabRendererData::network_state) network_state(
      const ::owl::mojom::TabRendererDataPtr& input) {
    return input->network_state;
  }

  static decltype(::owl::mojom::TabRendererData::should_hide_loading_throbber) should_hide_loading_throbber(
      const ::owl::mojom::TabRendererDataPtr& input) {
    return input->should_hide_loading_throbber;
  }

  static const decltype(::owl::mojom::TabRendererData::title)& title(
      const ::owl::mojom::TabRendererDataPtr& input) {
    return input->title;
  }

  static const decltype(::owl::mojom::TabRendererData::last_committed_url)& last_committed_url(
      const ::owl::mojom::TabRendererDataPtr& input) {
    return input->last_committed_url;
  }

  static const decltype(::owl::mojom::TabRendererData::visible_url)& visible_url(
      const ::owl::mojom::TabRendererDataPtr& input) {
    return input->visible_url;
  }

  static bool Read(::owl::mojom::TabRendererData::DataView input, ::owl::mojom::TabRendererDataPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::ClipboardOverride::DataView,
                                         ::owl::mojom::ClipboardOverridePtr> {
  static bool IsNull(const ::owl::mojom::ClipboardOverridePtr& input) { return !input; }
  static void SetToNull(::owl::mojom::ClipboardOverridePtr* output) { output->reset(); }

  static const decltype(::owl::mojom::ClipboardOverride::text)& text(
      const ::owl::mojom::ClipboardOverridePtr& input) {
    return input->text;
  }

  static const decltype(::owl::mojom::ClipboardOverride::html)& html(
      const ::owl::mojom::ClipboardOverridePtr& input) {
    return input->html;
  }

  static bool Read(::owl::mojom::ClipboardOverride::DataView input, ::owl::mojom::ClipboardOverridePtr* output);
};


template <>
struct  StructTraits<::owl::mojom::CertificateChain::DataView,
                                         ::owl::mojom::CertificateChainPtr> {
  static bool IsNull(const ::owl::mojom::CertificateChainPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::CertificateChainPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::CertificateChain::der_chain)& der_chain(
      const ::owl::mojom::CertificateChainPtr& input) {
    return input->der_chain;
  }

  static bool Read(::owl::mojom::CertificateChain::DataView input, ::owl::mojom::CertificateChainPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::StoragePartitionDescriptor::DataView,
                                         ::owl::mojom::StoragePartitionDescriptorPtr> {
  static bool IsNull(const ::owl::mojom::StoragePartitionDescriptorPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::StoragePartitionDescriptorPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::StoragePartitionDescriptor::partition_domain)& partition_domain(
      const ::owl::mojom::StoragePartitionDescriptorPtr& input) {
    return input->partition_domain;
  }

  static const decltype(::owl::mojom::StoragePartitionDescriptor::partition_name)& partition_name(
      const ::owl::mojom::StoragePartitionDescriptorPtr& input) {
    return input->partition_name;
  }

  static decltype(::owl::mojom::StoragePartitionDescriptor::in_memory) in_memory(
      const ::owl::mojom::StoragePartitionDescriptorPtr& input) {
    return input->in_memory;
  }

  static bool Read(::owl::mojom::StoragePartitionDescriptor::DataView input, ::owl::mojom::StoragePartitionDescriptorPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::ClientCertMetadata::DataView,
                                         ::owl::mojom::ClientCertMetadataPtr> {
  static bool IsNull(const ::owl::mojom::ClientCertMetadataPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::ClientCertMetadataPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::ClientCertMetadata::subject)& subject(
      const ::owl::mojom::ClientCertMetadataPtr& input) {
    return input->subject;
  }

  static const decltype(::owl::mojom::ClientCertMetadata::issuer)& issuer(
      const ::owl::mojom::ClientCertMetadataPtr& input) {
    return input->issuer;
  }

  static const decltype(::owl::mojom::ClientCertMetadata::serial)& serial(
      const ::owl::mojom::ClientCertMetadataPtr& input) {
    return input->serial;
  }

  static bool Read(::owl::mojom::ClientCertMetadata::DataView input, ::owl::mojom::ClientCertMetadataPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::PictureInPictureConfig::DataView,
                                         ::owl::mojom::PictureInPictureConfigPtr> {
  static bool IsNull(const ::owl::mojom::PictureInPictureConfigPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::PictureInPictureConfigPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::PictureInPictureConfig::window_options)& window_options(
      const ::owl::mojom::PictureInPictureConfigPtr& input) {
    return input->window_options;
  }

  static bool Read(::owl::mojom::PictureInPictureConfig::DataView input, ::owl::mojom::PictureInPictureConfigPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::WindowOpenContext::DataView,
                                         ::owl::mojom::WindowOpenContextPtr> {
  static bool IsNull(const ::owl::mojom::WindowOpenContextPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::WindowOpenContextPtr* output) { output->reset(); }

  static decltype(::owl::mojom::WindowOpenContext::disposition) disposition(
      const ::owl::mojom::WindowOpenContextPtr& input) {
    return input->disposition;
  }

  static const decltype(::owl::mojom::WindowOpenContext::window_features)& window_features(
      const ::owl::mojom::WindowOpenContextPtr& input) {
    return input->window_features;
  }

  static bool Read(::owl::mojom::WindowOpenContext::DataView input, ::owl::mojom::WindowOpenContextPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::ExtensionPopupContext::DataView,
                                         ::owl::mojom::ExtensionPopupContextPtr> {
  static bool IsNull(const ::owl::mojom::ExtensionPopupContextPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::ExtensionPopupContextPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::ExtensionPopupContext::extension_id)& extension_id(
      const ::owl::mojom::ExtensionPopupContextPtr& input) {
    return input->extension_id;
  }

  static bool Read(::owl::mojom::ExtensionPopupContext::DataView input, ::owl::mojom::ExtensionPopupContextPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::DevToolsContext::DataView,
                                         ::owl::mojom::DevToolsContextPtr> {
  static bool IsNull(const ::owl::mojom::DevToolsContextPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::DevToolsContextPtr* output) { output->reset(); }

  static decltype(::owl::mojom::DevToolsContext::dock_side) dock_side(
      const ::owl::mojom::DevToolsContextPtr& input) {
    return input->dock_side;
  }

  static bool Read(::owl::mojom::DevToolsContext::DataView input, ::owl::mojom::DevToolsContextPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::BackForwardState::DataView,
                                         ::owl::mojom::BackForwardStatePtr> {
  static bool IsNull(const ::owl::mojom::BackForwardStatePtr& input) { return !input; }
  static void SetToNull(::owl::mojom::BackForwardStatePtr* output) { output->reset(); }

  static decltype(::owl::mojom::BackForwardState::can_go_back) can_go_back(
      const ::owl::mojom::BackForwardStatePtr& input) {
    return input->can_go_back;
  }

  static decltype(::owl::mojom::BackForwardState::can_go_forward) can_go_forward(
      const ::owl::mojom::BackForwardStatePtr& input) {
    return input->can_go_forward;
  }

  static bool Read(::owl::mojom::BackForwardState::DataView input, ::owl::mojom::BackForwardStatePtr* output);
};


template <>
struct  StructTraits<::owl::mojom::NavigationEntryState::DataView,
                                         ::owl::mojom::NavigationEntryStatePtr> {
  static bool IsNull(const ::owl::mojom::NavigationEntryStatePtr& input) { return !input; }
  static void SetToNull(::owl::mojom::NavigationEntryStatePtr* output) { output->reset(); }

  static const decltype(::owl::mojom::NavigationEntryState::url)& url(
      const ::owl::mojom::NavigationEntryStatePtr& input) {
    return input->url;
  }

  static const decltype(::owl::mojom::NavigationEntryState::title)& title(
      const ::owl::mojom::NavigationEntryStatePtr& input) {
    return input->title;
  }

  static const decltype(::owl::mojom::NavigationEntryState::back_forward_state)& back_forward_state(
      const ::owl::mojom::NavigationEntryStatePtr& input) {
    return input->back_forward_state;
  }

  static bool Read(::owl::mojom::NavigationEntryState::DataView input, ::owl::mojom::NavigationEntryStatePtr* output);
};


template <>
struct  StructTraits<::owl::mojom::CommitDetails::DataView,
                                         ::owl::mojom::CommitDetailsPtr> {
  static bool IsNull(const ::owl::mojom::CommitDetailsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::CommitDetailsPtr* output) { output->reset(); }

  static decltype(::owl::mojom::CommitDetails::transition_type) transition_type(
      const ::owl::mojom::CommitDetailsPtr& input) {
    return input->transition_type;
  }

  static decltype(::owl::mojom::CommitDetails::is_redirect) is_redirect(
      const ::owl::mojom::CommitDetailsPtr& input) {
    return input->is_redirect;
  }

  static decltype(::owl::mojom::CommitDetails::is_chatgpt_frontend) is_chatgpt_frontend(
      const ::owl::mojom::CommitDetailsPtr& input) {
    return input->is_chatgpt_frontend;
  }

  static decltype(::owl::mojom::CommitDetails::did_replace_entry) did_replace_entry(
      const ::owl::mojom::CommitDetailsPtr& input) {
    return input->did_replace_entry;
  }

  static decltype(::owl::mojom::CommitDetails::is_same_document) is_same_document(
      const ::owl::mojom::CommitDetailsPtr& input) {
    return input->is_same_document;
  }

  static decltype(::owl::mojom::CommitDetails::entry_id) entry_id(
      const ::owl::mojom::CommitDetailsPtr& input) {
    return input->entry_id;
  }

  static const decltype(::owl::mojom::CommitDetails::removed_entry_ids)& removed_entry_ids(
      const ::owl::mojom::CommitDetailsPtr& input) {
    return input->removed_entry_ids;
  }

  static decltype(::owl::mojom::CommitDetails::main_frame_document_id) main_frame_document_id(
      const ::owl::mojom::CommitDetailsPtr& input) {
    return input->main_frame_document_id;
  }

  static const decltype(::owl::mojom::CommitDetails::removed_main_frame_document_ids)& removed_main_frame_document_ids(
      const ::owl::mojom::CommitDetailsPtr& input) {
    return input->removed_main_frame_document_ids;
  }

  static const decltype(::owl::mojom::CommitDetails::entry_state)& entry_state(
      const ::owl::mojom::CommitDetailsPtr& input) {
    return input->entry_state;
  }

  static decltype(::owl::mojom::CommitDetails::http_status_code) http_status_code(
      const ::owl::mojom::CommitDetailsPtr& input) {
    return input->http_status_code;
  }

  static decltype(::owl::mojom::CommitDetails::is_error_page) is_error_page(
      const ::owl::mojom::CommitDetailsPtr& input) {
    return input->is_error_page;
  }

  static bool Read(::owl::mojom::CommitDetails::DataView input, ::owl::mojom::CommitDetailsPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::NavigationEntryUrl::DataView,
                                         ::owl::mojom::NavigationEntryUrlPtr> {
  static bool IsNull(const ::owl::mojom::NavigationEntryUrlPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::NavigationEntryUrlPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::NavigationEntryUrl::url)& url(
      const ::owl::mojom::NavigationEntryUrlPtr& input) {
    return input->url;
  }

  static const decltype(::owl::mojom::NavigationEntryUrl::redirect_chain_start)& redirect_chain_start(
      const ::owl::mojom::NavigationEntryUrlPtr& input) {
    return input->redirect_chain_start;
  }

  static bool Read(::owl::mojom::NavigationEntryUrl::DataView input, ::owl::mojom::NavigationEntryUrlPtr* output);
};


template <>
struct  UnionTraits<::owl::mojom::SnapshotResult::DataView,
                                        ::owl::mojom::SnapshotResultPtr> {
  static bool IsNull(const ::owl::mojom::SnapshotResultPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::SnapshotResultPtr* output) { output->reset(); }

  static ::owl::mojom::SnapshotResult::Tag GetTag(const ::owl::mojom::SnapshotResultPtr& input) {
    return input->which();
  }

  static  ::SkBitmap& image( ::owl::mojom::SnapshotResultPtr& input) {
    return input->get_image();
  }

  static const std::string& error(const ::owl::mojom::SnapshotResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::owl::mojom::SnapshotResult::DataView input, ::owl::mojom::SnapshotResultPtr* output);
};


template <>
struct  UnionTraits<::owl::mojom::WebViewDisposition::DataView,
                                        ::owl::mojom::WebViewDispositionPtr> {
  static bool IsNull(const ::owl::mojom::WebViewDispositionPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::WebViewDispositionPtr* output) { output->reset(); }

  static ::owl::mojom::WebViewDisposition::Tag GetTag(const ::owl::mojom::WebViewDispositionPtr& input) {
    return input->which();
  }

  static const ::owl::mojom::WindowOpenContextPtr& window_open(const ::owl::mojom::WebViewDispositionPtr& input) {
    return input->get_window_open();
  }

  static const ::owl::mojom::PictureInPictureConfigPtr& picture_in_picture(const ::owl::mojom::WebViewDispositionPtr& input) {
    return input->get_picture_in_picture();
  }

  static  bool print_preview(const ::owl::mojom::WebViewDispositionPtr& input) {
    return input->get_print_preview();
  }

  static const ::owl::mojom::ExtensionPopupContextPtr& extension_popup(const ::owl::mojom::WebViewDispositionPtr& input) {
    return input->get_extension_popup();
  }

  static const ::owl::mojom::DevToolsContextPtr& dev_tools(const ::owl::mojom::WebViewDispositionPtr& input) {
    return input->get_dev_tools();
  }

  static bool Read(::owl::mojom::WebViewDisposition::DataView input, ::owl::mojom::WebViewDispositionPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_WEB_VIEW_MOJOM_H_