// owl/mojom/web_view.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_VIEW_MOJOM_SHARED_H_
#define OWL_MOJOM_WEB_VIEW_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/web_view.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "owl/mojom/address_prompt.mojom-shared.h"
#include "owl/mojom/autofill_popup.mojom-shared.h"
#include "owl/mojom/card_prompt.mojom-shared.h"
#include "owl/mojom/chatgpt_frontend.mojom-shared.h"
#include "owl/mojom/context_menu_params.mojom-shared.h"
#include "owl/mojom/password_prompt.mojom-shared.h"
#include "owl/mojom/permission_prompt.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_event.mojom-shared.h"
#include "third_party/blink/public/mojom/picture_in_picture_window_options/picture_in_picture_window_options.mojom-shared.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/remote_cocoa/common/application.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/web_view.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::DevToolsPanel>
    : public mojo::internal::EnumHashImpl<::owl::mojom::DevToolsPanel> {};

template <>
struct hash<::owl::mojom::TabAlertState>
    : public mojo::internal::EnumHashImpl<::owl::mojom::TabAlertState> {};

template <>
struct hash<::owl::mojom::TabNetworkState>
    : public mojo::internal::EnumHashImpl<::owl::mojom::TabNetworkState> {};

template <>
struct hash<::owl::mojom::NavigationType>
    : public mojo::internal::EnumHashImpl<::owl::mojom::NavigationType> {};

template <>
struct hash<::owl::mojom::TransitionType>
    : public mojo::internal::EnumHashImpl<::owl::mojom::TransitionType> {};

template <>
struct hash<::owl::mojom::SecurityLevel>
    : public mojo::internal::EnumHashImpl<::owl::mojom::SecurityLevel> {};

template <>
struct hash<::owl::mojom::FindDirection>
    : public mojo::internal::EnumHashImpl<::owl::mojom::FindDirection> {};

template <>
struct hash<::owl::mojom::JavaScriptDialogType>
    : public mojo::internal::EnumHashImpl<::owl::mojom::JavaScriptDialogType> {};

template <>
struct hash<::owl::mojom::TabSharingButtonState>
    : public mojo::internal::EnumHashImpl<::owl::mojom::TabSharingButtonState> {};

template <>
struct hash<::owl::mojom::TabSharingTabRole>
    : public mojo::internal::EnumHashImpl<::owl::mojom::TabSharingTabRole> {};

template <>
struct hash<::owl::mojom::RepostFormWarningResponse>
    : public mojo::internal::EnumHashImpl<::owl::mojom::RepostFormWarningResponse> {};

template <>
struct hash<::owl::mojom::WindowBridgeSource>
    : public mojo::internal::EnumHashImpl<::owl::mojom::WindowBridgeSource> {};

template <>
struct hash<::owl::mojom::DevToolsDockSide>
    : public mojo::internal::EnumHashImpl<::owl::mojom::DevToolsDockSide> {};

template <>
struct hash<::owl::mojom::RenderProcessStatus>
    : public mojo::internal::EnumHashImpl<::owl::mojom::RenderProcessStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::DevToolsPanel, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::DevToolsPanel, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::DevToolsPanel>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::TabAlertState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::TabAlertState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::TabAlertState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::TabNetworkState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::TabNetworkState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::TabNetworkState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::NavigationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::NavigationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::NavigationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::TransitionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::TransitionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::TransitionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::SecurityLevel, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::SecurityLevel, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::SecurityLevel>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::FindDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::FindDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::FindDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::JavaScriptDialogType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::JavaScriptDialogType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::JavaScriptDialogType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::TabSharingButtonState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::TabSharingButtonState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::TabSharingButtonState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::TabSharingTabRole, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::TabSharingTabRole, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::TabSharingTabRole>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::RepostFormWarningResponse, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::RepostFormWarningResponse, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::RepostFormWarningResponse>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::WindowBridgeSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::WindowBridgeSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::WindowBridgeSource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::DevToolsDockSide, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::DevToolsDockSide, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::DevToolsDockSide>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::RenderProcessStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::RenderProcessStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::RenderProcessStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::WebViewDiagnosticsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::WebViewDiagnosticsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::WebViewDiagnostics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->needs_reload = Traits::needs_reload(input);

    fragment->has_uncommitted_navigation_in_primary_main_frame = Traits::has_uncommitted_navigation_in_primary_main_frame(input);

    fragment->is_waiting_for_response = Traits::is_waiting_for_response(input);

    fragment->is_deferred = Traits::is_deferred(input);
    fragment->net_load_state_$flag = Traits::net_load_state(input).has_value();
    if (Traits::net_load_state(input).has_value()) {
      fragment->net_load_state_$value = Traits::net_load_state(input).value();
    }

    decltype(Traits::primary_main_frame_lifecycle(input)) in_primary_main_frame_lifecycle = Traits::primary_main_frame_lifecycle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->primary_main_frame_lifecycle)::BaseType> primary_main_frame_lifecycle_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_primary_main_frame_lifecycle,
      primary_main_frame_lifecycle_fragment);

    fragment->primary_main_frame_lifecycle.Set(
        primary_main_frame_lifecycle_fragment.is_null() ? nullptr : primary_main_frame_lifecycle_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->primary_main_frame_lifecycle.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null primary_main_frame_lifecycle in WebViewDiagnostics struct");

    decltype(Traits::last_committed_url(input)) in_last_committed_url = Traits::last_committed_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_committed_url)::BaseType> last_committed_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_last_committed_url,
      last_committed_url_fragment);

    fragment->last_committed_url.Set(
        last_committed_url_fragment.is_null() ? nullptr : last_committed_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_committed_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_committed_url in WebViewDiagnostics struct");

    fragment->entry_count = Traits::entry_count(input);

    fragment->pending_entry_index = Traits::pending_entry_index(input);

    fragment->current_entry_index = Traits::current_entry_index(input);

    fragment->is_web_contents_visible = Traits::is_web_contents_visible(input);
    fragment->is_rwhv_visible_$flag = Traits::is_rwhv_visible(input).has_value();
    if (Traits::is_rwhv_visible(input).has_value()) {
      fragment->is_rwhv_visible_$value = Traits::is_rwhv_visible(input).value();
    }

    decltype(Traits::rwhv_size(input)) in_rwhv_size = Traits::rwhv_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rwhv_size)::BaseType> rwhv_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_rwhv_size,
      rwhv_size_fragment);

    fragment->rwhv_size.Set(
        rwhv_size_fragment.is_null() ? nullptr : rwhv_size_fragment.data());
  }

  static bool Deserialize(::owl::mojom::internal::WebViewDiagnostics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::WebViewDiagnosticsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::FindResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::FindResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::FindResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->current_match_index = Traits::current_match_index(input);

    fragment->number_of_matches = Traits::number_of_matches(input);
  }

  static bool Deserialize(::owl::mojom::internal::FindResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::FindResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::DOMElementReferenceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::DOMElementReferenceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::DOMElementReference_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->frame_routing_id = Traits::frame_routing_id(input);

    fragment->frame_process_id = Traits::frame_process_id(input);

    fragment->x = Traits::x(input);

    fragment->y = Traits::y(input);
  }

  static bool Deserialize(::owl::mojom::internal::DOMElementReference_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::DOMElementReferenceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::NavigationEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::NavigationEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::NavigationEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->unique_id = Traits::unique_id(input);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in NavigationEntry struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NavigationEntry struct");

    decltype(Traits::favicon_url(input)) in_favicon_url = Traits::favicon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicon_url)::BaseType> favicon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_favicon_url,
      favicon_url_fragment);

    fragment->favicon_url.Set(
        favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());
  }

  static bool Deserialize(::owl::mojom::internal::NavigationEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::NavigationEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::SerializedDomElementInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::SerializedDomElementInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::SerializedDomElementInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tag(input)) in_tag = Traits::tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tag)::BaseType> tag_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_tag,
      tag_fragment);

    fragment->tag.Set(
        tag_fragment.is_null() ? nullptr : tag_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tag.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tag in SerializedDomElementInfo struct");

    decltype(Traits::selector(input)) in_selector = Traits::selector(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selector)::BaseType> selector_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_selector,
      selector_fragment);

    fragment->selector.Set(
        selector_fragment.is_null() ? nullptr : selector_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->selector.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selector in SerializedDomElementInfo struct");

    decltype(Traits::visible_bounds(input)) in_visible_bounds = Traits::visible_bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_bounds)::BaseType> visible_bounds_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_visible_bounds,
      visible_bounds_fragment);

    fragment->visible_bounds.Set(
        visible_bounds_fragment.is_null() ? nullptr : visible_bounds_fragment.data());

    decltype(Traits::click_point(input)) in_click_point = Traits::click_point(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->click_point)::BaseType> click_point_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_click_point,
      click_point_fragment);

    fragment->click_point.Set(
        click_point_fragment.is_null() ? nullptr : click_point_fragment.data());
  }

  static bool Deserialize(::owl::mojom::internal::SerializedDomElementInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::SerializedDomElementInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::TabRendererDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::TabRendererDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::TabRendererData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->blocked = Traits::blocked(input);

    fragment->crashed = Traits::crashed(input);

    decltype(Traits::alert_states(input)) in_alert_states = Traits::alert_states(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alert_states)::BaseType>
        alert_states_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& alert_states_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::owl::mojom::internal::TabAlertState_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::TabAlertState>>(
      in_alert_states,
      alert_states_fragment,
      &alert_states_validate_params);

    fragment->alert_states.Set(
        alert_states_fragment.is_null() ? nullptr : alert_states_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->alert_states.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_states in TabRendererData struct");

    decltype(Traits::favicon_image(input)) in_favicon_image = Traits::favicon_image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicon_image)::BaseType> favicon_image_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
      in_favicon_image,
      favicon_image_fragment);

    fragment->favicon_image.Set(
        favicon_image_fragment.is_null() ? nullptr : favicon_image_fragment.data());

    
    mojo::internal::Serialize<::owl::mojom::TabNetworkState>(
      Traits::network_state(input),
      &fragment->network_state);

    fragment->should_hide_loading_throbber = Traits::should_hide_loading_throbber(input);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in TabRendererData struct");

    decltype(Traits::last_committed_url(input)) in_last_committed_url = Traits::last_committed_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_committed_url)::BaseType> last_committed_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_last_committed_url,
      last_committed_url_fragment);

    fragment->last_committed_url.Set(
        last_committed_url_fragment.is_null() ? nullptr : last_committed_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_committed_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_committed_url in TabRendererData struct");

    decltype(Traits::visible_url(input)) in_visible_url = Traits::visible_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_url)::BaseType> visible_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_visible_url,
      visible_url_fragment);

    fragment->visible_url.Set(
        visible_url_fragment.is_null() ? nullptr : visible_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visible_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visible_url in TabRendererData struct");
  }

  static bool Deserialize(::owl::mojom::internal::TabRendererData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::TabRendererDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::ClipboardOverrideDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ClipboardOverrideDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ClipboardOverride_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    decltype(Traits::html(input)) in_html = Traits::html(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->html)::BaseType> html_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_html,
      html_fragment);

    fragment->html.Set(
        html_fragment.is_null() ? nullptr : html_fragment.data());
  }

  static bool Deserialize(::owl::mojom::internal::ClipboardOverride_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::ClipboardOverrideDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CertificateChainDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CertificateChainDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CertificateChain_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::der_chain(input)) in_der_chain = Traits::der_chain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->der_chain)::BaseType>
        der_chain_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& der_chain_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
      in_der_chain,
      der_chain_fragment,
      &der_chain_validate_params);

    fragment->der_chain.Set(
        der_chain_fragment.is_null() ? nullptr : der_chain_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->der_chain.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null der_chain in CertificateChain struct");
  }

  static bool Deserialize(::owl::mojom::internal::CertificateChain_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::CertificateChainDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::StoragePartitionDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::StoragePartitionDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::StoragePartitionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::partition_domain(input)) in_partition_domain = Traits::partition_domain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->partition_domain)::BaseType> partition_domain_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_partition_domain,
      partition_domain_fragment);

    fragment->partition_domain.Set(
        partition_domain_fragment.is_null() ? nullptr : partition_domain_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->partition_domain.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null partition_domain in StoragePartitionDescriptor struct");

    decltype(Traits::partition_name(input)) in_partition_name = Traits::partition_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->partition_name)::BaseType> partition_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_partition_name,
      partition_name_fragment);

    fragment->partition_name.Set(
        partition_name_fragment.is_null() ? nullptr : partition_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->partition_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null partition_name in StoragePartitionDescriptor struct");

    fragment->in_memory = Traits::in_memory(input);
  }

  static bool Deserialize(::owl::mojom::internal::StoragePartitionDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::StoragePartitionDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::ClientCertMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ClientCertMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ClientCertMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::subject(input)) in_subject = Traits::subject(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subject)::BaseType> subject_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_subject,
      subject_fragment);

    fragment->subject.Set(
        subject_fragment.is_null() ? nullptr : subject_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->subject.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subject in ClientCertMetadata struct");

    decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issuer)::BaseType> issuer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_issuer,
      issuer_fragment);

    fragment->issuer.Set(
        issuer_fragment.is_null() ? nullptr : issuer_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->issuer.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null issuer in ClientCertMetadata struct");

    decltype(Traits::serial(input)) in_serial = Traits::serial(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->serial)::BaseType> serial_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_serial,
      serial_fragment);

    fragment->serial.Set(
        serial_fragment.is_null() ? nullptr : serial_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->serial.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null serial in ClientCertMetadata struct");
  }

  static bool Deserialize(::owl::mojom::internal::ClientCertMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::ClientCertMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::PictureInPictureConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::PictureInPictureConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::PictureInPictureConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::window_options(input)) in_window_options = Traits::window_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->window_options)::BaseType> window_options_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PictureInPictureWindowOptionsDataView>(
      in_window_options,
      window_options_fragment);

    fragment->window_options.Set(
        window_options_fragment.is_null() ? nullptr : window_options_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->window_options.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null window_options in PictureInPictureConfig struct");
  }

  static bool Deserialize(::owl::mojom::internal::PictureInPictureConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::PictureInPictureConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::WindowOpenContextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::WindowOpenContextDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::WindowOpenContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::ui::mojom::WindowOpenDisposition>(
      Traits::disposition(input),
      &fragment->disposition);

    decltype(Traits::window_features(input)) in_window_features = Traits::window_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->window_features)::BaseType> window_features_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::WindowFeaturesDataView>(
      in_window_features,
      window_features_fragment);

    fragment->window_features.Set(
        window_features_fragment.is_null() ? nullptr : window_features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->window_features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null window_features in WindowOpenContext struct");
  }

  static bool Deserialize(::owl::mojom::internal::WindowOpenContext_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::WindowOpenContextDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::ExtensionPopupContextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ExtensionPopupContextDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ExtensionPopupContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::extension_id(input)) in_extension_id = Traits::extension_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extension_id)::BaseType> extension_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id,
      extension_id_fragment);

    fragment->extension_id.Set(
        extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->extension_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in ExtensionPopupContext struct");
  }

  static bool Deserialize(::owl::mojom::internal::ExtensionPopupContext_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::ExtensionPopupContextDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::DevToolsContextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::DevToolsContextDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::DevToolsContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::owl::mojom::DevToolsDockSide>(
      Traits::dock_side(input),
      &fragment->dock_side);
  }

  static bool Deserialize(::owl::mojom::internal::DevToolsContext_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::DevToolsContextDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::BackForwardStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::BackForwardStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::BackForwardState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->can_go_back = Traits::can_go_back(input);

    fragment->can_go_forward = Traits::can_go_forward(input);
  }

  static bool Deserialize(::owl::mojom::internal::BackForwardState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::BackForwardStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::NavigationEntryStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::NavigationEntryStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::NavigationEntryState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::owl::mojom::NavigationEntryUrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    decltype(Traits::back_forward_state(input)) in_back_forward_state = Traits::back_forward_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->back_forward_state)::BaseType> back_forward_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::owl::mojom::BackForwardStateDataView>(
      in_back_forward_state,
      back_forward_state_fragment);

    fragment->back_forward_state.Set(
        back_forward_state_fragment.is_null() ? nullptr : back_forward_state_fragment.data());
  }

  static bool Deserialize(::owl::mojom::internal::NavigationEntryState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::NavigationEntryStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CommitDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CommitDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CommitDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::owl::mojom::TransitionType>(
      Traits::transition_type(input),
      &fragment->transition_type);

    fragment->is_redirect = Traits::is_redirect(input);

    fragment->is_chatgpt_frontend = Traits::is_chatgpt_frontend(input);

    fragment->did_replace_entry = Traits::did_replace_entry(input);

    fragment->is_same_document = Traits::is_same_document(input);

    fragment->entry_id = Traits::entry_id(input);

    decltype(Traits::removed_entry_ids(input)) in_removed_entry_ids = Traits::removed_entry_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->removed_entry_ids)::BaseType>
        removed_entry_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& removed_entry_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
      in_removed_entry_ids,
      removed_entry_ids_fragment,
      &removed_entry_ids_validate_params);

    fragment->removed_entry_ids.Set(
        removed_entry_ids_fragment.is_null() ? nullptr : removed_entry_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->removed_entry_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null removed_entry_ids in CommitDetails struct");

    fragment->main_frame_document_id = Traits::main_frame_document_id(input);

    decltype(Traits::removed_main_frame_document_ids(input)) in_removed_main_frame_document_ids = Traits::removed_main_frame_document_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->removed_main_frame_document_ids)::BaseType>
        removed_main_frame_document_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& removed_main_frame_document_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
      in_removed_main_frame_document_ids,
      removed_main_frame_document_ids_fragment,
      &removed_main_frame_document_ids_validate_params);

    fragment->removed_main_frame_document_ids.Set(
        removed_main_frame_document_ids_fragment.is_null() ? nullptr : removed_main_frame_document_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->removed_main_frame_document_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null removed_main_frame_document_ids in CommitDetails struct");

    decltype(Traits::entry_state(input)) in_entry_state = Traits::entry_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->entry_state)::BaseType> entry_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::owl::mojom::NavigationEntryStateDataView>(
      in_entry_state,
      entry_state_fragment);

    fragment->entry_state.Set(
        entry_state_fragment.is_null() ? nullptr : entry_state_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->entry_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entry_state in CommitDetails struct");

    fragment->http_status_code = Traits::http_status_code(input);

    fragment->is_error_page = Traits::is_error_page(input);
  }

  static bool Deserialize(::owl::mojom::internal::CommitDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::CommitDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::NavigationEntryUrlDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::NavigationEntryUrlDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::NavigationEntryUrl_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NavigationEntryUrl struct");

    decltype(Traits::redirect_chain_start(input)) in_redirect_chain_start = Traits::redirect_chain_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->redirect_chain_start)::BaseType> redirect_chain_start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_redirect_chain_start,
      redirect_chain_start_fragment);

    fragment->redirect_chain_start.Set(
        redirect_chain_start_fragment.is_null() ? nullptr : redirect_chain_start_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->redirect_chain_start.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null redirect_chain_start in NavigationEntryUrl struct");
  }

  static bool Deserialize(::owl::mojom::internal::NavigationEntryUrl_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::NavigationEntryUrlDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::SnapshotResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::owl::mojom::SnapshotResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::owl::mojom::internal::SnapshotResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::owl::mojom::SnapshotResultDataView::Tag::kImage: {
    decltype(Traits::image(input))
    in_image = Traits::image(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_image)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
  in_image,
  value_fragment);
    fragment->data.f_image.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::SnapshotResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in SnapshotResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::owl::mojom::internal::SnapshotResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::SnapshotResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::WebViewDispositionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::owl::mojom::WebViewDispositionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::owl::mojom::internal::WebViewDisposition_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::owl::mojom::WebViewDispositionDataView::Tag::kWindowOpen: {
    decltype(Traits::window_open(input))
    in_window_open = Traits::window_open(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_window_open)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::WindowOpenContextDataView>(
  in_window_open,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null window_open in WebViewDisposition union");
    fragment->data.f_window_open.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::WebViewDispositionDataView::Tag::kPictureInPicture: {
    decltype(Traits::picture_in_picture(input))
    in_picture_in_picture = Traits::picture_in_picture(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_picture_in_picture)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::PictureInPictureConfigDataView>(
  in_picture_in_picture,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null picture_in_picture in WebViewDisposition union");
    fragment->data.f_picture_in_picture.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::WebViewDispositionDataView::Tag::kPrintPreview: {
    decltype(Traits::print_preview(input))
    in_print_preview = Traits::print_preview(input);
    fragment->data.f_print_preview = in_print_preview;
    break;
  }
  case ::owl::mojom::WebViewDispositionDataView::Tag::kExtensionPopup: {
    decltype(Traits::extension_popup(input))
    in_extension_popup = Traits::extension_popup(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_extension_popup)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::ExtensionPopupContextDataView>(
  in_extension_popup,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null extension_popup in WebViewDisposition union");
    fragment->data.f_extension_popup.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::WebViewDispositionDataView::Tag::kDevTools: {
    decltype(Traits::dev_tools(input))
    in_dev_tools = Traits::dev_tools(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_dev_tools)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::DevToolsContextDataView>(
  in_dev_tools,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null dev_tools in WebViewDisposition union");
    fragment->data.f_dev_tools.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::owl::mojom::internal::WebViewDisposition_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::WebViewDispositionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void WebViewDiagnosticsDataView::GetPrimaryMainFrameLifecycleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->primary_main_frame_lifecycle.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebViewDiagnosticsDataView::GetLastCommittedUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->last_committed_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void WebViewDiagnosticsDataView::GetRwhvSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->rwhv_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}






inline void NavigationEntryDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void NavigationEntryDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void NavigationEntryDataView::GetFaviconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->favicon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void SerializedDomElementInfoDataView::GetTagDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->tag.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SerializedDomElementInfoDataView::GetSelectorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->selector.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SerializedDomElementInfoDataView::GetVisibleBoundsDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->visible_bounds.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void SerializedDomElementInfoDataView::GetClickPointDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->click_point.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}


inline void TabRendererDataDataView::GetAlertStatesDataView(
    mojo::ArrayDataView<TabAlertState>* output) {
  auto pointer = data_->alert_states.Get();
  *output = mojo::ArrayDataView<TabAlertState>(pointer, message_);
}
inline void TabRendererDataDataView::GetFaviconImageDataView(
    ::gfx::mojom::ImageSkiaDataView* output) {
  auto pointer = data_->favicon_image.Get();
  *output = ::gfx::mojom::ImageSkiaDataView(pointer, message_);
}
inline void TabRendererDataDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void TabRendererDataDataView::GetLastCommittedUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->last_committed_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void TabRendererDataDataView::GetVisibleUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->visible_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void ClipboardOverrideDataView::GetTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ClipboardOverrideDataView::GetHtmlDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->html.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void CertificateChainDataView::GetDerChainDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->der_chain.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}


inline void StoragePartitionDescriptorDataView::GetPartitionDomainDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->partition_domain.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void StoragePartitionDescriptorDataView::GetPartitionNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->partition_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ClientCertMetadataDataView::GetSubjectDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->subject.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ClientCertMetadataDataView::GetIssuerDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->issuer.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ClientCertMetadataDataView::GetSerialDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->serial.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PictureInPictureConfigDataView::GetWindowOptionsDataView(
    ::blink::mojom::PictureInPictureWindowOptionsDataView* output) {
  auto pointer = data_->window_options.Get();
  *output = ::blink::mojom::PictureInPictureWindowOptionsDataView(pointer, message_);
}


inline void WindowOpenContextDataView::GetWindowFeaturesDataView(
    ::blink::mojom::WindowFeaturesDataView* output) {
  auto pointer = data_->window_features.Get();
  *output = ::blink::mojom::WindowFeaturesDataView(pointer, message_);
}


inline void ExtensionPopupContextDataView::GetExtensionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->extension_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}






inline void NavigationEntryStateDataView::GetUrlDataView(
    NavigationEntryUrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = NavigationEntryUrlDataView(pointer, message_);
}
inline void NavigationEntryStateDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void NavigationEntryStateDataView::GetBackForwardStateDataView(
    BackForwardStateDataView* output) {
  auto pointer = data_->back_forward_state.Get();
  *output = BackForwardStateDataView(pointer, message_);
}


inline void CommitDetailsDataView::GetRemovedEntryIdsDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->removed_entry_ids.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}
inline void CommitDetailsDataView::GetRemovedMainFrameDocumentIdsDataView(
    mojo::ArrayDataView<int64_t>* output) {
  auto pointer = data_->removed_main_frame_document_ids.Get();
  *output = mojo::ArrayDataView<int64_t>(pointer, message_);
}
inline void CommitDetailsDataView::GetEntryStateDataView(
    NavigationEntryStateDataView* output) {
  auto pointer = data_->entry_state.Get();
  *output = NavigationEntryStateDataView(pointer, message_);
}


inline void NavigationEntryUrlDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void NavigationEntryUrlDataView::GetRedirectChainStartDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->redirect_chain_start.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void SnapshotResultDataView::GetImageDataView(
    ::skia::mojom::BitmapN32DataView* output) const {
  CHECK(is_image());
  *output = ::skia::mojom::BitmapN32DataView(data_->data.f_image.Get(), message_);
}
inline void SnapshotResultDataView::GetErrorDataView(
    mojo::StringDataView* output) const {
  CHECK(is_error());
  *output = mojo::StringDataView(data_->data.f_error.Get(), message_);
}

inline void WebViewDispositionDataView::GetWindowOpenDataView(
    WindowOpenContextDataView* output) const {
  CHECK(is_window_open());
  *output = WindowOpenContextDataView(data_->data.f_window_open.Get(), message_);
}
inline void WebViewDispositionDataView::GetPictureInPictureDataView(
    PictureInPictureConfigDataView* output) const {
  CHECK(is_picture_in_picture());
  *output = PictureInPictureConfigDataView(data_->data.f_picture_in_picture.Get(), message_);
}
inline void WebViewDispositionDataView::GetExtensionPopupDataView(
    ExtensionPopupContextDataView* output) const {
  CHECK(is_extension_popup());
  *output = ExtensionPopupContextDataView(data_->data.f_extension_popup.Get(), message_);
}
inline void WebViewDispositionDataView::GetDevToolsDataView(
    DevToolsContextDataView* output) const {
  CHECK(is_dev_tools());
  *output = DevToolsContextDataView(data_->data.f_dev_tools.Get(), message_);
}


}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::DevToolsPanel> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::DevToolsPanel value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::TabAlertState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::TabAlertState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::TabNetworkState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::TabNetworkState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::NavigationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::NavigationType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::TransitionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::TransitionType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::SecurityLevel> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::SecurityLevel value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::FindDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::FindDirection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::JavaScriptDialogType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::JavaScriptDialogType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::TabSharingButtonState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::TabSharingButtonState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::TabSharingTabRole> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::TabSharingTabRole value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::RepostFormWarningResponse> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::RepostFormWarningResponse value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::WindowBridgeSource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::WindowBridgeSource value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::DevToolsDockSide> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::DevToolsDockSide value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::RenderProcessStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::RenderProcessStatus value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_WEB_VIEW_MOJOM_SHARED_H_