// owl/mojom/web_content.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_CONTENT_MOJOM_SHARED_H_
#define OWL_MOJOM_WEB_CONTENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/web_content.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "owl/mojom/context_menu_params.mojom-shared.h"
#include "owl/mojom/web_content_renderer.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-shared.h"
#include "ui/events/mojom/event.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/web_content.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::WindowSelectionMethod>
    : public mojo::internal::EnumHashImpl<::owl::mojom::WindowSelectionMethod> {};

template <>
struct hash<::owl::mojom::WindowVisibility>
    : public mojo::internal::EnumHashImpl<::owl::mojom::WindowVisibility> {};

template <>
struct hash<::owl::mojom::InputMode>
    : public mojo::internal::EnumHashImpl<::owl::mojom::InputMode> {};

template <>
struct hash<::owl::mojom::WebContentRendererType>
    : public mojo::internal::EnumHashImpl<::owl::mojom::WebContentRendererType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::WindowSelectionMethod, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::WindowSelectionMethod, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::WindowSelectionMethod>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::WindowVisibility, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::WindowVisibility, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::WindowVisibility>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::InputMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::InputMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::InputMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::WebContentRendererType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::WebContentRendererType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::WebContentRendererType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::FileSystemFileInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::FileSystemFileInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::FileSystemFileInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in FileSystemFileInfo struct");

    fragment->size = Traits::size(input);

    decltype(Traits::filesystem_id(input)) in_filesystem_id = Traits::filesystem_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filesystem_id)::BaseType> filesystem_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_filesystem_id,
      filesystem_id_fragment);

    fragment->filesystem_id.Set(
        filesystem_id_fragment.is_null() ? nullptr : filesystem_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->filesystem_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filesystem_id in FileSystemFileInfo struct");
  }

  static bool Deserialize(::owl::mojom::internal::FileSystemFileInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::FileSystemFileInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::DropDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::DropDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::DropData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    decltype(Traits::url_title(input)) in_url_title = Traits::url_title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url_title)::BaseType> url_title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_url_title,
      url_title_fragment);

    fragment->url_title.Set(
        url_title_fragment.is_null() ? nullptr : url_title_fragment.data());

    decltype(Traits::download_metadata(input)) in_download_metadata = Traits::download_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->download_metadata)::BaseType> download_metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_download_metadata,
      download_metadata_fragment);

    fragment->download_metadata.Set(
        download_metadata_fragment.is_null() ? nullptr : download_metadata_fragment.data());

    
    mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
      Traits::referrer_policy(input),
      &fragment->referrer_policy);

    decltype(Traits::filenames(input)) in_filenames = Traits::filenames(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filenames)::BaseType>
        filenames_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& filenames_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
      in_filenames,
      filenames_fragment,
      &filenames_validate_params);

    fragment->filenames.Set(
        filenames_fragment.is_null() ? nullptr : filenames_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->filenames.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filenames in DropData struct");

    decltype(Traits::file_mime_types(input)) in_file_mime_types = Traits::file_mime_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_mime_types)::BaseType>
        file_mime_types_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& file_mime_types_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_file_mime_types,
      file_mime_types_fragment,
      &file_mime_types_validate_params);

    fragment->file_mime_types.Set(
        file_mime_types_fragment.is_null() ? nullptr : file_mime_types_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->file_mime_types.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file_mime_types in DropData struct");

    decltype(Traits::filesystem_id(input)) in_filesystem_id = Traits::filesystem_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filesystem_id)::BaseType> filesystem_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_filesystem_id,
      filesystem_id_fragment);

    fragment->filesystem_id.Set(
        filesystem_id_fragment.is_null() ? nullptr : filesystem_id_fragment.data());

    decltype(Traits::file_system_files(input)) in_file_system_files = Traits::file_system_files(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_system_files)::BaseType>
        file_system_files_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& file_system_files_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::FileSystemFileInfoDataView>>(
      in_file_system_files,
      file_system_files_fragment,
      &file_system_files_validate_params);

    fragment->file_system_files.Set(
        file_system_files_fragment.is_null() ? nullptr : file_system_files_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->file_system_files.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file_system_files in DropData struct");

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    decltype(Traits::html(input)) in_html = Traits::html(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->html)::BaseType> html_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_html,
      html_fragment);

    fragment->html.Set(
        html_fragment.is_null() ? nullptr : html_fragment.data());

    decltype(Traits::html_base_url(input)) in_html_base_url = Traits::html_base_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->html_base_url)::BaseType> html_base_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_html_base_url,
      html_base_url_fragment);

    fragment->html_base_url.Set(
        html_base_url_fragment.is_null() ? nullptr : html_base_url_fragment.data());

    decltype(Traits::file_contents(input)) in_file_contents = Traits::file_contents(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_contents)::BaseType>
        file_contents_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& file_contents_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_file_contents,
      file_contents_fragment,
      &file_contents_validate_params);

    fragment->file_contents.Set(
        file_contents_fragment.is_null() ? nullptr : file_contents_fragment.data());

    fragment->file_contents_image_accessible = Traits::file_contents_image_accessible(input);

    decltype(Traits::file_contents_source_url(input)) in_file_contents_source_url = Traits::file_contents_source_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_contents_source_url)::BaseType> file_contents_source_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_file_contents_source_url,
      file_contents_source_url_fragment);

    fragment->file_contents_source_url.Set(
        file_contents_source_url_fragment.is_null() ? nullptr : file_contents_source_url_fragment.data());

    decltype(Traits::file_contents_filename_extension(input)) in_file_contents_filename_extension = Traits::file_contents_filename_extension(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_contents_filename_extension)::BaseType> file_contents_filename_extension_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_file_contents_filename_extension,
      file_contents_filename_extension_fragment);

    fragment->file_contents_filename_extension.Set(
        file_contents_filename_extension_fragment.is_null() ? nullptr : file_contents_filename_extension_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->file_contents_filename_extension.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file_contents_filename_extension in DropData struct");

    decltype(Traits::file_contents_content_disposition(input)) in_file_contents_content_disposition = Traits::file_contents_content_disposition(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_contents_content_disposition)::BaseType> file_contents_content_disposition_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_file_contents_content_disposition,
      file_contents_content_disposition_fragment);

    fragment->file_contents_content_disposition.Set(
        file_contents_content_disposition_fragment.is_null() ? nullptr : file_contents_content_disposition_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->file_contents_content_disposition.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file_contents_content_disposition in DropData struct");

    decltype(Traits::custom_data(input)) in_custom_data = Traits::custom_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->custom_data)::BaseType>
        custom_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& custom_data_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
      in_custom_data,
      custom_data_fragment,
      &custom_data_validate_params);

    fragment->custom_data.Set(
        custom_data_fragment.is_null() ? nullptr : custom_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->custom_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null custom_data in DropData struct");

    
    mojo::internal::Serialize<::ui::mojom::DragOperation>(
      Traits::operation(input),
      &fragment->operation);

    fragment->document_is_handling_drag = Traits::document_is_handling_drag(input);
  }

  static bool Deserialize(::owl::mojom::internal::DropData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::DropDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::DraggingInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::DraggingInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::DraggingInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::location_in_view(input)) in_location_in_view = Traits::location_in_view(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->location_in_view)::BaseType> location_in_view_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_location_in_view,
      location_in_view_fragment);

    fragment->location_in_view.Set(
        location_in_view_fragment.is_null() ? nullptr : location_in_view_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->location_in_view.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null location_in_view in DraggingInfo struct");

    decltype(Traits::location_in_screen(input)) in_location_in_screen = Traits::location_in_screen(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->location_in_screen)::BaseType> location_in_screen_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_location_in_screen,
      location_in_screen_fragment);

    fragment->location_in_screen.Set(
        location_in_screen_fragment.is_null() ? nullptr : location_in_screen_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->location_in_screen.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null location_in_screen in DraggingInfo struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    fragment->operation_mask = Traits::operation_mask(input);
  }

  static bool Deserialize(::owl::mojom::internal::DraggingInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::DraggingInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void FileSystemFileInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void FileSystemFileInfoDataView::GetFilesystemIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->filesystem_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DropDataDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DropDataDataView::GetUrlTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url_title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DropDataDataView::GetDownloadMetadataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->download_metadata.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DropDataDataView::GetFilenamesDataView(
    mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output) {
  auto pointer = data_->filenames.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>(pointer, message_);
}
inline void DropDataDataView::GetFileMimeTypesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->file_mime_types.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void DropDataDataView::GetFilesystemIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->filesystem_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DropDataDataView::GetFileSystemFilesDataView(
    mojo::ArrayDataView<FileSystemFileInfoDataView>* output) {
  auto pointer = data_->file_system_files.Get();
  *output = mojo::ArrayDataView<FileSystemFileInfoDataView>(pointer, message_);
}
inline void DropDataDataView::GetTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DropDataDataView::GetHtmlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->html.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DropDataDataView::GetHtmlBaseUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->html_base_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DropDataDataView::GetFileContentsDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->file_contents.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void DropDataDataView::GetFileContentsSourceUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->file_contents_source_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DropDataDataView::GetFileContentsFilenameExtensionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->file_contents_filename_extension.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DropDataDataView::GetFileContentsContentDispositionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->file_contents_content_disposition.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DropDataDataView::GetCustomDataDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->custom_data.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}


inline void DraggingInfoDataView::GetLocationInViewDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->location_in_view.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void DraggingInfoDataView::GetLocationInScreenDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->location_in_screen.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void DraggingInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::WindowSelectionMethod> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::WindowSelectionMethod value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::WindowVisibility> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::WindowVisibility value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::InputMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::InputMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::WebContentRendererType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::WebContentRendererType value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_WEB_CONTENT_MOJOM_SHARED_H_