// owl/mojom/session.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_SESSION_MOJOM_H_
#define OWL_MOJOM_SESSION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/session.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/session.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/session.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "owl/mojom/profile.mojom-forward.h"
#include "owl/mojom/web_view_session_data.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include "owl/mojom/icloud_passkeys.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class WatchdogClientProxy;

template <typename ImplRefTraits>
class WatchdogClientStub;

class WatchdogClientRequestValidator;
class WatchdogClientResponseValidator;


class WatchdogClient
    : public WatchdogClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WatchdogClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WatchdogClientInterfaceBase;
  using Proxy_ = WatchdogClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WatchdogClientStub<ImplRefTraits>;

  using RequestValidator_ = WatchdogClientRequestValidator;
  using ResponseValidator_ = WatchdogClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kPingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Ping_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WatchdogClient() = default;

  using PingCallback = base::OnceCallback<void()>;
  using PingMojoCallback = base::OnceCallback<void()>;

  virtual void Ping(PingCallback callback) = 0;
};

class SessionProxy;

template <typename ImplRefTraits>
class SessionStub;

class SessionRequestValidator;
class SessionResponseValidator;


class Session
    : public SessionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.Session";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SessionInterfaceBase;
  using Proxy_ = SessionProxy;

  template <typename ImplRefTraits>
  using Stub_ = SessionStub<ImplRefTraits>;

  using RequestValidator_ = SessionRequestValidator;
  using ResponseValidator_ = SessionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kShowChromeMinVersion = 0,
    kOpenProfileMinVersion = 0,
    kOpenGuestProfileMinVersion = 0,
    kSetAllowedWebUIPrefixesMinVersion = 0,
    kSetInternalURLsMinVersion = 0,
    kCreateWebViewSessionDataDecoderMinVersion = 0,
    kConfigureFeaturesMinVersion = 0,
    kPingMinVersion = 0,
    kStartWatchdogMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowChrome_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenProfile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenGuestProfile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAllowedWebUIPrefixes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetInternalURLs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateWebViewSessionDataDecoder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConfigureFeatures_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Ping_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartWatchdog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Session() = default;

  virtual void SetClient(::mojo::PendingAssociatedRemote<SessionClient> client) = 0;

  virtual void ShowChrome(bool enabled) = 0;

  virtual void OpenProfile(const ::base::FilePath& name, ::mojo::PendingReceiver<::owl::mojom::Profile> receiver) = 0;

  virtual void OpenGuestProfile(::mojo::PendingReceiver<::owl::mojom::Profile> receiver) = 0;

  virtual void SetAllowedWebUIPrefixes(const std::optional<std::vector<::GURL>>& prefixes) = 0;

  virtual void SetInternalURLs(std::optional<std::vector<InternalURLPatternPtr>> patterns) = 0;

  virtual void CreateWebViewSessionDataDecoder(::mojo::PendingReceiver<::owl::mojom::WebViewSessionDataDecoder> receiver) = 0;

  virtual void ConfigureFeatures(const base::flat_map<std::string, std::string>& feature_flags) = 0;

  using PingCallback = base::OnceCallback<void()>;
  using PingMojoCallback = base::OnceCallback<void()>;

  virtual void Ping(PingCallback callback) = 0;

  virtual void StartWatchdog(::mojo::PendingRemote<WatchdogClient> client) = 0;
};

class SessionClientProxy;

template <typename ImplRefTraits>
class SessionClientStub;

class SessionClientRequestValidator;


class SessionClient
    : public SessionClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.SessionClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SessionClientInterfaceBase;
  using Proxy_ = SessionClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SessionClientStub<ImplRefTraits>;

  using RequestValidator_ = SessionClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnNetworkStatusChangedMinVersion = 0,
    kOnNetworkServiceRestartedMinVersion = 0,
    kOnCaptivePortalStatusChangedMinVersion = 0,
    kGetICloudKeychainPasskeyBridgeMinVersion = 0,
    kOnNavigationThrottleImpactedNavigationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnNetworkStatusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNetworkServiceRestarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCaptivePortalStatusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetICloudKeychainPasskeyBridge_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNavigationThrottleImpactedNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SessionClient() = default;

  virtual void OnNetworkStatusChanged(NetworkStatus network_status) = 0;

  virtual void OnNetworkServiceRestarted(bool from_crash) = 0;

  virtual void OnCaptivePortalStatusChanged(bool is_behind_captive_portal) = 0;

  virtual void GetICloudKeychainPasskeyBridge(::mojo::PendingReceiver<::owl::mojom::ICloudKeychainPasskeyBridge> bridge) = 0;

  virtual void OnNavigationThrottleImpactedNavigation(const std::string& throttle_name, const std::string& event_description, const std::string& modification_type, const std::optional<::GURL>& url) = 0;
};



class  WatchdogClientProxy
    : public WatchdogClient {
 public:
  using InterfaceType = WatchdogClient;

  explicit WatchdogClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Ping(PingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SessionProxy
    : public Session {
 public:
  using InterfaceType = Session;

  explicit SessionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingAssociatedRemote<SessionClient> client) final;
  
  void ShowChrome(bool enabled) final;
  
  void OpenProfile(const ::base::FilePath& name, ::mojo::PendingReceiver<::owl::mojom::Profile> receiver) final;
  
  void OpenGuestProfile(::mojo::PendingReceiver<::owl::mojom::Profile> receiver) final;
  
  void SetAllowedWebUIPrefixes(const std::optional<std::vector<::GURL>>& prefixes) final;
  
  void SetInternalURLs(std::optional<std::vector<InternalURLPatternPtr>> patterns) final;
  
  void CreateWebViewSessionDataDecoder(::mojo::PendingReceiver<::owl::mojom::WebViewSessionDataDecoder> receiver) final;
  
  void ConfigureFeatures(const base::flat_map<std::string, std::string>& feature_flags) final;
  
  void Ping(PingCallback callback) final;
  
  void StartWatchdog(::mojo::PendingRemote<WatchdogClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SessionClientProxy
    : public SessionClient {
 public:
  using InterfaceType = SessionClient;

  explicit SessionClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnNetworkStatusChanged(NetworkStatus network_status) final;
  
  void OnNetworkServiceRestarted(bool from_crash) final;
  
  void OnCaptivePortalStatusChanged(bool is_behind_captive_portal) final;
  
  void GetICloudKeychainPasskeyBridge(::mojo::PendingReceiver<::owl::mojom::ICloudKeychainPasskeyBridge> bridge) final;
  
  void OnNavigationThrottleImpactedNavigation(const std::string& throttle_name, const std::string& event_description, const std::string& modification_type, const std::optional<::GURL>& url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WatchdogClientStubDispatch {
 public:
  static bool Accept(WatchdogClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WatchdogClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WatchdogClient>>
class WatchdogClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WatchdogClientStub() = default;
  ~WatchdogClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WatchdogClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WatchdogClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SessionStubDispatch {
 public:
  static bool Accept(Session* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Session* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Session>>
class SessionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SessionStub() = default;
  ~SessionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SessionClientStubDispatch {
 public:
  static bool Accept(SessionClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SessionClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SessionClient>>
class SessionClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SessionClientStub() = default;
  ~SessionClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WatchdogClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SessionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SessionClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WatchdogClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SessionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  InternalURLPattern {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InternalURLPattern, T>::value>;
  using DataView = InternalURLPatternDataView;
  using Data_ = internal::InternalURLPattern_Data;

  template <typename... Args>
  static InternalURLPatternPtr New(Args&&... args) {
    return InternalURLPatternPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InternalURLPatternPtr From(const U& u) {
    return mojo::TypeConverter<InternalURLPatternPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InternalURLPattern>::Convert(*this);
  }


  InternalURLPattern();

  InternalURLPattern(
      const std::string& prefix,
      const std::string& query);


  ~InternalURLPattern();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InternalURLPatternPtr>
  InternalURLPatternPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InternalURLPattern::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InternalURLPattern::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InternalURLPattern::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InternalURLPattern_UnserializedMessageContext<
            UserType, InternalURLPattern::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InternalURLPattern::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InternalURLPattern::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InternalURLPattern_UnserializedMessageContext<
            UserType, InternalURLPattern::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InternalURLPattern::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string prefix;
  
  std::string query;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InternalURLPattern::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
InternalURLPatternPtr InternalURLPattern::Clone() const {
  return New(
      mojo::Clone(prefix),
      mojo::Clone(query)
  );
}

template <typename T, InternalURLPattern::EnableIfSame<T>*>
bool InternalURLPattern::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->prefix, other_struct.prefix))
    return false;
  if (!mojo::Equals(this->query, other_struct.query))
    return false;
  return true;
}

template <typename T, InternalURLPattern::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.prefix < rhs.prefix)
    return true;
  if (rhs.prefix < lhs.prefix)
    return false;
  if (lhs.query < rhs.query)
    return true;
  if (rhs.query < lhs.query)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::InternalURLPattern::DataView,
                                         ::owl::mojom::InternalURLPatternPtr> {
  static bool IsNull(const ::owl::mojom::InternalURLPatternPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::InternalURLPatternPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::InternalURLPattern::prefix)& prefix(
      const ::owl::mojom::InternalURLPatternPtr& input) {
    return input->prefix;
  }

  static const decltype(::owl::mojom::InternalURLPattern::query)& query(
      const ::owl::mojom::InternalURLPatternPtr& input) {
    return input->query;
  }

  static bool Read(::owl::mojom::InternalURLPattern::DataView input, ::owl::mojom::InternalURLPatternPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_SESSION_MOJOM_H_