// owl/mojom/session.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/session.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/session.mojom-params-data.h"
#include "owl/mojom/session.mojom-shared-message-ids.h"

#include "owl/mojom/session.mojom-import-headers.h"
#include "owl/mojom/session.mojom-test-utils.h"


namespace owl::mojom {
InternalURLPattern::InternalURLPattern()
    : prefix(),
      query() {}

InternalURLPattern::InternalURLPattern(
    const std::string& prefix_in,
    const std::string& query_in)
    : prefix(std::move(prefix_in)),
      query(std::move(query_in)) {}

InternalURLPattern::~InternalURLPattern() = default;
size_t InternalURLPattern::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->prefix);
  seed = mojo::internal::Hash(seed, this->query);
  return seed;
}

void InternalURLPattern::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prefix"), this->prefix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "query"), this->query,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InternalURLPattern::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WatchdogClient::IPCStableHashFunction WatchdogClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WatchdogClient>(message.name())) {
    case messages::WatchdogClient::kPing: {
      return &WatchdogClient::Ping_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WatchdogClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WatchdogClient>(message.name())) {
      case messages::WatchdogClient::kPing:
            return "Receive owl::mojom::WatchdogClient::Ping";
    }
  } else {
    switch (static_cast<messages::WatchdogClient>(message.name())) {
      case messages::WatchdogClient::kPing:
            return "Receive reply owl::mojom::WatchdogClient::Ping";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WatchdogClient::Ping_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0131b649;  // IPCStableHash for owl::mojom::WatchdogClient::Ping
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WatchdogClient_Ping_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WatchdogClient_Ping_ForwardToCallback(
      WatchdogClient::PingCallback callback
      ) : callback_(std::move(callback)) {
  }

  WatchdogClient_Ping_ForwardToCallback(const WatchdogClient_Ping_ForwardToCallback&) = delete;
  WatchdogClient_Ping_ForwardToCallback& operator=(const WatchdogClient_Ping_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WatchdogClient::PingCallback callback_;
};

WatchdogClientProxy::WatchdogClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WatchdogClientProxy::Ping(
    PingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WatchdogClient::Ping");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WatchdogClient::kPing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WatchdogClient_Ping_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchdogClient::Name_);
  message.set_method_name("Ping");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WatchdogClient_Ping_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WatchdogClient_Ping_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WatchdogClient::PingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WatchdogClient_Ping_ProxyToResponder> proxy(
        new WatchdogClient_Ping_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WatchdogClient_Ping_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WatchdogClient_Ping_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WatchdogClient_Ping_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WatchdogClient::PingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WatchdogClient_Ping_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WatchdogClient_Ping_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WatchdogClient_Ping_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WatchdogClient.0
  bool success = true;
  WatchdogClient_Ping_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WatchdogClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WatchdogClient_Ping_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply owl::mojom::WatchdogClient::Ping");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WatchdogClient::kPing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WatchdogClient_Ping_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchdogClient::Name_);
  message.set_method_name("Ping");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WatchdogClientStubDispatch::Accept(
    WatchdogClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WatchdogClient>(message->header()->name)) {
    case messages::WatchdogClient::kPing: {
      break;
    }
  }
  return false;
}

// static
bool WatchdogClientStubDispatch::AcceptWithResponder(
    WatchdogClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WatchdogClient>(message->header()->name)) {
    case messages::WatchdogClient::kPing: {
      internal::WatchdogClient_Ping_Params_Data* params =
          reinterpret_cast<
              internal::WatchdogClient_Ping_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WatchdogClient.0
      bool success = true;
      WatchdogClient_Ping_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchdogClient::Name_, 0, false);
        return false;
      }
      auto callback =
          WatchdogClient_Ping_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Ping(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWatchdogClientValidationInfo[] = {
    { &internal::WatchdogClient_Ping_Params_Data::Validate,
     &internal::WatchdogClient_Ping_ResponseParams_Data::Validate},
};

bool WatchdogClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::WatchdogClient::Name_,
    kWatchdogClientValidationInfo);
}

bool WatchdogClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::WatchdogClient::Name_,
    kWatchdogClientValidationInfo);
}
// The declaration includes the definition on other builds.

Session::IPCStableHashFunction Session::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Session>(message.name())) {
    case messages::Session::kSetClient: {
      return &Session::SetClient_Sym::IPCStableHash;
    }
    case messages::Session::kShowChrome: {
      return &Session::ShowChrome_Sym::IPCStableHash;
    }
    case messages::Session::kOpenProfile: {
      return &Session::OpenProfile_Sym::IPCStableHash;
    }
    case messages::Session::kOpenGuestProfile: {
      return &Session::OpenGuestProfile_Sym::IPCStableHash;
    }
    case messages::Session::kSetAllowedWebUIPrefixes: {
      return &Session::SetAllowedWebUIPrefixes_Sym::IPCStableHash;
    }
    case messages::Session::kSetInternalURLs: {
      return &Session::SetInternalURLs_Sym::IPCStableHash;
    }
    case messages::Session::kCreateWebViewSessionDataDecoder: {
      return &Session::CreateWebViewSessionDataDecoder_Sym::IPCStableHash;
    }
    case messages::Session::kConfigureFeatures: {
      return &Session::ConfigureFeatures_Sym::IPCStableHash;
    }
    case messages::Session::kPing: {
      return &Session::Ping_Sym::IPCStableHash;
    }
    case messages::Session::kStartWatchdog: {
      return &Session::StartWatchdog_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Session::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Session>(message.name())) {
      case messages::Session::kSetClient:
            return "Receive owl::mojom::Session::SetClient";
      case messages::Session::kShowChrome:
            return "Receive owl::mojom::Session::ShowChrome";
      case messages::Session::kOpenProfile:
            return "Receive owl::mojom::Session::OpenProfile";
      case messages::Session::kOpenGuestProfile:
            return "Receive owl::mojom::Session::OpenGuestProfile";
      case messages::Session::kSetAllowedWebUIPrefixes:
            return "Receive owl::mojom::Session::SetAllowedWebUIPrefixes";
      case messages::Session::kSetInternalURLs:
            return "Receive owl::mojom::Session::SetInternalURLs";
      case messages::Session::kCreateWebViewSessionDataDecoder:
            return "Receive owl::mojom::Session::CreateWebViewSessionDataDecoder";
      case messages::Session::kConfigureFeatures:
            return "Receive owl::mojom::Session::ConfigureFeatures";
      case messages::Session::kPing:
            return "Receive owl::mojom::Session::Ping";
      case messages::Session::kStartWatchdog:
            return "Receive owl::mojom::Session::StartWatchdog";
    }
  } else {
    switch (static_cast<messages::Session>(message.name())) {
      case messages::Session::kSetClient:
            return "Receive reply owl::mojom::Session::SetClient";
      case messages::Session::kShowChrome:
            return "Receive reply owl::mojom::Session::ShowChrome";
      case messages::Session::kOpenProfile:
            return "Receive reply owl::mojom::Session::OpenProfile";
      case messages::Session::kOpenGuestProfile:
            return "Receive reply owl::mojom::Session::OpenGuestProfile";
      case messages::Session::kSetAllowedWebUIPrefixes:
            return "Receive reply owl::mojom::Session::SetAllowedWebUIPrefixes";
      case messages::Session::kSetInternalURLs:
            return "Receive reply owl::mojom::Session::SetInternalURLs";
      case messages::Session::kCreateWebViewSessionDataDecoder:
            return "Receive reply owl::mojom::Session::CreateWebViewSessionDataDecoder";
      case messages::Session::kConfigureFeatures:
            return "Receive reply owl::mojom::Session::ConfigureFeatures";
      case messages::Session::kPing:
            return "Receive reply owl::mojom::Session::Ping";
      case messages::Session::kStartWatchdog:
            return "Receive reply owl::mojom::Session::StartWatchdog";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Session::SetClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d52c97e;  // IPCStableHash for owl::mojom::Session::SetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::ShowChrome_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x51bc7dab;  // IPCStableHash for owl::mojom::Session::ShowChrome
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::OpenProfile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4044ac7e;  // IPCStableHash for owl::mojom::Session::OpenProfile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::OpenGuestProfile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8dceb8e9;  // IPCStableHash for owl::mojom::Session::OpenGuestProfile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::SetAllowedWebUIPrefixes_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaa5f0463;  // IPCStableHash for owl::mojom::Session::SetAllowedWebUIPrefixes
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::SetInternalURLs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4473acc4;  // IPCStableHash for owl::mojom::Session::SetInternalURLs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::CreateWebViewSessionDataDecoder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x31770536;  // IPCStableHash for owl::mojom::Session::CreateWebViewSessionDataDecoder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::ConfigureFeatures_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x428ae698;  // IPCStableHash for owl::mojom::Session::ConfigureFeatures
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::Ping_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe0995476;  // IPCStableHash for owl::mojom::Session::Ping
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::StartWatchdog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x21df8528;  // IPCStableHash for owl::mojom::Session::StartWatchdog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Session_Ping_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Session_Ping_ForwardToCallback(
      Session::PingCallback callback
      ) : callback_(std::move(callback)) {
  }

  Session_Ping_ForwardToCallback(const Session_Ping_ForwardToCallback&) = delete;
  Session_Ping_ForwardToCallback& operator=(const Session_Ping_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Session::PingCallback callback_;
};

SessionProxy::SessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SessionProxy::SetClient(
    ::mojo::PendingAssociatedRemote<SessionClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Session::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<SessionClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Session_SetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::SessionClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in Session.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionProxy::ShowChrome(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Session::ShowChrome", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kShowChrome), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Session_ShowChrome_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("ShowChrome");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionProxy::OpenProfile(
    const ::base::FilePath& in_name, ::mojo::PendingReceiver<::owl::mojom::Profile> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Session::OpenProfile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::owl::mojom::Profile>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kOpenProfile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Session_OpenProfile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in Session.OpenProfile request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::owl::mojom::ProfileInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in Session.OpenProfile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("OpenProfile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionProxy::OpenGuestProfile(
    ::mojo::PendingReceiver<::owl::mojom::Profile> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Session::OpenGuestProfile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::owl::mojom::Profile>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kOpenGuestProfile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Session_OpenGuestProfile_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::owl::mojom::ProfileInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in Session.OpenGuestProfile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("OpenGuestProfile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionProxy::SetAllowedWebUIPrefixes(
    const std::optional<std::vector<::GURL>>& in_prefixes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Session::SetAllowedWebUIPrefixes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prefixes"), in_prefixes,
                        "<value of type const std::optional<std::vector<::GURL>>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kSetAllowedWebUIPrefixes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Session_SetAllowedWebUIPrefixes_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->prefixes)::BaseType>
      prefixes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& prefixes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_prefixes,
    prefixes_fragment,
    &prefixes_validate_params);

  params->prefixes.Set(
      prefixes_fragment.is_null() ? nullptr : prefixes_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("SetAllowedWebUIPrefixes");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionProxy::SetInternalURLs(
    std::optional<std::vector<InternalURLPatternPtr>> in_patterns) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Session::SetInternalURLs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("patterns"), in_patterns,
                        "<value of type std::optional<std::vector<InternalURLPatternPtr>>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kSetInternalURLs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Session_SetInternalURLs_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->patterns)::BaseType>
      patterns_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& patterns_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::InternalURLPatternDataView>>(
    in_patterns,
    patterns_fragment,
    &patterns_validate_params);

  params->patterns.Set(
      patterns_fragment.is_null() ? nullptr : patterns_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("SetInternalURLs");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionProxy::CreateWebViewSessionDataDecoder(
    ::mojo::PendingReceiver<::owl::mojom::WebViewSessionDataDecoder> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Session::CreateWebViewSessionDataDecoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::owl::mojom::WebViewSessionDataDecoder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kCreateWebViewSessionDataDecoder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Session_CreateWebViewSessionDataDecoder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::owl::mojom::WebViewSessionDataDecoderInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in Session.CreateWebViewSessionDataDecoder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("CreateWebViewSessionDataDecoder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionProxy::ConfigureFeatures(
    const base::flat_map<std::string, std::string>& in_feature_flags) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Session::ConfigureFeatures", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature_flags"), in_feature_flags,
                        "<value of type const base::flat_map<std::string, std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kConfigureFeatures), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Session_ConfigureFeatures_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->feature_flags)::BaseType>
      feature_flags_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& feature_flags_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
    in_feature_flags,
    feature_flags_fragment,
    &feature_flags_validate_params);

  params->feature_flags.Set(
      feature_flags_fragment.is_null() ? nullptr : feature_flags_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->feature_flags.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null feature_flags in Session.ConfigureFeatures request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("ConfigureFeatures");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionProxy::Ping(
    PingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::Session::Ping");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kPing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Session_Ping_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("Ping");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Session_Ping_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SessionProxy::StartWatchdog(
    ::mojo::PendingRemote<WatchdogClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Session::StartWatchdog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<WatchdogClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kStartWatchdog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Session_StartWatchdog_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::owl::mojom::WatchdogClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in Session.StartWatchdog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("StartWatchdog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Session_Ping_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Session::PingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Session_Ping_ProxyToResponder> proxy(
        new Session_Ping_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Session_Ping_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Session_Ping_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Session_Ping_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Session::PingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Session_Ping_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Session_Ping_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Session_Ping_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Session.8
  bool success = true;
  Session_Ping_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Session::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Session_Ping_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply owl::mojom::Session::Ping");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kPing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Session_Ping_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("Ping");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SessionStubDispatch::Accept(
    Session* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Session>(message->header()->name)) {
    case messages::Session::kSetClient: {
      DCHECK(message->is_serialized());
      internal::Session_SetClient_Params_Data* params =
          reinterpret_cast<internal::Session_SetClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<SessionClient> p_client{};
      Session_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(        
        std::move(p_client));
      return true;
    }
    case messages::Session::kShowChrome: {
      DCHECK(message->is_serialized());
      internal::Session_ShowChrome_Params_Data* params =
          reinterpret_cast<internal::Session_ShowChrome_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.1
      bool success = true;
      bool p_enabled{};
      Session_ShowChrome_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowChrome(        
        std::move(p_enabled));
      return true;
    }
    case messages::Session::kOpenProfile: {
      DCHECK(message->is_serialized());
      internal::Session_OpenProfile_Params_Data* params =
          reinterpret_cast<internal::Session_OpenProfile_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.2
      bool success = true;
      ::base::FilePath p_name{};
      ::mojo::PendingReceiver<::owl::mojom::Profile> p_receiver{};
      Session_OpenProfile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenProfile(        
        std::move(p_name), 
        std::move(p_receiver));
      return true;
    }
    case messages::Session::kOpenGuestProfile: {
      DCHECK(message->is_serialized());
      internal::Session_OpenGuestProfile_Params_Data* params =
          reinterpret_cast<internal::Session_OpenGuestProfile_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.3
      bool success = true;
      ::mojo::PendingReceiver<::owl::mojom::Profile> p_receiver{};
      Session_OpenGuestProfile_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenGuestProfile(        
        std::move(p_receiver));
      return true;
    }
    case messages::Session::kSetAllowedWebUIPrefixes: {
      DCHECK(message->is_serialized());
      internal::Session_SetAllowedWebUIPrefixes_Params_Data* params =
          reinterpret_cast<internal::Session_SetAllowedWebUIPrefixes_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.4
      bool success = true;
      std::optional<std::vector<::GURL>> p_prefixes{};
      Session_SetAllowedWebUIPrefixes_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPrefixes(&p_prefixes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAllowedWebUIPrefixes(        
        std::move(p_prefixes));
      return true;
    }
    case messages::Session::kSetInternalURLs: {
      DCHECK(message->is_serialized());
      internal::Session_SetInternalURLs_Params_Data* params =
          reinterpret_cast<internal::Session_SetInternalURLs_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.5
      bool success = true;
      std::optional<std::vector<InternalURLPatternPtr>> p_patterns{};
      Session_SetInternalURLs_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPatterns(&p_patterns))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInternalURLs(        
        std::move(p_patterns));
      return true;
    }
    case messages::Session::kCreateWebViewSessionDataDecoder: {
      DCHECK(message->is_serialized());
      internal::Session_CreateWebViewSessionDataDecoder_Params_Data* params =
          reinterpret_cast<internal::Session_CreateWebViewSessionDataDecoder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.6
      bool success = true;
      ::mojo::PendingReceiver<::owl::mojom::WebViewSessionDataDecoder> p_receiver{};
      Session_CreateWebViewSessionDataDecoder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWebViewSessionDataDecoder(        
        std::move(p_receiver));
      return true;
    }
    case messages::Session::kConfigureFeatures: {
      DCHECK(message->is_serialized());
      internal::Session_ConfigureFeatures_Params_Data* params =
          reinterpret_cast<internal::Session_ConfigureFeatures_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.7
      bool success = true;
      base::flat_map<std::string, std::string> p_feature_flags{};
      Session_ConfigureFeatures_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeatureFlags(&p_feature_flags))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConfigureFeatures(        
        std::move(p_feature_flags));
      return true;
    }
    case messages::Session::kPing: {
      break;
    }
    case messages::Session::kStartWatchdog: {
      DCHECK(message->is_serialized());
      internal::Session_StartWatchdog_Params_Data* params =
          reinterpret_cast<internal::Session_StartWatchdog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.9
      bool success = true;
      ::mojo::PendingRemote<WatchdogClient> p_client{};
      Session_StartWatchdog_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartWatchdog(        
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool SessionStubDispatch::AcceptWithResponder(
    Session* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Session>(message->header()->name)) {
    case messages::Session::kSetClient: {
      break;
    }
    case messages::Session::kShowChrome: {
      break;
    }
    case messages::Session::kOpenProfile: {
      break;
    }
    case messages::Session::kOpenGuestProfile: {
      break;
    }
    case messages::Session::kSetAllowedWebUIPrefixes: {
      break;
    }
    case messages::Session::kSetInternalURLs: {
      break;
    }
    case messages::Session::kCreateWebViewSessionDataDecoder: {
      break;
    }
    case messages::Session::kConfigureFeatures: {
      break;
    }
    case messages::Session::kPing: {
      internal::Session_Ping_Params_Data* params =
          reinterpret_cast<
              internal::Session_Ping_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Session.8
      bool success = true;
      Session_Ping_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 8, false);
        return false;
      }
      auto callback =
          Session_Ping_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Ping(std::move(callback));
      return true;
    }
    case messages::Session::kStartWatchdog: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSessionValidationInfo[] = {
    { &internal::Session_SetClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Session_ShowChrome_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Session_OpenProfile_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Session_OpenGuestProfile_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Session_SetAllowedWebUIPrefixes_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Session_SetInternalURLs_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Session_CreateWebViewSessionDataDecoder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Session_ConfigureFeatures_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Session_Ping_Params_Data::Validate,
     &internal::Session_Ping_ResponseParams_Data::Validate},
    { &internal::Session_StartWatchdog_Params_Data::Validate,
     nullptr /* no response */},
};

bool SessionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::Session::Name_,
    kSessionValidationInfo);
}

bool SessionResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::Session::Name_,
    kSessionValidationInfo);
}
// The declaration includes the definition on other builds.

SessionClient::IPCStableHashFunction SessionClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SessionClient>(message.name())) {
    case messages::SessionClient::kOnNetworkStatusChanged: {
      return &SessionClient::OnNetworkStatusChanged_Sym::IPCStableHash;
    }
    case messages::SessionClient::kOnNetworkServiceRestarted: {
      return &SessionClient::OnNetworkServiceRestarted_Sym::IPCStableHash;
    }
    case messages::SessionClient::kOnCaptivePortalStatusChanged: {
      return &SessionClient::OnCaptivePortalStatusChanged_Sym::IPCStableHash;
    }
    case messages::SessionClient::kGetICloudKeychainPasskeyBridge: {
      return &SessionClient::GetICloudKeychainPasskeyBridge_Sym::IPCStableHash;
    }
    case messages::SessionClient::kOnNavigationThrottleImpactedNavigation: {
      return &SessionClient::OnNavigationThrottleImpactedNavigation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SessionClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SessionClient>(message.name())) {
      case messages::SessionClient::kOnNetworkStatusChanged:
            return "Receive owl::mojom::SessionClient::OnNetworkStatusChanged";
      case messages::SessionClient::kOnNetworkServiceRestarted:
            return "Receive owl::mojom::SessionClient::OnNetworkServiceRestarted";
      case messages::SessionClient::kOnCaptivePortalStatusChanged:
            return "Receive owl::mojom::SessionClient::OnCaptivePortalStatusChanged";
      case messages::SessionClient::kGetICloudKeychainPasskeyBridge:
            return "Receive owl::mojom::SessionClient::GetICloudKeychainPasskeyBridge";
      case messages::SessionClient::kOnNavigationThrottleImpactedNavigation:
            return "Receive owl::mojom::SessionClient::OnNavigationThrottleImpactedNavigation";
    }
  } else {
    switch (static_cast<messages::SessionClient>(message.name())) {
      case messages::SessionClient::kOnNetworkStatusChanged:
            return "Receive reply owl::mojom::SessionClient::OnNetworkStatusChanged";
      case messages::SessionClient::kOnNetworkServiceRestarted:
            return "Receive reply owl::mojom::SessionClient::OnNetworkServiceRestarted";
      case messages::SessionClient::kOnCaptivePortalStatusChanged:
            return "Receive reply owl::mojom::SessionClient::OnCaptivePortalStatusChanged";
      case messages::SessionClient::kGetICloudKeychainPasskeyBridge:
            return "Receive reply owl::mojom::SessionClient::GetICloudKeychainPasskeyBridge";
      case messages::SessionClient::kOnNavigationThrottleImpactedNavigation:
            return "Receive reply owl::mojom::SessionClient::OnNavigationThrottleImpactedNavigation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SessionClient::OnNetworkStatusChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x747bee8c;  // IPCStableHash for owl::mojom::SessionClient::OnNetworkStatusChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionClient::OnNetworkServiceRestarted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x69c617e1;  // IPCStableHash for owl::mojom::SessionClient::OnNetworkServiceRestarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionClient::OnCaptivePortalStatusChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x31d60a18;  // IPCStableHash for owl::mojom::SessionClient::OnCaptivePortalStatusChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionClient::GetICloudKeychainPasskeyBridge_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6680c11f;  // IPCStableHash for owl::mojom::SessionClient::GetICloudKeychainPasskeyBridge
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionClient::OnNavigationThrottleImpactedNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x88b59567;  // IPCStableHash for owl::mojom::SessionClient::OnNavigationThrottleImpactedNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SessionClientProxy::SessionClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SessionClientProxy::OnNetworkStatusChanged(
    NetworkStatus in_network_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::SessionClient::OnNetworkStatusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_status"), in_network_status,
                        "<value of type NetworkStatus>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionClient::kOnNetworkStatusChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SessionClient_OnNetworkStatusChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::NetworkStatus>(
    in_network_status,
    &params->network_status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionClient::Name_);
  message.set_method_name("OnNetworkStatusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionClientProxy::OnNetworkServiceRestarted(
    bool in_from_crash) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::SessionClient::OnNetworkServiceRestarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("from_crash"), in_from_crash,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionClient::kOnNetworkServiceRestarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SessionClient_OnNetworkServiceRestarted_Params_Data> params(
          message);
  params.Allocate();

  params->from_crash = in_from_crash;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionClient::Name_);
  message.set_method_name("OnNetworkServiceRestarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionClientProxy::OnCaptivePortalStatusChanged(
    bool in_is_behind_captive_portal) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::SessionClient::OnCaptivePortalStatusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_behind_captive_portal"), in_is_behind_captive_portal,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionClient::kOnCaptivePortalStatusChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SessionClient_OnCaptivePortalStatusChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_behind_captive_portal = in_is_behind_captive_portal;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionClient::Name_);
  message.set_method_name("OnCaptivePortalStatusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionClientProxy::GetICloudKeychainPasskeyBridge(
    ::mojo::PendingReceiver<::owl::mojom::ICloudKeychainPasskeyBridge> in_bridge) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::SessionClient::GetICloudKeychainPasskeyBridge", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bridge"), in_bridge,
                        "<value of type ::mojo::PendingReceiver<::owl::mojom::ICloudKeychainPasskeyBridge>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionClient::kGetICloudKeychainPasskeyBridge), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SessionClient_GetICloudKeychainPasskeyBridge_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::owl::mojom::ICloudKeychainPasskeyBridgeInterfaceBase>>(
    in_bridge,
    &params->bridge,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->bridge)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid bridge in SessionClient.GetICloudKeychainPasskeyBridge request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionClient::Name_);
  message.set_method_name("GetICloudKeychainPasskeyBridge");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionClientProxy::OnNavigationThrottleImpactedNavigation(
    const std::string& in_throttle_name, const std::string& in_event_description, const std::string& in_modification_type, const std::optional<::GURL>& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::SessionClient::OnNavigationThrottleImpactedNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("throttle_name"), in_throttle_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_description"), in_event_description,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modification_type"), in_modification_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionClient::kOnNavigationThrottleImpactedNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SessionClient_OnNavigationThrottleImpactedNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->throttle_name)::BaseType> throttle_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_throttle_name,
    throttle_name_fragment);

  params->throttle_name.Set(
      throttle_name_fragment.is_null() ? nullptr : throttle_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->throttle_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null throttle_name in SessionClient.OnNavigationThrottleImpactedNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_description)::BaseType> event_description_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_description,
    event_description_fragment);

  params->event_description.Set(
      event_description_fragment.is_null() ? nullptr : event_description_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_description.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_description in SessionClient.OnNavigationThrottleImpactedNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->modification_type)::BaseType> modification_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_modification_type,
    modification_type_fragment);

  params->modification_type.Set(
      modification_type_fragment.is_null() ? nullptr : modification_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->modification_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null modification_type in SessionClient.OnNavigationThrottleImpactedNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionClient::Name_);
  message.set_method_name("OnNavigationThrottleImpactedNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SessionClientStubDispatch::Accept(
    SessionClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SessionClient>(message->header()->name)) {
    case messages::SessionClient::kOnNetworkStatusChanged: {
      DCHECK(message->is_serialized());
      internal::SessionClient_OnNetworkStatusChanged_Params_Data* params =
          reinterpret_cast<internal::SessionClient_OnNetworkStatusChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SessionClient.0
      bool success = true;
      NetworkStatus p_network_status{};
      SessionClient_OnNetworkStatusChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNetworkStatus(&p_network_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkStatusChanged(        
        std::move(p_network_status));
      return true;
    }
    case messages::SessionClient::kOnNetworkServiceRestarted: {
      DCHECK(message->is_serialized());
      internal::SessionClient_OnNetworkServiceRestarted_Params_Data* params =
          reinterpret_cast<internal::SessionClient_OnNetworkServiceRestarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SessionClient.1
      bool success = true;
      bool p_from_crash{};
      SessionClient_OnNetworkServiceRestarted_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_from_crash = input_data_view.from_crash();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkServiceRestarted(        
        std::move(p_from_crash));
      return true;
    }
    case messages::SessionClient::kOnCaptivePortalStatusChanged: {
      DCHECK(message->is_serialized());
      internal::SessionClient_OnCaptivePortalStatusChanged_Params_Data* params =
          reinterpret_cast<internal::SessionClient_OnCaptivePortalStatusChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SessionClient.2
      bool success = true;
      bool p_is_behind_captive_portal{};
      SessionClient_OnCaptivePortalStatusChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_behind_captive_portal = input_data_view.is_behind_captive_portal();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCaptivePortalStatusChanged(        
        std::move(p_is_behind_captive_portal));
      return true;
    }
    case messages::SessionClient::kGetICloudKeychainPasskeyBridge: {
      DCHECK(message->is_serialized());
      internal::SessionClient_GetICloudKeychainPasskeyBridge_Params_Data* params =
          reinterpret_cast<internal::SessionClient_GetICloudKeychainPasskeyBridge_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SessionClient.3
      bool success = true;
      ::mojo::PendingReceiver<::owl::mojom::ICloudKeychainPasskeyBridge> p_bridge{};
      SessionClient_GetICloudKeychainPasskeyBridge_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_bridge =
            input_data_view.TakeBridge<decltype(p_bridge)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetICloudKeychainPasskeyBridge(        
        std::move(p_bridge));
      return true;
    }
    case messages::SessionClient::kOnNavigationThrottleImpactedNavigation: {
      DCHECK(message->is_serialized());
      internal::SessionClient_OnNavigationThrottleImpactedNavigation_Params_Data* params =
          reinterpret_cast<internal::SessionClient_OnNavigationThrottleImpactedNavigation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SessionClient.4
      bool success = true;
      std::string p_throttle_name{};
      std::string p_event_description{};
      std::string p_modification_type{};
      std::optional<::GURL> p_url{};
      SessionClient_OnNavigationThrottleImpactedNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadThrottleName(&p_throttle_name))
        success = false;
      if (success && !input_data_view.ReadEventDescription(&p_event_description))
        success = false;
      if (success && !input_data_view.ReadModificationType(&p_modification_type))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNavigationThrottleImpactedNavigation(        
        std::move(p_throttle_name), 
        std::move(p_event_description), 
        std::move(p_modification_type), 
        std::move(p_url));
      return true;
    }
  }
  return false;
}

// static
bool SessionClientStubDispatch::AcceptWithResponder(
    SessionClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SessionClient>(message->header()->name)) {
    case messages::SessionClient::kOnNetworkStatusChanged: {
      break;
    }
    case messages::SessionClient::kOnNetworkServiceRestarted: {
      break;
    }
    case messages::SessionClient::kOnCaptivePortalStatusChanged: {
      break;
    }
    case messages::SessionClient::kGetICloudKeychainPasskeyBridge: {
      break;
    }
    case messages::SessionClient::kOnNavigationThrottleImpactedNavigation: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSessionClientValidationInfo[] = {
    { &internal::SessionClient_OnNetworkStatusChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SessionClient_OnNetworkServiceRestarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SessionClient_OnCaptivePortalStatusChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SessionClient_GetICloudKeychainPasskeyBridge_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SessionClient_OnNavigationThrottleImpactedNavigation_Params_Data::Validate,
     nullptr /* no response */},
};

bool SessionClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::SessionClient::Name_,
    kSessionClientValidationInfo);
}



}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::InternalURLPattern::DataView, ::owl::mojom::InternalURLPatternPtr>::Read(
    ::owl::mojom::InternalURLPattern::DataView input,
    ::owl::mojom::InternalURLPatternPtr* output) {
  bool success = true;
  ::owl::mojom::InternalURLPatternPtr result(::owl::mojom::InternalURLPattern::New());
  
      if (success && !input.ReadPrefix(&result->prefix))
        success = false;
      if (success && !input.ReadQuery(&result->query))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void WatchdogClientInterceptorForTesting::Ping(PingCallback callback) {
  GetForwardingInterface()->Ping(std::move(callback));
}
WatchdogClientAsyncWaiter::WatchdogClientAsyncWaiter(
    WatchdogClient* proxy) : proxy_(proxy) {}

WatchdogClientAsyncWaiter::~WatchdogClientAsyncWaiter() = default;


void WatchdogClientAsyncWaiter::Ping(
    ) {
  base::RunLoop loop;
  proxy_->Ping(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void SessionInterceptorForTesting::SetClient(::mojo::PendingAssociatedRemote<SessionClient> client) {
  GetForwardingInterface()->SetClient(
    std::move(client)
    );
}
void SessionInterceptorForTesting::ShowChrome(bool enabled) {
  GetForwardingInterface()->ShowChrome(
    std::move(enabled)
    );
}
void SessionInterceptorForTesting::OpenProfile(const ::base::FilePath& name, ::mojo::PendingReceiver<::owl::mojom::Profile> receiver) {
  GetForwardingInterface()->OpenProfile(
    std::move(name)
    , 
    std::move(receiver)
    );
}
void SessionInterceptorForTesting::OpenGuestProfile(::mojo::PendingReceiver<::owl::mojom::Profile> receiver) {
  GetForwardingInterface()->OpenGuestProfile(
    std::move(receiver)
    );
}
void SessionInterceptorForTesting::SetAllowedWebUIPrefixes(const std::optional<std::vector<::GURL>>& prefixes) {
  GetForwardingInterface()->SetAllowedWebUIPrefixes(
    std::move(prefixes)
    );
}
void SessionInterceptorForTesting::SetInternalURLs(std::optional<std::vector<InternalURLPatternPtr>> patterns) {
  GetForwardingInterface()->SetInternalURLs(
    std::move(patterns)
    );
}
void SessionInterceptorForTesting::CreateWebViewSessionDataDecoder(::mojo::PendingReceiver<::owl::mojom::WebViewSessionDataDecoder> receiver) {
  GetForwardingInterface()->CreateWebViewSessionDataDecoder(
    std::move(receiver)
    );
}
void SessionInterceptorForTesting::ConfigureFeatures(const base::flat_map<std::string, std::string>& feature_flags) {
  GetForwardingInterface()->ConfigureFeatures(
    std::move(feature_flags)
    );
}
void SessionInterceptorForTesting::Ping(PingCallback callback) {
  GetForwardingInterface()->Ping(std::move(callback));
}
void SessionInterceptorForTesting::StartWatchdog(::mojo::PendingRemote<WatchdogClient> client) {
  GetForwardingInterface()->StartWatchdog(
    std::move(client)
    );
}
SessionAsyncWaiter::SessionAsyncWaiter(
    Session* proxy) : proxy_(proxy) {}

SessionAsyncWaiter::~SessionAsyncWaiter() = default;


void SessionAsyncWaiter::Ping(
    ) {
  base::RunLoop loop;
  proxy_->Ping(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void SessionClientInterceptorForTesting::OnNetworkStatusChanged(NetworkStatus network_status) {
  GetForwardingInterface()->OnNetworkStatusChanged(
    std::move(network_status)
    );
}
void SessionClientInterceptorForTesting::OnNetworkServiceRestarted(bool from_crash) {
  GetForwardingInterface()->OnNetworkServiceRestarted(
    std::move(from_crash)
    );
}
void SessionClientInterceptorForTesting::OnCaptivePortalStatusChanged(bool is_behind_captive_portal) {
  GetForwardingInterface()->OnCaptivePortalStatusChanged(
    std::move(is_behind_captive_portal)
    );
}
void SessionClientInterceptorForTesting::GetICloudKeychainPasskeyBridge(::mojo::PendingReceiver<::owl::mojom::ICloudKeychainPasskeyBridge> bridge) {
  GetForwardingInterface()->GetICloudKeychainPasskeyBridge(
    std::move(bridge)
    );
}
void SessionClientInterceptorForTesting::OnNavigationThrottleImpactedNavigation(const std::string& throttle_name, const std::string& event_description, const std::string& modification_type, const std::optional<::GURL>& url) {
  GetForwardingInterface()->OnNavigationThrottleImpactedNavigation(
    std::move(throttle_name)
    , 
    std::move(event_description)
    , 
    std::move(modification_type)
    , 
    std::move(url)
    );
}
SessionClientAsyncWaiter::SessionClientAsyncWaiter(
    SessionClient* proxy) : proxy_(proxy) {}

SessionClientAsyncWaiter::~SessionClientAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif