// owl/mojom/session.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_SESSION_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_SESSION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "owl/mojom/session.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "owl/mojom/profile.mojom-shared.h"
#include "owl/mojom/web_view_session_data.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "owl/mojom/icloud_passkeys.mojom-shared.h"


namespace owl::mojom {
class InternalURLPatternDataView;



}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::InternalURLPatternDataView> {
  using Data = ::owl::mojom::internal::InternalURLPattern_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class NetworkStatus : int32_t {
  
  kConnected = 0,
  
  kOffline = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, NetworkStatus value);
inline bool IsKnownEnumValue(NetworkStatus value) {
  return internal::NetworkStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WatchdogClientInterfaceBase {};

using WatchdogClientPtrDataView =
    mojo::InterfacePtrDataView<WatchdogClientInterfaceBase>;
using WatchdogClientRequestDataView =
    mojo::InterfaceRequestDataView<WatchdogClientInterfaceBase>;
using WatchdogClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WatchdogClientInterfaceBase>;
using WatchdogClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WatchdogClientInterfaceBase>;
class SessionInterfaceBase {};

using SessionPtrDataView =
    mojo::InterfacePtrDataView<SessionInterfaceBase>;
using SessionRequestDataView =
    mojo::InterfaceRequestDataView<SessionInterfaceBase>;
using SessionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SessionInterfaceBase>;
using SessionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SessionInterfaceBase>;
class SessionClientInterfaceBase {};

using SessionClientPtrDataView =
    mojo::InterfacePtrDataView<SessionClientInterfaceBase>;
using SessionClientRequestDataView =
    mojo::InterfaceRequestDataView<SessionClientInterfaceBase>;
using SessionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SessionClientInterfaceBase>;
using SessionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SessionClientInterfaceBase>;


class InternalURLPatternDataView {
 public:
  InternalURLPatternDataView() = default;

  InternalURLPatternDataView(
      internal::InternalURLPattern_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrefixDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrefix(UserType* output) {
    
    auto* pointer = data_->prefix.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetQueryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuery(UserType* output) {
    
    auto* pointer = data_->query.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::InternalURLPattern_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // owl::mojom

#endif  // OWL_MOJOM_SESSION_MOJOM_DATA_VIEW_H_