// owl/mojom/profile.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_PROFILE_MOJOM_SHARED_H_
#define OWL_MOJOM_PROFILE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/profile.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "owl/mojom/autocomplete.mojom-shared.h"
#include "owl/mojom/autofill.mojom-shared.h"
#include "owl/mojom/autofill_deprecated.mojom-shared.h"
#include "owl/mojom/bookmark_model.mojom-shared.h"
#include "owl/mojom/download_manager.mojom-shared.h"
#include "owl/mojom/extension_service.mojom-shared.h"
#include "owl/mojom/metrics.mojom-shared.h"
#include "owl/mojom/notification_service.mojom-shared.h"
#include "owl/mojom/search_keyword.mojom-shared.h"
#include "owl/mojom/web_content.mojom-shared.h"
#include "owl/mojom/web_prefs.mojom-shared.h"
#include "owl/mojom/web_view.mojom-shared.h"
#include "owl/mojom/web_view_container_view.mojom-shared.h"
#include "owl/mojom/web_view_group.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/display/mojom/display.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/remote_cocoa/common/application.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/profile.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::ClearBrowsingDataType>
    : public mojo::internal::EnumHashImpl<::owl::mojom::ClearBrowsingDataType> {};

template <>
struct hash<::owl::mojom::BrowserColorScheme>
    : public mojo::internal::EnumHashImpl<::owl::mojom::BrowserColorScheme> {};

template <>
struct hash<::owl::mojom::SetCookieResult>
    : public mojo::internal::EnumHashImpl<::owl::mojom::SetCookieResult> {};

template <>
struct hash<::owl::mojom::DeleteCookieResult>
    : public mojo::internal::EnumHashImpl<::owl::mojom::DeleteCookieResult> {};

template <>
struct hash<::owl::mojom::CookieSameSite>
    : public mojo::internal::EnumHashImpl<::owl::mojom::CookieSameSite> {};

template <>
struct hash<::owl::mojom::CookiePriority>
    : public mojo::internal::EnumHashImpl<::owl::mojom::CookiePriority> {};

template <>
struct hash<::owl::mojom::CookieSourceScheme>
    : public mojo::internal::EnumHashImpl<::owl::mojom::CookieSourceScheme> {};

template <>
struct hash<::owl::mojom::CookieSourceType>
    : public mojo::internal::EnumHashImpl<::owl::mojom::CookieSourceType> {};

template <>
struct hash<::owl::mojom::IsolatedWebViewSource>
    : public mojo::internal::EnumHashImpl<::owl::mojom::IsolatedWebViewSource> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::ClearBrowsingDataType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::ClearBrowsingDataType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::ClearBrowsingDataType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::BrowserColorScheme, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::BrowserColorScheme, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::BrowserColorScheme>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::SetCookieResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::SetCookieResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::SetCookieResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::DeleteCookieResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::DeleteCookieResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::DeleteCookieResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CookieSameSite, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::CookieSameSite, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::CookieSameSite>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CookiePriority, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::CookiePriority, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::CookiePriority>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CookieSourceScheme, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::CookieSourceScheme, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::CookieSourceScheme>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CookieSourceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::CookieSourceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::CookieSourceType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::IsolatedWebViewSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::IsolatedWebViewSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::IsolatedWebViewSource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::TypedUrlDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::TypedUrlDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::TypedUrl_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->unique_id = Traits::unique_id(input);

    decltype(Traits::url_as_string(input)) in_url_as_string = Traits::url_as_string(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url_as_string)::BaseType> url_as_string_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_url_as_string,
      url_as_string_fragment);

    fragment->url_as_string.Set(
        url_as_string_fragment.is_null() ? nullptr : url_as_string_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url_as_string.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_as_string in TypedUrl struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in TypedUrl struct");

    fragment->visit_count = Traits::visit_count(input);

    fragment->typed_count = Traits::typed_count(input);

    decltype(Traits::last_visit_time(input)) in_last_visit_time = Traits::last_visit_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_visit_time)::BaseType> last_visit_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_visit_time,
      last_visit_time_fragment);

    fragment->last_visit_time.Set(
        last_visit_time_fragment.is_null() ? nullptr : last_visit_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_visit_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_visit_time in TypedUrl struct");
  }

  static bool Deserialize(::owl::mojom::internal::TypedUrl_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::TypedUrlDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::QueryHistoryItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::QueryHistoryItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::QueryHistoryItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in QueryHistoryItem struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in QueryHistoryItem struct");

    decltype(Traits::visit_time(input)) in_visit_time = Traits::visit_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visit_time)::BaseType> visit_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_visit_time,
      visit_time_fragment);

    fragment->visit_time.Set(
        visit_time_fragment.is_null() ? nullptr : visit_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visit_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visit_time in QueryHistoryItem struct");
  }

  static bool Deserialize(::owl::mojom::internal::QueryHistoryItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::QueryHistoryItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::QueryHistoryResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::QueryHistoryResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::QueryHistoryResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::items(input)) in_items = Traits::items(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->items)::BaseType>
        items_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::QueryHistoryItemDataView>>(
      in_items,
      items_fragment,
      &items_validate_params);

    fragment->items.Set(
        items_fragment.is_null() ? nullptr : items_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->items.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null items in QueryHistoryResponse struct");
  }

  static bool Deserialize(::owl::mojom::internal::QueryHistoryResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::QueryHistoryResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::QueryHistoryOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::QueryHistoryOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::QueryHistoryOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->limit = Traits::limit(input);

    decltype(Traits::start(input)) in_start = Traits::start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start)::BaseType> start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_start,
      start_fragment);

    fragment->start.Set(
        start_fragment.is_null() ? nullptr : start_fragment.data());

    decltype(Traits::end(input)) in_end = Traits::end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->end)::BaseType> end_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_end,
      end_fragment);

    fragment->end.Set(
        end_fragment.is_null() ? nullptr : end_fragment.data());
  }

  static bool Deserialize(::owl::mojom::internal::QueryHistoryOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::QueryHistoryOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CookieDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CookieDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CookieData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in CookieData struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in CookieData struct");

    decltype(Traits::encrypted_value(input)) in_encrypted_value = Traits::encrypted_value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->encrypted_value)::BaseType>
        encrypted_value_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& encrypted_value_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_encrypted_value,
      encrypted_value_fragment,
      &encrypted_value_validate_params);

    fragment->encrypted_value.Set(
        encrypted_value_fragment.is_null() ? nullptr : encrypted_value_fragment.data());

    decltype(Traits::domain(input)) in_domain = Traits::domain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->domain)::BaseType> domain_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_domain,
      domain_fragment);

    fragment->domain.Set(
        domain_fragment.is_null() ? nullptr : domain_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->domain.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null domain in CookieData struct");

    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_path,
      path_fragment);

    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in CookieData struct");

    fragment->http_only = Traits::http_only(input);

    fragment->secure = Traits::secure(input);

    
    mojo::internal::Serialize<::owl::mojom::CookieSameSite>(
      Traits::same_site(input),
      &fragment->same_site);

    decltype(Traits::expiration_time(input)) in_expiration_time = Traits::expiration_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expiration_time)::BaseType> expiration_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_expiration_time,
      expiration_time_fragment);

    fragment->expiration_time.Set(
        expiration_time_fragment.is_null() ? nullptr : expiration_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->expiration_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expiration_time in CookieData struct");

    decltype(Traits::creation_time(input)) in_creation_time = Traits::creation_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creation_time)::BaseType> creation_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_creation_time,
      creation_time_fragment);

    fragment->creation_time.Set(
        creation_time_fragment.is_null() ? nullptr : creation_time_fragment.data());

    decltype(Traits::last_access_time(input)) in_last_access_time = Traits::last_access_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_access_time)::BaseType> last_access_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_access_time,
      last_access_time_fragment);

    fragment->last_access_time.Set(
        last_access_time_fragment.is_null() ? nullptr : last_access_time_fragment.data());

    decltype(Traits::last_update_time(input)) in_last_update_time = Traits::last_update_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_update_time)::BaseType> last_update_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_update_time,
      last_update_time_fragment);

    fragment->last_update_time.Set(
        last_update_time_fragment.is_null() ? nullptr : last_update_time_fragment.data());
    fragment->priority_$flag = Traits::priority(input).has_value();
    if (Traits::priority(input).has_value()) {
      
      mojo::internal::Serialize<::owl::mojom::CookiePriority>(
        Traits::priority(input).value(),
        &fragment->priority_$value);
    } else {
      fragment->priority_$value =
          static_cast<int32_t>(::owl::mojom::CookiePriority::kMinValue);
    }
    fragment->source_scheme_$flag = Traits::source_scheme(input).has_value();
    if (Traits::source_scheme(input).has_value()) {
      
      mojo::internal::Serialize<::owl::mojom::CookieSourceScheme>(
        Traits::source_scheme(input).value(),
        &fragment->source_scheme_$value);
    } else {
      fragment->source_scheme_$value =
          static_cast<int32_t>(::owl::mojom::CookieSourceScheme::kMinValue);
    }
    fragment->source_port_$flag = Traits::source_port(input).has_value();
    if (Traits::source_port(input).has_value()) {
      fragment->source_port_$value = Traits::source_port(input).value();
    }
    fragment->source_type_$flag = Traits::source_type(input).has_value();
    if (Traits::source_type(input).has_value()) {
      
      mojo::internal::Serialize<::owl::mojom::CookieSourceType>(
        Traits::source_type(input).value(),
        &fragment->source_type_$value);
    } else {
      fragment->source_type_$value =
          static_cast<int32_t>(::owl::mojom::CookieSourceType::kMinValue);
    }
  }

  static bool Deserialize(::owl::mojom::internal::CookieData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::CookieDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::HistoryVisitDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::HistoryVisitDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::HistoryVisit_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in HistoryVisit struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in HistoryVisit struct");

    decltype(Traits::time(input)) in_time = Traits::time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->time)::BaseType> time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_time,
      time_fragment);

    fragment->time.Set(
        time_fragment.is_null() ? nullptr : time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time in HistoryVisit struct");
    fragment->referring_visit_id_$flag = Traits::referring_visit_id(input).has_value();
    if (Traits::referring_visit_id(input).has_value()) {
      fragment->referring_visit_id_$value = Traits::referring_visit_id(input).value();
    }

    decltype(Traits::external_referrer_url(input)) in_external_referrer_url = Traits::external_referrer_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->external_referrer_url)::BaseType> external_referrer_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_external_referrer_url,
      external_referrer_url_fragment);

    fragment->external_referrer_url.Set(
        external_referrer_url_fragment.is_null() ? nullptr : external_referrer_url_fragment.data());
    fragment->hidden_$flag = Traits::hidden(input).has_value();
    if (Traits::hidden(input).has_value()) {
      fragment->hidden_$value = Traits::hidden(input).value();
    }
    fragment->transition_$flag = Traits::transition(input).has_value();
    if (Traits::transition(input).has_value()) {
      fragment->transition_$value = Traits::transition(input).value();
    }
    fragment->should_increment_typed_count_$flag = Traits::should_increment_typed_count(input).has_value();
    if (Traits::should_increment_typed_count(input).has_value()) {
      fragment->should_increment_typed_count_$value = Traits::should_increment_typed_count(input).value();
    }
    fragment->opener_visit_id_$flag = Traits::opener_visit_id(input).has_value();
    if (Traits::opener_visit_id(input).has_value()) {
      fragment->opener_visit_id_$value = Traits::opener_visit_id(input).value();
    }
    fragment->consider_for_ntp_most_visited_$flag = Traits::consider_for_ntp_most_visited(input).has_value();
    if (Traits::consider_for_ntp_most_visited(input).has_value()) {
      fragment->consider_for_ntp_most_visited_$value = Traits::consider_for_ntp_most_visited(input).value();
    }
    fragment->visit_duration_$flag = Traits::visit_duration(input).has_value();
    if (Traits::visit_duration(input).has_value()) {
      fragment->visit_duration_$value = Traits::visit_duration(input).value();
    }
    fragment->redirect_source_visit_id_$flag = Traits::redirect_source_visit_id(input).has_value();
    if (Traits::redirect_source_visit_id(input).has_value()) {
      fragment->redirect_source_visit_id_$value = Traits::redirect_source_visit_id(input).value();
    }
    fragment->redirect_destination_visit_id_$flag = Traits::redirect_destination_visit_id(input).has_value();
    if (Traits::redirect_destination_visit_id(input).has_value()) {
      fragment->redirect_destination_visit_id_$value = Traits::redirect_destination_visit_id(input).value();
    }
  }

  static bool Deserialize(::owl::mojom::internal::HistoryVisit_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::HistoryVisitDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CreateBookmarkModelResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CreateBookmarkModelResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CreateBookmarkModelResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::model(input)) in_model = Traits::model(input);

    
    mojo::internal::Serialize<::owl::mojom::BookmarkModelAssociatedPtrInfoDataView>(
      in_model,
      &fragment->model,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->model)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid model in CreateBookmarkModelResult struct");

    decltype(Traits::client(input)) in_client = Traits::client(input);

    
    mojo::internal::Serialize<::owl::mojom::BookmarkModelClientAssociatedRequestDataView>(
      in_client,
      &fragment->client,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->client)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in CreateBookmarkModelResult struct");
  }

  static bool Deserialize(::owl::mojom::internal::CreateBookmarkModelResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::CreateBookmarkModelResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void TypedUrlDataView::GetUrlAsStringDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url_as_string.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TypedUrlDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void TypedUrlDataView::GetLastVisitTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_visit_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void QueryHistoryItemDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void QueryHistoryItemDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void QueryHistoryItemDataView::GetVisitTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->visit_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void QueryHistoryResponseDataView::GetItemsDataView(
    mojo::ArrayDataView<QueryHistoryItemDataView>* output) {
  auto pointer = data_->items.Get();
  *output = mojo::ArrayDataView<QueryHistoryItemDataView>(pointer, message_);
}


inline void QueryHistoryOptionsDataView::GetStartDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->start.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void QueryHistoryOptionsDataView::GetEndDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->end.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void CookieDataDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CookieDataDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CookieDataDataView::GetEncryptedValueDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->encrypted_value.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void CookieDataDataView::GetDomainDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->domain.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CookieDataDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CookieDataDataView::GetExpirationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expiration_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void CookieDataDataView::GetCreationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->creation_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void CookieDataDataView::GetLastAccessTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_access_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void CookieDataDataView::GetLastUpdateTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_update_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void HistoryVisitDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryVisitDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HistoryVisitDataView::GetTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void HistoryVisitDataView::GetExternalReferrerUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->external_referrer_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}





}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::ClearBrowsingDataType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::ClearBrowsingDataType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::BrowserColorScheme> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::BrowserColorScheme value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::SetCookieResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::SetCookieResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::DeleteCookieResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::DeleteCookieResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::CookieSameSite> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::CookieSameSite value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::CookiePriority> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::CookiePriority value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::CookieSourceScheme> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::CookieSourceScheme value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::CookieSourceType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::CookieSourceType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::IsolatedWebViewSource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::IsolatedWebViewSource value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_PROFILE_MOJOM_SHARED_H_