// owl/mojom/download_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_H_
#define OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/download_manager.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/download_manager.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/download_manager.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class DownloadManagerProxy;

template <typename ImplRefTraits>
class DownloadManagerStub;

class DownloadManagerRequestValidator;
class DownloadManagerResponseValidator;


class DownloadManager
    : public DownloadManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.DownloadManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DownloadManagerInterfaceBase;
  using Proxy_ = DownloadManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = DownloadManagerStub<ImplRefTraits>;

  using RequestValidator_ = DownloadManagerRequestValidator;
  using ResponseValidator_ = DownloadManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAllDownloadsMinVersion = 0,
    kCancelDownloadMinVersion = 0,
    kOpenDownloadMinVersion = 0,
    kRemoveDownloadMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetAllDownloads_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelDownload_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenDownload_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveDownload_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DownloadManager() = default;

  using GetAllDownloadsCallback = base::OnceCallback<void(std::vector<DownloadItemPtr>)>;
  using GetAllDownloadsMojoCallback = base::OnceCallback<void(std::vector<DownloadItemPtr>)>;

  virtual void GetAllDownloads(GetAllDownloadsCallback callback) = 0;

  virtual void CancelDownload(const std::string& guid) = 0;

  virtual void OpenDownload(const std::string& guid) = 0;

  virtual void RemoveDownload(const std::string& guid) = 0;
};

class DownloadManagerClientProxy;

template <typename ImplRefTraits>
class DownloadManagerClientStub;

class DownloadManagerClientRequestValidator;


class DownloadManagerClient
    : public DownloadManagerClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.DownloadManagerClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DownloadManagerClientInterfaceBase;
  using Proxy_ = DownloadManagerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = DownloadManagerClientStub<ImplRefTraits>;

  using RequestValidator_ = DownloadManagerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDownloadCreatedMinVersion = 0,
    kOnDownloadUpdatedMinVersion = 0,
    kOnDownloadOpenedMinVersion = 0,
    kOnDownloadRemovedMinVersion = 0,
    kOnDownloadDestroyedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDownloadCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDownloadUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDownloadOpened_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDownloadRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDownloadDestroyed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DownloadManagerClient() = default;

  virtual void OnDownloadCreated(DownloadItemPtr item) = 0;

  virtual void OnDownloadUpdated(DownloadItemPtr item) = 0;

  virtual void OnDownloadOpened(DownloadItemPtr item) = 0;

  virtual void OnDownloadRemoved(DownloadItemPtr item) = 0;

  virtual void OnDownloadDestroyed(DownloadItemPtr item) = 0;
};



class  DownloadManagerProxy
    : public DownloadManager {
 public:
  using InterfaceType = DownloadManager;

  explicit DownloadManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAllDownloads(GetAllDownloadsCallback callback) final;
  
  void CancelDownload(const std::string& guid) final;
  
  void OpenDownload(const std::string& guid) final;
  
  void RemoveDownload(const std::string& guid) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DownloadManagerClientProxy
    : public DownloadManagerClient {
 public:
  using InterfaceType = DownloadManagerClient;

  explicit DownloadManagerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDownloadCreated(DownloadItemPtr item) final;
  
  void OnDownloadUpdated(DownloadItemPtr item) final;
  
  void OnDownloadOpened(DownloadItemPtr item) final;
  
  void OnDownloadRemoved(DownloadItemPtr item) final;
  
  void OnDownloadDestroyed(DownloadItemPtr item) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DownloadManagerStubDispatch {
 public:
  static bool Accept(DownloadManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DownloadManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DownloadManager>>
class DownloadManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DownloadManagerStub() = default;
  ~DownloadManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DownloadManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DownloadManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DownloadManagerClientStubDispatch {
 public:
  static bool Accept(DownloadManagerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DownloadManagerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DownloadManagerClient>>
class DownloadManagerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DownloadManagerClientStub() = default;
  ~DownloadManagerClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DownloadManagerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DownloadManagerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DownloadManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DownloadManagerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DownloadManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  DownloadItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DownloadItem, T>::value>;
  using DataView = DownloadItemDataView;
  using Data_ = internal::DownloadItem_Data;

  template <typename... Args>
  static DownloadItemPtr New(Args&&... args) {
    return DownloadItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DownloadItemPtr From(const U& u) {
    return mojo::TypeConverter<DownloadItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DownloadItem>::Convert(*this);
  }


  DownloadItem();

  DownloadItem(
      const std::string& guid,
      DownloadState state,
      const ::base::FilePath& target_file_path,
      int32_t percent_complete,
      int64_t total_bytes,
      int64_t received_bytes,
      int64_t current_speed,
      std::optional<::base::TimeDelta> time_remaining,
      ::base::Time end_time);


  ~DownloadItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DownloadItemPtr>
  DownloadItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DownloadItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DownloadItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DownloadItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DownloadItem::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DownloadItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DownloadItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DownloadItem_UnserializedMessageContext<
            UserType, DownloadItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DownloadItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DownloadItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DownloadItem_UnserializedMessageContext<
            UserType, DownloadItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DownloadItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string guid;
  
  DownloadState state;
  
  ::base::FilePath target_file_path;
  
  int32_t percent_complete;
  
  int64_t total_bytes;
  
  int64_t received_bytes;
  
  int64_t current_speed;
  
  std::optional<::base::TimeDelta> time_remaining;
  
  ::base::Time end_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DownloadItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DownloadItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DownloadItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DownloadItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DownloadItemPtr DownloadItem::Clone() const {
  return New(
      mojo::Clone(guid),
      mojo::Clone(state),
      mojo::Clone(target_file_path),
      mojo::Clone(percent_complete),
      mojo::Clone(total_bytes),
      mojo::Clone(received_bytes),
      mojo::Clone(current_speed),
      mojo::Clone(time_remaining),
      mojo::Clone(end_time)
  );
}

template <typename T, DownloadItem::EnableIfSame<T>*>
bool DownloadItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->guid, other_struct.guid))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->target_file_path, other_struct.target_file_path))
    return false;
  if (!mojo::Equals(this->percent_complete, other_struct.percent_complete))
    return false;
  if (!mojo::Equals(this->total_bytes, other_struct.total_bytes))
    return false;
  if (!mojo::Equals(this->received_bytes, other_struct.received_bytes))
    return false;
  if (!mojo::Equals(this->current_speed, other_struct.current_speed))
    return false;
  if (!mojo::Equals(this->time_remaining, other_struct.time_remaining))
    return false;
  if (!mojo::Equals(this->end_time, other_struct.end_time))
    return false;
  return true;
}

template <typename T, DownloadItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.guid < rhs.guid)
    return true;
  if (rhs.guid < lhs.guid)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.target_file_path < rhs.target_file_path)
    return true;
  if (rhs.target_file_path < lhs.target_file_path)
    return false;
  if (lhs.percent_complete < rhs.percent_complete)
    return true;
  if (rhs.percent_complete < lhs.percent_complete)
    return false;
  if (lhs.total_bytes < rhs.total_bytes)
    return true;
  if (rhs.total_bytes < lhs.total_bytes)
    return false;
  if (lhs.received_bytes < rhs.received_bytes)
    return true;
  if (rhs.received_bytes < lhs.received_bytes)
    return false;
  if (lhs.current_speed < rhs.current_speed)
    return true;
  if (rhs.current_speed < lhs.current_speed)
    return false;
  if (lhs.time_remaining < rhs.time_remaining)
    return true;
  if (rhs.time_remaining < lhs.time_remaining)
    return false;
  if (lhs.end_time < rhs.end_time)
    return true;
  if (rhs.end_time < lhs.end_time)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::DownloadItem::DataView,
                                         ::owl::mojom::DownloadItemPtr> {
  static bool IsNull(const ::owl::mojom::DownloadItemPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::DownloadItemPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::DownloadItem::guid)& guid(
      const ::owl::mojom::DownloadItemPtr& input) {
    return input->guid;
  }

  static decltype(::owl::mojom::DownloadItem::state) state(
      const ::owl::mojom::DownloadItemPtr& input) {
    return input->state;
  }

  static const decltype(::owl::mojom::DownloadItem::target_file_path)& target_file_path(
      const ::owl::mojom::DownloadItemPtr& input) {
    return input->target_file_path;
  }

  static decltype(::owl::mojom::DownloadItem::percent_complete) percent_complete(
      const ::owl::mojom::DownloadItemPtr& input) {
    return input->percent_complete;
  }

  static decltype(::owl::mojom::DownloadItem::total_bytes) total_bytes(
      const ::owl::mojom::DownloadItemPtr& input) {
    return input->total_bytes;
  }

  static decltype(::owl::mojom::DownloadItem::received_bytes) received_bytes(
      const ::owl::mojom::DownloadItemPtr& input) {
    return input->received_bytes;
  }

  static decltype(::owl::mojom::DownloadItem::current_speed) current_speed(
      const ::owl::mojom::DownloadItemPtr& input) {
    return input->current_speed;
  }

  static const decltype(::owl::mojom::DownloadItem::time_remaining)& time_remaining(
      const ::owl::mojom::DownloadItemPtr& input) {
    return input->time_remaining;
  }

  static const decltype(::owl::mojom::DownloadItem::end_time)& end_time(
      const ::owl::mojom::DownloadItemPtr& input) {
    return input->end_time;
  }

  static bool Read(::owl::mojom::DownloadItem::DataView input, ::owl::mojom::DownloadItemPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_DOWNLOAD_MANAGER_MOJOM_H_