// owl/mojom/download_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/download_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/download_manager.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* DownloadStateToStringHelper(DownloadState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DownloadState::kInProgress:
      return "kInProgress";
    case DownloadState::kComplete:
      return "kComplete";
    case DownloadState::kCancelled:
      return "kCancelled";
    case DownloadState::kInterrupted:
      return "kInterrupted";
    default:
      return nullptr;
  }
}

std::string DownloadStateToString(DownloadState value) {
  const char *str = DownloadStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DownloadState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DownloadState value) {
  return os << DownloadStateToString(value);
}

namespace internal {


// static
bool DownloadItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DownloadItem_Data* object =
      static_cast<const DownloadItem_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& guid_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->guid, validation_context,
                                         &guid_validate_params)) {
    return false;
  }


  if (!::owl::mojom::internal::DownloadState_Data
        ::Validate(object->state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_file_path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target_file_path, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->time_remaining, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->end_time, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->end_time, validation_context))
    return false;

  return true;
}

DownloadItem_Data::DownloadItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadManager_GetAllDownloads_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DownloadManager_GetAllDownloads_Params_Data* object =
      static_cast<const DownloadManager_GetAllDownloads_Params_Data*>(data);

  return true;
}

DownloadManager_GetAllDownloads_Params_Data::DownloadManager_GetAllDownloads_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadManager_GetAllDownloads_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DownloadManager_GetAllDownloads_ResponseParams_Data* object =
      static_cast<const DownloadManager_GetAllDownloads_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->items, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->items, validation_context,
                                         &items_validate_params)) {
    return false;
  }

  return true;
}

DownloadManager_GetAllDownloads_ResponseParams_Data::DownloadManager_GetAllDownloads_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadManager_CancelDownload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DownloadManager_CancelDownload_Params_Data* object =
      static_cast<const DownloadManager_CancelDownload_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& guid_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->guid, validation_context,
                                         &guid_validate_params)) {
    return false;
  }

  return true;
}

DownloadManager_CancelDownload_Params_Data::DownloadManager_CancelDownload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadManager_OpenDownload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DownloadManager_OpenDownload_Params_Data* object =
      static_cast<const DownloadManager_OpenDownload_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& guid_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->guid, validation_context,
                                         &guid_validate_params)) {
    return false;
  }

  return true;
}

DownloadManager_OpenDownload_Params_Data::DownloadManager_OpenDownload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadManager_RemoveDownload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DownloadManager_RemoveDownload_Params_Data* object =
      static_cast<const DownloadManager_RemoveDownload_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& guid_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->guid, validation_context,
                                         &guid_validate_params)) {
    return false;
  }

  return true;
}

DownloadManager_RemoveDownload_Params_Data::DownloadManager_RemoveDownload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadManagerClient_OnDownloadCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DownloadManagerClient_OnDownloadCreated_Params_Data* object =
      static_cast<const DownloadManagerClient_OnDownloadCreated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->item, validation_context))
    return false;

  return true;
}

DownloadManagerClient_OnDownloadCreated_Params_Data::DownloadManagerClient_OnDownloadCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadManagerClient_OnDownloadUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DownloadManagerClient_OnDownloadUpdated_Params_Data* object =
      static_cast<const DownloadManagerClient_OnDownloadUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->item, validation_context))
    return false;

  return true;
}

DownloadManagerClient_OnDownloadUpdated_Params_Data::DownloadManagerClient_OnDownloadUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadManagerClient_OnDownloadOpened_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DownloadManagerClient_OnDownloadOpened_Params_Data* object =
      static_cast<const DownloadManagerClient_OnDownloadOpened_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->item, validation_context))
    return false;

  return true;
}

DownloadManagerClient_OnDownloadOpened_Params_Data::DownloadManagerClient_OnDownloadOpened_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadManagerClient_OnDownloadRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DownloadManagerClient_OnDownloadRemoved_Params_Data* object =
      static_cast<const DownloadManagerClient_OnDownloadRemoved_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->item, validation_context))
    return false;

  return true;
}

DownloadManagerClient_OnDownloadRemoved_Params_Data::DownloadManagerClient_OnDownloadRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadManagerClient_OnDownloadDestroyed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DownloadManagerClient_OnDownloadDestroyed_Params_Data* object =
      static_cast<const DownloadManagerClient_OnDownloadDestroyed_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->item, validation_context))
    return false;

  return true;
}

DownloadManagerClient_OnDownloadDestroyed_Params_Data::DownloadManagerClient_OnDownloadDestroyed_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::DownloadState>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::DownloadState value) {
  return std::move(context).WriteString(::owl::mojom::DownloadStateToString(value));
}

} // namespace perfetto