// owl/mojom/bookmark_model.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_BOOKMARK_MODEL_MOJOM_SHARED_H_
#define OWL_MOJOM_BOOKMARK_MODEL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/bookmark_model.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/bookmark_model.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::BookmarkType>
    : public mojo::internal::EnumHashImpl<::owl::mojom::BookmarkType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::BookmarkType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::BookmarkType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::BookmarkType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::BookmarkNodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::BookmarkNodeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::BookmarkNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uuid)::BaseType> uuid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
      in_uuid,
      uuid_fragment);

    fragment->uuid.Set(
        uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->uuid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in BookmarkNode struct");

    
    mojo::internal::Serialize<::owl::mojom::BookmarkType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in BookmarkNode struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    decltype(Traits::children(input)) in_children = Traits::children(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->children)::BaseType>
        children_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::BookmarkNodeDataView>>(
      in_children,
      children_fragment,
      &children_validate_params);

    fragment->children.Set(
        children_fragment.is_null() ? nullptr : children_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->children.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null children in BookmarkNode struct");
  }

  static bool Deserialize(::owl::mojom::internal::BookmarkNode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::BookmarkNodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::BookmarksDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::BookmarksDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::Bookmarks_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bookmark_bar_node(input)) in_bookmark_bar_node = Traits::bookmark_bar_node(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bookmark_bar_node)::BaseType> bookmark_bar_node_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::owl::mojom::BookmarkNodeDataView>(
      in_bookmark_bar_node,
      bookmark_bar_node_fragment);

    fragment->bookmark_bar_node.Set(
        bookmark_bar_node_fragment.is_null() ? nullptr : bookmark_bar_node_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bookmark_bar_node.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bookmark_bar_node in Bookmarks struct");

    decltype(Traits::other_node(input)) in_other_node = Traits::other_node(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->other_node)::BaseType> other_node_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::owl::mojom::BookmarkNodeDataView>(
      in_other_node,
      other_node_fragment);

    fragment->other_node.Set(
        other_node_fragment.is_null() ? nullptr : other_node_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->other_node.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null other_node in Bookmarks struct");

    decltype(Traits::mobile_node(input)) in_mobile_node = Traits::mobile_node(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mobile_node)::BaseType> mobile_node_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::owl::mojom::BookmarkNodeDataView>(
      in_mobile_node,
      mobile_node_fragment);

    fragment->mobile_node.Set(
        mobile_node_fragment.is_null() ? nullptr : mobile_node_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mobile_node.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mobile_node in Bookmarks struct");
  }

  static bool Deserialize(::owl::mojom::internal::Bookmarks_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::BookmarksDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void BookmarkNodeDataView::GetUuidDataView(
    ::mojo_base::mojom::UuidDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = ::mojo_base::mojom::UuidDataView(pointer, message_);
}
inline void BookmarkNodeDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void BookmarkNodeDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BookmarkNodeDataView::GetChildrenDataView(
    mojo::ArrayDataView<BookmarkNodeDataView>* output) {
  auto pointer = data_->children.Get();
  *output = mojo::ArrayDataView<BookmarkNodeDataView>(pointer, message_);
}


inline void BookmarksDataView::GetBookmarkBarNodeDataView(
    BookmarkNodeDataView* output) {
  auto pointer = data_->bookmark_bar_node.Get();
  *output = BookmarkNodeDataView(pointer, message_);
}
inline void BookmarksDataView::GetOtherNodeDataView(
    BookmarkNodeDataView* output) {
  auto pointer = data_->other_node.Get();
  *output = BookmarkNodeDataView(pointer, message_);
}
inline void BookmarksDataView::GetMobileNodeDataView(
    BookmarkNodeDataView* output) {
  auto pointer = data_->mobile_node.Get();
  *output = BookmarkNodeDataView(pointer, message_);
}



}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::BookmarkType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::BookmarkType value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_BOOKMARK_MODEL_MOJOM_SHARED_H_