// owl/mojom/autofill_popup.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_AUTOFILL_POPUP_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_AUTOFILL_POPUP_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "owl/mojom/autofill_popup.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace owl::mojom {
class AutofillSuggestionTextDataView;

class AutofillSuggestionDataView;

class AutofillPopupDetailsDataView;

class AutofillSuggestionCustomIconDataView;


}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::AutofillSuggestionTextDataView> {
  using Data = ::owl::mojom::internal::AutofillSuggestionText_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::AutofillSuggestionDataView> {
  using Data = ::owl::mojom::internal::AutofillSuggestion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::AutofillPopupDetailsDataView> {
  using Data = ::owl::mojom::internal::AutofillPopupDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::AutofillSuggestionCustomIconDataView> {
  using Data = ::owl::mojom::internal::AutofillSuggestionCustomIcon_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class AutofillSuggestionIcon : int32_t {
  
  kUnknown = -1,
  
  kNoIcon = 0,
  
  kAccount = 1,
  
  kClear = 2,
  
  kCreate = 3,
  
  kCode = 4,
  
  kDelete = 5,
  
  kDevice = 6,
  
  kEdit = 7,
  
  kEmail = 8,
  
  kError = 9,
  
  kFlight = 10,
  
  kGlobe = 11,
  
  kGoogle = 12,
  
  kGoogleMonochrome = 13,
  
  kGooglePasswordManager = 14,
  
  kGooglePay = 15,
  
  kGoogleWallet = 16,
  
  kGoogleWalletMonochrome = 17,
  
  kHome = 18,
  
  kHttpWarning = 19,
  
  kHttpsInvalid = 20,
  
  kIdCard = 21,
  
  kKey = 22,
  
  kLocation = 23,
  
  kLoyalty = 24,
  
  kMagic = 25,
  
  kOfferTag = 26,
  
  kPenSpark = 27,
  
  kPlusAddress = 28,
  
  kQuestionMark = 29,
  
  kRecoveryPassword = 30,
  
  kScanCreditCard = 31,
  
  kSettings = 32,
  
  kSettingsAndroid = 33,
  
  kUndo = 34,
  
  kVehicle = 35,
  
  kWork = 36,
  
  kCardGeneric = 37,
  
  kCardAmericanExpress = 38,
  
  kCardDiners = 39,
  
  kCardDiscover = 40,
  
  kCardElo = 41,
  
  kCardJCB = 42,
  
  kCardMasterCard = 43,
  
  kCardMir = 44,
  
  kCardTroy = 45,
  
  kCardUnionPay = 46,
  
  kCardVerve = 47,
  
  kCardVisa = 48,
  
  kIban = 49,
  
  kBnpl = 50,
  
  kSaveAndFill = 51,
  
  kPersonCheck = 52,
  
  kAndroidMessages = 53,
  kMinValue = -1,
  kMaxValue = 53,
};

 std::ostream& operator<<(std::ostream& os, AutofillSuggestionIcon value);
inline bool IsKnownEnumValue(AutofillSuggestionIcon value) {
  return internal::AutofillSuggestionIcon_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AutofillSuggestionType : int32_t {
  
  kUnknown = -1,
  
  kAutocompleteEntry = 0,
  
  kICloudPromo = 2,
  
  kAddressEntry = 1,
  
  kAddressFieldByFieldFilling = 7,
  
  kAddressEntryOnTyping = 63,
  
  kManageAddress = 10,
  
  kManageAutofillAi = 64,
  
  kManageCreditCard = 11,
  
  kManageIban = 12,
  
  kManagePlusAddress = 13,
  
  kManageLoyaltyCard = 68,
  
  kComposeProactiveNudge = 14,
  
  kComposeResumeNudge = 15,
  
  kComposeSavedStateNotification = 16,
  
  kComposeDisable = 17,
  
  kComposeGoToSettings = 18,
  
  kComposeNeverShowOnThisSiteAgain = 19,
  
  kDatalistEntry = 20,
  
  kPasswordEntry = 21,
  
  kBackupPasswordEntry = 70,
  
  kTroubleSigningInEntry = 71,
  
  kAllSavedPasswordsEntry = 22,
  
  kGeneratePasswordEntry = 23,
  
  kAccountStoragePasswordEntry = 27,
  
  kPasswordFieldByFieldFilling = 30,
  
  kFillPassword = 31,
  
  kViewPasswordDetails = 32,
  
  kFreeformFooter = 72,
  
  kCreditCardEntry = 33,
  
  kInsecureContextPaymentDisabledMessage = 34,
  
  kScanCreditCard = 35,
  
  kVirtualCreditCardEntry = 36,
  
  kIbanEntry = 38,
  
  kBnplEntry = 61,
  
  kSaveAndFillCreditCardEntry = 62,
  
  kCreateNewPlusAddress = 39,
  
  kCreateNewPlusAddressInline = 52,
  
  kFillExistingPlusAddress = 40,
  
  kPlusAddressError = 57,
  
  kMerchantPromoCodeEntry = 41,
  
  kSeePromoCodeDetails = 42,
  
  kIdentityCredential = 66,
  
  kLoyaltyCardEntry = 67,
  
  kAllLoyaltyCardsEntry = 73,
  
  kWebauthnCredential = 43,
  
  kWebauthnSignInWithAnotherDevice = 44,
  
  kOneTimePasswordEntry = 74,
  
  kTitle = 45,
  
  kSeparator = 46,
  
  kUndoOrClear = 47,
  
  kMixedFormMessage = 48,
  
  kDevtoolsTestAddresses = 49,
  
  kDevtoolsTestAddressEntry = 50,
  
  kDevtoolsTestAddressByCountry = 51,
  
  kFillAutofillAi = 55,
  
  kPendingStateSignin = 65,
  kMinValue = -1,
  kMaxValue = 74,
};

 std::ostream& operator<<(std::ostream& os, AutofillSuggestionType value);
inline bool IsKnownEnumValue(AutofillSuggestionType value) {
  return internal::AutofillSuggestionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AutofillPopupInterfaceBase {};

using AutofillPopupPtrDataView =
    mojo::InterfacePtrDataView<AutofillPopupInterfaceBase>;
using AutofillPopupRequestDataView =
    mojo::InterfaceRequestDataView<AutofillPopupInterfaceBase>;
using AutofillPopupAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AutofillPopupInterfaceBase>;
using AutofillPopupAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AutofillPopupInterfaceBase>;
class AutofillPopupClientInterfaceBase {};

using AutofillPopupClientPtrDataView =
    mojo::InterfacePtrDataView<AutofillPopupClientInterfaceBase>;
using AutofillPopupClientRequestDataView =
    mojo::InterfaceRequestDataView<AutofillPopupClientInterfaceBase>;
using AutofillPopupClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AutofillPopupClientInterfaceBase>;
using AutofillPopupClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AutofillPopupClientInterfaceBase>;


class AutofillSuggestionTextDataView {
 public:
  AutofillSuggestionTextDataView() = default;

  AutofillSuggestionTextDataView(
      internal::AutofillSuggestionText_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool is_primary() const {
    return data_->is_primary;
  }
  bool should_truncate() const {
    return data_->should_truncate;
  }
 private:
  internal::AutofillSuggestionText_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AutofillSuggestionDataView {
 public:
  AutofillSuggestionDataView() = default;

  AutofillSuggestionDataView(
      internal::AutofillSuggestion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t type() const {
    return data_->type;
  }
  inline void GetMainTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainText(UserType* output) {
    
    auto* pointer = data_->main_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetMinorTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinorText(UserType* output) {
    
    auto* pointer = data_->minor_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTypeV1(UserType* output) const {
    auto data_value = data_->type_v1;
    return mojo::internal::Deserialize<::owl::mojom::AutofillSuggestionType>(
        data_value, output);
  }
  AutofillSuggestionType type_v1() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::AutofillSuggestionType>(data_->type_v1));
  }
  inline void GetMainTextV1DataView(
      AutofillSuggestionTextDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainTextV1(UserType* output) {
    
    auto* pointer = data_->main_text_v1.Get();
    return mojo::internal::Deserialize<::owl::mojom::AutofillSuggestionTextDataView>(
        pointer, output, message_);
  }
  inline void GetMinorTextsDataView(
      mojo::ArrayDataView<AutofillSuggestionTextDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinorTexts(UserType* output) {
    
    auto* pointer = data_->minor_texts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::owl::mojom::AutofillSuggestionTextDataView>>(
        pointer, output, message_);
  }
  inline void GetLabelsDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<AutofillSuggestionTextDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabels(UserType* output) {
    
    auto* pointer = data_->labels.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<::owl::mojom::AutofillSuggestionTextDataView>>>(
        pointer, output, message_);
  }
  inline void GetAdditionalLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdditionalLabel(UserType* output) {
    
    auto* pointer = data_->additional_label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool additional_label_alignment_right() const {
    return data_->additional_label_alignment_right;
  }
  inline void GetCustomIconDataView(
      AutofillSuggestionCustomIconDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCustomIcon(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::owl::mojom::AutofillSuggestionCustomIconDataView, UserType>(),
    "Attempting to read the optional `custom_icon` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCustomIcon` instead "
    "of `ReadCustomIcon if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->custom_icon.is_null() ? &data_->custom_icon : nullptr;
    return mojo::internal::Deserialize<::owl::mojom::AutofillSuggestionCustomIconDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) const {
    auto data_value = data_->icon;
    return mojo::internal::Deserialize<::owl::mojom::AutofillSuggestionIcon>(
        data_value, output);
  }
  AutofillSuggestionIcon icon() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::AutofillSuggestionIcon>(data_->icon));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTrailingIcon(UserType* output) const {
    auto data_value = data_->trailing_icon;
    return mojo::internal::Deserialize<::owl::mojom::AutofillSuggestionIcon>(
        data_value, output);
  }
  AutofillSuggestionIcon trailing_icon() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::AutofillSuggestionIcon>(data_->trailing_icon));
  }
  inline void GetIconImageDataView(
      ::gfx::mojom::ImageSkiaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::ImageSkiaDataView, UserType>(),
    "Attempting to read the optional `icon_image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIconImage` instead "
    "of `ReadIconImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->icon_image.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ImageSkiaDataView>(
        pointer, output, message_);
  }
 private:
  internal::AutofillSuggestion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AutofillPopupDetailsDataView {
 public:
  AutofillPopupDetailsDataView() = default;

  AutofillPopupDetailsDataView(
      internal::AutofillPopupDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double x() const {
    return data_->x;
  }
  double y() const {
    return data_->y;
  }
  double width() const {
    return data_->width;
  }
  double height() const {
    return data_->height;
  }
  inline void GetSuggestionsDataView(
      mojo::ArrayDataView<AutofillSuggestionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestions(UserType* output) {
    
    auto* pointer = data_->suggestions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::owl::mojom::AutofillSuggestionDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AutofillPopupDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AutofillSuggestionCustomIconDataView {
 public:
  using Tag = internal::AutofillSuggestionCustomIcon_Data::AutofillSuggestionCustomIcon_Tag;

  AutofillSuggestionCustomIconDataView() = default;

  AutofillSuggestionCustomIconDataView(
      internal::AutofillSuggestionCustomIcon_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_image() const { return data_->tag == Tag::kImage; }
  inline void GetImageDataView(
      ::gfx::mojom::ImageSkiaDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadImage(UserType* output) const {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::ImageSkiaDataView, UserType>(),
    "Attempting to read the optional `image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImage` instead "
    "of `ReadImage if you're fine with null values being "
    "silently ignored in this case.");
    CHECK(is_image());
    return mojo::internal::Deserialize<::gfx::mojom::ImageSkiaDataView>(
        data_->data.f_image.Get(), output, message_);
  }
  bool is_url() const { return data_->tag == Tag::kUrl; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) const {
    
    CHECK(is_url());
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        data_->data.f_url.Get(), output, message_);
  }
  bool is_monogram() const { return data_->tag == Tag::kMonogram; }
  inline void GetMonogramDataView(
      ::mojo_base::mojom::String16DataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadMonogram(UserType* output) const {
    
    CHECK(is_monogram());
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        data_->data.f_monogram.Get(), output, message_);
  }

 private:
  internal::AutofillSuggestionCustomIcon_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // owl::mojom

#endif  // OWL_MOJOM_AUTOFILL_POPUP_MOJOM_DATA_VIEW_H_