// owl/mojom/autocomplete.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_AUTOCOMPLETE_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_AUTOCOMPLETE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "owl/mojom/autocomplete.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace owl::mojom {
class AutocompleteMatchDataView;

class AutocompleteResultsDataView;



}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::AutocompleteMatchDataView> {
  using Data = ::owl::mojom::internal::AutocompleteMatch_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::AutocompleteResultsDataView> {
  using Data = ::owl::mojom::internal::AutocompleteResults_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class AutocompleteConfiguration : int32_t {
  
  kMinimal = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, AutocompleteConfiguration value);
inline bool IsKnownEnumValue(AutocompleteConfiguration value) {
  return internal::AutocompleteConfiguration_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AutocompleteMatchType : int32_t {
  
  kUrlThatYouTyped = 0,
  
  kHistory = 1,
  
  kBookmarkTitle = 2,
  
  kOpenTab = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, AutocompleteMatchType value);
inline bool IsKnownEnumValue(AutocompleteMatchType value) {
  return internal::AutocompleteMatchType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AutocompleteControllerInterfaceBase {};

using AutocompleteControllerPtrDataView =
    mojo::InterfacePtrDataView<AutocompleteControllerInterfaceBase>;
using AutocompleteControllerRequestDataView =
    mojo::InterfaceRequestDataView<AutocompleteControllerInterfaceBase>;
using AutocompleteControllerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AutocompleteControllerInterfaceBase>;
using AutocompleteControllerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AutocompleteControllerInterfaceBase>;
class AutocompleteClientInterfaceBase {};

using AutocompleteClientPtrDataView =
    mojo::InterfacePtrDataView<AutocompleteClientInterfaceBase>;
using AutocompleteClientRequestDataView =
    mojo::InterfaceRequestDataView<AutocompleteClientInterfaceBase>;
using AutocompleteClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AutocompleteClientInterfaceBase>;
using AutocompleteClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AutocompleteClientInterfaceBase>;


class AutocompleteMatchDataView {
 public:
  AutocompleteMatchDataView() = default;

  AutocompleteMatchDataView(
      internal::AutocompleteMatch_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::owl::mojom::AutocompleteMatchType>(
        data_value, output);
  }
  AutocompleteMatchType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::AutocompleteMatchType>(data_->type));
  }
  inline void GetFillIntoEditDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFillIntoEdit(UserType* output) {
    
    auto* pointer = data_->fill_into_edit.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetInlineAutocompletionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInlineAutocompletion(UserType* output) {
    
    auto* pointer = data_->inline_autocompletion.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  double score() const {
    return data_->score;
  }
  inline void GetTargetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetUrl(UserType* output) {
    
    auto* pointer = data_->target_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::AutocompleteMatch_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AutocompleteResultsDataView {
 public:
  AutocompleteResultsDataView() = default;

  AutocompleteResultsDataView(
      internal::AutocompleteResults_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMatchesDataView(
      mojo::ArrayDataView<AutocompleteMatchDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatches(UserType* output) {
    
    auto* pointer = data_->matches.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::owl::mojom::AutocompleteMatchDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AutocompleteResults_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // owl::mojom

#endif  // OWL_MOJOM_AUTOCOMPLETE_MOJOM_DATA_VIEW_H_