// owl/mojom/address_prompt.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_ADDRESS_PROMPT_MOJOM_H_
#define OWL_MOJOM_ADDRESS_PROMPT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/address_prompt.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/address_prompt.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/address_prompt.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class SaveAddressPromptProxy;

template <typename ImplRefTraits>
class SaveAddressPromptStub;

class SaveAddressPromptRequestValidator;


class SaveAddressPrompt
    : public SaveAddressPromptInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.SaveAddressPrompt";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SaveAddressPromptInterfaceBase;
  using Proxy_ = SaveAddressPromptProxy;

  template <typename ImplRefTraits>
  using Stub_ = SaveAddressPromptStub<ImplRefTraits>;

  using RequestValidator_ = SaveAddressPromptRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SaveAddressPrompt() = default;

  virtual void Close() = 0;
};

class SaveAddressPromptClientProxy;

template <typename ImplRefTraits>
class SaveAddressPromptClientStub;

class SaveAddressPromptClientRequestValidator;


class SaveAddressPromptClient
    : public SaveAddressPromptClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.SaveAddressPromptClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SaveAddressPromptClientInterfaceBase;
  using Proxy_ = SaveAddressPromptClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SaveAddressPromptClientStub<ImplRefTraits>;

  using RequestValidator_ = SaveAddressPromptClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAcceptMinVersion = 0,
    kDeclineMinVersion = 0,
    kNeverMinVersion = 0,
    kDismissMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Accept_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Decline_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Never_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Dismiss_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SaveAddressPromptClient() = default;

  virtual void Accept() = 0;

  virtual void Decline() = 0;

  virtual void Never() = 0;

  virtual void Dismiss() = 0;
};



class  SaveAddressPromptProxy
    : public SaveAddressPrompt {
 public:
  using InterfaceType = SaveAddressPrompt;

  explicit SaveAddressPromptProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Close() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SaveAddressPromptClientProxy
    : public SaveAddressPromptClient {
 public:
  using InterfaceType = SaveAddressPromptClient;

  explicit SaveAddressPromptClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Accept() final;
  
  void Decline() final;
  
  void Never() final;
  
  void Dismiss() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SaveAddressPromptStubDispatch {
 public:
  static bool Accept(SaveAddressPrompt* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SaveAddressPrompt* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SaveAddressPrompt>>
class SaveAddressPromptStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SaveAddressPromptStub() = default;
  ~SaveAddressPromptStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SaveAddressPromptStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SaveAddressPromptStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SaveAddressPromptClientStubDispatch {
 public:
  static bool Accept(SaveAddressPromptClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SaveAddressPromptClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SaveAddressPromptClient>>
class SaveAddressPromptClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SaveAddressPromptClientStub() = default;
  ~SaveAddressPromptClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SaveAddressPromptClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SaveAddressPromptClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SaveAddressPromptRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SaveAddressPromptClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  SaveAddressPromptDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SaveAddressPromptDetails, T>::value>;
  using DataView = SaveAddressPromptDetailsDataView;
  using Data_ = internal::SaveAddressPromptDetails_Data;

  template <typename... Args>
  static SaveAddressPromptDetailsPtr New(Args&&... args) {
    return SaveAddressPromptDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SaveAddressPromptDetailsPtr From(const U& u) {
    return mojo::TypeConverter<SaveAddressPromptDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SaveAddressPromptDetails>::Convert(*this);
  }


  SaveAddressPromptDetails();

  SaveAddressPromptDetails(
      SaveAddressPromptType type,
      const ::std::u16string& full_name,
      const ::std::u16string& single_line_address);


  ~SaveAddressPromptDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SaveAddressPromptDetailsPtr>
  SaveAddressPromptDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SaveAddressPromptDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SaveAddressPromptDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SaveAddressPromptDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SaveAddressPromptDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SaveAddressPromptDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SaveAddressPromptDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SaveAddressPromptDetails_UnserializedMessageContext<
            UserType, SaveAddressPromptDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SaveAddressPromptDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SaveAddressPromptDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SaveAddressPromptDetails_UnserializedMessageContext<
            UserType, SaveAddressPromptDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SaveAddressPromptDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SaveAddressPromptType type;
  
  ::std::u16string full_name;
  
  ::std::u16string single_line_address;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SaveAddressPromptDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SaveAddressPromptDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SaveAddressPromptDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SaveAddressPromptDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SaveAddressPromptDetailsPtr SaveAddressPromptDetails::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(full_name),
      mojo::Clone(single_line_address)
  );
}

template <typename T, SaveAddressPromptDetails::EnableIfSame<T>*>
bool SaveAddressPromptDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->full_name, other_struct.full_name))
    return false;
  if (!mojo::Equals(this->single_line_address, other_struct.single_line_address))
    return false;
  return true;
}

template <typename T, SaveAddressPromptDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.full_name < rhs.full_name)
    return true;
  if (rhs.full_name < lhs.full_name)
    return false;
  if (lhs.single_line_address < rhs.single_line_address)
    return true;
  if (rhs.single_line_address < lhs.single_line_address)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::SaveAddressPromptDetails::DataView,
                                         ::owl::mojom::SaveAddressPromptDetailsPtr> {
  static bool IsNull(const ::owl::mojom::SaveAddressPromptDetailsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::SaveAddressPromptDetailsPtr* output) { output->reset(); }

  static decltype(::owl::mojom::SaveAddressPromptDetails::type) type(
      const ::owl::mojom::SaveAddressPromptDetailsPtr& input) {
    return input->type;
  }

  static const decltype(::owl::mojom::SaveAddressPromptDetails::full_name)& full_name(
      const ::owl::mojom::SaveAddressPromptDetailsPtr& input) {
    return input->full_name;
  }

  static const decltype(::owl::mojom::SaveAddressPromptDetails::single_line_address)& single_line_address(
      const ::owl::mojom::SaveAddressPromptDetailsPtr& input) {
    return input->single_line_address;
  }

  static bool Read(::owl::mojom::SaveAddressPromptDetails::DataView input, ::owl::mojom::SaveAddressPromptDetailsPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_ADDRESS_PROMPT_MOJOM_H_