// mojo/public/mojom/base/file_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_FILE_INFO_MOJOM_SHARED_H_
#define MOJO_PUBLIC_MOJOM_BASE_FILE_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/file_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"




#include "mojo/public/mojom/base/file_info.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo_base::mojom::FileInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo_base::mojom::FileInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo_base::mojom::internal::FileInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->size = Traits::size(input);

    fragment->is_directory = Traits::is_directory(input);

    fragment->is_symbolic_link = Traits::is_symbolic_link(input);

    decltype(Traits::last_modified(input)) in_last_modified = Traits::last_modified(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_modified)::BaseType> last_modified_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_modified,
      last_modified_fragment);

    fragment->last_modified.Set(
        last_modified_fragment.is_null() ? nullptr : last_modified_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_modified.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_modified in FileInfo struct");

    decltype(Traits::last_accessed(input)) in_last_accessed = Traits::last_accessed(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_accessed)::BaseType> last_accessed_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_accessed,
      last_accessed_fragment);

    fragment->last_accessed.Set(
        last_accessed_fragment.is_null() ? nullptr : last_accessed_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_accessed.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_accessed in FileInfo struct");

    decltype(Traits::creation_time(input)) in_creation_time = Traits::creation_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creation_time)::BaseType> creation_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_creation_time,
      creation_time_fragment);

    fragment->creation_time.Set(
        creation_time_fragment.is_null() ? nullptr : creation_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->creation_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null creation_time in FileInfo struct");
  }

  static bool Deserialize(::mojo_base::mojom::internal::FileInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo_base::mojom::FileInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojo_base::mojom {

inline void FileInfoDataView::GetLastModifiedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_modified.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void FileInfoDataView::GetLastAccessedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_accessed.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void FileInfoDataView::GetCreationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->creation_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}



}  // mojo_base::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MOJO_PUBLIC_MOJOM_BASE_FILE_INFO_MOJOM_SHARED_H_