// mojo/public/mojom/base/file_info.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_FILE_INFO_MOJOM_SEND_VALIDATION_H_
#define MOJO_PUBLIC_MOJOM_BASE_FILE_INFO_MOJOM_SEND_VALIDATION_H_

#include "mojo/public/mojom/base/file_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "mojo/public/mojom/base/file_info.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojo_base::mojom::FileInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo_base::mojom::FileInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo_base::mojom::internal::FileInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->size = Traits::size(input);

      fragment->is_directory = Traits::is_directory(input);

      fragment->is_symbolic_link = Traits::is_symbolic_link(input);

      decltype(Traits::last_modified(input)) in_last_modified = Traits::last_modified(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_modified)::BaseType> last_modified_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_modified,
        last_modified_fragment);

      fragment->last_modified.Set(
          last_modified_fragment.is_null() ? nullptr : last_modified_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_modified.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_modified in FileInfo struct");

      decltype(Traits::last_accessed(input)) in_last_accessed = Traits::last_accessed(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_accessed)::BaseType> last_accessed_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_accessed,
        last_accessed_fragment);

      fragment->last_accessed.Set(
          last_accessed_fragment.is_null() ? nullptr : last_accessed_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_accessed.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_accessed in FileInfo struct");

      decltype(Traits::creation_time(input)) in_creation_time = Traits::creation_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->creation_time)::BaseType> creation_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_creation_time,
        creation_time_fragment);

      fragment->creation_time.Set(
          creation_time_fragment.is_null() ? nullptr : creation_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->creation_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null creation_time in FileInfo struct");
  }
};

}  // namespace mojo::internal

#endif  // MOJO_PUBLIC_MOJOM_BASE_FILE_INFO_MOJOM_SEND_VALIDATION_H_