// mojo/public/mojom/base/big_buffer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "mojo/public/mojom/base/big_buffer.mojom-params-data.h"
namespace mojo_base {
namespace mojom {

namespace internal {
// static
bool BigBuffer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const BigBuffer_Data* object = static_cast<const BigBuffer_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case BigBuffer_Tag::kBytes: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_bytes, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_bytes, validation_context,
                                             &bytes_validate_params)) {
        return false;
      }
      return true;
    }
    case BigBuffer_Tag::kSharedMemory: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_memory, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_memory, validation_context))
        return false;
      return true;
    }
    case BigBuffer_Tag::kInvalidBuffer: {

      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in BigBuffer");
      return false;
    }
  }
}


// static
bool BigBufferSharedMemoryRegion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BigBufferSharedMemoryRegion_Data* object =
      static_cast<const BigBufferSharedMemoryRegion_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->buffer_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->buffer_handle,
                                                 validation_context)) {
    return false;
  }

  return true;
}

BigBufferSharedMemoryRegion_Data::BigBufferSharedMemoryRegion_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace mojo_base