// media/mojo/mojom/webrtc_video_perf.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  VideoCodecProfile as media_mojom_VideoCodecProfile,
  VideoCodecProfileSpec as media_mojom_VideoCodecProfileSpec
} from './media_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebrtcVideoPerfRecorderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.WebrtcVideoPerfRecorder', scope);
  }
}

/** @interface */
export class WebrtcVideoPerfRecorderInterface {
  
  /**
   * @param { !WebrtcPredictionFeatures } features
   * @param { !WebrtcVideoStats } videoStats
   */

  updateRecord(features, videoStats) {}
}

/**
 * @implements { WebrtcVideoPerfRecorderInterface }
 */
export class WebrtcVideoPerfRecorderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebrtcVideoPerfRecorderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebrtcVideoPerfRecorderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebrtcVideoPerfRecorderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !WebrtcPredictionFeatures } features
   * @param { !WebrtcVideoStats } videoStats
   */

  updateRecord(
      features,
      videoStats) {
    this.proxy.sendMessage(
        0,
        WebrtcVideoPerfRecorder_UpdateRecord_ParamsSpec.$,
        null,
        [
          features,
          videoStats
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebrtcVideoPerfRecorder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebrtcVideoPerfRecorderReceiver {
  /**
   * @param {!WebrtcVideoPerfRecorderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebrtcVideoPerfRecorderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebrtcVideoPerfRecorderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebrtcVideoPerfRecorderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebrtcVideoPerfRecorder_UpdateRecord_ParamsSpec.$,
        null,
        impl.updateRecord.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebrtcVideoPerfRecorder {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.WebrtcVideoPerfRecorder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebrtcVideoPerfRecorderRemote}
   */
  static getRemote() {
    let remote = new WebrtcVideoPerfRecorderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebrtcVideoPerfRecorder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebrtcVideoPerfRecorderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebrtcVideoPerfRecorderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebrtcVideoPerfRecorderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateRecord =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebrtcVideoPerfRecorder_UpdateRecord_ParamsSpec.$,
        null,
        this.updateRecord.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebrtcVideoPerfHistoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.WebrtcVideoPerfHistory', scope);
  }
}

/** @interface */
export class WebrtcVideoPerfHistoryInterface {
  
  /**
   * @param { !WebrtcPredictionFeatures } features
   * @param { !number } framesPerSecond
   * @return {!Promise<{
        isSmooth: !boolean,
   *  }>}
   */

  getPerfInfo(features, framesPerSecond) {}
}

/**
 * @implements { WebrtcVideoPerfHistoryInterface }
 */
export class WebrtcVideoPerfHistoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebrtcVideoPerfHistoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebrtcVideoPerfHistoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebrtcVideoPerfHistoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !WebrtcPredictionFeatures } features
   * @param { !number } framesPerSecond
   * @return {!Promise<{
        isSmooth: !boolean,
   *  }>}
   */

  getPerfInfo(
      features,
      framesPerSecond) {
    return this.proxy.sendMessage(
        0,
        WebrtcVideoPerfHistory_GetPerfInfo_ParamsSpec.$,
        WebrtcVideoPerfHistory_GetPerfInfo_ResponseParamsSpec.$,
        [
          features,
          framesPerSecond
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebrtcVideoPerfHistory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebrtcVideoPerfHistoryReceiver {
  /**
   * @param {!WebrtcVideoPerfHistoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebrtcVideoPerfHistoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebrtcVideoPerfHistoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebrtcVideoPerfHistoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebrtcVideoPerfHistory_GetPerfInfo_ParamsSpec.$,
        WebrtcVideoPerfHistory_GetPerfInfo_ResponseParamsSpec.$,
        impl.getPerfInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebrtcVideoPerfHistory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.WebrtcVideoPerfHistory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebrtcVideoPerfHistoryRemote}
   */
  static getRemote() {
    let remote = new WebrtcVideoPerfHistoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebrtcVideoPerfHistory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebrtcVideoPerfHistoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebrtcVideoPerfHistoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebrtcVideoPerfHistoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPerfInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebrtcVideoPerfHistory_GetPerfInfo_ParamsSpec.$,
        WebrtcVideoPerfHistory_GetPerfInfo_ResponseParamsSpec.$,
        this.getPerfInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebrtcPredictionFeaturesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebrtcVideoStatsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebrtcVideoPerfRecorder_UpdateRecord_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebrtcVideoPerfHistory_GetPerfInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebrtcVideoPerfHistory_GetPerfInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WebrtcPredictionFeaturesSpec.$,
    'WebrtcPredictionFeatures',
    [
      mojo.internal.StructField(
        'isDecodeStats', 0,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'profile', 4,
        0,
        media_mojom_VideoCodecProfileSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoPixels', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hardwareAccelerated', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebrtcPredictionFeatures {
  constructor() {
    /** @type { !boolean } */
    this.isDecodeStats;
    /** @type { !media_mojom_VideoCodecProfile } */
    this.profile;
    /** @type { !number } */
    this.videoPixels;
    /** @type { !boolean } */
    this.hardwareAccelerated;
  }
}



mojo.internal.Struct(
    WebrtcVideoStatsSpec.$,
    'WebrtcVideoStats',
    [
      mojo.internal.StructField(
        'framesProcessed', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyFramesProcessed', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'p99ProcessingTimeMs', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebrtcVideoStats {
  constructor() {
    /** @type { !number } */
    this.framesProcessed;
    /** @type { !number } */
    this.keyFramesProcessed;
    /** @type { !number } */
    this.p99ProcessingTimeMs;
  }
}



mojo.internal.Struct(
    WebrtcVideoPerfRecorder_UpdateRecord_ParamsSpec.$,
    'WebrtcVideoPerfRecorder_UpdateRecord_Params',
    [
      mojo.internal.StructField(
        'features', 0,
        0,
        WebrtcPredictionFeaturesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoStats', 8,
        0,
        WebrtcVideoStatsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebrtcVideoPerfRecorder_UpdateRecord_Params {
  constructor() {
    /** @type { !WebrtcPredictionFeatures } */
    this.features;
    /** @type { !WebrtcVideoStats } */
    this.videoStats;
  }
}



mojo.internal.Struct(
    WebrtcVideoPerfHistory_GetPerfInfo_ParamsSpec.$,
    'WebrtcVideoPerfHistory_GetPerfInfo_Params',
    [
      mojo.internal.StructField(
        'features', 0,
        0,
        WebrtcPredictionFeaturesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framesPerSecond', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebrtcVideoPerfHistory_GetPerfInfo_Params {
  constructor() {
    /** @type { !WebrtcPredictionFeatures } */
    this.features;
    /** @type { !number } */
    this.framesPerSecond;
  }
}



mojo.internal.Struct(
    WebrtcVideoPerfHistory_GetPerfInfo_ResponseParamsSpec.$,
    'WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'isSmooth', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.isSmooth;
  }
}

