// media/mojo/mojom/video_decoder.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/video_decoder.mojom-shared-internal.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "media/mojo/mojom/media_log.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "media/mojo/mojom/video_decoder.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SupportedVideoDecoderConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SupportedVideoDecoderConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SupportedVideoDecoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
      Traits::profile_min(input),
      &fragment->profile_min);

    
    mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
      Traits::profile_max(input),
      &fragment->profile_max);

    decltype(Traits::coded_size_min(input)) in_coded_size_min = Traits::coded_size_min(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coded_size_min)::BaseType> coded_size_min_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_coded_size_min,
      coded_size_min_fragment);

    fragment->coded_size_min.Set(
        coded_size_min_fragment.is_null() ? nullptr : coded_size_min_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->coded_size_min.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null coded_size_min in SupportedVideoDecoderConfig struct");

    decltype(Traits::coded_size_max(input)) in_coded_size_max = Traits::coded_size_max(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coded_size_max)::BaseType> coded_size_max_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_coded_size_max,
      coded_size_max_fragment);

    fragment->coded_size_max.Set(
        coded_size_max_fragment.is_null() ? nullptr : coded_size_max_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->coded_size_max.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null coded_size_max in SupportedVideoDecoderConfig struct");

    fragment->allow_encrypted = Traits::allow_encrypted(input);

    fragment->require_encrypted = Traits::require_encrypted(input);
  }

  static bool Deserialize(::media::mojom::internal::SupportedVideoDecoderConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::SupportedVideoDecoderConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CommandBufferIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CommandBufferIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CommandBufferId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::channel_token(input)) in_channel_token = Traits::channel_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->channel_token)::BaseType> channel_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_channel_token,
      channel_token_fragment);

    fragment->channel_token.Set(
        channel_token_fragment.is_null() ? nullptr : channel_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->channel_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null channel_token in CommandBufferId struct");

    fragment->route_id = Traits::route_id(input);
  }

  static bool Deserialize(::media::mojom::internal::CommandBufferId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::CommandBufferIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CdmDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::CdmDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media::mojom::internal::Cdm_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media::mojom::CdmDataView::Tag::kCdmId: {
    decltype(Traits::cdm_id(input))
    in_cdm_id = Traits::cdm_id(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_cdm_id)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
  in_cdm_id,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null cdm_id in Cdm union");
    fragment->data.f_cdm_id.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::media::mojom::internal::Cdm_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::CdmDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void SupportedVideoDecoderConfigDataView::GetCodedSizeMinDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->coded_size_min.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void SupportedVideoDecoderConfigDataView::GetCodedSizeMaxDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->coded_size_max.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void CommandBufferIdDataView::GetChannelTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->channel_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void CdmDataView::GetCdmIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) const {
  CHECK(is_cdm_id());
  *output = ::mojo_base::mojom::UnguessableTokenDataView(data_->data.f_cdm_id.Get(), message_);
}


}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_SHARED_H_