// media/mojo/mojom/video_decode_perf_history.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.PredictionFeatures');






goog.provide('media.mojom.VideoDecodePerfHistory');
goog.provide('media.mojom.VideoDecodePerfHistoryReceiver');
goog.provide('media.mojom.VideoDecodePerfHistoryCallbackRouter');
goog.provide('media.mojom.VideoDecodePerfHistoryInterface');
goog.provide('media.mojom.VideoDecodePerfHistoryRemote');
goog.provide('media.mojom.VideoDecodePerfHistoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.VideoDecodePerfHistoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.VideoDecodePerfHistory.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.VideoDecodePerfHistoryInterface = class {
  
  /**
   * @param { !media.mojom.PredictionFeatures } features
   * @return {!Promise<{
        isSmooth: !boolean,
        isPowerEfficient: !boolean,
   *  }>}
   */

  getPerfInfo(features) {}
};

/**
 * @export
 * @implements { media.mojom.VideoDecodePerfHistoryInterface }
 */
media.mojom.VideoDecodePerfHistoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.VideoDecodePerfHistoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.VideoDecodePerfHistoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.VideoDecodePerfHistoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.PredictionFeatures } features
   * @return {!Promise<{
        isSmooth: !boolean,
        isPowerEfficient: !boolean,
   *  }>}
   */

  getPerfInfo(
      features) {
    return this.proxy.sendMessage(
        0,
        media.mojom.VideoDecodePerfHistory_GetPerfInfo_ParamsSpec.$,
        media.mojom.VideoDecodePerfHistory_GetPerfInfo_ResponseParamsSpec.$,
        [
          features
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VideoDecodePerfHistory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.VideoDecodePerfHistoryReceiver = class {
  /**
   * @param {!media.mojom.VideoDecodePerfHistoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.VideoDecodePerfHistoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.VideoDecodePerfHistoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoDecodePerfHistoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoDecodePerfHistory_GetPerfInfo_ParamsSpec.$,
        media.mojom.VideoDecodePerfHistory_GetPerfInfo_ResponseParamsSpec.$,
        impl.getPerfInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.VideoDecodePerfHistory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoDecodePerfHistory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.VideoDecodePerfHistoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.VideoDecodePerfHistoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VideoDecodePerfHistory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.VideoDecodePerfHistoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.VideoDecodePerfHistoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoDecodePerfHistoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPerfInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoDecodePerfHistory_GetPerfInfo_ParamsSpec.$,
        media.mojom.VideoDecodePerfHistory_GetPerfInfo_ResponseParamsSpec.$,
        this.getPerfInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.VideoDecodePerfHistory_GetPerfInfo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecodePerfHistory_GetPerfInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecodePerfHistory_GetPerfInfo_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecodePerfHistory_GetPerfInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.VideoDecodePerfHistory_GetPerfInfo_ParamsSpec.$,
    'VideoDecodePerfHistory_GetPerfInfo_Params',
    [
      mojo.internal.StructField(
        'features', 0,
        0,
        media.mojom.PredictionFeaturesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoDecodePerfHistory_GetPerfInfo_Params');

/** @record */
media.mojom.VideoDecodePerfHistory_GetPerfInfo_Params = class {
  constructor() {
    /** @export { !media.mojom.PredictionFeatures } */
    this.features;
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecodePerfHistory_GetPerfInfo_ResponseParamsSpec.$,
    'VideoDecodePerfHistory_GetPerfInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'isSmooth', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isPowerEfficient', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoDecodePerfHistory_GetPerfInfo_ResponseParams');

/** @record */
media.mojom.VideoDecodePerfHistory_GetPerfInfo_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.isSmooth;
    /** @export { !boolean } */
    this.isPowerEfficient;
  }
};

