// media/mojo/mojom/speech_recognizer.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('media.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.AvailabilityStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.AvailabilityStatus = {
  
  kUnavailable: 0,
  kDownloadable: 1,
  kDownloading: 2,
  kAvailable: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.SpeechRecognizerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.SpeechRecognizer.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.SpeechRecognizerInterface }
 */
media.mojom.SpeechRecognizerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.SpeechRecognizerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.SpeechRecognizerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.SpeechRecognizerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.StartSpeechRecognitionRequestParams } params
   */

  start(
      params) {
    this.proxy.sendMessage(
        0,
        media.mojom.SpeechRecognizer_Start_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechRecognizer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.SpeechRecognizerReceiver = class {
  /**
   * @param {!media.mojom.SpeechRecognizerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.SpeechRecognizerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.SpeechRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognizer_Start_ParamsSpec.$,
        null,
        impl.start.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.SpeechRecognizer = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognizer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.SpeechRecognizerRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.SpeechRecognizerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechRecognizer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.SpeechRecognizerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.SpeechRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.start =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognizer_Start_ParamsSpec.$,
        null,
        this.start.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.OnDeviceSpeechRecognitionPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.OnDeviceSpeechRecognition.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.OnDeviceSpeechRecognitionInterface }
 */
media.mojom.OnDeviceSpeechRecognitionRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.OnDeviceSpeechRecognitionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.OnDeviceSpeechRecognitionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.OnDeviceSpeechRecognitionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!string> } languages
   * @return {!Promise<{
        status: !media.mojom.AvailabilityStatus,
   *  }>}
   */

  available(
      languages) {
    return this.proxy.sendMessage(
        0,
        media.mojom.OnDeviceSpeechRecognition_Available_ParamsSpec.$,
        media.mojom.OnDeviceSpeechRecognition_Available_ResponseParamsSpec.$,
        [
          languages
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } languages
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  install(
      languages) {
    return this.proxy.sendMessage(
        1,
        media.mojom.OnDeviceSpeechRecognition_Install_ParamsSpec.$,
        media.mojom.OnDeviceSpeechRecognition_Install_ResponseParamsSpec.$,
        [
          languages
        ],
        false);
  }
};

/**
 * An object which receives request messages for the OnDeviceSpeechRecognition
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.OnDeviceSpeechRecognitionReceiver = class {
  /**
   * @param {!media.mojom.OnDeviceSpeechRecognitionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.OnDeviceSpeechRecognitionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.OnDeviceSpeechRecognitionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.OnDeviceSpeechRecognitionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.OnDeviceSpeechRecognition_Available_ParamsSpec.$,
        media.mojom.OnDeviceSpeechRecognition_Available_ResponseParamsSpec.$,
        impl.available.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.OnDeviceSpeechRecognition_Install_ParamsSpec.$,
        media.mojom.OnDeviceSpeechRecognition_Install_ResponseParamsSpec.$,
        impl.install.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.OnDeviceSpeechRecognition = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.OnDeviceSpeechRecognition";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.OnDeviceSpeechRecognitionRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.OnDeviceSpeechRecognitionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the OnDeviceSpeechRecognition
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.OnDeviceSpeechRecognitionCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.OnDeviceSpeechRecognitionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.OnDeviceSpeechRecognitionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.available =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.OnDeviceSpeechRecognition_Available_ParamsSpec.$,
        media.mojom.OnDeviceSpeechRecognition_Available_ResponseParamsSpec.$,
        this.available.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.install =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.OnDeviceSpeechRecognition_Install_ParamsSpec.$,
        media.mojom.OnDeviceSpeechRecognition_Install_ResponseParamsSpec.$,
        this.install.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.SpeechRecognitionSessionPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.SpeechRecognitionSession.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.SpeechRecognitionSessionInterface }
 */
media.mojom.SpeechRecognitionSessionRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.SpeechRecognitionSessionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.SpeechRecognitionSessionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.SpeechRecognitionSessionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  abort() {
    this.proxy.sendMessage(
        0,
        media.mojom.SpeechRecognitionSession_Abort_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  stopCapture() {
    this.proxy.sendMessage(
        1,
        media.mojom.SpeechRecognitionSession_StopCapture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.SpeechRecognitionRecognitionContext } recognitionContext
   */

  updateRecognitionContext(
      recognitionContext) {
    this.proxy.sendMessage(
        2,
        media.mojom.SpeechRecognitionSession_UpdateRecognitionContext_ParamsSpec.$,
        null,
        [
          recognitionContext
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechRecognitionSession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.SpeechRecognitionSessionReceiver = class {
  /**
   * @param {!media.mojom.SpeechRecognitionSessionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.SpeechRecognitionSessionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.SpeechRecognitionSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionSession_Abort_ParamsSpec.$,
        null,
        impl.abort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionSession_StopCapture_ParamsSpec.$,
        null,
        impl.stopCapture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.SpeechRecognitionSession_UpdateRecognitionContext_ParamsSpec.$,
        null,
        impl.updateRecognitionContext.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.SpeechRecognitionSession = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionSession";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.SpeechRecognitionSessionRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.SpeechRecognitionSessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechRecognitionSession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.SpeechRecognitionSessionCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.SpeechRecognitionSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionSession_Abort_ParamsSpec.$,
        null,
        this.abort.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopCapture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionSession_StopCapture_ParamsSpec.$,
        null,
        this.stopCapture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateRecognitionContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.SpeechRecognitionSession_UpdateRecognitionContext_ParamsSpec.$,
        null,
        this.updateRecognitionContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.SpeechRecognitionSessionClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.SpeechRecognitionSessionClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.SpeechRecognitionSessionClientInterface }
 */
media.mojom.SpeechRecognitionSessionClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.SpeechRecognitionSessionClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.SpeechRecognitionSessionClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.SpeechRecognitionSessionClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!media.mojom.WebSpeechRecognitionResult> } results
   */

  resultRetrieved(
      results) {
    this.proxy.sendMessage(
        0,
        media.mojom.SpeechRecognitionSessionClient_ResultRetrieved_ParamsSpec.$,
        null,
        [
          results
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.SpeechRecognitionError } error
   */

  errorOccurred(
      error) {
    this.proxy.sendMessage(
        1,
        media.mojom.SpeechRecognitionSessionClient_ErrorOccurred_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }

  
  /**
   */

  started() {
    this.proxy.sendMessage(
        2,
        media.mojom.SpeechRecognitionSessionClient_Started_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  audioStarted() {
    this.proxy.sendMessage(
        3,
        media.mojom.SpeechRecognitionSessionClient_AudioStarted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  soundStarted() {
    this.proxy.sendMessage(
        4,
        media.mojom.SpeechRecognitionSessionClient_SoundStarted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  soundEnded() {
    this.proxy.sendMessage(
        5,
        media.mojom.SpeechRecognitionSessionClient_SoundEnded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  audioEnded() {
    this.proxy.sendMessage(
        6,
        media.mojom.SpeechRecognitionSessionClient_AudioEnded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  ended() {
    this.proxy.sendMessage(
        7,
        media.mojom.SpeechRecognitionSessionClient_Ended_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechRecognitionSessionClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.SpeechRecognitionSessionClientReceiver = class {
  /**
   * @param {!media.mojom.SpeechRecognitionSessionClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.SpeechRecognitionSessionClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.SpeechRecognitionSessionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionSessionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionSessionClient_ResultRetrieved_ParamsSpec.$,
        null,
        impl.resultRetrieved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionSessionClient_ErrorOccurred_ParamsSpec.$,
        null,
        impl.errorOccurred.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.SpeechRecognitionSessionClient_Started_ParamsSpec.$,
        null,
        impl.started.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.SpeechRecognitionSessionClient_AudioStarted_ParamsSpec.$,
        null,
        impl.audioStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.SpeechRecognitionSessionClient_SoundStarted_ParamsSpec.$,
        null,
        impl.soundStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.SpeechRecognitionSessionClient_SoundEnded_ParamsSpec.$,
        null,
        impl.soundEnded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        media.mojom.SpeechRecognitionSessionClient_AudioEnded_ParamsSpec.$,
        null,
        impl.audioEnded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        media.mojom.SpeechRecognitionSessionClient_Ended_ParamsSpec.$,
        null,
        impl.ended.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.SpeechRecognitionSessionClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionSessionClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.SpeechRecognitionSessionClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.SpeechRecognitionSessionClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechRecognitionSessionClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.SpeechRecognitionSessionClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.SpeechRecognitionSessionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionSessionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resultRetrieved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionSessionClient_ResultRetrieved_ParamsSpec.$,
        null,
        this.resultRetrieved.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.errorOccurred =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionSessionClient_ErrorOccurred_ParamsSpec.$,
        null,
        this.errorOccurred.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.started =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.SpeechRecognitionSessionClient_Started_ParamsSpec.$,
        null,
        this.started.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.SpeechRecognitionSessionClient_AudioStarted_ParamsSpec.$,
        null,
        this.audioStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.soundStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.SpeechRecognitionSessionClient_SoundStarted_ParamsSpec.$,
        null,
        this.soundStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.soundEnded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.SpeechRecognitionSessionClient_SoundEnded_ParamsSpec.$,
        null,
        this.soundEnded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioEnded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        media.mojom.SpeechRecognitionSessionClient_AudioEnded_ParamsSpec.$,
        null,
        this.audioEnded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.ended =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        media.mojom.SpeechRecognitionSessionClient_Ended_ParamsSpec.$,
        null,
        this.ended.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.StartSpeechRecognitionRequestParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognizer_Start_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.OnDeviceSpeechRecognition_Available_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.OnDeviceSpeechRecognition_Available_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.OnDeviceSpeechRecognition_Install_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.OnDeviceSpeechRecognition_Install_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSession_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSession_StopCapture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSession_UpdateRecognitionContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSessionClient_ResultRetrieved_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSessionClient_ErrorOccurred_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSessionClient_Started_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSessionClient_AudioStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSessionClient_SoundStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSessionClient_SoundEnded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSessionClient_AudioEnded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSessionClient_Ended_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.StartSpeechRecognitionRequestParamsSpec.$,
    'StartSpeechRecognitionRequestParams',
    [
      mojo.internal.StructField(
        'sessionReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.SpeechRecognitionSessionPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.InterfaceProxy(media.mojom.SpeechRecognitionSessionClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'language', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'grammars', 24,
        0,
        mojo.internal.Array(media.mojom.SpeechRecognitionGrammarSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'recognitionContext', 32,
        0,
        media.mojom.SpeechRecognitionRecognitionContextSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxHypotheses', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'continuous', 40,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'interimResults', 40,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'onDevice', 40,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowCloudFallback', 40,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioForwarder', 44,
        0,
        mojo.internal.InterfaceRequest(media.mojom.SpeechRecognitionAudioForwarderPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelCount', 48,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sampleRate', 52,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
media.mojom.StartSpeechRecognitionRequestParams = class {
  constructor() {
    /** @export { !media.mojom.SpeechRecognitionSessionPendingReceiver } */
    this.sessionReceiver;
    /** @export { !media.mojom.SpeechRecognitionSessionClientRemote } */
    this.client;
    /** @export { !string } */
    this.language;
    /** @export { !Array<!media.mojom.SpeechRecognitionGrammar> } */
    this.grammars;
    /** @export { (media.mojom.SpeechRecognitionRecognitionContext|undefined) } */
    this.recognitionContext;
    /** @export { !number } */
    this.maxHypotheses;
    /** @export { !boolean } */
    this.continuous;
    /** @export { !boolean } */
    this.interimResults;
    /** @export { !boolean } */
    this.onDevice;
    /** @export { !boolean } */
    this.allowCloudFallback;
    /** @export { (media.mojom.SpeechRecognitionAudioForwarderPendingReceiver|undefined) } */
    this.audioForwarder;
    /** @export { !number } */
    this.channelCount;
    /** @export { !number } */
    this.sampleRate;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognizer_Start_ParamsSpec.$,
    'SpeechRecognizer_Start_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        media.mojom.StartSpeechRecognitionRequestParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.SpeechRecognizer_Start_Params = class {
  constructor() {
    /** @export { !media.mojom.StartSpeechRecognitionRequestParams } */
    this.params;
  }
};



mojo.internal.Struct(
    media.mojom.OnDeviceSpeechRecognition_Available_ParamsSpec.$,
    'OnDeviceSpeechRecognition_Available_Params',
    [
      mojo.internal.StructField(
        'languages', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.OnDeviceSpeechRecognition_Available_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.languages;
  }
};



mojo.internal.Struct(
    media.mojom.OnDeviceSpeechRecognition_Available_ResponseParamsSpec.$,
    'OnDeviceSpeechRecognition_Available_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.AvailabilityStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.OnDeviceSpeechRecognition_Available_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.AvailabilityStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.OnDeviceSpeechRecognition_Install_ParamsSpec.$,
    'OnDeviceSpeechRecognition_Install_Params',
    [
      mojo.internal.StructField(
        'languages', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.OnDeviceSpeechRecognition_Install_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.languages;
  }
};



mojo.internal.Struct(
    media.mojom.OnDeviceSpeechRecognition_Install_ResponseParamsSpec.$,
    'OnDeviceSpeechRecognition_Install_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.OnDeviceSpeechRecognition_Install_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSession_Abort_ParamsSpec.$,
    'SpeechRecognitionSession_Abort_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.SpeechRecognitionSession_Abort_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSession_StopCapture_ParamsSpec.$,
    'SpeechRecognitionSession_StopCapture_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.SpeechRecognitionSession_StopCapture_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSession_UpdateRecognitionContext_ParamsSpec.$,
    'SpeechRecognitionSession_UpdateRecognitionContext_Params',
    [
      mojo.internal.StructField(
        'recognitionContext', 0,
        0,
        media.mojom.SpeechRecognitionRecognitionContextSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.SpeechRecognitionSession_UpdateRecognitionContext_Params = class {
  constructor() {
    /** @export { !media.mojom.SpeechRecognitionRecognitionContext } */
    this.recognitionContext;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSessionClient_ResultRetrieved_ParamsSpec.$,
    'SpeechRecognitionSessionClient_ResultRetrieved_Params',
    [
      mojo.internal.StructField(
        'results', 0,
        0,
        mojo.internal.Array(media.mojom.WebSpeechRecognitionResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.SpeechRecognitionSessionClient_ResultRetrieved_Params = class {
  constructor() {
    /** @export { !Array<!media.mojom.WebSpeechRecognitionResult> } */
    this.results;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSessionClient_ErrorOccurred_ParamsSpec.$,
    'SpeechRecognitionSessionClient_ErrorOccurred_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        media.mojom.SpeechRecognitionErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.SpeechRecognitionSessionClient_ErrorOccurred_Params = class {
  constructor() {
    /** @export { !media.mojom.SpeechRecognitionError } */
    this.error;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSessionClient_Started_ParamsSpec.$,
    'SpeechRecognitionSessionClient_Started_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.SpeechRecognitionSessionClient_Started_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSessionClient_AudioStarted_ParamsSpec.$,
    'SpeechRecognitionSessionClient_AudioStarted_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.SpeechRecognitionSessionClient_AudioStarted_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSessionClient_SoundStarted_ParamsSpec.$,
    'SpeechRecognitionSessionClient_SoundStarted_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.SpeechRecognitionSessionClient_SoundStarted_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSessionClient_SoundEnded_ParamsSpec.$,
    'SpeechRecognitionSessionClient_SoundEnded_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.SpeechRecognitionSessionClient_SoundEnded_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSessionClient_AudioEnded_ParamsSpec.$,
    'SpeechRecognitionSessionClient_AudioEnded_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.SpeechRecognitionSessionClient_AudioEnded_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSessionClient_Ended_ParamsSpec.$,
    'SpeechRecognitionSessionClient_Ended_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.SpeechRecognitionSessionClient_Ended_Params = class {
  constructor() {
  }
};

