// media/mojo/mojom/speech_recognition_recognition_context.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/speech_recognition_recognition_context.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');



  function SpeechRecognitionPhrase(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionPhrase.prototype.initDefaults_ = function() {
    this.phrase = null;
    this.boost = 0;
  };
  SpeechRecognitionPhrase.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionPhrase.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionPhrase.phrase
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SpeechRecognitionPhrase.encodedSize = codec.kStructHeaderSize + 16;

  SpeechRecognitionPhrase.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionPhrase();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.phrase =
        decoder.decodeStruct(codec.String);
    val.boost =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpeechRecognitionPhrase.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionPhrase.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.phrase);
    encoder.encodeStruct(codec.Float, val.boost);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechRecognitionRecognitionContext(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionRecognitionContext.prototype.initDefaults_ = function() {
    this.phrases = null;
  };
  SpeechRecognitionRecognitionContext.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionRecognitionContext.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionRecognitionContext.phrases
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SpeechRecognitionPhrase), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionRecognitionContext.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionRecognitionContext.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionRecognitionContext();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.phrases =
        decoder.decodeArrayPointer(new codec.PointerTo(SpeechRecognitionPhrase));
    return val;
  };

  SpeechRecognitionRecognitionContext.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionRecognitionContext.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SpeechRecognitionPhrase), val.phrases);
  };
  exports.SpeechRecognitionPhrase = SpeechRecognitionPhrase;
  exports.SpeechRecognitionRecognitionContext = SpeechRecognitionRecognitionContext;
})();