// media/mojo/mojom/renderer.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_RENDERER_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_RENDERER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/renderer.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/renderer.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/renderer.mojom-blink-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/demuxer_stream.mojom-blink-forward.h"
#include "media/mojo/mojom/media_types.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/site_for_cookies.mojom-blink-forward.h"
#include "services/network/public/mojom/storage_access_api.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "url/mojom/url.mojom-blink-forward.h"
#include "url/mojom/origin.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {

class RendererProxy;

template <typename ImplRefTraits>
class RendererStub;

class RendererRequestValidator;
class RendererResponseValidator;


class BLINK_PLATFORM_EXPORT Renderer
    : public RendererInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.Renderer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererInterfaceBase;
  using Proxy_ = RendererProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererStub<ImplRefTraits>;

  using RequestValidator_ = RendererRequestValidator;
  using ResponseValidator_ = RendererResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitializeMinVersion = 0,
    kFlushMinVersion = 0,
    kStartPlayingFromMinVersion = 0,
    kSetPlaybackRateMinVersion = 0,
    kSetVolumeMinVersion = 0,
    kSetCdmMinVersion = 0,
    kSetLatencyHintMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Initialize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Flush_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartPlayingFrom_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPlaybackRate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVolume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCdm_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetLatencyHint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Renderer() = default;

  using InitializeCallback = base::OnceCallback<void(bool)>;
  using InitializeMojoCallback = base::OnceCallback<void(bool)>;

  virtual void Initialize(::mojo::PendingAssociatedRemote<RendererClient> client, std::optional<::blink::Vector<::mojo::PendingRemote<::media::mojom::blink::DemuxerStream>>> streams, InitializeCallback callback) = 0;

  using FlushCallback = base::OnceCallback<void()>;
  using FlushMojoCallback = base::OnceCallback<void()>;

  virtual void Flush(FlushCallback callback) = 0;

  virtual void StartPlayingFrom(::base::TimeDelta time) = 0;

  virtual void SetPlaybackRate(double playback_rate) = 0;

  virtual void SetVolume(float volume) = 0;

  using SetCdmCallback = base::OnceCallback<void(bool)>;
  using SetCdmMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetCdm(const std::optional<::base::UnguessableToken>& cdm_id, SetCdmCallback callback) = 0;

  virtual void SetLatencyHint(std::optional<::base::TimeDelta> latency_hint) = 0;
};

class RendererClientProxy;

template <typename ImplRefTraits>
class RendererClientStub;

class RendererClientRequestValidator;


class BLINK_PLATFORM_EXPORT RendererClient
    : public RendererClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.RendererClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererClientInterfaceBase;
  using Proxy_ = RendererClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererClientStub<ImplRefTraits>;

  using RequestValidator_ = RendererClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnTimeUpdateMinVersion = 0,
    kOnBufferingStateChangeMinVersion = 0,
    kOnEndedMinVersion = 0,
    kOnErrorMinVersion = 0,
    kOnAudioConfigChangeMinVersion = 0,
    kOnVideoConfigChangeMinVersion = 0,
    kOnVideoNaturalSizeChangeMinVersion = 0,
    kOnVideoOpacityChangeMinVersion = 0,
    kOnStatisticsUpdateMinVersion = 0,
    kOnWaitingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnTimeUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBufferingStateChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnEnded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAudioConfigChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnVideoConfigChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnVideoNaturalSizeChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnVideoOpacityChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStatisticsUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWaiting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RendererClient() = default;

  virtual void OnTimeUpdate(::base::TimeDelta time, ::base::TimeDelta max_time, ::base::TimeTicks capture_time) = 0;

  virtual void OnBufferingStateChange(::media::mojom::blink::BufferingState state, ::media::mojom::blink::BufferingStateChangeReason reason) = 0;

  virtual void OnEnded() = 0;

  virtual void OnError(const ::media::PipelineStatus& status) = 0;

  virtual void OnAudioConfigChange(::media::mojom::blink::AudioDecoderConfigPtr config) = 0;

  virtual void OnVideoConfigChange(::media::mojom::blink::VideoDecoderConfigPtr config) = 0;

  virtual void OnVideoNaturalSizeChange(const ::gfx::Size& size) = 0;

  virtual void OnVideoOpacityChange(bool opaque) = 0;

  virtual void OnStatisticsUpdate(const ::media::PipelineStatistics& stats) = 0;

  virtual void OnWaiting(::media::mojom::blink::WaitingReason reason) = 0;
};



class BLINK_PLATFORM_EXPORT RendererProxy
    : public Renderer {
 public:
  using InterfaceType = Renderer;

  explicit RendererProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Initialize(::mojo::PendingAssociatedRemote<RendererClient> client, std::optional<::blink::Vector<::mojo::PendingRemote<::media::mojom::blink::DemuxerStream>>> streams, InitializeCallback callback) final;
  
  void Flush(FlushCallback callback) final;
  
  void StartPlayingFrom(::base::TimeDelta time) final;
  
  void SetPlaybackRate(double playback_rate) final;
  
  void SetVolume(float volume) final;
  
  void SetCdm(const std::optional<::base::UnguessableToken>& cdm_id, SetCdmCallback callback) final;
  
  void SetLatencyHint(std::optional<::base::TimeDelta> latency_hint) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT RendererClientProxy
    : public RendererClient {
 public:
  using InterfaceType = RendererClient;

  explicit RendererClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnTimeUpdate(::base::TimeDelta time, ::base::TimeDelta max_time, ::base::TimeTicks capture_time) final;
  
  void OnBufferingStateChange(::media::mojom::blink::BufferingState state, ::media::mojom::blink::BufferingStateChangeReason reason) final;
  
  void OnEnded() final;
  
  void OnError(const ::media::PipelineStatus& status) final;
  
  void OnAudioConfigChange(::media::mojom::blink::AudioDecoderConfigPtr config) final;
  
  void OnVideoConfigChange(::media::mojom::blink::VideoDecoderConfigPtr config) final;
  
  void OnVideoNaturalSizeChange(const ::gfx::Size& size) final;
  
  void OnVideoOpacityChange(bool opaque) final;
  
  void OnStatisticsUpdate(const ::media::PipelineStatistics& stats) final;
  
  void OnWaiting(::media::mojom::blink::WaitingReason reason) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT RendererStubDispatch {
 public:
  static bool Accept(Renderer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Renderer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Renderer>>
class RendererStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererStub() = default;
  ~RendererStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT RendererClientStubDispatch {
 public:
  static bool Accept(RendererClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererClient>>
class RendererClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererClientStub() = default;
  ~RendererClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT RendererRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT RendererClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT RendererResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_RENDERER_MOJOM_BLINK_H_