// media/mojo/mojom/remoting_common.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_REMOTING_COMMON_MOJOM_SEND_VALIDATION_H_
#define MEDIA_MOJO_MOJOM_REMOTING_COMMON_MOJOM_SEND_VALIDATION_H_

#include "media/mojo/mojom/remoting_common.mojom-shared-internal.h"

#include "media/mojo/mojom/remoting_common.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::RemotingStopReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::RemotingStartFailReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::RemotingSinkFeature, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::RemotingSinkAudioCapability, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::RemotingSinkVideoCapability, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::RemotingSinkMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::RemotingSinkMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::RemotingSinkMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::features(input)) in_features = Traits::features(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->features)::BaseType>
          features_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& features_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::RemotingSinkFeature_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::RemotingSinkFeature>, send_validation>(
        in_features,
        features_fragment,
        &features_validate_params);

      fragment->features.Set(
          features_fragment.is_null() ? nullptr : features_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->features.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null features in RemotingSinkMetadata struct");

      decltype(Traits::audio_capabilities(input)) in_audio_capabilities = Traits::audio_capabilities(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->audio_capabilities)::BaseType>
          audio_capabilities_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& audio_capabilities_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::RemotingSinkAudioCapability_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::RemotingSinkAudioCapability>, send_validation>(
        in_audio_capabilities,
        audio_capabilities_fragment,
        &audio_capabilities_validate_params);

      fragment->audio_capabilities.Set(
          audio_capabilities_fragment.is_null() ? nullptr : audio_capabilities_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->audio_capabilities.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null audio_capabilities in RemotingSinkMetadata struct");

      decltype(Traits::video_capabilities(input)) in_video_capabilities = Traits::video_capabilities(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->video_capabilities)::BaseType>
          video_capabilities_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& video_capabilities_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::RemotingSinkVideoCapability_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::RemotingSinkVideoCapability>, send_validation>(
        in_video_capabilities,
        video_capabilities_fragment,
        &video_capabilities_validate_params);

      fragment->video_capabilities.Set(
          video_capabilities_fragment.is_null() ? nullptr : video_capabilities_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->video_capabilities.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null video_capabilities in RemotingSinkMetadata struct");

      decltype(Traits::friendly_name(input)) in_friendly_name = Traits::friendly_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->friendly_name)::BaseType> friendly_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_friendly_name,
        friendly_name_fragment);

      fragment->friendly_name.Set(
          friendly_name_fragment.is_null() ? nullptr : friendly_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->friendly_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null friendly_name in RemotingSinkMetadata struct");
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_MOJO_MOJOM_REMOTING_COMMON_MOJOM_SEND_VALIDATION_H_