// media/mojo/mojom/playback_events_recorder.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_PLAYBACK_EVENTS_RECORDER_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_PLAYBACK_EVENTS_RECORDER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/playback_events_recorder.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/playback_events_recorder.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/playback_events_recorder.mojom-blink-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {

class PlaybackEventsRecorderProxy;

template <typename ImplRefTraits>
class PlaybackEventsRecorderStub;

class PlaybackEventsRecorderRequestValidator;


class BLINK_PLATFORM_EXPORT PlaybackEventsRecorder
    : public PlaybackEventsRecorderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.PlaybackEventsRecorder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PlaybackEventsRecorderInterfaceBase;
  using Proxy_ = PlaybackEventsRecorderProxy;

  template <typename ImplRefTraits>
  using Stub_ = PlaybackEventsRecorderStub<ImplRefTraits>;

  using RequestValidator_ = PlaybackEventsRecorderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnPlayingMinVersion = 0,
    kOnPausedMinVersion = 0,
    kOnSeekingMinVersion = 0,
    kOnEndedMinVersion = 0,
    kOnErrorMinVersion = 0,
    kOnBufferingMinVersion = 0,
    kOnBufferingCompleteMinVersion = 0,
    kOnNaturalSizeChangedMinVersion = 0,
    kOnPipelineStatisticsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnPlaying_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPaused_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSeeking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnEnded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBuffering_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBufferingComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNaturalSizeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPipelineStatistics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PlaybackEventsRecorder() = default;

  virtual void OnPlaying() = 0;

  virtual void OnPaused() = 0;

  virtual void OnSeeking() = 0;

  virtual void OnEnded() = 0;

  virtual void OnError(const ::media::PipelineStatus& status) = 0;

  virtual void OnBuffering() = 0;

  virtual void OnBufferingComplete() = 0;

  virtual void OnNaturalSizeChanged(const ::gfx::Size& size) = 0;

  virtual void OnPipelineStatistics(const ::media::PipelineStatistics& stats) = 0;
};



class BLINK_PLATFORM_EXPORT PlaybackEventsRecorderProxy
    : public PlaybackEventsRecorder {
 public:
  using InterfaceType = PlaybackEventsRecorder;

  explicit PlaybackEventsRecorderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPlaying() final;
  
  void OnPaused() final;
  
  void OnSeeking() final;
  
  void OnEnded() final;
  
  void OnError(const ::media::PipelineStatus& status) final;
  
  void OnBuffering() final;
  
  void OnBufferingComplete() final;
  
  void OnNaturalSizeChanged(const ::gfx::Size& size) final;
  
  void OnPipelineStatistics(const ::media::PipelineStatistics& stats) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT PlaybackEventsRecorderStubDispatch {
 public:
  static bool Accept(PlaybackEventsRecorder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PlaybackEventsRecorder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PlaybackEventsRecorder>>
class PlaybackEventsRecorderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PlaybackEventsRecorderStub() = default;
  ~PlaybackEventsRecorderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PlaybackEventsRecorderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PlaybackEventsRecorderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT PlaybackEventsRecorderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_PLAYBACK_EVENTS_RECORDER_MOJOM_BLINK_H_