// media/mojo/mojom/media_player.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/media_player.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/media_player.mojom-params-data.h"
#include "media/mojo/mojom/media_player.mojom-shared-message-ids.h"

#include "media/mojo/mojom/media_player.mojom-import-headers.h"
#include "media/mojo/mojom/media_player.mojom-test-utils.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

MediaPlayer::IPCStableHashFunction MediaPlayer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaPlayer>(message.name())) {
    case messages::MediaPlayer::kRequestPlay: {
      return &MediaPlayer::RequestPlay_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kRequestPause: {
      return &MediaPlayer::RequestPause_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kRequestSeekForward: {
      return &MediaPlayer::RequestSeekForward_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kRequestSeekBackward: {
      return &MediaPlayer::RequestSeekBackward_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kRequestSeekTo: {
      return &MediaPlayer::RequestSeekTo_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kRequestEnterPictureInPicture: {
      return &MediaPlayer::RequestEnterPictureInPicture_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kRequestMute: {
      return &MediaPlayer::RequestMute_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kSetVolumeMultiplier: {
      return &MediaPlayer::SetVolumeMultiplier_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kSetPersistentState: {
      return &MediaPlayer::SetPersistentState_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kSetPowerExperimentState: {
      return &MediaPlayer::SetPowerExperimentState_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kSetAudioSinkId: {
      return &MediaPlayer::SetAudioSinkId_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kSuspendForFrameClosed: {
      return &MediaPlayer::SuspendForFrameClosed_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kRequestMediaRemoting: {
      return &MediaPlayer::RequestMediaRemoting_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kRequestVisibility: {
      return &MediaPlayer::RequestVisibility_Sym::IPCStableHash;
    }
    case messages::MediaPlayer::kRecordAutoPictureInPictureInfo: {
      return &MediaPlayer::RecordAutoPictureInPictureInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaPlayer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaPlayer>(message.name())) {
      case messages::MediaPlayer::kRequestPlay:
            return "Receive media::mojom::MediaPlayer::RequestPlay";
      case messages::MediaPlayer::kRequestPause:
            return "Receive media::mojom::MediaPlayer::RequestPause";
      case messages::MediaPlayer::kRequestSeekForward:
            return "Receive media::mojom::MediaPlayer::RequestSeekForward";
      case messages::MediaPlayer::kRequestSeekBackward:
            return "Receive media::mojom::MediaPlayer::RequestSeekBackward";
      case messages::MediaPlayer::kRequestSeekTo:
            return "Receive media::mojom::MediaPlayer::RequestSeekTo";
      case messages::MediaPlayer::kRequestEnterPictureInPicture:
            return "Receive media::mojom::MediaPlayer::RequestEnterPictureInPicture";
      case messages::MediaPlayer::kRequestMute:
            return "Receive media::mojom::MediaPlayer::RequestMute";
      case messages::MediaPlayer::kSetVolumeMultiplier:
            return "Receive media::mojom::MediaPlayer::SetVolumeMultiplier";
      case messages::MediaPlayer::kSetPersistentState:
            return "Receive media::mojom::MediaPlayer::SetPersistentState";
      case messages::MediaPlayer::kSetPowerExperimentState:
            return "Receive media::mojom::MediaPlayer::SetPowerExperimentState";
      case messages::MediaPlayer::kSetAudioSinkId:
            return "Receive media::mojom::MediaPlayer::SetAudioSinkId";
      case messages::MediaPlayer::kSuspendForFrameClosed:
            return "Receive media::mojom::MediaPlayer::SuspendForFrameClosed";
      case messages::MediaPlayer::kRequestMediaRemoting:
            return "Receive media::mojom::MediaPlayer::RequestMediaRemoting";
      case messages::MediaPlayer::kRequestVisibility:
            return "Receive media::mojom::MediaPlayer::RequestVisibility";
      case messages::MediaPlayer::kRecordAutoPictureInPictureInfo:
            return "Receive media::mojom::MediaPlayer::RecordAutoPictureInPictureInfo";
    }
  } else {
    switch (static_cast<messages::MediaPlayer>(message.name())) {
      case messages::MediaPlayer::kRequestPlay:
            return "Receive reply media::mojom::MediaPlayer::RequestPlay";
      case messages::MediaPlayer::kRequestPause:
            return "Receive reply media::mojom::MediaPlayer::RequestPause";
      case messages::MediaPlayer::kRequestSeekForward:
            return "Receive reply media::mojom::MediaPlayer::RequestSeekForward";
      case messages::MediaPlayer::kRequestSeekBackward:
            return "Receive reply media::mojom::MediaPlayer::RequestSeekBackward";
      case messages::MediaPlayer::kRequestSeekTo:
            return "Receive reply media::mojom::MediaPlayer::RequestSeekTo";
      case messages::MediaPlayer::kRequestEnterPictureInPicture:
            return "Receive reply media::mojom::MediaPlayer::RequestEnterPictureInPicture";
      case messages::MediaPlayer::kRequestMute:
            return "Receive reply media::mojom::MediaPlayer::RequestMute";
      case messages::MediaPlayer::kSetVolumeMultiplier:
            return "Receive reply media::mojom::MediaPlayer::SetVolumeMultiplier";
      case messages::MediaPlayer::kSetPersistentState:
            return "Receive reply media::mojom::MediaPlayer::SetPersistentState";
      case messages::MediaPlayer::kSetPowerExperimentState:
            return "Receive reply media::mojom::MediaPlayer::SetPowerExperimentState";
      case messages::MediaPlayer::kSetAudioSinkId:
            return "Receive reply media::mojom::MediaPlayer::SetAudioSinkId";
      case messages::MediaPlayer::kSuspendForFrameClosed:
            return "Receive reply media::mojom::MediaPlayer::SuspendForFrameClosed";
      case messages::MediaPlayer::kRequestMediaRemoting:
            return "Receive reply media::mojom::MediaPlayer::RequestMediaRemoting";
      case messages::MediaPlayer::kRequestVisibility:
            return "Receive reply media::mojom::MediaPlayer::RequestVisibility";
      case messages::MediaPlayer::kRecordAutoPictureInPictureInfo:
            return "Receive reply media::mojom::MediaPlayer::RecordAutoPictureInPictureInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaPlayer::RequestPlay_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x290d71fa;  // IPCStableHash for media::mojom::MediaPlayer::RequestPlay
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::RequestPause_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8eb0ff15;  // IPCStableHash for media::mojom::MediaPlayer::RequestPause
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::RequestSeekForward_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdfa6e0ad;  // IPCStableHash for media::mojom::MediaPlayer::RequestSeekForward
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::RequestSeekBackward_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0807e2f8;  // IPCStableHash for media::mojom::MediaPlayer::RequestSeekBackward
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::RequestSeekTo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x303bfbc3;  // IPCStableHash for media::mojom::MediaPlayer::RequestSeekTo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::RequestEnterPictureInPicture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdef21e43;  // IPCStableHash for media::mojom::MediaPlayer::RequestEnterPictureInPicture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::RequestMute_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x70d552fe;  // IPCStableHash for media::mojom::MediaPlayer::RequestMute
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::SetVolumeMultiplier_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde9ae98c;  // IPCStableHash for media::mojom::MediaPlayer::SetVolumeMultiplier
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::SetPersistentState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8d18d212;  // IPCStableHash for media::mojom::MediaPlayer::SetPersistentState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::SetPowerExperimentState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa890f66a;  // IPCStableHash for media::mojom::MediaPlayer::SetPowerExperimentState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::SetAudioSinkId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x893f4598;  // IPCStableHash for media::mojom::MediaPlayer::SetAudioSinkId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::SuspendForFrameClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb57b5c76;  // IPCStableHash for media::mojom::MediaPlayer::SuspendForFrameClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::RequestMediaRemoting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x72e63efa;  // IPCStableHash for media::mojom::MediaPlayer::RequestMediaRemoting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::RequestVisibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x30ad2e3a;  // IPCStableHash for media::mojom::MediaPlayer::RequestVisibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayer::RecordAutoPictureInPictureInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb17db794;  // IPCStableHash for media::mojom::MediaPlayer::RecordAutoPictureInPictureInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MediaPlayer_RequestVisibility_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaPlayer_RequestVisibility_ForwardToCallback(
      MediaPlayer::RequestVisibilityCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaPlayer_RequestVisibility_ForwardToCallback(const MediaPlayer_RequestVisibility_ForwardToCallback&) = delete;
  MediaPlayer_RequestVisibility_ForwardToCallback& operator=(const MediaPlayer_RequestVisibility_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaPlayer::RequestVisibilityCallback callback_;
};

MediaPlayerProxy::MediaPlayerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaPlayerProxy::RequestPlay(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaPlayer::RequestPlay");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kRequestPlay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestPlay_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestPlay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerProxy::RequestPause(
    bool in_triggered_by_user) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayer::RequestPause", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("triggered_by_user"), in_triggered_by_user,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kRequestPause), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestPause_Params_Data> params(
          message);
  params.Allocate();

  params->triggered_by_user = in_triggered_by_user;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestPause");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerProxy::RequestSeekForward(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayer::RequestSeekForward", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kRequestSeekForward), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestSeekForward_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_seek_time,
    seek_time_fragment);

  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->seek_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null seek_time in MediaPlayer.RequestSeekForward request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestSeekForward");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerProxy::RequestSeekBackward(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayer::RequestSeekBackward", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kRequestSeekBackward), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestSeekBackward_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_seek_time,
    seek_time_fragment);

  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->seek_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null seek_time in MediaPlayer.RequestSeekBackward request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestSeekBackward");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerProxy::RequestSeekTo(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayer::RequestSeekTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kRequestSeekTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestSeekTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_seek_time,
    seek_time_fragment);

  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->seek_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null seek_time in MediaPlayer.RequestSeekTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestSeekTo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerProxy::RequestEnterPictureInPicture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaPlayer::RequestEnterPictureInPicture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kRequestEnterPictureInPicture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestEnterPictureInPicture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestEnterPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerProxy::RequestMute(
    bool in_mute) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayer::RequestMute", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mute"), in_mute,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kRequestMute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestMute_Params_Data> params(
          message);
  params.Allocate();

  params->mute = in_mute;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestMute");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerProxy::SetVolumeMultiplier(
    double in_multiplier) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayer::SetVolumeMultiplier", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("multiplier"), in_multiplier,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kSetVolumeMultiplier), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_SetVolumeMultiplier_Params_Data> params(
          message);
  params.Allocate();

  params->multiplier = in_multiplier;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("SetVolumeMultiplier");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerProxy::SetPersistentState(
    bool in_persistent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayer::SetPersistentState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("persistent"), in_persistent,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kSetPersistentState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_SetPersistentState_Params_Data> params(
          message);
  params.Allocate();

  params->persistent = in_persistent;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("SetPersistentState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerProxy::SetPowerExperimentState(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayer::SetPowerExperimentState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kSetPowerExperimentState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_SetPowerExperimentState_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("SetPowerExperimentState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerProxy::SetAudioSinkId(
    const std::string& in_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayer::SetAudioSinkId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kSetAudioSinkId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_SetAudioSinkId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sink_id)::BaseType> sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_sink_id,
    sink_id_fragment);

  params->sink_id.Set(
      sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sink_id in MediaPlayer.SetAudioSinkId request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("SetAudioSinkId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerProxy::SuspendForFrameClosed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaPlayer::SuspendForFrameClosed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kSuspendForFrameClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_SuspendForFrameClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("SuspendForFrameClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerProxy::RequestMediaRemoting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaPlayer::RequestMediaRemoting");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kRequestMediaRemoting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestMediaRemoting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestMediaRemoting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerProxy::RequestVisibility(
    RequestVisibilityCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaPlayer::RequestVisibility");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kRequestVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestVisibility_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestVisibility");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaPlayer_RequestVisibility_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaPlayerProxy::RecordAutoPictureInPictureInfo(
    const ::media::PictureInPictureEventsInfo::AutoPipInfo& in_auto_picture_in_picture_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayer::RecordAutoPictureInPictureInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auto_picture_in_picture_info"), in_auto_picture_in_picture_info,
                        "<value of type const ::media::PictureInPictureEventsInfo::AutoPipInfo&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kRecordAutoPictureInPictureInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RecordAutoPictureInPictureInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->auto_picture_in_picture_info)::BaseType> auto_picture_in_picture_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AutoPipInfoDataView>(
    in_auto_picture_in_picture_info,
    auto_picture_in_picture_info_fragment);

  params->auto_picture_in_picture_info.Set(
      auto_picture_in_picture_info_fragment.is_null() ? nullptr : auto_picture_in_picture_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auto_picture_in_picture_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auto_picture_in_picture_info in MediaPlayer.RecordAutoPictureInPictureInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RecordAutoPictureInPictureInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class MediaPlayer_RequestVisibility_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaPlayer::RequestVisibilityCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaPlayer_RequestVisibility_ProxyToResponder> proxy(
        new MediaPlayer_RequestVisibility_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaPlayer_RequestVisibility_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaPlayer_RequestVisibility_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaPlayer_RequestVisibility_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaPlayer::RequestVisibilityCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_has_sufficiently_visible_video);
};

bool MediaPlayer_RequestVisibility_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaPlayer_RequestVisibility_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaPlayer_RequestVisibility_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaPlayer.13
  bool success = true;
  bool p_has_sufficiently_visible_video{};
  MediaPlayer_RequestVisibility_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_sufficiently_visible_video = input_data_view.has_sufficiently_visible_video();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaPlayer::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_has_sufficiently_visible_video));
  }
  return true;
}

void MediaPlayer_RequestVisibility_ProxyToResponder::Run(
    bool in_has_sufficiently_visible_video) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::MediaPlayer::RequestVisibility", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_sufficiently_visible_video"), in_has_sufficiently_visible_video,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayer::kRequestVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestVisibility_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->has_sufficiently_visible_video = in_has_sufficiently_visible_video;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestVisibility");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaPlayerStubDispatch::Accept(
    MediaPlayer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaPlayer>(message->header()->name)) {
    case messages::MediaPlayer::kRequestPlay: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestPlay_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestPlay_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.0
      bool success = true;
      MediaPlayer_RequestPlay_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPlay(        );
      return true;
    }
    case messages::MediaPlayer::kRequestPause: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestPause_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestPause_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.1
      bool success = true;
      bool p_triggered_by_user{};
      MediaPlayer_RequestPause_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_triggered_by_user = input_data_view.triggered_by_user();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPause(        
        std::move(p_triggered_by_user));
      return true;
    }
    case messages::MediaPlayer::kRequestSeekForward: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestSeekForward_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestSeekForward_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.2
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaPlayer_RequestSeekForward_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSeekForward(        
        std::move(p_seek_time));
      return true;
    }
    case messages::MediaPlayer::kRequestSeekBackward: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestSeekBackward_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestSeekBackward_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.3
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaPlayer_RequestSeekBackward_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSeekBackward(        
        std::move(p_seek_time));
      return true;
    }
    case messages::MediaPlayer::kRequestSeekTo: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestSeekTo_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestSeekTo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.4
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaPlayer_RequestSeekTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSeekTo(        
        std::move(p_seek_time));
      return true;
    }
    case messages::MediaPlayer::kRequestEnterPictureInPicture: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestEnterPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestEnterPictureInPicture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.5
      bool success = true;
      MediaPlayer_RequestEnterPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestEnterPictureInPicture(        );
      return true;
    }
    case messages::MediaPlayer::kRequestMute: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestMute_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestMute_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.6
      bool success = true;
      bool p_mute{};
      MediaPlayer_RequestMute_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_mute = input_data_view.mute();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestMute(        
        std::move(p_mute));
      return true;
    }
    case messages::MediaPlayer::kSetVolumeMultiplier: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_SetVolumeMultiplier_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_SetVolumeMultiplier_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.7
      bool success = true;
      double p_multiplier{};
      MediaPlayer_SetVolumeMultiplier_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_multiplier = input_data_view.multiplier();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVolumeMultiplier(        
        std::move(p_multiplier));
      return true;
    }
    case messages::MediaPlayer::kSetPersistentState: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_SetPersistentState_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_SetPersistentState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.8
      bool success = true;
      bool p_persistent{};
      MediaPlayer_SetPersistentState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_persistent = input_data_view.persistent();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPersistentState(        
        std::move(p_persistent));
      return true;
    }
    case messages::MediaPlayer::kSetPowerExperimentState: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_SetPowerExperimentState_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_SetPowerExperimentState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.9
      bool success = true;
      bool p_enabled{};
      MediaPlayer_SetPowerExperimentState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPowerExperimentState(        
        std::move(p_enabled));
      return true;
    }
    case messages::MediaPlayer::kSetAudioSinkId: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_SetAudioSinkId_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_SetAudioSinkId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.10
      bool success = true;
      std::string p_sink_id{};
      MediaPlayer_SetAudioSinkId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSinkId(&p_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAudioSinkId(        
        std::move(p_sink_id));
      return true;
    }
    case messages::MediaPlayer::kSuspendForFrameClosed: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_SuspendForFrameClosed_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_SuspendForFrameClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.11
      bool success = true;
      MediaPlayer_SuspendForFrameClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuspendForFrameClosed(        );
      return true;
    }
    case messages::MediaPlayer::kRequestMediaRemoting: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestMediaRemoting_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestMediaRemoting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.12
      bool success = true;
      MediaPlayer_RequestMediaRemoting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestMediaRemoting(        );
      return true;
    }
    case messages::MediaPlayer::kRequestVisibility: {
      break;
    }
    case messages::MediaPlayer::kRecordAutoPictureInPictureInfo: {
      DCHECK(message->is_serialized());
      internal::MediaPlayer_RecordAutoPictureInPictureInfo_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RecordAutoPictureInPictureInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayer.14
      bool success = true;
      ::media::PictureInPictureEventsInfo::AutoPipInfo p_auto_picture_in_picture_info{};
      MediaPlayer_RecordAutoPictureInPictureInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAutoPictureInPictureInfo(&p_auto_picture_in_picture_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordAutoPictureInPictureInfo(        
        std::move(p_auto_picture_in_picture_info));
      return true;
    }
  }
  return false;
}

// static
bool MediaPlayerStubDispatch::AcceptWithResponder(
    MediaPlayer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaPlayer>(message->header()->name)) {
    case messages::MediaPlayer::kRequestPlay: {
      break;
    }
    case messages::MediaPlayer::kRequestPause: {
      break;
    }
    case messages::MediaPlayer::kRequestSeekForward: {
      break;
    }
    case messages::MediaPlayer::kRequestSeekBackward: {
      break;
    }
    case messages::MediaPlayer::kRequestSeekTo: {
      break;
    }
    case messages::MediaPlayer::kRequestEnterPictureInPicture: {
      break;
    }
    case messages::MediaPlayer::kRequestMute: {
      break;
    }
    case messages::MediaPlayer::kSetVolumeMultiplier: {
      break;
    }
    case messages::MediaPlayer::kSetPersistentState: {
      break;
    }
    case messages::MediaPlayer::kSetPowerExperimentState: {
      break;
    }
    case messages::MediaPlayer::kSetAudioSinkId: {
      break;
    }
    case messages::MediaPlayer::kSuspendForFrameClosed: {
      break;
    }
    case messages::MediaPlayer::kRequestMediaRemoting: {
      break;
    }
    case messages::MediaPlayer::kRequestVisibility: {
      internal::MediaPlayer_RequestVisibility_Params_Data* params =
          reinterpret_cast<
              internal::MediaPlayer_RequestVisibility_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaPlayer.13
      bool success = true;
      MediaPlayer_RequestVisibility_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 13, false);
        return false;
      }
      auto callback =
          MediaPlayer_RequestVisibility_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestVisibility(std::move(callback));
      return true;
    }
    case messages::MediaPlayer::kRecordAutoPictureInPictureInfo: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaPlayerValidationInfo[] = {
    { &internal::MediaPlayer_RequestPlay_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayer_RequestPause_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayer_RequestSeekForward_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayer_RequestSeekBackward_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayer_RequestSeekTo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayer_RequestEnterPictureInPicture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayer_RequestMute_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayer_SetVolumeMultiplier_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayer_SetPersistentState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayer_SetPowerExperimentState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayer_SetAudioSinkId_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayer_SuspendForFrameClosed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayer_RequestMediaRemoting_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayer_RequestVisibility_Params_Data::Validate,
     &internal::MediaPlayer_RequestVisibility_ResponseParams_Data::Validate},
    { &internal::MediaPlayer_RecordAutoPictureInPictureInfo_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaPlayerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::MediaPlayer::Name_,
    kMediaPlayerValidationInfo);
}

bool MediaPlayerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::MediaPlayer::Name_,
    kMediaPlayerValidationInfo);
}
// The declaration includes the definition on other builds.

MediaPlayerObserverClient::IPCStableHashFunction MediaPlayerObserverClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaPlayerObserverClient>(message.name())) {
    case messages::MediaPlayerObserverClient::kGetHasPlayedBefore: {
      return &MediaPlayerObserverClient::GetHasPlayedBefore_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaPlayerObserverClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaPlayerObserverClient>(message.name())) {
      case messages::MediaPlayerObserverClient::kGetHasPlayedBefore:
            return "Receive media::mojom::MediaPlayerObserverClient::GetHasPlayedBefore";
    }
  } else {
    switch (static_cast<messages::MediaPlayerObserverClient>(message.name())) {
      case messages::MediaPlayerObserverClient::kGetHasPlayedBefore:
            return "Receive reply media::mojom::MediaPlayerObserverClient::GetHasPlayedBefore";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaPlayerObserverClient::GetHasPlayedBefore_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1b303adb;  // IPCStableHash for media::mojom::MediaPlayerObserverClient::GetHasPlayedBefore
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MediaPlayerObserverClient_GetHasPlayedBefore_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaPlayerObserverClient_GetHasPlayedBefore_ForwardToCallback(
      MediaPlayerObserverClient::GetHasPlayedBeforeCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaPlayerObserverClient_GetHasPlayedBefore_ForwardToCallback(const MediaPlayerObserverClient_GetHasPlayedBefore_ForwardToCallback&) = delete;
  MediaPlayerObserverClient_GetHasPlayedBefore_ForwardToCallback& operator=(const MediaPlayerObserverClient_GetHasPlayedBefore_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaPlayerObserverClient::GetHasPlayedBeforeCallback callback_;
};

MediaPlayerObserverClientProxy::MediaPlayerObserverClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaPlayerObserverClientProxy::GetHasPlayedBefore(
    GetHasPlayedBeforeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaPlayerObserverClient::GetHasPlayedBefore");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserverClient::kGetHasPlayedBefore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserverClient_GetHasPlayedBefore_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserverClient::Name_);
  message.set_method_name("GetHasPlayedBefore");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaPlayerObserverClient_GetHasPlayedBefore_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MediaPlayerObserverClient_GetHasPlayedBefore_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaPlayerObserverClient::GetHasPlayedBeforeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaPlayerObserverClient_GetHasPlayedBefore_ProxyToResponder> proxy(
        new MediaPlayerObserverClient_GetHasPlayedBefore_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaPlayerObserverClient_GetHasPlayedBefore_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaPlayerObserverClient_GetHasPlayedBefore_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaPlayerObserverClient_GetHasPlayedBefore_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaPlayerObserverClient::GetHasPlayedBeforeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_has_played_before);
};

bool MediaPlayerObserverClient_GetHasPlayedBefore_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaPlayerObserverClient.0
  bool success = true;
  bool p_has_played_before{};
  MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_played_before = input_data_view.has_played_before();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaPlayerObserverClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_has_played_before));
  }
  return true;
}

void MediaPlayerObserverClient_GetHasPlayedBefore_ProxyToResponder::Run(
    bool in_has_played_before) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::MediaPlayerObserverClient::GetHasPlayedBefore", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_played_before"), in_has_played_before,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserverClient::kGetHasPlayedBefore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->has_played_before = in_has_played_before;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserverClient::Name_);
  message.set_method_name("GetHasPlayedBefore");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaPlayerObserverClientStubDispatch::Accept(
    MediaPlayerObserverClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaPlayerObserverClient>(message->header()->name)) {
    case messages::MediaPlayerObserverClient::kGetHasPlayedBefore: {
      break;
    }
  }
  return false;
}

// static
bool MediaPlayerObserverClientStubDispatch::AcceptWithResponder(
    MediaPlayerObserverClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaPlayerObserverClient>(message->header()->name)) {
    case messages::MediaPlayerObserverClient::kGetHasPlayedBefore: {
      internal::MediaPlayerObserverClient_GetHasPlayedBefore_Params_Data* params =
          reinterpret_cast<
              internal::MediaPlayerObserverClient_GetHasPlayedBefore_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaPlayerObserverClient.0
      bool success = true;
      MediaPlayerObserverClient_GetHasPlayedBefore_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserverClient::Name_, 0, false);
        return false;
      }
      auto callback =
          MediaPlayerObserverClient_GetHasPlayedBefore_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHasPlayedBefore(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaPlayerObserverClientValidationInfo[] = {
    { &internal::MediaPlayerObserverClient_GetHasPlayedBefore_Params_Data::Validate,
     &internal::MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams_Data::Validate},
};

bool MediaPlayerObserverClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::MediaPlayerObserverClient::Name_,
    kMediaPlayerObserverClientValidationInfo);
}

bool MediaPlayerObserverClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::MediaPlayerObserverClient::Name_,
    kMediaPlayerObserverClientValidationInfo);
}
// The declaration includes the definition on other builds.

MediaPlayerObserver::IPCStableHashFunction MediaPlayerObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaPlayerObserver>(message.name())) {
    case messages::MediaPlayerObserver::kOnMediaPlaying: {
      return &MediaPlayerObserver::OnMediaPlaying_Sym::IPCStableHash;
    }
    case messages::MediaPlayerObserver::kOnMediaPaused: {
      return &MediaPlayerObserver::OnMediaPaused_Sym::IPCStableHash;
    }
    case messages::MediaPlayerObserver::kOnMutedStatusChanged: {
      return &MediaPlayerObserver::OnMutedStatusChanged_Sym::IPCStableHash;
    }
    case messages::MediaPlayerObserver::kOnMediaMetadataChanged: {
      return &MediaPlayerObserver::OnMediaMetadataChanged_Sym::IPCStableHash;
    }
    case messages::MediaPlayerObserver::kOnMediaPositionStateChanged: {
      return &MediaPlayerObserver::OnMediaPositionStateChanged_Sym::IPCStableHash;
    }
    case messages::MediaPlayerObserver::kOnMediaEffectivelyFullscreenChanged: {
      return &MediaPlayerObserver::OnMediaEffectivelyFullscreenChanged_Sym::IPCStableHash;
    }
    case messages::MediaPlayerObserver::kOnMediaSizeChanged: {
      return &MediaPlayerObserver::OnMediaSizeChanged_Sym::IPCStableHash;
    }
    case messages::MediaPlayerObserver::kOnPictureInPictureAvailabilityChanged: {
      return &MediaPlayerObserver::OnPictureInPictureAvailabilityChanged_Sym::IPCStableHash;
    }
    case messages::MediaPlayerObserver::kOnAudioOutputSinkChanged: {
      return &MediaPlayerObserver::OnAudioOutputSinkChanged_Sym::IPCStableHash;
    }
    case messages::MediaPlayerObserver::kOnUseAudioServiceChanged: {
      return &MediaPlayerObserver::OnUseAudioServiceChanged_Sym::IPCStableHash;
    }
    case messages::MediaPlayerObserver::kOnAudioOutputSinkChangingDisabled: {
      return &MediaPlayerObserver::OnAudioOutputSinkChangingDisabled_Sym::IPCStableHash;
    }
    case messages::MediaPlayerObserver::kOnRemotePlaybackMetadataChange: {
      return &MediaPlayerObserver::OnRemotePlaybackMetadataChange_Sym::IPCStableHash;
    }
    case messages::MediaPlayerObserver::kOnVideoVisibilityChanged: {
      return &MediaPlayerObserver::OnVideoVisibilityChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaPlayerObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaPlayerObserver>(message.name())) {
      case messages::MediaPlayerObserver::kOnMediaPlaying:
            return "Receive media::mojom::MediaPlayerObserver::OnMediaPlaying";
      case messages::MediaPlayerObserver::kOnMediaPaused:
            return "Receive media::mojom::MediaPlayerObserver::OnMediaPaused";
      case messages::MediaPlayerObserver::kOnMutedStatusChanged:
            return "Receive media::mojom::MediaPlayerObserver::OnMutedStatusChanged";
      case messages::MediaPlayerObserver::kOnMediaMetadataChanged:
            return "Receive media::mojom::MediaPlayerObserver::OnMediaMetadataChanged";
      case messages::MediaPlayerObserver::kOnMediaPositionStateChanged:
            return "Receive media::mojom::MediaPlayerObserver::OnMediaPositionStateChanged";
      case messages::MediaPlayerObserver::kOnMediaEffectivelyFullscreenChanged:
            return "Receive media::mojom::MediaPlayerObserver::OnMediaEffectivelyFullscreenChanged";
      case messages::MediaPlayerObserver::kOnMediaSizeChanged:
            return "Receive media::mojom::MediaPlayerObserver::OnMediaSizeChanged";
      case messages::MediaPlayerObserver::kOnPictureInPictureAvailabilityChanged:
            return "Receive media::mojom::MediaPlayerObserver::OnPictureInPictureAvailabilityChanged";
      case messages::MediaPlayerObserver::kOnAudioOutputSinkChanged:
            return "Receive media::mojom::MediaPlayerObserver::OnAudioOutputSinkChanged";
      case messages::MediaPlayerObserver::kOnUseAudioServiceChanged:
            return "Receive media::mojom::MediaPlayerObserver::OnUseAudioServiceChanged";
      case messages::MediaPlayerObserver::kOnAudioOutputSinkChangingDisabled:
            return "Receive media::mojom::MediaPlayerObserver::OnAudioOutputSinkChangingDisabled";
      case messages::MediaPlayerObserver::kOnRemotePlaybackMetadataChange:
            return "Receive media::mojom::MediaPlayerObserver::OnRemotePlaybackMetadataChange";
      case messages::MediaPlayerObserver::kOnVideoVisibilityChanged:
            return "Receive media::mojom::MediaPlayerObserver::OnVideoVisibilityChanged";
    }
  } else {
    switch (static_cast<messages::MediaPlayerObserver>(message.name())) {
      case messages::MediaPlayerObserver::kOnMediaPlaying:
            return "Receive reply media::mojom::MediaPlayerObserver::OnMediaPlaying";
      case messages::MediaPlayerObserver::kOnMediaPaused:
            return "Receive reply media::mojom::MediaPlayerObserver::OnMediaPaused";
      case messages::MediaPlayerObserver::kOnMutedStatusChanged:
            return "Receive reply media::mojom::MediaPlayerObserver::OnMutedStatusChanged";
      case messages::MediaPlayerObserver::kOnMediaMetadataChanged:
            return "Receive reply media::mojom::MediaPlayerObserver::OnMediaMetadataChanged";
      case messages::MediaPlayerObserver::kOnMediaPositionStateChanged:
            return "Receive reply media::mojom::MediaPlayerObserver::OnMediaPositionStateChanged";
      case messages::MediaPlayerObserver::kOnMediaEffectivelyFullscreenChanged:
            return "Receive reply media::mojom::MediaPlayerObserver::OnMediaEffectivelyFullscreenChanged";
      case messages::MediaPlayerObserver::kOnMediaSizeChanged:
            return "Receive reply media::mojom::MediaPlayerObserver::OnMediaSizeChanged";
      case messages::MediaPlayerObserver::kOnPictureInPictureAvailabilityChanged:
            return "Receive reply media::mojom::MediaPlayerObserver::OnPictureInPictureAvailabilityChanged";
      case messages::MediaPlayerObserver::kOnAudioOutputSinkChanged:
            return "Receive reply media::mojom::MediaPlayerObserver::OnAudioOutputSinkChanged";
      case messages::MediaPlayerObserver::kOnUseAudioServiceChanged:
            return "Receive reply media::mojom::MediaPlayerObserver::OnUseAudioServiceChanged";
      case messages::MediaPlayerObserver::kOnAudioOutputSinkChangingDisabled:
            return "Receive reply media::mojom::MediaPlayerObserver::OnAudioOutputSinkChangingDisabled";
      case messages::MediaPlayerObserver::kOnRemotePlaybackMetadataChange:
            return "Receive reply media::mojom::MediaPlayerObserver::OnRemotePlaybackMetadataChange";
      case messages::MediaPlayerObserver::kOnVideoVisibilityChanged:
            return "Receive reply media::mojom::MediaPlayerObserver::OnVideoVisibilityChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaPlayerObserver::OnMediaPlaying_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6a3ba49c;  // IPCStableHash for media::mojom::MediaPlayerObserver::OnMediaPlaying
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayerObserver::OnMediaPaused_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf78b3b40;  // IPCStableHash for media::mojom::MediaPlayerObserver::OnMediaPaused
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayerObserver::OnMutedStatusChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x204133bf;  // IPCStableHash for media::mojom::MediaPlayerObserver::OnMutedStatusChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayerObserver::OnMediaMetadataChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b025ced;  // IPCStableHash for media::mojom::MediaPlayerObserver::OnMediaMetadataChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayerObserver::OnMediaPositionStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9e8715fc;  // IPCStableHash for media::mojom::MediaPlayerObserver::OnMediaPositionStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayerObserver::OnMediaEffectivelyFullscreenChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdfb9a47c;  // IPCStableHash for media::mojom::MediaPlayerObserver::OnMediaEffectivelyFullscreenChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayerObserver::OnMediaSizeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8d53ab4d;  // IPCStableHash for media::mojom::MediaPlayerObserver::OnMediaSizeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayerObserver::OnPictureInPictureAvailabilityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc270ad08;  // IPCStableHash for media::mojom::MediaPlayerObserver::OnPictureInPictureAvailabilityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayerObserver::OnAudioOutputSinkChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f478d0b;  // IPCStableHash for media::mojom::MediaPlayerObserver::OnAudioOutputSinkChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayerObserver::OnUseAudioServiceChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2db0fd8f;  // IPCStableHash for media::mojom::MediaPlayerObserver::OnUseAudioServiceChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayerObserver::OnAudioOutputSinkChangingDisabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e840be7;  // IPCStableHash for media::mojom::MediaPlayerObserver::OnAudioOutputSinkChangingDisabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayerObserver::OnRemotePlaybackMetadataChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdcee109b;  // IPCStableHash for media::mojom::MediaPlayerObserver::OnRemotePlaybackMetadataChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayerObserver::OnVideoVisibilityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcce69453;  // IPCStableHash for media::mojom::MediaPlayerObserver::OnVideoVisibilityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaPlayerObserverProxy::MediaPlayerObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaPlayerObserverProxy::OnMediaPlaying(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaPlayerObserver::OnMediaPlaying");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserver::kOnMediaPlaying), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMediaPlaying_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMediaPlaying");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerObserverProxy::OnMediaPaused(
    bool in_stream_ended) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerObserver::OnMediaPaused", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_ended"), in_stream_ended,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserver::kOnMediaPaused), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMediaPaused_Params_Data> params(
          message);
  params.Allocate();

  params->stream_ended = in_stream_ended;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMediaPaused");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerObserverProxy::OnMutedStatusChanged(
    bool in_muted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerObserver::OnMutedStatusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("muted"), in_muted,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserver::kOnMutedStatusChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMutedStatusChanged_Params_Data> params(
          message);
  params.Allocate();

  params->muted = in_muted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMutedStatusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerObserverProxy::OnMediaMetadataChanged(
    bool in_has_audio, bool in_has_video, ::media::MediaContentType in_content_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerObserver::OnMediaMetadataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_audio"), in_has_audio,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_video"), in_has_video,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_type"), in_content_type,
                        "<value of type ::media::MediaContentType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserver::kOnMediaMetadataChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMediaMetadataChanged_Params_Data> params(
          message);
  params.Allocate();

  params->has_audio = in_has_audio;

  params->has_video = in_has_video;

  
  mojo::internal::Serialize<::media::mojom::MediaContentType>(
    in_content_type,
    &params->content_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMediaMetadataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerObserverProxy::OnMediaPositionStateChanged(
    const ::media_session::MediaPosition& in_media_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerObserver::OnMediaPositionStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_position"), in_media_position,
                        "<value of type const ::media_session::MediaPosition&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserver::kOnMediaPositionStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMediaPositionStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->media_position)::BaseType> media_position_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaPositionDataView>(
    in_media_position,
    media_position_fragment);

  params->media_position.Set(
      media_position_fragment.is_null() ? nullptr : media_position_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->media_position.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null media_position in MediaPlayerObserver.OnMediaPositionStateChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMediaPositionStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerObserverProxy::OnMediaEffectivelyFullscreenChanged(
    ::blink::WebFullscreenVideoStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerObserver::OnMediaEffectivelyFullscreenChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::WebFullscreenVideoStatus>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserver::kOnMediaEffectivelyFullscreenChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::FullscreenVideoStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMediaEffectivelyFullscreenChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerObserverProxy::OnMediaSizeChanged(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerObserver::OnMediaSizeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserver::kOnMediaSizeChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMediaSizeChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null size in MediaPlayerObserver.OnMediaSizeChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMediaSizeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerObserverProxy::OnPictureInPictureAvailabilityChanged(
    bool in_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerObserver::OnPictureInPictureAvailabilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("available"), in_available,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserver::kOnPictureInPictureAvailabilityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params_Data> params(
          message);
  params.Allocate();

  params->available = in_available;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnPictureInPictureAvailabilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerObserverProxy::OnAudioOutputSinkChanged(
    const std::string& in_hashed_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerObserver::OnAudioOutputSinkChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hashed_device_id"), in_hashed_device_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserver::kOnAudioOutputSinkChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnAudioOutputSinkChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hashed_device_id)::BaseType> hashed_device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_hashed_device_id,
    hashed_device_id_fragment);

  params->hashed_device_id.Set(
      hashed_device_id_fragment.is_null() ? nullptr : hashed_device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->hashed_device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null hashed_device_id in MediaPlayerObserver.OnAudioOutputSinkChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnAudioOutputSinkChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerObserverProxy::OnUseAudioServiceChanged(
    bool in_uses_audio_service) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerObserver::OnUseAudioServiceChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uses_audio_service"), in_uses_audio_service,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserver::kOnUseAudioServiceChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnUseAudioServiceChanged_Params_Data> params(
          message);
  params.Allocate();

  params->uses_audio_service = in_uses_audio_service;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnUseAudioServiceChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerObserverProxy::OnAudioOutputSinkChangingDisabled(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaPlayerObserver::OnAudioOutputSinkChangingDisabled");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserver::kOnAudioOutputSinkChangingDisabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnAudioOutputSinkChangingDisabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerObserverProxy::OnRemotePlaybackMetadataChange(
    ::media_session::mojom::RemotePlaybackMetadataPtr in_remote_playback_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerObserver::OnRemotePlaybackMetadataChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_playback_metadata"), in_remote_playback_metadata,
                        "<value of type ::media_session::mojom::RemotePlaybackMetadataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserver::kOnRemotePlaybackMetadataChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->remote_playback_metadata)::BaseType> remote_playback_metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::RemotePlaybackMetadataDataView>(
    in_remote_playback_metadata,
    remote_playback_metadata_fragment);

  params->remote_playback_metadata.Set(
      remote_playback_metadata_fragment.is_null() ? nullptr : remote_playback_metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->remote_playback_metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null remote_playback_metadata in MediaPlayerObserver.OnRemotePlaybackMetadataChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnRemotePlaybackMetadataChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerObserverProxy::OnVideoVisibilityChanged(
    bool in_meets_visibility_threshold) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerObserver::OnVideoVisibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("meets_visibility_threshold"), in_meets_visibility_threshold,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerObserver::kOnVideoVisibilityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnVideoVisibilityChanged_Params_Data> params(
          message);
  params.Allocate();

  params->meets_visibility_threshold = in_meets_visibility_threshold;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnVideoVisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaPlayerObserverStubDispatch::Accept(
    MediaPlayerObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaPlayerObserver>(message->header()->name)) {
    case messages::MediaPlayerObserver::kOnMediaPlaying: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMediaPlaying_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMediaPlaying_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerObserver.0
      bool success = true;
      MediaPlayerObserver_OnMediaPlaying_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaPlaying(        );
      return true;
    }
    case messages::MediaPlayerObserver::kOnMediaPaused: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMediaPaused_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMediaPaused_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerObserver.1
      bool success = true;
      bool p_stream_ended{};
      MediaPlayerObserver_OnMediaPaused_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_ended = input_data_view.stream_ended();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaPaused(        
        std::move(p_stream_ended));
      return true;
    }
    case messages::MediaPlayerObserver::kOnMutedStatusChanged: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMutedStatusChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMutedStatusChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerObserver.2
      bool success = true;
      bool p_muted{};
      MediaPlayerObserver_OnMutedStatusChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_muted = input_data_view.muted();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMutedStatusChanged(        
        std::move(p_muted));
      return true;
    }
    case messages::MediaPlayerObserver::kOnMediaMetadataChanged: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMediaMetadataChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMediaMetadataChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerObserver.3
      bool success = true;
      bool p_has_audio{};
      bool p_has_video{};
      ::media::MediaContentType p_content_type{};
      MediaPlayerObserver_OnMediaMetadataChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_has_audio = input_data_view.has_audio();
      if (success)
        p_has_video = input_data_view.has_video();
      if (success && !input_data_view.ReadContentType(&p_content_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaMetadataChanged(        
        std::move(p_has_audio), 
        std::move(p_has_video), 
        std::move(p_content_type));
      return true;
    }
    case messages::MediaPlayerObserver::kOnMediaPositionStateChanged: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMediaPositionStateChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMediaPositionStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerObserver.4
      bool success = true;
      ::media_session::MediaPosition p_media_position{};
      MediaPlayerObserver_OnMediaPositionStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMediaPosition(&p_media_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaPositionStateChanged(        
        std::move(p_media_position));
      return true;
    }
    case messages::MediaPlayerObserver::kOnMediaEffectivelyFullscreenChanged: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerObserver.5
      bool success = true;
      ::blink::WebFullscreenVideoStatus p_status{};
      MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaEffectivelyFullscreenChanged(        
        std::move(p_status));
      return true;
    }
    case messages::MediaPlayerObserver::kOnMediaSizeChanged: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMediaSizeChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMediaSizeChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerObserver.6
      bool success = true;
      ::gfx::Size p_size{};
      MediaPlayerObserver_OnMediaSizeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaSizeChanged(        
        std::move(p_size));
      return true;
    }
    case messages::MediaPlayerObserver::kOnPictureInPictureAvailabilityChanged: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerObserver.7
      bool success = true;
      bool p_available{};
      MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_available = input_data_view.available();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPictureInPictureAvailabilityChanged(        
        std::move(p_available));
      return true;
    }
    case messages::MediaPlayerObserver::kOnAudioOutputSinkChanged: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnAudioOutputSinkChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnAudioOutputSinkChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerObserver.8
      bool success = true;
      std::string p_hashed_device_id{};
      MediaPlayerObserver_OnAudioOutputSinkChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHashedDeviceId(&p_hashed_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAudioOutputSinkChanged(        
        std::move(p_hashed_device_id));
      return true;
    }
    case messages::MediaPlayerObserver::kOnUseAudioServiceChanged: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnUseAudioServiceChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnUseAudioServiceChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerObserver.9
      bool success = true;
      bool p_uses_audio_service{};
      MediaPlayerObserver_OnUseAudioServiceChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_uses_audio_service = input_data_view.uses_audio_service();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUseAudioServiceChanged(        
        std::move(p_uses_audio_service));
      return true;
    }
    case messages::MediaPlayerObserver::kOnAudioOutputSinkChangingDisabled: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerObserver.10
      bool success = true;
      MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAudioOutputSinkChangingDisabled(        );
      return true;
    }
    case messages::MediaPlayerObserver::kOnRemotePlaybackMetadataChange: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerObserver.11
      bool success = true;
      ::media_session::mojom::RemotePlaybackMetadataPtr p_remote_playback_metadata{};
      MediaPlayerObserver_OnRemotePlaybackMetadataChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRemotePlaybackMetadata(&p_remote_playback_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRemotePlaybackMetadataChange(        
        std::move(p_remote_playback_metadata));
      return true;
    }
    case messages::MediaPlayerObserver::kOnVideoVisibilityChanged: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnVideoVisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnVideoVisibilityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerObserver.12
      bool success = true;
      bool p_meets_visibility_threshold{};
      MediaPlayerObserver_OnVideoVisibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_meets_visibility_threshold = input_data_view.meets_visibility_threshold();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVideoVisibilityChanged(        
        std::move(p_meets_visibility_threshold));
      return true;
    }
  }
  return false;
}

// static
bool MediaPlayerObserverStubDispatch::AcceptWithResponder(
    MediaPlayerObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaPlayerObserver>(message->header()->name)) {
    case messages::MediaPlayerObserver::kOnMediaPlaying: {
      break;
    }
    case messages::MediaPlayerObserver::kOnMediaPaused: {
      break;
    }
    case messages::MediaPlayerObserver::kOnMutedStatusChanged: {
      break;
    }
    case messages::MediaPlayerObserver::kOnMediaMetadataChanged: {
      break;
    }
    case messages::MediaPlayerObserver::kOnMediaPositionStateChanged: {
      break;
    }
    case messages::MediaPlayerObserver::kOnMediaEffectivelyFullscreenChanged: {
      break;
    }
    case messages::MediaPlayerObserver::kOnMediaSizeChanged: {
      break;
    }
    case messages::MediaPlayerObserver::kOnPictureInPictureAvailabilityChanged: {
      break;
    }
    case messages::MediaPlayerObserver::kOnAudioOutputSinkChanged: {
      break;
    }
    case messages::MediaPlayerObserver::kOnUseAudioServiceChanged: {
      break;
    }
    case messages::MediaPlayerObserver::kOnAudioOutputSinkChangingDisabled: {
      break;
    }
    case messages::MediaPlayerObserver::kOnRemotePlaybackMetadataChange: {
      break;
    }
    case messages::MediaPlayerObserver::kOnVideoVisibilityChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaPlayerObserverValidationInfo[] = {
    { &internal::MediaPlayerObserver_OnMediaPlaying_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayerObserver_OnMediaPaused_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayerObserver_OnMutedStatusChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayerObserver_OnMediaMetadataChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayerObserver_OnMediaPositionStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayerObserver_OnMediaSizeChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayerObserver_OnAudioOutputSinkChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayerObserver_OnUseAudioServiceChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaPlayerObserver_OnVideoVisibilityChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaPlayerObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::MediaPlayerObserver::Name_,
    kMediaPlayerObserverValidationInfo);
}

// The declaration includes the definition on other builds.

MediaPlayerHost::IPCStableHashFunction MediaPlayerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaPlayerHost>(message.name())) {
    case messages::MediaPlayerHost::kOnMediaPlayerAdded: {
      return &MediaPlayerHost::OnMediaPlayerAdded_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaPlayerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaPlayerHost>(message.name())) {
      case messages::MediaPlayerHost::kOnMediaPlayerAdded:
            return "Receive media::mojom::MediaPlayerHost::OnMediaPlayerAdded";
    }
  } else {
    switch (static_cast<messages::MediaPlayerHost>(message.name())) {
      case messages::MediaPlayerHost::kOnMediaPlayerAdded:
            return "Receive reply media::mojom::MediaPlayerHost::OnMediaPlayerAdded";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaPlayerHost::OnMediaPlayerAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6ada5f80;  // IPCStableHash for media::mojom::MediaPlayerHost::OnMediaPlayerAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaPlayerHostProxy::MediaPlayerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaPlayerHostProxy::OnMediaPlayerAdded(
    ::mojo::PendingAssociatedRemote<MediaPlayer> in_player_remote, ::mojo::PendingAssociatedReceiver<MediaPlayerObserver> in_observer, int32_t in_player_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerHost::OnMediaPlayerAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("player_remote"), in_player_remote,
                        "<value of type ::mojo::PendingAssociatedRemote<MediaPlayer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingAssociatedReceiver<MediaPlayerObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("player_id"), in_player_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerHost::kOnMediaPlayerAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerHost_OnMediaPlayerAdded_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::MediaPlayerAssociatedPtrInfoDataView>(
    in_player_remote,
    &params->player_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->player_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid player_remote in MediaPlayerHost.OnMediaPlayerAdded request");

  
  mojo::internal::Serialize<::media::mojom::MediaPlayerObserverAssociatedRequestDataView>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid observer in MediaPlayerHost.OnMediaPlayerAdded request");

  params->player_id = in_player_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerHost::Name_);
  message.set_method_name("OnMediaPlayerAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaPlayerHostStubDispatch::Accept(
    MediaPlayerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaPlayerHost>(message->header()->name)) {
    case messages::MediaPlayerHost::kOnMediaPlayerAdded: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerHost_OnMediaPlayerAdded_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerHost_OnMediaPlayerAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaPlayerHost.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<MediaPlayer> p_player_remote{};
      ::mojo::PendingAssociatedReceiver<MediaPlayerObserver> p_observer{};
      int32_t p_player_id{};
      MediaPlayerHost_OnMediaPlayerAdded_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_player_remote =
            input_data_view.TakePlayerRemote<decltype(p_player_remote)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success)
        p_player_id = input_data_view.player_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaPlayerAdded(        
        std::move(p_player_remote), 
        std::move(p_observer), 
        std::move(p_player_id));
      return true;
    }
  }
  return false;
}

// static
bool MediaPlayerHostStubDispatch::AcceptWithResponder(
    MediaPlayerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaPlayerHost>(message->header()->name)) {
    case messages::MediaPlayerHost::kOnMediaPlayerAdded: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaPlayerHostValidationInfo[] = {
    { &internal::MediaPlayerHost_OnMediaPlayerAdded_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaPlayerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::MediaPlayerHost::Name_,
    kMediaPlayerHostValidationInfo);
}



}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void MediaPlayerInterceptorForTesting::RequestPlay() {
  GetForwardingInterface()->RequestPlay();
}
void MediaPlayerInterceptorForTesting::RequestPause(bool triggered_by_user) {
  GetForwardingInterface()->RequestPause(
    std::move(triggered_by_user)
    );
}
void MediaPlayerInterceptorForTesting::RequestSeekForward(::base::TimeDelta seek_time) {
  GetForwardingInterface()->RequestSeekForward(
    std::move(seek_time)
    );
}
void MediaPlayerInterceptorForTesting::RequestSeekBackward(::base::TimeDelta seek_time) {
  GetForwardingInterface()->RequestSeekBackward(
    std::move(seek_time)
    );
}
void MediaPlayerInterceptorForTesting::RequestSeekTo(::base::TimeDelta seek_time) {
  GetForwardingInterface()->RequestSeekTo(
    std::move(seek_time)
    );
}
void MediaPlayerInterceptorForTesting::RequestEnterPictureInPicture() {
  GetForwardingInterface()->RequestEnterPictureInPicture();
}
void MediaPlayerInterceptorForTesting::RequestMute(bool mute) {
  GetForwardingInterface()->RequestMute(
    std::move(mute)
    );
}
void MediaPlayerInterceptorForTesting::SetVolumeMultiplier(double multiplier) {
  GetForwardingInterface()->SetVolumeMultiplier(
    std::move(multiplier)
    );
}
void MediaPlayerInterceptorForTesting::SetPersistentState(bool persistent) {
  GetForwardingInterface()->SetPersistentState(
    std::move(persistent)
    );
}
void MediaPlayerInterceptorForTesting::SetPowerExperimentState(bool enabled) {
  GetForwardingInterface()->SetPowerExperimentState(
    std::move(enabled)
    );
}
void MediaPlayerInterceptorForTesting::SetAudioSinkId(const std::string& sink_id) {
  GetForwardingInterface()->SetAudioSinkId(
    std::move(sink_id)
    );
}
void MediaPlayerInterceptorForTesting::SuspendForFrameClosed() {
  GetForwardingInterface()->SuspendForFrameClosed();
}
void MediaPlayerInterceptorForTesting::RequestMediaRemoting() {
  GetForwardingInterface()->RequestMediaRemoting();
}
void MediaPlayerInterceptorForTesting::RequestVisibility(RequestVisibilityCallback callback) {
  GetForwardingInterface()->RequestVisibility(std::move(callback));
}
void MediaPlayerInterceptorForTesting::RecordAutoPictureInPictureInfo(const ::media::PictureInPictureEventsInfo::AutoPipInfo& auto_picture_in_picture_info) {
  GetForwardingInterface()->RecordAutoPictureInPictureInfo(
    std::move(auto_picture_in_picture_info)
    );
}
MediaPlayerAsyncWaiter::MediaPlayerAsyncWaiter(
    MediaPlayer* proxy) : proxy_(proxy) {}

MediaPlayerAsyncWaiter::~MediaPlayerAsyncWaiter() = default;


void MediaPlayerAsyncWaiter::RequestVisibility(
    bool* out_has_sufficiently_visible_video) {
  base::RunLoop loop;
  proxy_->RequestVisibility(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_sufficiently_visible_video
,
             bool has_sufficiently_visible_video) {*out_has_sufficiently_visible_video = std::move(has_sufficiently_visible_video);
            loop->Quit();
          },
          &loop,
          out_has_sufficiently_visible_video));
  loop.Run();
}

bool MediaPlayerAsyncWaiter::RequestVisibility(
    ) {
  bool async_wait_result;
  RequestVisibility(&async_wait_result);
  return async_wait_result;
}




void MediaPlayerObserverClientInterceptorForTesting::GetHasPlayedBefore(GetHasPlayedBeforeCallback callback) {
  GetForwardingInterface()->GetHasPlayedBefore(std::move(callback));
}
MediaPlayerObserverClientAsyncWaiter::MediaPlayerObserverClientAsyncWaiter(
    MediaPlayerObserverClient* proxy) : proxy_(proxy) {}

MediaPlayerObserverClientAsyncWaiter::~MediaPlayerObserverClientAsyncWaiter() = default;


void MediaPlayerObserverClientAsyncWaiter::GetHasPlayedBefore(
    bool* out_has_played_before) {
  base::RunLoop loop;
  proxy_->GetHasPlayedBefore(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_played_before
,
             bool has_played_before) {*out_has_played_before = std::move(has_played_before);
            loop->Quit();
          },
          &loop,
          out_has_played_before));
  loop.Run();
}

bool MediaPlayerObserverClientAsyncWaiter::GetHasPlayedBefore(
    ) {
  bool async_wait_result;
  GetHasPlayedBefore(&async_wait_result);
  return async_wait_result;
}




void MediaPlayerObserverInterceptorForTesting::OnMediaPlaying() {
  GetForwardingInterface()->OnMediaPlaying();
}
void MediaPlayerObserverInterceptorForTesting::OnMediaPaused(bool stream_ended) {
  GetForwardingInterface()->OnMediaPaused(
    std::move(stream_ended)
    );
}
void MediaPlayerObserverInterceptorForTesting::OnMutedStatusChanged(bool muted) {
  GetForwardingInterface()->OnMutedStatusChanged(
    std::move(muted)
    );
}
void MediaPlayerObserverInterceptorForTesting::OnMediaMetadataChanged(bool has_audio, bool has_video, ::media::MediaContentType content_type) {
  GetForwardingInterface()->OnMediaMetadataChanged(
    std::move(has_audio)
    , 
    std::move(has_video)
    , 
    std::move(content_type)
    );
}
void MediaPlayerObserverInterceptorForTesting::OnMediaPositionStateChanged(const ::media_session::MediaPosition& media_position) {
  GetForwardingInterface()->OnMediaPositionStateChanged(
    std::move(media_position)
    );
}
void MediaPlayerObserverInterceptorForTesting::OnMediaEffectivelyFullscreenChanged(::blink::WebFullscreenVideoStatus status) {
  GetForwardingInterface()->OnMediaEffectivelyFullscreenChanged(
    std::move(status)
    );
}
void MediaPlayerObserverInterceptorForTesting::OnMediaSizeChanged(const ::gfx::Size& size) {
  GetForwardingInterface()->OnMediaSizeChanged(
    std::move(size)
    );
}
void MediaPlayerObserverInterceptorForTesting::OnPictureInPictureAvailabilityChanged(bool available) {
  GetForwardingInterface()->OnPictureInPictureAvailabilityChanged(
    std::move(available)
    );
}
void MediaPlayerObserverInterceptorForTesting::OnAudioOutputSinkChanged(const std::string& hashed_device_id) {
  GetForwardingInterface()->OnAudioOutputSinkChanged(
    std::move(hashed_device_id)
    );
}
void MediaPlayerObserverInterceptorForTesting::OnUseAudioServiceChanged(bool uses_audio_service) {
  GetForwardingInterface()->OnUseAudioServiceChanged(
    std::move(uses_audio_service)
    );
}
void MediaPlayerObserverInterceptorForTesting::OnAudioOutputSinkChangingDisabled() {
  GetForwardingInterface()->OnAudioOutputSinkChangingDisabled();
}
void MediaPlayerObserverInterceptorForTesting::OnRemotePlaybackMetadataChange(::media_session::mojom::RemotePlaybackMetadataPtr remote_playback_metadata) {
  GetForwardingInterface()->OnRemotePlaybackMetadataChange(
    std::move(remote_playback_metadata)
    );
}
void MediaPlayerObserverInterceptorForTesting::OnVideoVisibilityChanged(bool meets_visibility_threshold) {
  GetForwardingInterface()->OnVideoVisibilityChanged(
    std::move(meets_visibility_threshold)
    );
}
MediaPlayerObserverAsyncWaiter::MediaPlayerObserverAsyncWaiter(
    MediaPlayerObserver* proxy) : proxy_(proxy) {}

MediaPlayerObserverAsyncWaiter::~MediaPlayerObserverAsyncWaiter() = default;





void MediaPlayerHostInterceptorForTesting::OnMediaPlayerAdded(::mojo::PendingAssociatedRemote<MediaPlayer> player_remote, ::mojo::PendingAssociatedReceiver<MediaPlayerObserver> observer, int32_t player_id) {
  GetForwardingInterface()->OnMediaPlayerAdded(
    std::move(player_remote)
    , 
    std::move(observer)
    , 
    std::move(player_id)
    );
}
MediaPlayerHostAsyncWaiter::MediaPlayerHostAsyncWaiter(
    MediaPlayerHost* proxy) : proxy_(proxy) {}

MediaPlayerHostAsyncWaiter::~MediaPlayerHostAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif