// media/mojo/mojom/media_log.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/media_log.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', 'media_types.mojom.js');
  }



  function MediaLog_AddLogRecord_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaLog_AddLogRecord_Params.prototype.initDefaults_ = function() {
    this.event = null;
  };
  MediaLog_AddLogRecord_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaLog_AddLogRecord_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaLog_AddLogRecord_Params.event
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.MediaLogRecord, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaLog_AddLogRecord_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaLog_AddLogRecord_Params.decode = function(decoder) {
    var packed;
    var val = new MediaLog_AddLogRecord_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.event =
        decoder.decodeStructPointer(media_types$.MediaLogRecord);
    return val;
  };

  MediaLog_AddLogRecord_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaLog_AddLogRecord_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.MediaLogRecord, val.event);
  };
  var kMediaLog_AddLogRecord_Name = 0;

  function MediaLogPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaLog,
                                                   handleOrPtrInfo);
  }

  function MediaLogAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaLog, associatedInterfacePtrInfo);
  }

  MediaLogAssociatedPtr.prototype =
      Object.create(MediaLogPtr.prototype);
  MediaLogAssociatedPtr.prototype.constructor =
      MediaLogAssociatedPtr;

  function MediaLogProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaLogPtr.prototype.addLogRecord = function() {
    return MediaLogProxy.prototype.addLogRecord
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaLogProxy.prototype.addLogRecord = function(event) {
    var params_ = new MediaLog_AddLogRecord_Params();
    params_.event = event;
    var builder = new codec.MessageV0Builder(
        kMediaLog_AddLogRecord_Name,
        codec.align(MediaLog_AddLogRecord_Params.encodedSize));
    builder.encodeStruct(MediaLog_AddLogRecord_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function MediaLogStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaLogStub.prototype.addLogRecord = function(event) {
    return this.delegate_ && this.delegate_.addLogRecord && this.delegate_.addLogRecord(event);
  }

  MediaLogStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaLog_AddLogRecord_Name:
      var params = reader.decodeStruct(MediaLog_AddLogRecord_Params);
      this.addLogRecord(params.event);
      return true;
    default:
      return false;
    }
  };

  MediaLogStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateMediaLogRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaLog_AddLogRecord_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaLog_AddLogRecord_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaLogResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var MediaLog = {
    name: 'media.mojom.MediaLog',
    kVersion: 0,
    ptrClass: MediaLogPtr,
    proxyClass: MediaLogProxy,
    stubClass: MediaLogStub,
    validateRequest: validateMediaLogRequest,
    validateResponse: null,
  };
  MediaLogStub.prototype.validator = validateMediaLogRequest;
  MediaLogProxy.prototype.validator = null;
  exports.MediaLog = MediaLog;
  exports.MediaLogPtr = MediaLogPtr;
  exports.MediaLogAssociatedPtr = MediaLogAssociatedPtr;
})();