// media/mojo/mojom/key_system_support.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/key_system_support.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var content_decryption_module$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/content_decryption_module.mojom', 'content_decryption_module.mojom.js');
  }
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', 'media_types.mojom.js');
  }
  var version$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/version.mojom', '../../../mojo/public/mojom/base/version.mojom.js');
  }


  var CdmCapabilityQueryStatus = {};
  CdmCapabilityQueryStatus.kSuccess = 0;
  CdmCapabilityQueryStatus.kUnknown = 1;
  CdmCapabilityQueryStatus.kHardwareSecureCodecNotSupported = 2;
  CdmCapabilityQueryStatus.kNoSupportedVideoCodec = 3;
  CdmCapabilityQueryStatus.kNoSupportedEncryptionScheme = 4;
  CdmCapabilityQueryStatus.kUnsupportedKeySystem = 5;
  CdmCapabilityQueryStatus.kMediaFoundationCdmNotSupported = 6;
  CdmCapabilityQueryStatus.kDisconnectionError = 7;
  CdmCapabilityQueryStatus.kMediaFoundationGetCdmFactoryFailed = 8;
  CdmCapabilityQueryStatus.kCreateDummyMediaFoundationCdmFailed = 9;
  CdmCapabilityQueryStatus.kUnexpectedEmptyCapability = 10;
  CdmCapabilityQueryStatus.kNoMediaDrmSupport = 11;
  CdmCapabilityQueryStatus.kMediaFoundationGetExtendedDRMTypeSupportFailed = 12;
  CdmCapabilityQueryStatus.MIN_VALUE = 0;
  CdmCapabilityQueryStatus.MAX_VALUE = 12;

  CdmCapabilityQueryStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
      return true;
    }
    return false;
  };

  CdmCapabilityQueryStatus.toKnownEnumValue = function(value) {
    return value;
  };

  CdmCapabilityQueryStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function VideoCodecInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoCodecInfo.prototype.initDefaults_ = function() {
    this.supportedProfiles = null;
    this.supportsClearLead = true;
  };
  VideoCodecInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoCodecInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCodecInfo.supportedProfiles
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(media_types$.VideoCodecProfile), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VideoCodecInfo.encodedSize = codec.kStructHeaderSize + 16;

  VideoCodecInfo.decode = function(decoder) {
    var packed;
    var val = new VideoCodecInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.supportedProfiles =
        decoder.decodeArrayPointer(new codec.Enum(media_types$.VideoCodecProfile));
    packed = decoder.readUint8();
    val.supportsClearLead = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoCodecInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoCodecInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(media_types$.VideoCodecProfile), val.supportedProfiles);
    packed = 0;
    packed |= (val.supportsClearLead & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CdmCapability(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmCapability.prototype.initDefaults_ = function() {
    this.audioCodecs = null;
    this.videoCodecs = null;
    this.encryptionSchemes = null;
    this.sessionTypes = null;
    this.version = null;
  };
  CdmCapability.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmCapability.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmCapability.audioCodecs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(media_types$.AudioCodec), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmCapability.videoCodecs
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, new codec.Enum(media_types$.VideoCodec), new codec.PointerTo(VideoCodecInfo), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmCapability.encryptionSchemes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, new codec.Enum(media_types$.EncryptionScheme), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmCapability.sessionTypes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 4, new codec.Enum(content_decryption_module$.CdmSessionType), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmCapability.version
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, version$.Version, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmCapability.encodedSize = codec.kStructHeaderSize + 40;

  CdmCapability.decode = function(decoder) {
    var packed;
    var val = new CdmCapability();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.audioCodecs =
        decoder.decodeArrayPointer(new codec.Enum(media_types$.AudioCodec));
    val.videoCodecs =
        decoder.decodeMapPointer(new codec.Enum(media_types$.VideoCodec), new codec.PointerTo(VideoCodecInfo));
    val.encryptionSchemes =
        decoder.decodeArrayPointer(new codec.Enum(media_types$.EncryptionScheme));
    val.sessionTypes =
        decoder.decodeArrayPointer(new codec.Enum(content_decryption_module$.CdmSessionType));
    val.version =
        decoder.decodeStructPointer(version$.Version);
    return val;
  };

  CdmCapability.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmCapability.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(media_types$.AudioCodec), val.audioCodecs);
    encoder.encodeMapPointer(new codec.Enum(media_types$.VideoCodec), new codec.PointerTo(VideoCodecInfo), val.videoCodecs);
    encoder.encodeArrayPointer(new codec.Enum(media_types$.EncryptionScheme), val.encryptionSchemes);
    encoder.encodeArrayPointer(new codec.Enum(content_decryption_module$.CdmSessionType), val.sessionTypes);
    encoder.encodeStructPointer(version$.Version, val.version);
  };
  function KeySystemCapability(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  KeySystemCapability.prototype.initDefaults_ = function() {
    this.swSecureCapability = null;
    this.hwSecureCapability = null;
    this.sw_secure_capability_query_status_$flag = false;
    this.hw_secure_capability_query_status_$flag = false;
    this.sw_secure_capability_query_status_$value = 0;
    this.hw_secure_capability_query_status_$value = 0;
  };
  KeySystemCapability.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  KeySystemCapability.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate KeySystemCapability.swSecureCapability
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CdmCapability, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate KeySystemCapability.hwSecureCapability
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, CdmCapability, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate KeySystemCapability.sw_secure_capability_query_status_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, CdmCapabilityQueryStatus);
    if (err !== validator.validationError.NONE)
        return err;



    // validate KeySystemCapability.hw_secure_capability_query_status_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, CdmCapabilityQueryStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  KeySystemCapability.encodedSize = codec.kStructHeaderSize + 32;

  KeySystemCapability.decode = function(decoder) {
    var packed;
    var val = new KeySystemCapability();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.swSecureCapability =
        decoder.decodeStructPointer(CdmCapability);
    val.hwSecureCapability =
        decoder.decodeStructPointer(CdmCapability);
    packed = decoder.readUint8();
    val.sw_secure_capability_query_status_$flag = (packed >> 0) & 1 ? true : false;
    val.hw_secure_capability_query_status_$flag = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sw_secure_capability_query_status_$value =
        decoder.decodeStruct(new codec.Enum(CdmCapabilityQueryStatus));
    val.hw_secure_capability_query_status_$value =
        decoder.decodeStruct(new codec.Enum(CdmCapabilityQueryStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  KeySystemCapability.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(KeySystemCapability.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CdmCapability, val.swSecureCapability);
    encoder.encodeStructPointer(CdmCapability, val.hwSecureCapability);
    packed = 0;
    packed |= (val.sw_secure_capability_query_status_$flag & 1) << 0
    packed |= (val.hw_secure_capability_query_status_$flag & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.sw_secure_capability_query_status_$value);
    encoder.encodeStruct(codec.Int32, val.hw_secure_capability_query_status_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function KeySystemSupportObserver_OnKeySystemSupportUpdated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  KeySystemSupportObserver_OnKeySystemSupportUpdated_Params.prototype.initDefaults_ = function() {
    this.keySystems = null;
  };
  KeySystemSupportObserver_OnKeySystemSupportUpdated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  KeySystemSupportObserver_OnKeySystemSupportUpdated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate KeySystemSupportObserver_OnKeySystemSupportUpdated_Params.keySystems
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, new codec.PointerTo(KeySystemCapability), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  KeySystemSupportObserver_OnKeySystemSupportUpdated_Params.encodedSize = codec.kStructHeaderSize + 8;

  KeySystemSupportObserver_OnKeySystemSupportUpdated_Params.decode = function(decoder) {
    var packed;
    var val = new KeySystemSupportObserver_OnKeySystemSupportUpdated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keySystems =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(KeySystemCapability));
    return val;
  };

  KeySystemSupportObserver_OnKeySystemSupportUpdated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(KeySystemSupportObserver_OnKeySystemSupportUpdated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(KeySystemCapability), val.keySystems);
  };
  function KeySystemSupport_SetObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  KeySystemSupport_SetObserver_Params.prototype.initDefaults_ = function() {
    this.observer = new KeySystemSupportObserverPtr();
  };
  KeySystemSupport_SetObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  KeySystemSupport_SetObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate KeySystemSupport_SetObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  KeySystemSupport_SetObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  KeySystemSupport_SetObserver_Params.decode = function(decoder) {
    var packed;
    var val = new KeySystemSupport_SetObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(new codec.Interface(KeySystemSupportObserverPtr));
    return val;
  };

  KeySystemSupport_SetObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(KeySystemSupport_SetObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(KeySystemSupportObserverPtr), val.observer);
  };
  var kKeySystemSupportObserver_OnKeySystemSupportUpdated_Name = 0;

  function KeySystemSupportObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(KeySystemSupportObserver,
                                                   handleOrPtrInfo);
  }

  function KeySystemSupportObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        KeySystemSupportObserver, associatedInterfacePtrInfo);
  }

  KeySystemSupportObserverAssociatedPtr.prototype =
      Object.create(KeySystemSupportObserverPtr.prototype);
  KeySystemSupportObserverAssociatedPtr.prototype.constructor =
      KeySystemSupportObserverAssociatedPtr;

  function KeySystemSupportObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  KeySystemSupportObserverPtr.prototype.onKeySystemSupportUpdated = function() {
    return KeySystemSupportObserverProxy.prototype.onKeySystemSupportUpdated
        .apply(this.ptr.getProxy(), arguments);
  };

  KeySystemSupportObserverProxy.prototype.onKeySystemSupportUpdated = function(keySystems) {
    var params_ = new KeySystemSupportObserver_OnKeySystemSupportUpdated_Params();
    params_.keySystems = keySystems;
    var builder = new codec.MessageV0Builder(
        kKeySystemSupportObserver_OnKeySystemSupportUpdated_Name,
        codec.align(KeySystemSupportObserver_OnKeySystemSupportUpdated_Params.encodedSize));
    builder.encodeStruct(KeySystemSupportObserver_OnKeySystemSupportUpdated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function KeySystemSupportObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  KeySystemSupportObserverStub.prototype.onKeySystemSupportUpdated = function(keySystems) {
    return this.delegate_ && this.delegate_.onKeySystemSupportUpdated && this.delegate_.onKeySystemSupportUpdated(keySystems);
  }

  KeySystemSupportObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kKeySystemSupportObserver_OnKeySystemSupportUpdated_Name:
      var params = reader.decodeStruct(KeySystemSupportObserver_OnKeySystemSupportUpdated_Params);
      this.onKeySystemSupportUpdated(params.keySystems);
      return true;
    default:
      return false;
    }
  };

  KeySystemSupportObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateKeySystemSupportObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kKeySystemSupportObserver_OnKeySystemSupportUpdated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = KeySystemSupportObserver_OnKeySystemSupportUpdated_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateKeySystemSupportObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var KeySystemSupportObserver = {
    name: 'media.mojom.KeySystemSupportObserver',
    kVersion: 0,
    ptrClass: KeySystemSupportObserverPtr,
    proxyClass: KeySystemSupportObserverProxy,
    stubClass: KeySystemSupportObserverStub,
    validateRequest: validateKeySystemSupportObserverRequest,
    validateResponse: null,
  };
  KeySystemSupportObserverStub.prototype.validator = validateKeySystemSupportObserverRequest;
  KeySystemSupportObserverProxy.prototype.validator = null;
  var kKeySystemSupport_SetObserver_Name = 0;

  function KeySystemSupportPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(KeySystemSupport,
                                                   handleOrPtrInfo);
  }

  function KeySystemSupportAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        KeySystemSupport, associatedInterfacePtrInfo);
  }

  KeySystemSupportAssociatedPtr.prototype =
      Object.create(KeySystemSupportPtr.prototype);
  KeySystemSupportAssociatedPtr.prototype.constructor =
      KeySystemSupportAssociatedPtr;

  function KeySystemSupportProxy(receiver) {
    this.receiver_ = receiver;
  }
  KeySystemSupportPtr.prototype.setObserver = function() {
    return KeySystemSupportProxy.prototype.setObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  KeySystemSupportProxy.prototype.setObserver = function(observer) {
    var params_ = new KeySystemSupport_SetObserver_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kKeySystemSupport_SetObserver_Name,
        codec.align(KeySystemSupport_SetObserver_Params.encodedSize));
    builder.encodeStruct(KeySystemSupport_SetObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function KeySystemSupportStub(delegate) {
    this.delegate_ = delegate;
  }
  KeySystemSupportStub.prototype.setObserver = function(observer) {
    return this.delegate_ && this.delegate_.setObserver && this.delegate_.setObserver(observer);
  }

  KeySystemSupportStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kKeySystemSupport_SetObserver_Name:
      var params = reader.decodeStruct(KeySystemSupport_SetObserver_Params);
      this.setObserver(params.observer);
      return true;
    default:
      return false;
    }
  };

  KeySystemSupportStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateKeySystemSupportRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kKeySystemSupport_SetObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = KeySystemSupport_SetObserver_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateKeySystemSupportResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var KeySystemSupport = {
    name: 'media.mojom.KeySystemSupport',
    kVersion: 0,
    ptrClass: KeySystemSupportPtr,
    proxyClass: KeySystemSupportProxy,
    stubClass: KeySystemSupportStub,
    validateRequest: validateKeySystemSupportRequest,
    validateResponse: null,
  };
  KeySystemSupportStub.prototype.validator = validateKeySystemSupportRequest;
  KeySystemSupportProxy.prototype.validator = null;
  exports.CdmCapabilityQueryStatus = CdmCapabilityQueryStatus;
  exports.VideoCodecInfo = VideoCodecInfo;
  exports.CdmCapability = CdmCapability;
  exports.KeySystemCapability = KeySystemCapability;
  exports.KeySystemSupportObserver = KeySystemSupportObserver;
  exports.KeySystemSupportObserverPtr = KeySystemSupportObserverPtr;
  exports.KeySystemSupportObserverAssociatedPtr = KeySystemSupportObserverAssociatedPtr;
  exports.KeySystemSupport = KeySystemSupport;
  exports.KeySystemSupportPtr = KeySystemSupportPtr;
  exports.KeySystemSupportAssociatedPtr = KeySystemSupportAssociatedPtr;
})();