// media/mojo/mojom/key_system_support.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_SEND_VALIDATION_H_
#define MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_SEND_VALIDATION_H_

#include "media/mojo/mojom/key_system_support.mojom-shared-internal.h"
#include "media/mojo/mojom/content_decryption_module.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/version.mojom-shared.h"

#include "media/mojo/mojom/key_system_support.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::CdmCapabilityQueryStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoCodecInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCodecInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCodecInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::supported_profiles(input)) in_supported_profiles = Traits::supported_profiles(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_profiles)::BaseType>
          supported_profiles_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& supported_profiles_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::VideoCodecProfile_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCodecProfile>, send_validation>(
        in_supported_profiles,
        supported_profiles_fragment,
        &supported_profiles_validate_params);

      fragment->supported_profiles.Set(
          supported_profiles_fragment.is_null() ? nullptr : supported_profiles_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->supported_profiles.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_profiles in VideoCodecInfo struct");

      fragment->supports_clear_lead = Traits::supports_clear_lead(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::CdmCapabilityDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CdmCapabilityDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CdmCapability_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::audio_codecs(input)) in_audio_codecs = Traits::audio_codecs(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->audio_codecs)::BaseType>
          audio_codecs_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& audio_codecs_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::AudioCodec_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::AudioCodec>, send_validation>(
        in_audio_codecs,
        audio_codecs_fragment,
        &audio_codecs_validate_params);

      fragment->audio_codecs.Set(
          audio_codecs_fragment.is_null() ? nullptr : audio_codecs_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->audio_codecs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null audio_codecs in CdmCapability struct");

      decltype(Traits::video_codecs(input)) in_video_codecs = Traits::video_codecs(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->video_codecs)::BaseType>
          video_codecs_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& video_codecs_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::VideoCodec_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::media::mojom::VideoCodec, ::media::mojom::VideoCodecInfoDataView>, send_validation>(
        in_video_codecs,
        video_codecs_fragment,
        &video_codecs_validate_params);

      fragment->video_codecs.Set(
          video_codecs_fragment.is_null() ? nullptr : video_codecs_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->video_codecs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null video_codecs in CdmCapability struct");

      decltype(Traits::encryption_schemes(input)) in_encryption_schemes = Traits::encryption_schemes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->encryption_schemes)::BaseType>
          encryption_schemes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& encryption_schemes_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::EncryptionScheme_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::EncryptionScheme>, send_validation>(
        in_encryption_schemes,
        encryption_schemes_fragment,
        &encryption_schemes_validate_params);

      fragment->encryption_schemes.Set(
          encryption_schemes_fragment.is_null() ? nullptr : encryption_schemes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->encryption_schemes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null encryption_schemes in CdmCapability struct");

      decltype(Traits::session_types(input)) in_session_types = Traits::session_types(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->session_types)::BaseType>
          session_types_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& session_types_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::CdmSessionType_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::CdmSessionType>, send_validation>(
        in_session_types,
        session_types_fragment,
        &session_types_validate_params);

      fragment->session_types.Set(
          session_types_fragment.is_null() ? nullptr : session_types_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->session_types.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_types in CdmCapability struct");

      decltype(Traits::version(input)) in_version = Traits::version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->version)::BaseType> version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::VersionDataView, send_validation>(
        in_version,
        version_fragment);

      fragment->version.Set(
          version_fragment.is_null() ? nullptr : version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null version in CdmCapability struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::KeySystemCapabilityDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::KeySystemCapabilityDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::KeySystemCapability_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::sw_secure_capability(input)) in_sw_secure_capability = Traits::sw_secure_capability(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sw_secure_capability)::BaseType> sw_secure_capability_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::CdmCapabilityDataView, send_validation>(
        in_sw_secure_capability,
        sw_secure_capability_fragment);

      fragment->sw_secure_capability.Set(
          sw_secure_capability_fragment.is_null() ? nullptr : sw_secure_capability_fragment.data());

      decltype(Traits::hw_secure_capability(input)) in_hw_secure_capability = Traits::hw_secure_capability(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hw_secure_capability)::BaseType> hw_secure_capability_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::CdmCapabilityDataView, send_validation>(
        in_hw_secure_capability,
        hw_secure_capability_fragment);

      fragment->hw_secure_capability.Set(
          hw_secure_capability_fragment.is_null() ? nullptr : hw_secure_capability_fragment.data());
      fragment->sw_secure_capability_query_status_$flag = Traits::sw_secure_capability_query_status(input).has_value();
      if (Traits::sw_secure_capability_query_status(input).has_value()) {
        
        mojo::internal::Serialize<::media::mojom::CdmCapabilityQueryStatus>(
          Traits::sw_secure_capability_query_status(input).value(),
          &fragment->sw_secure_capability_query_status_$value);
      } else {
        fragment->sw_secure_capability_query_status_$value =
            static_cast<int32_t>(::media::mojom::CdmCapabilityQueryStatus::kMinValue);
      }
      fragment->hw_secure_capability_query_status_$flag = Traits::hw_secure_capability_query_status(input).has_value();
      if (Traits::hw_secure_capability_query_status(input).has_value()) {
        
        mojo::internal::Serialize<::media::mojom::CdmCapabilityQueryStatus>(
          Traits::hw_secure_capability_query_status(input).value(),
          &fragment->hw_secure_capability_query_status_$value);
      } else {
        fragment->hw_secure_capability_query_status_$value =
            static_cast<int32_t>(::media::mojom::CdmCapabilityQueryStatus::kMinValue);
      }
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_SEND_VALIDATION_H_