// media/mojo/mojom/frame_interface_factory.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.CdmStorage');
goog.require('media.mojom.ProvisionFetcher');
goog.require('mojoBase.mojom.GenericPendingReceiver');
goog.require('url.mojom.Origin');






goog.provide('media.mojom.FrameInterfaceFactory');
goog.provide('media.mojom.FrameInterfaceFactoryReceiver');
goog.provide('media.mojom.FrameInterfaceFactoryCallbackRouter');
goog.provide('media.mojom.FrameInterfaceFactoryInterface');
goog.provide('media.mojom.FrameInterfaceFactoryRemote');
goog.provide('media.mojom.FrameInterfaceFactoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.FrameInterfaceFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.FrameInterfaceFactory.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.FrameInterfaceFactoryInterface = class {
  
  /**
   * @param { !media.mojom.ProvisionFetcherPendingReceiver } provisionFetcher
   */

  createProvisionFetcher(provisionFetcher) {}
  
  /**
   * @param { !media.mojom.CdmStoragePendingReceiver } cdmStorage
   */

  createCdmStorage(cdmStorage) {}
  
  /**
   * @return {!Promise<{
        cdmOrigin: !url.mojom.Origin,
   *  }>}
   */

  getCdmOrigin() {}
  
  /**
   * @param { !mojoBase.mojom.GenericPendingReceiver } receiver
   */

  bindEmbedderReceiver(receiver) {}
};

/**
 * @export
 * @implements { media.mojom.FrameInterfaceFactoryInterface }
 */
media.mojom.FrameInterfaceFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.FrameInterfaceFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.FrameInterfaceFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.FrameInterfaceFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.ProvisionFetcherPendingReceiver } provisionFetcher
   */

  createProvisionFetcher(
      provisionFetcher) {
    this.proxy.sendMessage(
        0,
        media.mojom.FrameInterfaceFactory_CreateProvisionFetcher_ParamsSpec.$,
        null,
        [
          provisionFetcher
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.CdmStoragePendingReceiver } cdmStorage
   */

  createCdmStorage(
      cdmStorage) {
    this.proxy.sendMessage(
        1,
        media.mojom.FrameInterfaceFactory_CreateCdmStorage_ParamsSpec.$,
        null,
        [
          cdmStorage
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        cdmOrigin: !url.mojom.Origin,
   *  }>}
   */

  getCdmOrigin() {
    return this.proxy.sendMessage(
        2,
        media.mojom.FrameInterfaceFactory_GetCdmOrigin_ParamsSpec.$,
        media.mojom.FrameInterfaceFactory_GetCdmOrigin_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.GenericPendingReceiver } receiver
   */

  bindEmbedderReceiver(
      receiver) {
    this.proxy.sendMessage(
        3,
        media.mojom.FrameInterfaceFactory_BindEmbedderReceiver_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FrameInterfaceFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.FrameInterfaceFactoryReceiver = class {
  /**
   * @param {!media.mojom.FrameInterfaceFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.FrameInterfaceFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.FrameInterfaceFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.FrameInterfaceFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.FrameInterfaceFactory_CreateProvisionFetcher_ParamsSpec.$,
        null,
        impl.createProvisionFetcher.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.FrameInterfaceFactory_CreateCdmStorage_ParamsSpec.$,
        null,
        impl.createCdmStorage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.FrameInterfaceFactory_GetCdmOrigin_ParamsSpec.$,
        media.mojom.FrameInterfaceFactory_GetCdmOrigin_ResponseParamsSpec.$,
        impl.getCdmOrigin.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.FrameInterfaceFactory_BindEmbedderReceiver_ParamsSpec.$,
        null,
        impl.bindEmbedderReceiver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.FrameInterfaceFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.FrameInterfaceFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.FrameInterfaceFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.FrameInterfaceFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FrameInterfaceFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.FrameInterfaceFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.FrameInterfaceFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.FrameInterfaceFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createProvisionFetcher =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.FrameInterfaceFactory_CreateProvisionFetcher_ParamsSpec.$,
        null,
        this.createProvisionFetcher.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createCdmStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.FrameInterfaceFactory_CreateCdmStorage_ParamsSpec.$,
        null,
        this.createCdmStorage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCdmOrigin =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.FrameInterfaceFactory_GetCdmOrigin_ParamsSpec.$,
        media.mojom.FrameInterfaceFactory_GetCdmOrigin_ResponseParamsSpec.$,
        this.getCdmOrigin.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindEmbedderReceiver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.FrameInterfaceFactory_BindEmbedderReceiver_ParamsSpec.$,
        null,
        this.bindEmbedderReceiver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.FrameInterfaceFactory_CreateProvisionFetcher_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.FrameInterfaceFactory_CreateProvisionFetcher_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.FrameInterfaceFactory_CreateCdmStorage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.FrameInterfaceFactory_CreateCdmStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.FrameInterfaceFactory_GetCdmOrigin_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.FrameInterfaceFactory_GetCdmOrigin_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.FrameInterfaceFactory_GetCdmOrigin_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.FrameInterfaceFactory_GetCdmOrigin_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.FrameInterfaceFactory_BindEmbedderReceiver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.FrameInterfaceFactory_BindEmbedderReceiver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.FrameInterfaceFactory_CreateProvisionFetcher_ParamsSpec.$,
    'FrameInterfaceFactory_CreateProvisionFetcher_Params',
    [
      mojo.internal.StructField(
        'provisionFetcher', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.ProvisionFetcherPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.FrameInterfaceFactory_CreateProvisionFetcher_Params');

/** @record */
media.mojom.FrameInterfaceFactory_CreateProvisionFetcher_Params = class {
  constructor() {
    /** @export { !media.mojom.ProvisionFetcherPendingReceiver } */
    this.provisionFetcher;
  }
};



mojo.internal.Struct(
    media.mojom.FrameInterfaceFactory_CreateCdmStorage_ParamsSpec.$,
    'FrameInterfaceFactory_CreateCdmStorage_Params',
    [
      mojo.internal.StructField(
        'cdmStorage', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.CdmStoragePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.FrameInterfaceFactory_CreateCdmStorage_Params');

/** @record */
media.mojom.FrameInterfaceFactory_CreateCdmStorage_Params = class {
  constructor() {
    /** @export { !media.mojom.CdmStoragePendingReceiver } */
    this.cdmStorage;
  }
};



mojo.internal.Struct(
    media.mojom.FrameInterfaceFactory_GetCdmOrigin_ParamsSpec.$,
    'FrameInterfaceFactory_GetCdmOrigin_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.FrameInterfaceFactory_GetCdmOrigin_Params');

/** @record */
media.mojom.FrameInterfaceFactory_GetCdmOrigin_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.FrameInterfaceFactory_GetCdmOrigin_ResponseParamsSpec.$,
    'FrameInterfaceFactory_GetCdmOrigin_ResponseParams',
    [
      mojo.internal.StructField(
        'cdmOrigin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.FrameInterfaceFactory_GetCdmOrigin_ResponseParams');

/** @record */
media.mojom.FrameInterfaceFactory_GetCdmOrigin_ResponseParams = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.cdmOrigin;
  }
};



mojo.internal.Struct(
    media.mojom.FrameInterfaceFactory_BindEmbedderReceiver_ParamsSpec.$,
    'FrameInterfaceFactory_BindEmbedderReceiver_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojoBase.mojom.GenericPendingReceiverSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.FrameInterfaceFactory_BindEmbedderReceiver_Params');

/** @record */
media.mojom.FrameInterfaceFactory_BindEmbedderReceiver_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.GenericPendingReceiver } */
    this.receiver;
  }
};

