// media/mojo/mojom/content_decryption_module.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/content_decryption_module.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/content_decryption_module.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* CdmKeyStatusToStringHelper(CdmKeyStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CdmKeyStatus::USABLE:
      return "USABLE";
    case CdmKeyStatus::INTERNAL_ERROR:
      return "INTERNAL_ERROR";
    case CdmKeyStatus::EXPIRED:
      return "EXPIRED";
    case CdmKeyStatus::OUTPUT_RESTRICTED:
      return "OUTPUT_RESTRICTED";
    case CdmKeyStatus::OUTPUT_DOWNSCALED:
      return "OUTPUT_DOWNSCALED";
    case CdmKeyStatus::KEY_STATUS_PENDING:
      return "KEY_STATUS_PENDING";
    case CdmKeyStatus::RELEASED:
      return "RELEASED";
    case CdmKeyStatus::USABLE_IN_FUTURE:
      return "USABLE_IN_FUTURE";
    default:
      return nullptr;
  }
}

std::string CdmKeyStatusToString(CdmKeyStatus value) {
  const char *str = CdmKeyStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CdmKeyStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CdmKeyStatus value) {
  return os << CdmKeyStatusToString(value);
}

namespace internal {


// static
bool CdmConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmConfig_Data* object =
      static_cast<const CdmConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_system, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_system_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key_system, validation_context,
                                         &key_system_validate_params)) {
    return false;
  }

  return true;
}

CdmConfig_Data::CdmConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmPromiseResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmPromiseResult_Data* object =
      static_cast<const CdmPromiseResult_Data*>(data);


  if (!::media::mojom::internal::CdmPromiseResult_Exception_Data
        ::Validate(object->exception, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

CdmPromiseResult_Data::CdmPromiseResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmKeyInformation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmKeyInformation_Data* object =
      static_cast<const CdmKeyInformation_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key_id, validation_context,
                                         &key_id_validate_params)) {
    return false;
  }


  if (!::media::mojom::internal::CdmKeyStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

CdmKeyInformation_Data::CdmKeyInformation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContext_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContext_Data* object =
      static_cast<const CdmContext_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cdm_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cdm_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->decryptor,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CdmContext_Data::CdmContext_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_SetClient_Params_Data* object =
      static_cast<const ContentDecryptionModule_SetClient_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ContentDecryptionModule_SetClient_Params_Data::ContentDecryptionModule_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_SetServerCertificate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_SetServerCertificate_Params_Data* object =
      static_cast<const ContentDecryptionModule_SetServerCertificate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->certificate_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& certificate_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->certificate_data, validation_context,
                                         &certificate_data_validate_params)) {
    return false;
  }

  return true;
}

ContentDecryptionModule_SetServerCertificate_Params_Data::ContentDecryptionModule_SetServerCertificate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_SetServerCertificate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_SetServerCertificate_ResponseParams_Data* object =
      static_cast<const ContentDecryptionModule_SetServerCertificate_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ContentDecryptionModule_SetServerCertificate_ResponseParams_Data::ContentDecryptionModule_SetServerCertificate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_GetStatusForPolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_GetStatusForPolicy_Params_Data* object =
      static_cast<const ContentDecryptionModule_GetStatusForPolicy_Params_Data*>(data);


  if (!::media::mojom::internal::HdcpVersion_Data
        ::Validate(object->min_hdcp_version, validation_context))
    return false;

  return true;
}

ContentDecryptionModule_GetStatusForPolicy_Params_Data::ContentDecryptionModule_GetStatusForPolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data* object =
      static_cast<const ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;


  if (!::media::mojom::internal::CdmKeyStatus_Data
        ::Validate(object->key_status, validation_context))
    return false;

  return true;
}

ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data::ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data* object =
      static_cast<const ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data*>(data);


  if (!::media::mojom::internal::CdmSessionType_Data
        ::Validate(object->session_type, validation_context))
    return false;


  if (!::media::mojom::internal::EmeInitDataType_Data
        ::Validate(object->init_data_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->init_data, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& init_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->init_data, validation_context,
                                         &init_data_validate_params)) {
    return false;
  }

  return true;
}

ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data::ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data* object =
      static_cast<const ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  return true;
}

ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data::ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_LoadSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_LoadSession_Params_Data* object =
      static_cast<const ContentDecryptionModule_LoadSession_Params_Data*>(data);


  if (!::media::mojom::internal::CdmSessionType_Data
        ::Validate(object->session_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  return true;
}

ContentDecryptionModule_LoadSession_Params_Data::ContentDecryptionModule_LoadSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_LoadSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_LoadSession_ResponseParams_Data* object =
      static_cast<const ContentDecryptionModule_LoadSession_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  return true;
}

ContentDecryptionModule_LoadSession_ResponseParams_Data::ContentDecryptionModule_LoadSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_UpdateSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_UpdateSession_Params_Data* object =
      static_cast<const ContentDecryptionModule_UpdateSession_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& response_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->response, validation_context,
                                         &response_validate_params)) {
    return false;
  }

  return true;
}

ContentDecryptionModule_UpdateSession_Params_Data::ContentDecryptionModule_UpdateSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_UpdateSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_UpdateSession_ResponseParams_Data* object =
      static_cast<const ContentDecryptionModule_UpdateSession_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ContentDecryptionModule_UpdateSession_ResponseParams_Data::ContentDecryptionModule_UpdateSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_CloseSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_CloseSession_Params_Data* object =
      static_cast<const ContentDecryptionModule_CloseSession_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  return true;
}

ContentDecryptionModule_CloseSession_Params_Data::ContentDecryptionModule_CloseSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_CloseSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_CloseSession_ResponseParams_Data* object =
      static_cast<const ContentDecryptionModule_CloseSession_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ContentDecryptionModule_CloseSession_ResponseParams_Data::ContentDecryptionModule_CloseSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_RemoveSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_RemoveSession_Params_Data* object =
      static_cast<const ContentDecryptionModule_RemoveSession_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  return true;
}

ContentDecryptionModule_RemoveSession_Params_Data::ContentDecryptionModule_RemoveSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModule_RemoveSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModule_RemoveSession_ResponseParams_Data* object =
      static_cast<const ContentDecryptionModule_RemoveSession_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ContentDecryptionModule_RemoveSession_ResponseParams_Data::ContentDecryptionModule_RemoveSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModuleClient_OnSessionMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModuleClient_OnSessionMessage_Params_Data* object =
      static_cast<const ContentDecryptionModuleClient_OnSessionMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }


  if (!::media::mojom::internal::CdmMessageType_Data
        ::Validate(object->message_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

ContentDecryptionModuleClient_OnSessionMessage_Params_Data::ContentDecryptionModuleClient_OnSessionMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModuleClient_OnSessionClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModuleClient_OnSessionClosed_Params_Data* object =
      static_cast<const ContentDecryptionModuleClient_OnSessionClosed_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }


  if (!::media::mojom::internal::CdmSessionClosedReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

ContentDecryptionModuleClient_OnSessionClosed_Params_Data::ContentDecryptionModuleClient_OnSessionClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data* object =
      static_cast<const ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys_info, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& keys_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->keys_info, validation_context,
                                         &keys_info_validate_params)) {
    return false;
  }

  return true;
}

ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data::ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data* object =
      static_cast<const ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  return true;
}

ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data::ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmFactory_CreateCdm_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmFactory_CreateCdm_Params_Data* object =
      static_cast<const CdmFactory_CreateCdm_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cdm_config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cdm_config, validation_context))
    return false;

  return true;
}

CdmFactory_CreateCdm_Params_Data::CdmFactory_CreateCdm_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmFactory_CreateCdm_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmFactory_CreateCdm_ResponseParams_Data* object =
      static_cast<const CdmFactory_CreateCdm_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->cdm,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->cdm_context, validation_context))
    return false;


  if (!::media::mojom::internal::CreateCdmStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

CdmFactory_CreateCdm_ResponseParams_Data::CdmFactory_CreateCdm_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::CdmKeyStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::CdmKeyStatus value) {
  return std::move(context).WriteString(::media::mojom::CdmKeyStatusToString(value));
}

} // namespace perfetto