// media/mojo/mojom/cdm_storage.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CdmStoragePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.CdmStorage', scope);
  }
}

/** @interface */
export class CdmStorageInterface {
  
  /**
   * @param { !string } fileName
   * @return {!Promise<{
        status: !CdmStorage_Status,
        cdmFile: ?Object,
   *  }>}
   */

  open(fileName) {}
}

/**
 * @implements { CdmStorageInterface }
 */
export class CdmStorageRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CdmStoragePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CdmStoragePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CdmStoragePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } fileName
   * @return {!Promise<{
        status: !CdmStorage_Status,
        cdmFile: ?Object,
   *  }>}
   */

  open(
      fileName) {
    return this.proxy.sendMessage(
        0,
        CdmStorage_Open_ParamsSpec.$,
        CdmStorage_Open_ResponseParamsSpec.$,
        [
          fileName
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CdmStorage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CdmStorageReceiver {
  /**
   * @param {!CdmStorageInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CdmStorageRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CdmStorageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmStorageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CdmStorage_Open_ParamsSpec.$,
        CdmStorage_Open_ResponseParamsSpec.$,
        impl.open.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CdmStorage {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.CdmStorage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CdmStorageRemote}
   */
  static getRemote() {
    let remote = new CdmStorageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CdmStorage_StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CdmStorage_Status = {
  
  kSuccess: 0,
  kInUse: 1,
  kFailure: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * An object which receives request messages for the CdmStorage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CdmStorageCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CdmStorageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmStorageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.open =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CdmStorage_Open_ParamsSpec.$,
        CdmStorage_Open_ResponseParamsSpec.$,
        this.open.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CdmFilePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.CdmFile', scope);
  }
}

/** @interface */
export class CdmFileInterface {
  
  /**
   * @return {!Promise<{
        status: !CdmFile_Status,
        data: !Array<!number>,
   *  }>}
   */

  read() {}
  
  /**
   * @param { !Array<!number> } data
   * @return {!Promise<{
        status: !CdmFile_Status,
   *  }>}
   */

  write(data) {}
}

/**
 * @implements { CdmFileInterface }
 */
export class CdmFileRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CdmFilePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CdmFilePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CdmFilePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        status: !CdmFile_Status,
        data: !Array<!number>,
   *  }>}
   */

  read() {
    return this.proxy.sendMessage(
        0,
        CdmFile_Read_ParamsSpec.$,
        CdmFile_Read_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } data
   * @return {!Promise<{
        status: !CdmFile_Status,
   *  }>}
   */

  write(
      data) {
    return this.proxy.sendMessage(
        1,
        CdmFile_Write_ParamsSpec.$,
        CdmFile_Write_ResponseParamsSpec.$,
        [
          data
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CdmFile
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CdmFileReceiver {
  /**
   * @param {!CdmFileInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CdmFileRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CdmFileRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmFileRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CdmFile_Read_ParamsSpec.$,
        CdmFile_Read_ResponseParamsSpec.$,
        impl.read.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CdmFile_Write_ParamsSpec.$,
        CdmFile_Write_ResponseParamsSpec.$,
        impl.write.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CdmFile {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.CdmFile";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CdmFileRemote}
   */
  static getRemote() {
    let remote = new CdmFileRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CdmFile_StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CdmFile_Status = {
  
  kSuccess: 0,
  kFailure: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * An object which receives request messages for the CdmFile
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CdmFileCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CdmFileRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmFileRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.read =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CdmFile_Read_ParamsSpec.$,
        CdmFile_Read_ResponseParamsSpec.$,
        this.read.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.write =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CdmFile_Write_ParamsSpec.$,
        CdmFile_Write_ResponseParamsSpec.$,
        this.write.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmStorage_Open_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmStorage_Open_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmFile_Read_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmFile_Read_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmFile_Write_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmFile_Write_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CdmStorage_Open_ParamsSpec.$,
    'CdmStorage_Open_Params',
    [
      mojo.internal.StructField(
        'fileName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CdmStorage_Open_Params {
  constructor() {
    /** @type { !string } */
    this.fileName;
  }
}



mojo.internal.Struct(
    CdmStorage_Open_ResponseParamsSpec.$,
    'CdmStorage_Open_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        CdmStorage_StatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cdmFile', 4,
        0,
        mojo.internal.AssociatedInterfaceProxy(CdmFileRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CdmStorage_Open_ResponseParams {
  constructor() {
    /** @type { !CdmStorage_Status } */
    this.status;
    /** @type { (Object|undefined) } */
    this.cdmFile;
  }
}



mojo.internal.Struct(
    CdmFile_Read_ParamsSpec.$,
    'CdmFile_Read_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CdmFile_Read_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CdmFile_Read_ResponseParamsSpec.$,
    'CdmFile_Read_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        CdmFile_StatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CdmFile_Read_ResponseParams {
  constructor() {
    /** @type { !CdmFile_Status } */
    this.status;
    /** @type { !Array<!number> } */
    this.data;
  }
}



mojo.internal.Struct(
    CdmFile_Write_ParamsSpec.$,
    'CdmFile_Write_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CdmFile_Write_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.data;
  }
}



mojo.internal.Struct(
    CdmFile_Write_ResponseParamsSpec.$,
    'CdmFile_Write_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        CdmFile_StatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CdmFile_Write_ResponseParams {
  constructor() {
    /** @type { !CdmFile_Status } */
    this.status;
  }
}

