// media/mojo/mojom/cdm_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  SeatbeltExtensionToken as sandbox_mac_mojom_SeatbeltExtensionToken,
  SeatbeltExtensionTokenSpec as sandbox_mac_mojom_SeatbeltExtensionTokenSpec
} from '../../../sandbox/mac/mojom/seatbelt_extension_token.mojom.m.js';

import {
  CdmFactoryRemote as media_mojom_CdmFactoryRemote,
  CdmFactoryPendingReceiver as media_mojom_CdmFactoryPendingReceiver
} from './content_decryption_module.mojom.m.js';

import {
  FrameInterfaceFactoryRemote as media_mojom_FrameInterfaceFactoryRemote,
  FrameInterfaceFactoryPendingReceiver as media_mojom_FrameInterfaceFactoryPendingReceiver
} from './frame_interface_factory.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CdmServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.CdmService', scope);
  }
}

/** @interface */
export class CdmServiceInterface {
  
  /**
   * @param { !media_mojom_CdmFactoryPendingReceiver } factory
   * @param { !media_mojom_FrameInterfaceFactoryRemote } frameInterfaces
   */

  createCdmFactory(factory, frameInterfaces) {}
}

/**
 * @implements { CdmServiceInterface }
 */
export class CdmServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CdmServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CdmServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CdmServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_CdmFactoryPendingReceiver } factory
   * @param { !media_mojom_FrameInterfaceFactoryRemote } frameInterfaces
   */

  createCdmFactory(
      factory,
      frameInterfaces) {
    this.proxy.sendMessage(
        0,
        CdmService_CreateCdmFactory_ParamsSpec.$,
        null,
        [
          factory,
          frameInterfaces
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CdmService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CdmServiceReceiver {
  /**
   * @param {!CdmServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CdmServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CdmServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CdmService_CreateCdmFactory_ParamsSpec.$,
        null,
        impl.createCdmFactory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CdmService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.CdmService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CdmServiceRemote}
   */
  static getRemote() {
    let remote = new CdmServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CdmService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CdmServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CdmServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createCdmFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CdmService_CreateCdmFactory_ParamsSpec.$,
        null,
        this.createCdmFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SeatbeltExtensionTokenProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.SeatbeltExtensionTokenProvider', scope);
  }
}

/** @interface */
export class SeatbeltExtensionTokenProviderInterface {
  
  /**
   * @return {!Promise<{
        tokens: !Array<!sandbox_mac_mojom_SeatbeltExtensionToken>,
   *  }>}
   */

  getTokens() {}
}

/**
 * @implements { SeatbeltExtensionTokenProviderInterface }
 */
export class SeatbeltExtensionTokenProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SeatbeltExtensionTokenProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SeatbeltExtensionTokenProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SeatbeltExtensionTokenProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        tokens: !Array<!sandbox_mac_mojom_SeatbeltExtensionToken>,
   *  }>}
   */

  getTokens() {
    return this.proxy.sendMessage(
        0,
        SeatbeltExtensionTokenProvider_GetTokens_ParamsSpec.$,
        SeatbeltExtensionTokenProvider_GetTokens_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SeatbeltExtensionTokenProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SeatbeltExtensionTokenProviderReceiver {
  /**
   * @param {!SeatbeltExtensionTokenProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SeatbeltExtensionTokenProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SeatbeltExtensionTokenProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SeatbeltExtensionTokenProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SeatbeltExtensionTokenProvider_GetTokens_ParamsSpec.$,
        SeatbeltExtensionTokenProvider_GetTokens_ResponseParamsSpec.$,
        impl.getTokens.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SeatbeltExtensionTokenProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SeatbeltExtensionTokenProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SeatbeltExtensionTokenProviderRemote}
   */
  static getRemote() {
    let remote = new SeatbeltExtensionTokenProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SeatbeltExtensionTokenProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SeatbeltExtensionTokenProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SeatbeltExtensionTokenProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SeatbeltExtensionTokenProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SeatbeltExtensionTokenProvider_GetTokens_ParamsSpec.$,
        SeatbeltExtensionTokenProvider_GetTokens_ResponseParamsSpec.$,
        this.getTokens.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CdmServiceBrokerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.CdmServiceBroker', scope);
  }
}

/** @interface */
export class CdmServiceBrokerInterface {
  
  /**
   * @param { !mojoBase_mojom_FilePath } cdmPath
   * @param { ?SeatbeltExtensionTokenProviderRemote } tokenProvider
   * @param { !CdmServicePendingReceiver } receiver
   */

  getService(cdmPath, tokenProvider, receiver) {}
}

/**
 * @implements { CdmServiceBrokerInterface }
 */
export class CdmServiceBrokerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CdmServiceBrokerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CdmServiceBrokerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CdmServiceBrokerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } cdmPath
   * @param { ?SeatbeltExtensionTokenProviderRemote } tokenProvider
   * @param { !CdmServicePendingReceiver } receiver
   */

  getService(
      cdmPath,
      tokenProvider,
      receiver) {
    this.proxy.sendMessage(
        0,
        CdmServiceBroker_GetService_ParamsSpec.$,
        null,
        [
          cdmPath,
          tokenProvider,
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CdmServiceBroker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CdmServiceBrokerReceiver {
  /**
   * @param {!CdmServiceBrokerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CdmServiceBrokerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CdmServiceBrokerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmServiceBrokerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CdmServiceBroker_GetService_ParamsSpec.$,
        null,
        impl.getService.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CdmServiceBroker {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.CdmServiceBroker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CdmServiceBrokerRemote}
   */
  static getRemote() {
    let remote = new CdmServiceBrokerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CdmServiceBroker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CdmServiceBrokerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CdmServiceBrokerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmServiceBrokerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getService =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CdmServiceBroker_GetService_ParamsSpec.$,
        null,
        this.getService.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmService_CreateCdmFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SeatbeltExtensionTokenProvider_GetTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SeatbeltExtensionTokenProvider_GetTokens_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmServiceBroker_GetService_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CdmService_CreateCdmFactory_ParamsSpec.$,
    'CdmService_CreateCdmFactory_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_CdmFactoryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameInterfaces', 4,
        0,
        mojo.internal.InterfaceProxy(media_mojom_FrameInterfaceFactoryRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CdmService_CreateCdmFactory_Params {
  constructor() {
    /** @type { !media_mojom_CdmFactoryPendingReceiver } */
    this.factory;
    /** @type { !media_mojom_FrameInterfaceFactoryRemote } */
    this.frameInterfaces;
  }
}



mojo.internal.Struct(
    SeatbeltExtensionTokenProvider_GetTokens_ParamsSpec.$,
    'SeatbeltExtensionTokenProvider_GetTokens_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SeatbeltExtensionTokenProvider_GetTokens_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SeatbeltExtensionTokenProvider_GetTokens_ResponseParamsSpec.$,
    'SeatbeltExtensionTokenProvider_GetTokens_ResponseParams',
    [
      mojo.internal.StructField(
        'tokens', 0,
        0,
        mojo.internal.Array(sandbox_mac_mojom_SeatbeltExtensionTokenSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SeatbeltExtensionTokenProvider_GetTokens_ResponseParams {
  constructor() {
    /** @type { !Array<!sandbox_mac_mojom_SeatbeltExtensionToken> } */
    this.tokens;
  }
}



mojo.internal.Struct(
    CdmServiceBroker_GetService_ParamsSpec.$,
    'CdmServiceBroker_GetService_Params',
    [
      mojo.internal.StructField(
        'cdmPath', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tokenProvider', 8,
        0,
        mojo.internal.InterfaceProxy(SeatbeltExtensionTokenProviderRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 16,
        0,
        mojo.internal.InterfaceRequest(CdmServicePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CdmServiceBroker_GetService_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.cdmPath;
    /** @type { (SeatbeltExtensionTokenProviderRemote|undefined) } */
    this.tokenProvider;
    /** @type { !CdmServicePendingReceiver } */
    this.receiver;
  }
}

