// media/mojo/mojom/cdm_document_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/cdm_document_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', 'media_types.mojom.js');
  }



  function CdmDocumentService_ChallengePlatform_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmDocumentService_ChallengePlatform_Params.prototype.initDefaults_ = function() {
    this.serviceId = null;
    this.challenge = null;
  };
  CdmDocumentService_ChallengePlatform_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmDocumentService_ChallengePlatform_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmDocumentService_ChallengePlatform_Params.serviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmDocumentService_ChallengePlatform_Params.challenge
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmDocumentService_ChallengePlatform_Params.encodedSize = codec.kStructHeaderSize + 16;

  CdmDocumentService_ChallengePlatform_Params.decode = function(decoder) {
    var packed;
    var val = new CdmDocumentService_ChallengePlatform_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.serviceId =
        decoder.decodeStruct(codec.String);
    val.challenge =
        decoder.decodeStruct(codec.String);
    return val;
  };

  CdmDocumentService_ChallengePlatform_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmDocumentService_ChallengePlatform_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.serviceId);
    encoder.encodeStruct(codec.String, val.challenge);
  };
  function CdmDocumentService_ChallengePlatform_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmDocumentService_ChallengePlatform_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.signedData = null;
    this.signedDataSignature = null;
    this.platformKeyCertificate = null;
  };
  CdmDocumentService_ChallengePlatform_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmDocumentService_ChallengePlatform_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CdmDocumentService_ChallengePlatform_ResponseParams.signedData
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmDocumentService_ChallengePlatform_ResponseParams.signedDataSignature
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmDocumentService_ChallengePlatform_ResponseParams.platformKeyCertificate
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmDocumentService_ChallengePlatform_ResponseParams.encodedSize = codec.kStructHeaderSize + 32;

  CdmDocumentService_ChallengePlatform_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CdmDocumentService_ChallengePlatform_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.signedData =
        decoder.decodeStruct(codec.String);
    val.signedDataSignature =
        decoder.decodeStruct(codec.String);
    val.platformKeyCertificate =
        decoder.decodeStruct(codec.String);
    return val;
  };

  CdmDocumentService_ChallengePlatform_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmDocumentService_ChallengePlatform_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.signedData);
    encoder.encodeStruct(codec.String, val.signedDataSignature);
    encoder.encodeStruct(codec.String, val.platformKeyCertificate);
  };
  function CdmDocumentService_GetStorageId_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmDocumentService_GetStorageId_Params.prototype.initDefaults_ = function() {
    this.version = 0;
  };
  CdmDocumentService_GetStorageId_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmDocumentService_GetStorageId_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CdmDocumentService_GetStorageId_Params.encodedSize = codec.kStructHeaderSize + 8;

  CdmDocumentService_GetStorageId_Params.decode = function(decoder) {
    var packed;
    var val = new CdmDocumentService_GetStorageId_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.version =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CdmDocumentService_GetStorageId_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmDocumentService_GetStorageId_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.version);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CdmDocumentService_GetStorageId_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmDocumentService_GetStorageId_ResponseParams.prototype.initDefaults_ = function() {
    this.version = 0;
    this.storageId = null;
  };
  CdmDocumentService_GetStorageId_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmDocumentService_GetStorageId_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CdmDocumentService_GetStorageId_ResponseParams.storageId
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmDocumentService_GetStorageId_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CdmDocumentService_GetStorageId_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CdmDocumentService_GetStorageId_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.version =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.storageId =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  CdmDocumentService_GetStorageId_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmDocumentService_GetStorageId_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.version);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.storageId);
  };
  var kCdmDocumentService_ChallengePlatform_Name = 0;
  var kCdmDocumentService_GetStorageId_Name = 1;

  function CdmDocumentServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CdmDocumentService,
                                                   handleOrPtrInfo);
  }

  function CdmDocumentServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CdmDocumentService, associatedInterfacePtrInfo);
  }

  CdmDocumentServiceAssociatedPtr.prototype =
      Object.create(CdmDocumentServicePtr.prototype);
  CdmDocumentServiceAssociatedPtr.prototype.constructor =
      CdmDocumentServiceAssociatedPtr;

  function CdmDocumentServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  CdmDocumentServicePtr.prototype.challengePlatform = function() {
    return CdmDocumentServiceProxy.prototype.challengePlatform
        .apply(this.ptr.getProxy(), arguments);
  };

  CdmDocumentServiceProxy.prototype.challengePlatform = function(serviceId, challenge) {
    var params_ = new CdmDocumentService_ChallengePlatform_Params();
    params_.serviceId = serviceId;
    params_.challenge = challenge;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCdmDocumentService_ChallengePlatform_Name,
          codec.align(CdmDocumentService_ChallengePlatform_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CdmDocumentService_ChallengePlatform_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CdmDocumentService_ChallengePlatform_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CdmDocumentServicePtr.prototype.getStorageId = function() {
    return CdmDocumentServiceProxy.prototype.getStorageId
        .apply(this.ptr.getProxy(), arguments);
  };

  CdmDocumentServiceProxy.prototype.getStorageId = function(version) {
    var params_ = new CdmDocumentService_GetStorageId_Params();
    params_.version = version;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCdmDocumentService_GetStorageId_Name,
          codec.align(CdmDocumentService_GetStorageId_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CdmDocumentService_GetStorageId_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CdmDocumentService_GetStorageId_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function CdmDocumentServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  CdmDocumentServiceStub.prototype.challengePlatform = function(serviceId, challenge) {
    return this.delegate_ && this.delegate_.challengePlatform && this.delegate_.challengePlatform(serviceId, challenge);
  }
  CdmDocumentServiceStub.prototype.getStorageId = function(version) {
    return this.delegate_ && this.delegate_.getStorageId && this.delegate_.getStorageId(version);
  }

  CdmDocumentServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  CdmDocumentServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCdmDocumentService_ChallengePlatform_Name:
      var params = reader.decodeStruct(CdmDocumentService_ChallengePlatform_Params);
      this.challengePlatform(params.serviceId, params.challenge).then(function(response) {
        var responseParams =
            new CdmDocumentService_ChallengePlatform_ResponseParams();
        responseParams.success = response.success;
        responseParams.signedData = response.signedData;
        responseParams.signedDataSignature = response.signedDataSignature;
        responseParams.platformKeyCertificate = response.platformKeyCertificate;
        var builder = new codec.MessageV1Builder(
            kCdmDocumentService_ChallengePlatform_Name,
            codec.align(CdmDocumentService_ChallengePlatform_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CdmDocumentService_ChallengePlatform_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCdmDocumentService_GetStorageId_Name:
      var params = reader.decodeStruct(CdmDocumentService_GetStorageId_Params);
      this.getStorageId(params.version).then(function(response) {
        var responseParams =
            new CdmDocumentService_GetStorageId_ResponseParams();
        responseParams.version = response.version;
        responseParams.storageId = response.storageId;
        var builder = new codec.MessageV1Builder(
            kCdmDocumentService_GetStorageId_Name,
            codec.align(CdmDocumentService_GetStorageId_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CdmDocumentService_GetStorageId_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCdmDocumentServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCdmDocumentService_ChallengePlatform_Name:
        if (message.expectsResponse())
          paramsClass = CdmDocumentService_ChallengePlatform_Params;
      break;
      case kCdmDocumentService_GetStorageId_Name:
        if (message.expectsResponse())
          paramsClass = CdmDocumentService_GetStorageId_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCdmDocumentServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCdmDocumentService_ChallengePlatform_Name:
        if (message.isResponse())
          paramsClass = CdmDocumentService_ChallengePlatform_ResponseParams;
        break;
      case kCdmDocumentService_GetStorageId_Name:
        if (message.isResponse())
          paramsClass = CdmDocumentService_GetStorageId_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CdmDocumentService = {
    name: 'media.mojom.CdmDocumentService',
    kVersion: 0,
    ptrClass: CdmDocumentServicePtr,
    proxyClass: CdmDocumentServiceProxy,
    stubClass: CdmDocumentServiceStub,
    validateRequest: validateCdmDocumentServiceRequest,
    validateResponse: validateCdmDocumentServiceResponse,
  };
  CdmDocumentServiceStub.prototype.validator = validateCdmDocumentServiceRequest;
  CdmDocumentServiceProxy.prototype.validator = validateCdmDocumentServiceResponse;
  exports.CdmDocumentService = CdmDocumentService;
  exports.CdmDocumentServicePtr = CdmDocumentServicePtr;
  exports.CdmDocumentServiceAssociatedPtr = CdmDocumentServiceAssociatedPtr;
})();