// media/mojo/mojom/audio_stream_factory.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/audio_stream_factory.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_stream_factory.mojom-params-data.h"
namespace media {
namespace mojom {

namespace internal {


// static
bool AudioStreamFactory_CreateInputStream_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioStreamFactory_CreateInputStream_Params_Data* object =
      static_cast<const AudioStreamFactory_CreateInputStream_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->stream, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->log,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& device_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->device_id, validation_context,
                                         &device_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->group_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->processing_config, validation_context))
    return false;

  return true;
}

AudioStreamFactory_CreateInputStream_Params_Data::AudioStreamFactory_CreateInputStream_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioStreamFactory_CreateInputStream_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioStreamFactory_CreateInputStream_ResponseParams_Data* object =
      static_cast<const AudioStreamFactory_CreateInputStream_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->data_pipe, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->stream_id, validation_context))
    return false;

  return true;
}

AudioStreamFactory_CreateInputStream_ResponseParams_Data::AudioStreamFactory_CreateInputStream_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data* object =
      static_cast<const AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_stream_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_stream_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_device_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& output_device_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->output_device_id, validation_context,
                                         &output_device_id_validate_params)) {
    return false;
  }

  return true;
}

AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data::AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioStreamFactory_CreateOutputStream_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioStreamFactory_CreateOutputStream_Params_Data* object =
      static_cast<const AudioStreamFactory_CreateOutputStream_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->stream, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->log,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& device_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->device_id, validation_context,
                                         &device_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->group_id, validation_context))
    return false;

  return true;
}

AudioStreamFactory_CreateOutputStream_Params_Data::AudioStreamFactory_CreateOutputStream_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioStreamFactory_CreateOutputStream_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioStreamFactory_CreateOutputStream_ResponseParams_Data* object =
      static_cast<const AudioStreamFactory_CreateOutputStream_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->data_pipe, validation_context))
    return false;

  return true;
}

AudioStreamFactory_CreateOutputStream_ResponseParams_Data::AudioStreamFactory_CreateOutputStream_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioStreamFactory_CreateSwitchableOutputStream_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioStreamFactory_CreateSwitchableOutputStream_Params_Data* object =
      static_cast<const AudioStreamFactory_CreateSwitchableOutputStream_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->stream, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->device_switch_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->device_switch_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->log,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& device_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->device_id, validation_context,
                                         &device_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->group_id, validation_context))
    return false;

  return true;
}

AudioStreamFactory_CreateSwitchableOutputStream_Params_Data::AudioStreamFactory_CreateSwitchableOutputStream_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data* object =
      static_cast<const AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->data_pipe, validation_context))
    return false;

  return true;
}

AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data::AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioStreamFactory_BindMuter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioStreamFactory_BindMuter_Params_Data* object =
      static_cast<const AudioStreamFactory_BindMuter_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->group_id, validation_context))
    return false;

  return true;
}

AudioStreamFactory_BindMuter_Params_Data::AudioStreamFactory_BindMuter_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioStreamFactory_CreateLoopbackStream_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioStreamFactory_CreateLoopbackStream_Params_Data* object =
      static_cast<const AudioStreamFactory_CreateLoopbackStream_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->group_id, validation_context))
    return false;

  return true;
}

AudioStreamFactory_CreateLoopbackStream_Params_Data::AudioStreamFactory_CreateLoopbackStream_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data* object =
      static_cast<const AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->data_pipe, validation_context))
    return false;

  return true;
}

AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data::AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media