// media/mojo/mojom/audio_processing.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_H_
#define MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/audio_processing.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_processing.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_processing.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "media/mojo/mojom/audio_processing_mojom_traits.h"




namespace media::mojom {

class AudioProcessorControlsProxy;

template <typename ImplRefTraits>
class AudioProcessorControlsStub;

class AudioProcessorControlsRequestValidator;
class AudioProcessorControlsResponseValidator;


class AudioProcessorControls
    : public AudioProcessorControlsInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.AudioProcessorControls";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioProcessorControlsInterfaceBase;
  using Proxy_ = AudioProcessorControlsProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioProcessorControlsStub<ImplRefTraits>;

  using RequestValidator_ = AudioProcessorControlsRequestValidator;
  using ResponseValidator_ = AudioProcessorControlsResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetStatsMinVersion = 0,
    kSetPreferredNumCaptureChannelsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetStats_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPreferredNumCaptureChannels_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioProcessorControls() = default;

  using GetStatsCallback = base::OnceCallback<void(const ::media::AudioProcessingStats&)>;
  using GetStatsMojoCallback = base::OnceCallback<void(const ::media::AudioProcessingStats&)>;

  virtual void GetStats(GetStatsCallback callback) = 0;

  virtual void SetPreferredNumCaptureChannels(int32_t num_preferred_channels) = 0;
};



class  AudioProcessorControlsProxy
    : public AudioProcessorControls {
 public:
  using InterfaceType = AudioProcessorControls;

  explicit AudioProcessorControlsProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetStats(GetStatsCallback callback) final;
  
  void SetPreferredNumCaptureChannels(int32_t num_preferred_channels) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AudioProcessorControlsStubDispatch {
 public:
  static bool Accept(AudioProcessorControls* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioProcessorControls* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioProcessorControls>>
class AudioProcessorControlsStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioProcessorControlsStub() = default;
  ~AudioProcessorControlsStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioProcessorControlsStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioProcessorControlsStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioProcessorControlsRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AudioProcessorControlsResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  AudioProcessingStats {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioProcessingStats, T>::value>;
  using DataView = AudioProcessingStatsDataView;
  using Data_ = internal::AudioProcessingStats_Data;

  template <typename... Args>
  static AudioProcessingStatsPtr New(Args&&... args) {
    return AudioProcessingStatsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioProcessingStatsPtr From(const U& u) {
    return mojo::TypeConverter<AudioProcessingStatsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioProcessingStats>::Convert(*this);
  }


  AudioProcessingStats();

  AudioProcessingStats(
      bool has_echo_return_loss,
      double echo_return_loss,
      bool has_echo_return_loss_enhancement,
      double echo_return_loss_enhancement);


  ~AudioProcessingStats();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioProcessingStatsPtr>
  AudioProcessingStatsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioProcessingStats::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioProcessingStats::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioProcessingStats::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioProcessingStats::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioProcessingStats::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioProcessingStats::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioProcessingStats_UnserializedMessageContext<
            UserType, AudioProcessingStats::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioProcessingStats::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioProcessingStats::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioProcessingStats_UnserializedMessageContext<
            UserType, AudioProcessingStats::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioProcessingStats::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool has_echo_return_loss;
  
  double echo_return_loss;
  
  bool has_echo_return_loss_enhancement;
  
  double echo_return_loss_enhancement;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioProcessingStats::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioProcessingStats::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioProcessingStats::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioProcessingStats::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  AudioProcessingSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioProcessingSettings, T>::value>;
  using DataView = AudioProcessingSettingsDataView;
  using Data_ = internal::AudioProcessingSettings_Data;

  template <typename... Args>
  static AudioProcessingSettingsPtr New(Args&&... args) {
    return AudioProcessingSettingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioProcessingSettingsPtr From(const U& u) {
    return mojo::TypeConverter<AudioProcessingSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioProcessingSettings>::Convert(*this);
  }


  AudioProcessingSettings();

  AudioProcessingSettings(
      bool echo_cancellation,
      bool noise_suppression,
      bool automatic_gain_control,
      bool multi_channel_capture_processing,
      bool use_loopback_aec_reference);


  ~AudioProcessingSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioProcessingSettingsPtr>
  AudioProcessingSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioProcessingSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioProcessingSettings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioProcessingSettings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioProcessingSettings::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioProcessingSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioProcessingSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioProcessingSettings_UnserializedMessageContext<
            UserType, AudioProcessingSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioProcessingSettings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioProcessingSettings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioProcessingSettings_UnserializedMessageContext<
            UserType, AudioProcessingSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioProcessingSettings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool echo_cancellation;
  
  bool noise_suppression;
  
  bool automatic_gain_control;
  
  bool multi_channel_capture_processing;
  
  bool use_loopback_aec_reference;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioProcessingSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioProcessingSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioProcessingSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioProcessingSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AudioProcessingConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioProcessingConfig, T>::value>;
  using DataView = AudioProcessingConfigDataView;
  using Data_ = internal::AudioProcessingConfig_Data;

  template <typename... Args>
  static AudioProcessingConfigPtr New(Args&&... args) {
    return AudioProcessingConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioProcessingConfigPtr From(const U& u) {
    return mojo::TypeConverter<AudioProcessingConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioProcessingConfig>::Convert(*this);
  }


  AudioProcessingConfig();

  AudioProcessingConfig(
      ::mojo::PendingReceiver<AudioProcessorControls> controls_receiver,
      const ::media::AudioProcessingSettings& settings);

AudioProcessingConfig(const AudioProcessingConfig&) = delete;
AudioProcessingConfig& operator=(const AudioProcessingConfig&) = delete;

  ~AudioProcessingConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioProcessingConfigPtr>
  AudioProcessingConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioProcessingConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioProcessingConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioProcessingConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioProcessingConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioProcessingConfig_UnserializedMessageContext<
            UserType, AudioProcessingConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioProcessingConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioProcessingConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioProcessingConfig_UnserializedMessageContext<
            UserType, AudioProcessingConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioProcessingConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingReceiver<AudioProcessorControls> controls_receiver;
  
  ::media::AudioProcessingSettings settings;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioProcessingConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioProcessingConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioProcessingConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioProcessingConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AudioProcessingStatsPtr AudioProcessingStats::Clone() const {
  return New(
      mojo::Clone(has_echo_return_loss),
      mojo::Clone(echo_return_loss),
      mojo::Clone(has_echo_return_loss_enhancement),
      mojo::Clone(echo_return_loss_enhancement)
  );
}

template <typename T, AudioProcessingStats::EnableIfSame<T>*>
bool AudioProcessingStats::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_echo_return_loss, other_struct.has_echo_return_loss))
    return false;
  if (!mojo::Equals(this->echo_return_loss, other_struct.echo_return_loss))
    return false;
  if (!mojo::Equals(this->has_echo_return_loss_enhancement, other_struct.has_echo_return_loss_enhancement))
    return false;
  if (!mojo::Equals(this->echo_return_loss_enhancement, other_struct.echo_return_loss_enhancement))
    return false;
  return true;
}

template <typename T, AudioProcessingStats::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.has_echo_return_loss < rhs.has_echo_return_loss)
    return true;
  if (rhs.has_echo_return_loss < lhs.has_echo_return_loss)
    return false;
  if (lhs.echo_return_loss < rhs.echo_return_loss)
    return true;
  if (rhs.echo_return_loss < lhs.echo_return_loss)
    return false;
  if (lhs.has_echo_return_loss_enhancement < rhs.has_echo_return_loss_enhancement)
    return true;
  if (rhs.has_echo_return_loss_enhancement < lhs.has_echo_return_loss_enhancement)
    return false;
  if (lhs.echo_return_loss_enhancement < rhs.echo_return_loss_enhancement)
    return true;
  if (rhs.echo_return_loss_enhancement < lhs.echo_return_loss_enhancement)
    return false;
  return false;
}
template <typename StructPtrType>
AudioProcessingSettingsPtr AudioProcessingSettings::Clone() const {
  return New(
      mojo::Clone(echo_cancellation),
      mojo::Clone(noise_suppression),
      mojo::Clone(automatic_gain_control),
      mojo::Clone(multi_channel_capture_processing),
      mojo::Clone(use_loopback_aec_reference)
  );
}

template <typename T, AudioProcessingSettings::EnableIfSame<T>*>
bool AudioProcessingSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->echo_cancellation, other_struct.echo_cancellation))
    return false;
  if (!mojo::Equals(this->noise_suppression, other_struct.noise_suppression))
    return false;
  if (!mojo::Equals(this->automatic_gain_control, other_struct.automatic_gain_control))
    return false;
  if (!mojo::Equals(this->multi_channel_capture_processing, other_struct.multi_channel_capture_processing))
    return false;
  if (!mojo::Equals(this->use_loopback_aec_reference, other_struct.use_loopback_aec_reference))
    return false;
  return true;
}

template <typename T, AudioProcessingSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.echo_cancellation < rhs.echo_cancellation)
    return true;
  if (rhs.echo_cancellation < lhs.echo_cancellation)
    return false;
  if (lhs.noise_suppression < rhs.noise_suppression)
    return true;
  if (rhs.noise_suppression < lhs.noise_suppression)
    return false;
  if (lhs.automatic_gain_control < rhs.automatic_gain_control)
    return true;
  if (rhs.automatic_gain_control < lhs.automatic_gain_control)
    return false;
  if (lhs.multi_channel_capture_processing < rhs.multi_channel_capture_processing)
    return true;
  if (rhs.multi_channel_capture_processing < lhs.multi_channel_capture_processing)
    return false;
  if (lhs.use_loopback_aec_reference < rhs.use_loopback_aec_reference)
    return true;
  if (rhs.use_loopback_aec_reference < lhs.use_loopback_aec_reference)
    return false;
  return false;
}
template <typename StructPtrType>
AudioProcessingConfigPtr AudioProcessingConfig::Clone() const {
  return New(
      mojo::Clone(controls_receiver),
      mojo::Clone(settings)
  );
}

template <typename T, AudioProcessingConfig::EnableIfSame<T>*>
bool AudioProcessingConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->controls_receiver, other_struct.controls_receiver))
    return false;
  if (!mojo::Equals(this->settings, other_struct.settings))
    return false;
  return true;
}

template <typename T, AudioProcessingConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.controls_receiver < rhs.controls_receiver)
    return true;
  if (rhs.controls_receiver < lhs.controls_receiver)
    return false;
  if (lhs.settings < rhs.settings)
    return true;
  if (rhs.settings < lhs.settings)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::AudioProcessingStats::DataView,
                                         ::media::mojom::AudioProcessingStatsPtr> {
  static bool IsNull(const ::media::mojom::AudioProcessingStatsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::AudioProcessingStatsPtr* output) { output->reset(); }

  static decltype(::media::mojom::AudioProcessingStats::has_echo_return_loss) has_echo_return_loss(
      const ::media::mojom::AudioProcessingStatsPtr& input) {
    return input->has_echo_return_loss;
  }

  static decltype(::media::mojom::AudioProcessingStats::echo_return_loss) echo_return_loss(
      const ::media::mojom::AudioProcessingStatsPtr& input) {
    return input->echo_return_loss;
  }

  static decltype(::media::mojom::AudioProcessingStats::has_echo_return_loss_enhancement) has_echo_return_loss_enhancement(
      const ::media::mojom::AudioProcessingStatsPtr& input) {
    return input->has_echo_return_loss_enhancement;
  }

  static decltype(::media::mojom::AudioProcessingStats::echo_return_loss_enhancement) echo_return_loss_enhancement(
      const ::media::mojom::AudioProcessingStatsPtr& input) {
    return input->echo_return_loss_enhancement;
  }

  static bool Read(::media::mojom::AudioProcessingStats::DataView input, ::media::mojom::AudioProcessingStatsPtr* output);
};


template <>
struct  StructTraits<::media::mojom::AudioProcessingSettings::DataView,
                                         ::media::mojom::AudioProcessingSettingsPtr> {
  static bool IsNull(const ::media::mojom::AudioProcessingSettingsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::AudioProcessingSettingsPtr* output) { output->reset(); }

  static decltype(::media::mojom::AudioProcessingSettings::echo_cancellation) echo_cancellation(
      const ::media::mojom::AudioProcessingSettingsPtr& input) {
    return input->echo_cancellation;
  }

  static decltype(::media::mojom::AudioProcessingSettings::noise_suppression) noise_suppression(
      const ::media::mojom::AudioProcessingSettingsPtr& input) {
    return input->noise_suppression;
  }

  static decltype(::media::mojom::AudioProcessingSettings::automatic_gain_control) automatic_gain_control(
      const ::media::mojom::AudioProcessingSettingsPtr& input) {
    return input->automatic_gain_control;
  }

  static decltype(::media::mojom::AudioProcessingSettings::multi_channel_capture_processing) multi_channel_capture_processing(
      const ::media::mojom::AudioProcessingSettingsPtr& input) {
    return input->multi_channel_capture_processing;
  }

  static decltype(::media::mojom::AudioProcessingSettings::use_loopback_aec_reference) use_loopback_aec_reference(
      const ::media::mojom::AudioProcessingSettingsPtr& input) {
    return input->use_loopback_aec_reference;
  }

  static bool Read(::media::mojom::AudioProcessingSettings::DataView input, ::media::mojom::AudioProcessingSettingsPtr* output);
};


template <>
struct  StructTraits<::media::mojom::AudioProcessingConfig::DataView,
                                         ::media::mojom::AudioProcessingConfigPtr> {
  static bool IsNull(const ::media::mojom::AudioProcessingConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::AudioProcessingConfigPtr* output) { output->reset(); }

  static  decltype(::media::mojom::AudioProcessingConfig::controls_receiver)& controls_receiver(
       ::media::mojom::AudioProcessingConfigPtr& input) {
    return input->controls_receiver;
  }

  static const decltype(::media::mojom::AudioProcessingConfig::settings)& settings(
      const ::media::mojom::AudioProcessingConfigPtr& input) {
    return input->settings;
  }

  static bool Read(::media::mojom::AudioProcessingConfig::DataView input, ::media::mojom::AudioProcessingConfigPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_H_