// media/mojo/mojom/audio_output_stream.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/audio_output_stream.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_output_stream.mojom-params-data.h"
#include "media/mojo/mojom/audio_output_stream.mojom-shared-message-ids.h"

#include "media/mojo/mojom/audio_output_stream.mojom-import-headers.h"
#include "media/mojo/mojom/audio_output_stream.mojom-test-utils.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

AudioOutputStream::IPCStableHashFunction AudioOutputStream::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioOutputStream>(message.name())) {
    case messages::AudioOutputStream::kPlay: {
      return &AudioOutputStream::Play_Sym::IPCStableHash;
    }
    case messages::AudioOutputStream::kPause: {
      return &AudioOutputStream::Pause_Sym::IPCStableHash;
    }
    case messages::AudioOutputStream::kFlush: {
      return &AudioOutputStream::Flush_Sym::IPCStableHash;
    }
    case messages::AudioOutputStream::kSetVolume: {
      return &AudioOutputStream::SetVolume_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioOutputStream::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioOutputStream>(message.name())) {
      case messages::AudioOutputStream::kPlay:
            return "Receive media::mojom::AudioOutputStream::Play";
      case messages::AudioOutputStream::kPause:
            return "Receive media::mojom::AudioOutputStream::Pause";
      case messages::AudioOutputStream::kFlush:
            return "Receive media::mojom::AudioOutputStream::Flush";
      case messages::AudioOutputStream::kSetVolume:
            return "Receive media::mojom::AudioOutputStream::SetVolume";
    }
  } else {
    switch (static_cast<messages::AudioOutputStream>(message.name())) {
      case messages::AudioOutputStream::kPlay:
            return "Receive reply media::mojom::AudioOutputStream::Play";
      case messages::AudioOutputStream::kPause:
            return "Receive reply media::mojom::AudioOutputStream::Pause";
      case messages::AudioOutputStream::kFlush:
            return "Receive reply media::mojom::AudioOutputStream::Flush";
      case messages::AudioOutputStream::kSetVolume:
            return "Receive reply media::mojom::AudioOutputStream::SetVolume";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioOutputStream::Play_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcbd5b7ff;  // IPCStableHash for media::mojom::AudioOutputStream::Play
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioOutputStream::Pause_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x09a08c31;  // IPCStableHash for media::mojom::AudioOutputStream::Pause
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioOutputStream::Flush_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x632e5b11;  // IPCStableHash for media::mojom::AudioOutputStream::Flush
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioOutputStream::SetVolume_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7390c745;  // IPCStableHash for media::mojom::AudioOutputStream::SetVolume
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioOutputStreamProxy::AudioOutputStreamProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioOutputStreamProxy::Play(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioOutputStream::Play");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioOutputStream::kPlay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStream_Play_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStream::Name_);
  message.set_method_name("Play");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioOutputStreamProxy::Pause(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioOutputStream::Pause");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioOutputStream::kPause), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStream_Pause_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStream::Name_);
  message.set_method_name("Pause");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioOutputStreamProxy::Flush(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioOutputStream::Flush");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioOutputStream::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStream_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStream::Name_);
  message.set_method_name("Flush");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioOutputStreamProxy::SetVolume(
    double in_volume) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioOutputStream::SetVolume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("volume"), in_volume,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioOutputStream::kSetVolume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStream_SetVolume_Params_Data> params(
          message);
  params.Allocate();

  params->volume = in_volume;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStream::Name_);
  message.set_method_name("SetVolume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioOutputStreamStubDispatch::Accept(
    AudioOutputStream* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioOutputStream>(message->header()->name)) {
    case messages::AudioOutputStream::kPlay: {
      DCHECK(message->is_serialized());
      internal::AudioOutputStream_Play_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStream_Play_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioOutputStream.0
      bool success = true;
      AudioOutputStream_Play_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStream::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Play(        );
      return true;
    }
    case messages::AudioOutputStream::kPause: {
      DCHECK(message->is_serialized());
      internal::AudioOutputStream_Pause_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStream_Pause_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioOutputStream.1
      bool success = true;
      AudioOutputStream_Pause_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStream::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Pause(        );
      return true;
    }
    case messages::AudioOutputStream::kFlush: {
      DCHECK(message->is_serialized());
      internal::AudioOutputStream_Flush_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStream_Flush_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioOutputStream.2
      bool success = true;
      AudioOutputStream_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStream::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(        );
      return true;
    }
    case messages::AudioOutputStream::kSetVolume: {
      DCHECK(message->is_serialized());
      internal::AudioOutputStream_SetVolume_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStream_SetVolume_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioOutputStream.3
      bool success = true;
      double p_volume{};
      AudioOutputStream_SetVolume_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_volume = input_data_view.volume();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStream::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVolume(        
        std::move(p_volume));
      return true;
    }
  }
  return false;
}

// static
bool AudioOutputStreamStubDispatch::AcceptWithResponder(
    AudioOutputStream* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioOutputStream>(message->header()->name)) {
    case messages::AudioOutputStream::kPlay: {
      break;
    }
    case messages::AudioOutputStream::kPause: {
      break;
    }
    case messages::AudioOutputStream::kFlush: {
      break;
    }
    case messages::AudioOutputStream::kSetVolume: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioOutputStreamValidationInfo[] = {
    { &internal::AudioOutputStream_Play_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioOutputStream_Pause_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioOutputStream_Flush_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioOutputStream_SetVolume_Params_Data::Validate,
     nullptr /* no response */},
};

bool AudioOutputStreamRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::AudioOutputStream::Name_,
    kAudioOutputStreamValidationInfo);
}

// The declaration includes the definition on other builds.

AudioOutputStreamObserver::IPCStableHashFunction AudioOutputStreamObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioOutputStreamObserver>(message.name())) {
    case messages::AudioOutputStreamObserver::kDidStartPlaying: {
      return &AudioOutputStreamObserver::DidStartPlaying_Sym::IPCStableHash;
    }
    case messages::AudioOutputStreamObserver::kDidStopPlaying: {
      return &AudioOutputStreamObserver::DidStopPlaying_Sym::IPCStableHash;
    }
    case messages::AudioOutputStreamObserver::kDidChangeAudibleState: {
      return &AudioOutputStreamObserver::DidChangeAudibleState_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioOutputStreamObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioOutputStreamObserver>(message.name())) {
      case messages::AudioOutputStreamObserver::kDidStartPlaying:
            return "Receive media::mojom::AudioOutputStreamObserver::DidStartPlaying";
      case messages::AudioOutputStreamObserver::kDidStopPlaying:
            return "Receive media::mojom::AudioOutputStreamObserver::DidStopPlaying";
      case messages::AudioOutputStreamObserver::kDidChangeAudibleState:
            return "Receive media::mojom::AudioOutputStreamObserver::DidChangeAudibleState";
    }
  } else {
    switch (static_cast<messages::AudioOutputStreamObserver>(message.name())) {
      case messages::AudioOutputStreamObserver::kDidStartPlaying:
            return "Receive reply media::mojom::AudioOutputStreamObserver::DidStartPlaying";
      case messages::AudioOutputStreamObserver::kDidStopPlaying:
            return "Receive reply media::mojom::AudioOutputStreamObserver::DidStopPlaying";
      case messages::AudioOutputStreamObserver::kDidChangeAudibleState:
            return "Receive reply media::mojom::AudioOutputStreamObserver::DidChangeAudibleState";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioOutputStreamObserver::DidStartPlaying_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfaae1156;  // IPCStableHash for media::mojom::AudioOutputStreamObserver::DidStartPlaying
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioOutputStreamObserver::DidStopPlaying_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15da5b44;  // IPCStableHash for media::mojom::AudioOutputStreamObserver::DidStopPlaying
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioOutputStreamObserver::DidChangeAudibleState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbe153725;  // IPCStableHash for media::mojom::AudioOutputStreamObserver::DidChangeAudibleState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioOutputStreamObserverProxy::AudioOutputStreamObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioOutputStreamObserverProxy::DidStartPlaying(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioOutputStreamObserver::DidStartPlaying");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioOutputStreamObserver::kDidStartPlaying), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStreamObserver_DidStartPlaying_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStreamObserver::Name_);
  message.set_method_name("DidStartPlaying");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioOutputStreamObserverProxy::DidStopPlaying(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioOutputStreamObserver::DidStopPlaying");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioOutputStreamObserver::kDidStopPlaying), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStreamObserver_DidStopPlaying_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStreamObserver::Name_);
  message.set_method_name("DidStopPlaying");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioOutputStreamObserverProxy::DidChangeAudibleState(
    bool in_is_audible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioOutputStreamObserver::DidChangeAudibleState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_audible"), in_is_audible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioOutputStreamObserver::kDidChangeAudibleState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStreamObserver_DidChangeAudibleState_Params_Data> params(
          message);
  params.Allocate();

  params->is_audible = in_is_audible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStreamObserver::Name_);
  message.set_method_name("DidChangeAudibleState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioOutputStreamObserverStubDispatch::Accept(
    AudioOutputStreamObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioOutputStreamObserver>(message->header()->name)) {
    case messages::AudioOutputStreamObserver::kDidStartPlaying: {
      DCHECK(message->is_serialized());
      internal::AudioOutputStreamObserver_DidStartPlaying_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStreamObserver_DidStartPlaying_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioOutputStreamObserver.0
      bool success = true;
      AudioOutputStreamObserver_DidStartPlaying_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStreamObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStartPlaying(        );
      return true;
    }
    case messages::AudioOutputStreamObserver::kDidStopPlaying: {
      DCHECK(message->is_serialized());
      internal::AudioOutputStreamObserver_DidStopPlaying_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStreamObserver_DidStopPlaying_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioOutputStreamObserver.1
      bool success = true;
      AudioOutputStreamObserver_DidStopPlaying_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStreamObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStopPlaying(        );
      return true;
    }
    case messages::AudioOutputStreamObserver::kDidChangeAudibleState: {
      DCHECK(message->is_serialized());
      internal::AudioOutputStreamObserver_DidChangeAudibleState_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStreamObserver_DidChangeAudibleState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioOutputStreamObserver.2
      bool success = true;
      bool p_is_audible{};
      AudioOutputStreamObserver_DidChangeAudibleState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_audible = input_data_view.is_audible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStreamObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeAudibleState(        
        std::move(p_is_audible));
      return true;
    }
  }
  return false;
}

// static
bool AudioOutputStreamObserverStubDispatch::AcceptWithResponder(
    AudioOutputStreamObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioOutputStreamObserver>(message->header()->name)) {
    case messages::AudioOutputStreamObserver::kDidStartPlaying: {
      break;
    }
    case messages::AudioOutputStreamObserver::kDidStopPlaying: {
      break;
    }
    case messages::AudioOutputStreamObserver::kDidChangeAudibleState: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioOutputStreamObserverValidationInfo[] = {
    { &internal::AudioOutputStreamObserver_DidStartPlaying_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioOutputStreamObserver_DidStopPlaying_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioOutputStreamObserver_DidChangeAudibleState_Params_Data::Validate,
     nullptr /* no response */},
};

bool AudioOutputStreamObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::AudioOutputStreamObserver::Name_,
    kAudioOutputStreamObserverValidationInfo);
}

// The declaration includes the definition on other builds.

AudioOutputStreamProvider::IPCStableHashFunction AudioOutputStreamProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioOutputStreamProvider>(message.name())) {
    case messages::AudioOutputStreamProvider::kAcquire: {
      return &AudioOutputStreamProvider::Acquire_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioOutputStreamProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioOutputStreamProvider>(message.name())) {
      case messages::AudioOutputStreamProvider::kAcquire:
            return "Receive media::mojom::AudioOutputStreamProvider::Acquire";
    }
  } else {
    switch (static_cast<messages::AudioOutputStreamProvider>(message.name())) {
      case messages::AudioOutputStreamProvider::kAcquire:
            return "Receive reply media::mojom::AudioOutputStreamProvider::Acquire";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioOutputStreamProvider::Acquire_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc0871cf7;  // IPCStableHash for media::mojom::AudioOutputStreamProvider::Acquire
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioOutputStreamProviderProxy::AudioOutputStreamProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioOutputStreamProviderProxy::Acquire(
    const ::media::AudioParameters& in_params, ::mojo::PendingRemote<AudioOutputStreamProviderClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioOutputStreamProvider::Acquire", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const ::media::AudioParameters&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<AudioOutputStreamProviderClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioOutputStreamProvider::kAcquire), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStreamProvider_Acquire_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in AudioOutputStreamProvider.Acquire request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioOutputStreamProviderClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in AudioOutputStreamProvider.Acquire request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStreamProvider::Name_);
  message.set_method_name("Acquire");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioOutputStreamProviderStubDispatch::Accept(
    AudioOutputStreamProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioOutputStreamProvider>(message->header()->name)) {
    case messages::AudioOutputStreamProvider::kAcquire: {
      DCHECK(message->is_serialized());
      internal::AudioOutputStreamProvider_Acquire_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStreamProvider_Acquire_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioOutputStreamProvider.0
      bool success = true;
      ::media::AudioParameters p_params{};
      ::mojo::PendingRemote<AudioOutputStreamProviderClient> p_client{};
      AudioOutputStreamProvider_Acquire_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStreamProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Acquire(        
        std::move(p_params), 
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool AudioOutputStreamProviderStubDispatch::AcceptWithResponder(
    AudioOutputStreamProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioOutputStreamProvider>(message->header()->name)) {
    case messages::AudioOutputStreamProvider::kAcquire: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioOutputStreamProviderValidationInfo[] = {
    { &internal::AudioOutputStreamProvider_Acquire_Params_Data::Validate,
     nullptr /* no response */},
};

bool AudioOutputStreamProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::AudioOutputStreamProvider::Name_,
    kAudioOutputStreamProviderValidationInfo);
}

// The declaration includes the definition on other builds.

AudioOutputStreamProviderClient::IPCStableHashFunction AudioOutputStreamProviderClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioOutputStreamProviderClient>(message.name())) {
    case messages::AudioOutputStreamProviderClient::kCreated: {
      return &AudioOutputStreamProviderClient::Created_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioOutputStreamProviderClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioOutputStreamProviderClient>(message.name())) {
      case messages::AudioOutputStreamProviderClient::kCreated:
            return "Receive media::mojom::AudioOutputStreamProviderClient::Created";
    }
  } else {
    switch (static_cast<messages::AudioOutputStreamProviderClient>(message.name())) {
      case messages::AudioOutputStreamProviderClient::kCreated:
            return "Receive reply media::mojom::AudioOutputStreamProviderClient::Created";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioOutputStreamProviderClient::Created_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x42dd484a;  // IPCStableHash for media::mojom::AudioOutputStreamProviderClient::Created
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioOutputStreamProviderClientProxy::AudioOutputStreamProviderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioOutputStreamProviderClientProxy::Created(
    ::mojo::PendingRemote<AudioOutputStream> in_stream, ::media::mojom::ReadWriteAudioDataPipePtr in_data_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioOutputStreamProviderClient::Created", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream,
                        "<value of type ::mojo::PendingRemote<AudioOutputStream>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe"), in_data_pipe,
                        "<value of type ::media::mojom::ReadWriteAudioDataPipePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioOutputStreamProviderClient::kCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStreamProviderClient_Created_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioOutputStreamInterfaceBase>>(
    in_stream,
    &params->stream,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->stream)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid stream in AudioOutputStreamProviderClient.Created request");
  mojo::internal::MessageFragment<
      typename decltype(params->data_pipe)::BaseType> data_pipe_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
    in_data_pipe,
    data_pipe_fragment);

  params->data_pipe.Set(
      data_pipe_fragment.is_null() ? nullptr : data_pipe_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data_pipe.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data_pipe in AudioOutputStreamProviderClient.Created request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStreamProviderClient::Name_);
  message.set_method_name("Created");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioOutputStreamProviderClientStubDispatch::Accept(
    AudioOutputStreamProviderClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioOutputStreamProviderClient>(message->header()->name)) {
    case messages::AudioOutputStreamProviderClient::kCreated: {
      DCHECK(message->is_serialized());
      internal::AudioOutputStreamProviderClient_Created_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStreamProviderClient_Created_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioOutputStreamProviderClient.0
      bool success = true;
      ::mojo::PendingRemote<AudioOutputStream> p_stream{};
      ::media::mojom::ReadWriteAudioDataPipePtr p_data_pipe{};
      AudioOutputStreamProviderClient_Created_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_stream =
            input_data_view.TakeStream<decltype(p_stream)>();
      }
      if (success && !input_data_view.ReadDataPipe(&p_data_pipe))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStreamProviderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Created(        
        std::move(p_stream), 
        std::move(p_data_pipe));
      return true;
    }
  }
  return false;
}

// static
bool AudioOutputStreamProviderClientStubDispatch::AcceptWithResponder(
    AudioOutputStreamProviderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioOutputStreamProviderClient>(message->header()->name)) {
    case messages::AudioOutputStreamProviderClient::kCreated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioOutputStreamProviderClientValidationInfo[] = {
    { &internal::AudioOutputStreamProviderClient_Created_Params_Data::Validate,
     nullptr /* no response */},
};

bool AudioOutputStreamProviderClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::AudioOutputStreamProviderClient::Name_,
    kAudioOutputStreamProviderClientValidationInfo);
}

// The declaration includes the definition on other builds.

DeviceSwitchInterface::IPCStableHashFunction DeviceSwitchInterface::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DeviceSwitchInterface>(message.name())) {
    case messages::DeviceSwitchInterface::kSwitchAudioOutputDeviceId: {
      return &DeviceSwitchInterface::SwitchAudioOutputDeviceId_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DeviceSwitchInterface::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DeviceSwitchInterface>(message.name())) {
      case messages::DeviceSwitchInterface::kSwitchAudioOutputDeviceId:
            return "Receive media::mojom::DeviceSwitchInterface::SwitchAudioOutputDeviceId";
    }
  } else {
    switch (static_cast<messages::DeviceSwitchInterface>(message.name())) {
      case messages::DeviceSwitchInterface::kSwitchAudioOutputDeviceId:
            return "Receive reply media::mojom::DeviceSwitchInterface::SwitchAudioOutputDeviceId";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DeviceSwitchInterface::SwitchAudioOutputDeviceId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x01b6153e;  // IPCStableHash for media::mojom::DeviceSwitchInterface::SwitchAudioOutputDeviceId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DeviceSwitchInterfaceProxy::DeviceSwitchInterfaceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceSwitchInterfaceProxy::SwitchAudioOutputDeviceId(
    const std::string& in_output_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::DeviceSwitchInterface::SwitchAudioOutputDeviceId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_device_id"), in_output_device_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceSwitchInterface::kSwitchAudioOutputDeviceId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->output_device_id)::BaseType> output_device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_output_device_id,
    output_device_id_fragment);

  params->output_device_id.Set(
      output_device_id_fragment.is_null() ? nullptr : output_device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->output_device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null output_device_id in DeviceSwitchInterface.SwitchAudioOutputDeviceId request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceSwitchInterface::Name_);
  message.set_method_name("SwitchAudioOutputDeviceId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DeviceSwitchInterfaceStubDispatch::Accept(
    DeviceSwitchInterface* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DeviceSwitchInterface>(message->header()->name)) {
    case messages::DeviceSwitchInterface::kSwitchAudioOutputDeviceId: {
      DCHECK(message->is_serialized());
      internal::DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data* params =
          reinterpret_cast<internal::DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DeviceSwitchInterface.0
      bool success = true;
      std::string p_output_device_id{};
      DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOutputDeviceId(&p_output_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceSwitchInterface::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SwitchAudioOutputDeviceId(        
        std::move(p_output_device_id));
      return true;
    }
  }
  return false;
}

// static
bool DeviceSwitchInterfaceStubDispatch::AcceptWithResponder(
    DeviceSwitchInterface* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DeviceSwitchInterface>(message->header()->name)) {
    case messages::DeviceSwitchInterface::kSwitchAudioOutputDeviceId: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDeviceSwitchInterfaceValidationInfo[] = {
    { &internal::DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data::Validate,
     nullptr /* no response */},
};

bool DeviceSwitchInterfaceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::DeviceSwitchInterface::Name_,
    kDeviceSwitchInterfaceValidationInfo);
}



}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void AudioOutputStreamInterceptorForTesting::Play() {
  GetForwardingInterface()->Play();
}
void AudioOutputStreamInterceptorForTesting::Pause() {
  GetForwardingInterface()->Pause();
}
void AudioOutputStreamInterceptorForTesting::Flush() {
  GetForwardingInterface()->Flush();
}
void AudioOutputStreamInterceptorForTesting::SetVolume(double volume) {
  GetForwardingInterface()->SetVolume(
    std::move(volume)
    );
}
AudioOutputStreamAsyncWaiter::AudioOutputStreamAsyncWaiter(
    AudioOutputStream* proxy) : proxy_(proxy) {}

AudioOutputStreamAsyncWaiter::~AudioOutputStreamAsyncWaiter() = default;





void AudioOutputStreamObserverInterceptorForTesting::DidStartPlaying() {
  GetForwardingInterface()->DidStartPlaying();
}
void AudioOutputStreamObserverInterceptorForTesting::DidStopPlaying() {
  GetForwardingInterface()->DidStopPlaying();
}
void AudioOutputStreamObserverInterceptorForTesting::DidChangeAudibleState(bool is_audible) {
  GetForwardingInterface()->DidChangeAudibleState(
    std::move(is_audible)
    );
}
AudioOutputStreamObserverAsyncWaiter::AudioOutputStreamObserverAsyncWaiter(
    AudioOutputStreamObserver* proxy) : proxy_(proxy) {}

AudioOutputStreamObserverAsyncWaiter::~AudioOutputStreamObserverAsyncWaiter() = default;





void AudioOutputStreamProviderInterceptorForTesting::Acquire(const ::media::AudioParameters& params, ::mojo::PendingRemote<AudioOutputStreamProviderClient> client) {
  GetForwardingInterface()->Acquire(
    std::move(params)
    , 
    std::move(client)
    );
}
AudioOutputStreamProviderAsyncWaiter::AudioOutputStreamProviderAsyncWaiter(
    AudioOutputStreamProvider* proxy) : proxy_(proxy) {}

AudioOutputStreamProviderAsyncWaiter::~AudioOutputStreamProviderAsyncWaiter() = default;





void AudioOutputStreamProviderClientInterceptorForTesting::Created(::mojo::PendingRemote<AudioOutputStream> stream, ::media::mojom::ReadWriteAudioDataPipePtr data_pipe) {
  GetForwardingInterface()->Created(
    std::move(stream)
    , 
    std::move(data_pipe)
    );
}
AudioOutputStreamProviderClientAsyncWaiter::AudioOutputStreamProviderClientAsyncWaiter(
    AudioOutputStreamProviderClient* proxy) : proxy_(proxy) {}

AudioOutputStreamProviderClientAsyncWaiter::~AudioOutputStreamProviderClientAsyncWaiter() = default;





void DeviceSwitchInterfaceInterceptorForTesting::SwitchAudioOutputDeviceId(const std::string& output_device_id) {
  GetForwardingInterface()->SwitchAudioOutputDeviceId(
    std::move(output_device_id)
    );
}
DeviceSwitchInterfaceAsyncWaiter::DeviceSwitchInterfaceAsyncWaiter(
    DeviceSwitchInterface* proxy) : proxy_(proxy) {}

DeviceSwitchInterfaceAsyncWaiter::~DeviceSwitchInterfaceAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif