// media/mojo/mojom/audio_logging.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  AudioParameters as media_mojom_AudioParameters,
  AudioParametersSpec as media_mojom_AudioParametersSpec
} from './audio_parameters.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AudioLogComponentSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AudioLogComponent = {
  
  kInputController: 0,
  kOutputController: 1,
  kOutputStream: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioLogPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioLog', scope);
  }
}

/** @interface */
export class AudioLogInterface {
  
  /**
   * @param { !media_mojom_AudioParameters } params
   * @param { !string } deviceId
   */

  onCreated(params, deviceId) {}
  
  /**
   */

  onStarted() {}
  
  /**
   */

  onStopped() {}
  
  /**
   */

  onClosed() {}
  
  /**
   */

  onError() {}
  
  /**
   * @param { !number } volume
   */

  onSetVolume(volume) {}
  
  /**
   * @param { !string } message
   */

  onProcessingStateChanged(message) {}
  
  /**
   * @param { !string } message
   */

  onLogMessage(message) {}
}

/**
 * @implements { AudioLogInterface }
 */
export class AudioLogRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioLogPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioLogPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioLogPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_AudioParameters } params
   * @param { !string } deviceId
   */

  onCreated(
      params,
      deviceId) {
    this.proxy.sendMessage(
        0,
        AudioLog_OnCreated_ParamsSpec.$,
        null,
        [
          params,
          deviceId
        ],
        false);
  }

  
  /**
   */

  onStarted() {
    this.proxy.sendMessage(
        1,
        AudioLog_OnStarted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onStopped() {
    this.proxy.sendMessage(
        2,
        AudioLog_OnStopped_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onClosed() {
    this.proxy.sendMessage(
        3,
        AudioLog_OnClosed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onError() {
    this.proxy.sendMessage(
        4,
        AudioLog_OnError_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } volume
   */

  onSetVolume(
      volume) {
    this.proxy.sendMessage(
        5,
        AudioLog_OnSetVolume_ParamsSpec.$,
        null,
        [
          volume
        ],
        false);
  }

  
  /**
   * @param { !string } message
   */

  onProcessingStateChanged(
      message) {
    this.proxy.sendMessage(
        6,
        AudioLog_OnProcessingStateChanged_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  
  /**
   * @param { !string } message
   */

  onLogMessage(
      message) {
    this.proxy.sendMessage(
        7,
        AudioLog_OnLogMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioLog
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioLogReceiver {
  /**
   * @param {!AudioLogInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioLogRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioLogRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioLogRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioLog_OnCreated_ParamsSpec.$,
        null,
        impl.onCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioLog_OnStarted_ParamsSpec.$,
        null,
        impl.onStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AudioLog_OnStopped_ParamsSpec.$,
        null,
        impl.onStopped.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        AudioLog_OnClosed_ParamsSpec.$,
        null,
        impl.onClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        AudioLog_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        AudioLog_OnSetVolume_ParamsSpec.$,
        null,
        impl.onSetVolume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        AudioLog_OnProcessingStateChanged_ParamsSpec.$,
        null,
        impl.onProcessingStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        AudioLog_OnLogMessage_ParamsSpec.$,
        null,
        impl.onLogMessage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioLog {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioLog";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioLogRemote}
   */
  static getRemote() {
    let remote = new AudioLogRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioLog
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioLogCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioLogRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioLogRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioLog_OnCreated_ParamsSpec.$,
        null,
        this.onCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioLog_OnStarted_ParamsSpec.$,
        null,
        this.onStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStopped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AudioLog_OnStopped_ParamsSpec.$,
        null,
        this.onStopped.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        AudioLog_OnClosed_ParamsSpec.$,
        null,
        this.onClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        AudioLog_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSetVolume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        AudioLog_OnSetVolume_ParamsSpec.$,
        null,
        this.onSetVolume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onProcessingStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        AudioLog_OnProcessingStateChanged_ParamsSpec.$,
        null,
        this.onProcessingStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLogMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        AudioLog_OnLogMessage_ParamsSpec.$,
        null,
        this.onLogMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioLogFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioLogFactory', scope);
  }
}

/** @interface */
export class AudioLogFactoryInterface {
  
  /**
   * @param { !AudioLogComponent } component
   * @param { !number } componentId
   * @param { !AudioLogPendingReceiver } audioLogReceiver
   */

  createAudioLog(component, componentId, audioLogReceiver) {}
}

/**
 * @implements { AudioLogFactoryInterface }
 */
export class AudioLogFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioLogFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioLogFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioLogFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AudioLogComponent } component
   * @param { !number } componentId
   * @param { !AudioLogPendingReceiver } audioLogReceiver
   */

  createAudioLog(
      component,
      componentId,
      audioLogReceiver) {
    this.proxy.sendMessage(
        0,
        AudioLogFactory_CreateAudioLog_ParamsSpec.$,
        null,
        [
          component,
          componentId,
          audioLogReceiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioLogFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioLogFactoryReceiver {
  /**
   * @param {!AudioLogFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioLogFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioLogFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioLogFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioLogFactory_CreateAudioLog_ParamsSpec.$,
        null,
        impl.createAudioLog.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioLogFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioLogFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioLogFactoryRemote}
   */
  static getRemote() {
    let remote = new AudioLogFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioLogFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioLogFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioLogFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioLogFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createAudioLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioLogFactory_CreateAudioLog_ParamsSpec.$,
        null,
        this.createAudioLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioLog_OnCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioLog_OnStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioLog_OnStopped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioLog_OnClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioLog_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioLog_OnSetVolume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioLog_OnProcessingStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioLog_OnLogMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioLogFactory_CreateAudioLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AudioLog_OnCreated_ParamsSpec.$,
    'AudioLog_OnCreated_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        media_mojom_AudioParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioLog_OnCreated_Params {
  constructor() {
    /** @type { !media_mojom_AudioParameters } */
    this.params;
    /** @type { !string } */
    this.deviceId;
  }
}



mojo.internal.Struct(
    AudioLog_OnStarted_ParamsSpec.$,
    'AudioLog_OnStarted_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioLog_OnStarted_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioLog_OnStopped_ParamsSpec.$,
    'AudioLog_OnStopped_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioLog_OnStopped_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioLog_OnClosed_ParamsSpec.$,
    'AudioLog_OnClosed_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioLog_OnClosed_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioLog_OnError_ParamsSpec.$,
    'AudioLog_OnError_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioLog_OnError_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioLog_OnSetVolume_ParamsSpec.$,
    'AudioLog_OnSetVolume_Params',
    [
      mojo.internal.StructField(
        'volume', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioLog_OnSetVolume_Params {
  constructor() {
    /** @type { !number } */
    this.volume;
  }
}



mojo.internal.Struct(
    AudioLog_OnProcessingStateChanged_ParamsSpec.$,
    'AudioLog_OnProcessingStateChanged_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioLog_OnProcessingStateChanged_Params {
  constructor() {
    /** @type { !string } */
    this.message;
  }
}



mojo.internal.Struct(
    AudioLog_OnLogMessage_ParamsSpec.$,
    'AudioLog_OnLogMessage_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioLog_OnLogMessage_Params {
  constructor() {
    /** @type { !string } */
    this.message;
  }
}



mojo.internal.Struct(
    AudioLogFactory_CreateAudioLog_ParamsSpec.$,
    'AudioLogFactory_CreateAudioLog_Params',
    [
      mojo.internal.StructField(
        'component', 0,
        0,
        AudioLogComponentSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'componentId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioLogReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(AudioLogPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioLogFactory_CreateAudioLog_Params {
  constructor() {
    /** @type { !AudioLogComponent } */
    this.component;
    /** @type { !number } */
    this.componentId;
    /** @type { !AudioLogPendingReceiver } */
    this.audioLogReceiver;
  }
}

