// media/mojo/mojom/audio_input_stream.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.InputStreamErrorCode');






goog.provide('media.mojom.AudioInputStream');
goog.provide('media.mojom.AudioInputStreamReceiver');
goog.provide('media.mojom.AudioInputStreamCallbackRouter');
goog.provide('media.mojom.AudioInputStreamInterface');
goog.provide('media.mojom.AudioInputStreamRemote');
goog.provide('media.mojom.AudioInputStreamPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioInputStreamPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioInputStream.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.AudioInputStreamInterface = class {
  
  /**
   */

  record() {}
  
  /**
   * @param { !number } volume
   */

  setVolume(volume) {}
};

/**
 * @export
 * @implements { media.mojom.AudioInputStreamInterface }
 */
media.mojom.AudioInputStreamRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioInputStreamPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioInputStreamPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioInputStreamPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  record() {
    this.proxy.sendMessage(
        0,
        media.mojom.AudioInputStream_Record_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } volume
   */

  setVolume(
      volume) {
    this.proxy.sendMessage(
        1,
        media.mojom.AudioInputStream_SetVolume_ParamsSpec.$,
        null,
        [
          volume
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioInputStream
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioInputStreamReceiver = class {
  /**
   * @param {!media.mojom.AudioInputStreamInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioInputStreamRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioInputStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioInputStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioInputStream_Record_ParamsSpec.$,
        null,
        impl.record.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioInputStream_SetVolume_ParamsSpec.$,
        null,
        impl.setVolume.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioInputStream = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioInputStream";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioInputStreamRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioInputStreamRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioInputStream
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioInputStreamCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioInputStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioInputStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.record =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioInputStream_Record_ParamsSpec.$,
        null,
        this.record.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVolume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioInputStream_SetVolume_ParamsSpec.$,
        null,
        this.setVolume.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.AudioInputStreamClient');
goog.provide('media.mojom.AudioInputStreamClientReceiver');
goog.provide('media.mojom.AudioInputStreamClientCallbackRouter');
goog.provide('media.mojom.AudioInputStreamClientInterface');
goog.provide('media.mojom.AudioInputStreamClientRemote');
goog.provide('media.mojom.AudioInputStreamClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioInputStreamClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioInputStreamClient.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.AudioInputStreamClientInterface = class {
  
  /**
   * @param { !media.mojom.InputStreamErrorCode } code
   */

  onError(code) {}
  
  /**
   * @param { !boolean } isMuted
   */

  onMutedStateChanged(isMuted) {}
};

/**
 * @export
 * @implements { media.mojom.AudioInputStreamClientInterface }
 */
media.mojom.AudioInputStreamClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioInputStreamClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioInputStreamClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioInputStreamClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.InputStreamErrorCode } code
   */

  onError(
      code) {
    this.proxy.sendMessage(
        0,
        media.mojom.AudioInputStreamClient_OnError_ParamsSpec.$,
        null,
        [
          code
        ],
        false);
  }

  
  /**
   * @param { !boolean } isMuted
   */

  onMutedStateChanged(
      isMuted) {
    this.proxy.sendMessage(
        1,
        media.mojom.AudioInputStreamClient_OnMutedStateChanged_ParamsSpec.$,
        null,
        [
          isMuted
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioInputStreamClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioInputStreamClientReceiver = class {
  /**
   * @param {!media.mojom.AudioInputStreamClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioInputStreamClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioInputStreamClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioInputStreamClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioInputStreamClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioInputStreamClient_OnMutedStateChanged_ParamsSpec.$,
        null,
        impl.onMutedStateChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioInputStreamClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioInputStreamClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioInputStreamClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioInputStreamClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioInputStreamClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioInputStreamClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioInputStreamClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioInputStreamClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioInputStreamClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMutedStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioInputStreamClient_OnMutedStateChanged_ParamsSpec.$,
        null,
        this.onMutedStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.AudioInputStreamObserver');
goog.provide('media.mojom.AudioInputStreamObserverReceiver');
goog.provide('media.mojom.AudioInputStreamObserverCallbackRouter');
goog.provide('media.mojom.AudioInputStreamObserverInterface');
goog.provide('media.mojom.AudioInputStreamObserverRemote');
goog.provide('media.mojom.AudioInputStreamObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioInputStreamObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioInputStreamObserver.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.AudioInputStreamObserverInterface = class {
  
  /**
   */

  didStartRecording() {}
};

/**
 * @export
 * @implements { media.mojom.AudioInputStreamObserverInterface }
 */
media.mojom.AudioInputStreamObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioInputStreamObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioInputStreamObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioInputStreamObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  didStartRecording() {
    this.proxy.sendMessage(
        0,
        media.mojom.AudioInputStreamObserver_DidStartRecording_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioInputStreamObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioInputStreamObserverReceiver = class {
  /**
   * @param {!media.mojom.AudioInputStreamObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioInputStreamObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioInputStreamObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioInputStreamObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioInputStreamObserver_DidStartRecording_ParamsSpec.$,
        null,
        impl.didStartRecording.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioInputStreamObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioInputStreamObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioInputStreamObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioInputStreamObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};

goog.provide('media.mojom.AudioInputStreamObserver_DisconnectReason');
goog.provide('media.mojom.AudioInputStreamObserver.DisconnectReasonSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.AudioInputStreamObserver.DisconnectReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.AudioInputStreamObserver_DisconnectReason = {
  
  kDefault: 0,
  kPlatformError: 1,
  kTerminatedByClient: 2,
  kStreamCreationFailed: 3,
  kDocumentDestroyed: 4,
  kSystemPermissions: 5,
  kDeviceInUse: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};

/**
 * An object which receives request messages for the AudioInputStreamObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioInputStreamObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioInputStreamObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioInputStreamObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStartRecording =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioInputStreamObserver_DidStartRecording_ParamsSpec.$,
        null,
        this.didStartRecording.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.AudioInputStream_Record_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioInputStream_Record_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioInputStream_SetVolume_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioInputStream_SetVolume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioInputStreamClient_OnError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioInputStreamClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioInputStreamClient_OnMutedStateChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioInputStreamClient_OnMutedStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioInputStreamObserver_DidStartRecording_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioInputStreamObserver_DidStartRecording_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.AudioInputStream_Record_ParamsSpec.$,
    'AudioInputStream_Record_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.AudioInputStream_Record_Params');

/** @record */
media.mojom.AudioInputStream_Record_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.AudioInputStream_SetVolume_ParamsSpec.$,
    'AudioInputStream_SetVolume_Params',
    [
      mojo.internal.StructField(
        'volume', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.AudioInputStream_SetVolume_Params');

/** @record */
media.mojom.AudioInputStream_SetVolume_Params = class {
  constructor() {
    /** @export { !number } */
    this.volume;
  }
};



mojo.internal.Struct(
    media.mojom.AudioInputStreamClient_OnError_ParamsSpec.$,
    'AudioInputStreamClient_OnError_Params',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        media.mojom.InputStreamErrorCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.AudioInputStreamClient_OnError_Params');

/** @record */
media.mojom.AudioInputStreamClient_OnError_Params = class {
  constructor() {
    /** @export { !media.mojom.InputStreamErrorCode } */
    this.code;
  }
};



mojo.internal.Struct(
    media.mojom.AudioInputStreamClient_OnMutedStateChanged_ParamsSpec.$,
    'AudioInputStreamClient_OnMutedStateChanged_Params',
    [
      mojo.internal.StructField(
        'isMuted', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.AudioInputStreamClient_OnMutedStateChanged_Params');

/** @record */
media.mojom.AudioInputStreamClient_OnMutedStateChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isMuted;
  }
};



mojo.internal.Struct(
    media.mojom.AudioInputStreamObserver_DidStartRecording_ParamsSpec.$,
    'AudioInputStreamObserver_DidStartRecording_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.AudioInputStreamObserver_DidStartRecording_Params');

/** @record */
media.mojom.AudioInputStreamObserver_DidStartRecording_Params = class {
  constructor() {
  }
};

