// media/mojo/mojom/audio_encoder.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_ENCODER_MOJOM_H_
#define MEDIA_MOJO_MOJOM_AUDIO_ENCODER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/audio_encoder.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_encoder.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_encoder.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom.h"
#include "media/mojo/mojom/audio_parameters.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "media/mojo/mojom/audio_encoder_config_mojom_traits.h"
#include "media/mojo/mojom/encoded_audio_buffer_traits.h"




namespace media::mojom {

class AudioEncoderProxy;

template <typename ImplRefTraits>
class AudioEncoderStub;

class AudioEncoderRequestValidator;
class AudioEncoderResponseValidator;


class AudioEncoder
    : public AudioEncoderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.AudioEncoder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioEncoderInterfaceBase;
  using Proxy_ = AudioEncoderProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioEncoderStub<ImplRefTraits>;

  using RequestValidator_ = AudioEncoderRequestValidator;
  using ResponseValidator_ = AudioEncoderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitializeMinVersion = 0,
    kEncodeMinVersion = 0,
    kFlushMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Initialize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Encode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Flush_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioEncoder() = default;

  using InitializeCallback = base::OnceCallback<void(const ::media::EncoderStatus&)>;
  using InitializeMojoCallback = base::OnceCallback<void(const ::media::EncoderStatus&)>;

  virtual void Initialize(::mojo::PendingAssociatedRemote<AudioEncoderClient> client, const ::media::AudioEncoder::Options& config, InitializeCallback callback) = 0;

  using EncodeCallback = base::OnceCallback<void(const ::media::EncoderStatus&)>;
  using EncodeMojoCallback = base::OnceCallback<void(const ::media::EncoderStatus&)>;

  virtual void Encode(::media::mojom::AudioBufferPtr buffer, EncodeCallback callback) = 0;

  using FlushCallback = base::OnceCallback<void(const ::media::EncoderStatus&)>;
  using FlushMojoCallback = base::OnceCallback<void(const ::media::EncoderStatus&)>;

  virtual void Flush(FlushCallback callback) = 0;
};

class AudioEncoderClientProxy;

template <typename ImplRefTraits>
class AudioEncoderClientStub;

class AudioEncoderClientRequestValidator;


class AudioEncoderClient
    : public AudioEncoderClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.AudioEncoderClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioEncoderClientInterfaceBase;
  using Proxy_ = AudioEncoderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioEncoderClientStub<ImplRefTraits>;

  using RequestValidator_ = AudioEncoderClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnEncodedBufferReadyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnEncodedBufferReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioEncoderClient() = default;

  virtual void OnEncodedBufferReady(::media::EncodedAudioBuffer buffer, const std::vector<uint8_t>& description) = 0;
};



class  AudioEncoderProxy
    : public AudioEncoder {
 public:
  using InterfaceType = AudioEncoder;

  explicit AudioEncoderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Initialize(::mojo::PendingAssociatedRemote<AudioEncoderClient> client, const ::media::AudioEncoder::Options& config, InitializeCallback callback) final;
  
  void Encode(::media::mojom::AudioBufferPtr buffer, EncodeCallback callback) final;
  
  void Flush(FlushCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AudioEncoderClientProxy
    : public AudioEncoderClient {
 public:
  using InterfaceType = AudioEncoderClient;

  explicit AudioEncoderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnEncodedBufferReady(::media::EncodedAudioBuffer buffer, const std::vector<uint8_t>& description) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AudioEncoderStubDispatch {
 public:
  static bool Accept(AudioEncoder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioEncoder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioEncoder>>
class AudioEncoderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioEncoderStub() = default;
  ~AudioEncoderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioEncoderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioEncoderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioEncoderClientStubDispatch {
 public:
  static bool Accept(AudioEncoderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioEncoderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioEncoderClient>>
class AudioEncoderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioEncoderClientStub() = default;
  ~AudioEncoderClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioEncoderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioEncoderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioEncoderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AudioEncoderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AudioEncoderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  AacAudioEncoderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AacAudioEncoderConfig, T>::value>;
  using DataView = AacAudioEncoderConfigDataView;
  using Data_ = internal::AacAudioEncoderConfig_Data;

  template <typename... Args>
  static AacAudioEncoderConfigPtr New(Args&&... args) {
    return AacAudioEncoderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AacAudioEncoderConfigPtr From(const U& u) {
    return mojo::TypeConverter<AacAudioEncoderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AacAudioEncoderConfig>::Convert(*this);
  }


  AacAudioEncoderConfig();

  explicit AacAudioEncoderConfig(
      AacOutputFormat format);


  ~AacAudioEncoderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AacAudioEncoderConfigPtr>
  AacAudioEncoderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AacAudioEncoderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AacAudioEncoderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AacAudioEncoderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AacAudioEncoderConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AacAudioEncoderConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AacAudioEncoderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AacAudioEncoderConfig_UnserializedMessageContext<
            UserType, AacAudioEncoderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AacAudioEncoderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AacAudioEncoderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AacAudioEncoderConfig_UnserializedMessageContext<
            UserType, AacAudioEncoderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AacAudioEncoderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AacOutputFormat format;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AacAudioEncoderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AacAudioEncoderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AacAudioEncoderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AacAudioEncoderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  AudioEncoderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioEncoderConfig, T>::value>;
  using DataView = AudioEncoderConfigDataView;
  using Data_ = internal::AudioEncoderConfig_Data;

  template <typename... Args>
  static AudioEncoderConfigPtr New(Args&&... args) {
    return AudioEncoderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioEncoderConfigPtr From(const U& u) {
    return mojo::TypeConverter<AudioEncoderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioEncoderConfig>::Convert(*this);
  }


  AudioEncoderConfig();

  AudioEncoderConfig(
      ::media::AudioCodec codec,
      uint8_t channel_count,
      uint32_t sample_rate,
      uint32_t bitrate,
      AacAudioEncoderConfigPtr aac);

AudioEncoderConfig(const AudioEncoderConfig&) = delete;
AudioEncoderConfig& operator=(const AudioEncoderConfig&) = delete;

  ~AudioEncoderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioEncoderConfigPtr>
  AudioEncoderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioEncoderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioEncoderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioEncoderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioEncoderConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioEncoderConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioEncoderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioEncoderConfig_UnserializedMessageContext<
            UserType, AudioEncoderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioEncoderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioEncoderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioEncoderConfig_UnserializedMessageContext<
            UserType, AudioEncoderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioEncoderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::AudioCodec codec;
  
  uint8_t channel_count;
  
  uint32_t sample_rate;
  
  uint32_t bitrate;
  
  AacAudioEncoderConfigPtr aac;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioEncoderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioEncoderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioEncoderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioEncoderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  EncodedAudioBuffer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EncodedAudioBuffer, T>::value>;
  using DataView = EncodedAudioBufferDataView;
  using Data_ = internal::EncodedAudioBuffer_Data;

  template <typename... Args>
  static EncodedAudioBufferPtr New(Args&&... args) {
    return EncodedAudioBufferPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EncodedAudioBufferPtr From(const U& u) {
    return mojo::TypeConverter<EncodedAudioBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EncodedAudioBuffer>::Convert(*this);
  }


  EncodedAudioBuffer();

  EncodedAudioBuffer(
      const ::media::AudioParameters& params,
      ::base::TimeDelta timestamp,
      ::base::TimeDelta duration,
      std::vector<uint8_t> data);


  ~EncodedAudioBuffer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EncodedAudioBufferPtr>
  EncodedAudioBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EncodedAudioBuffer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EncodedAudioBuffer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EncodedAudioBuffer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EncodedAudioBuffer::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EncodedAudioBuffer::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EncodedAudioBuffer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EncodedAudioBuffer_UnserializedMessageContext<
            UserType, EncodedAudioBuffer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EncodedAudioBuffer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EncodedAudioBuffer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EncodedAudioBuffer_UnserializedMessageContext<
            UserType, EncodedAudioBuffer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EncodedAudioBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::AudioParameters params;
  
  ::base::TimeDelta timestamp;
  
  ::base::TimeDelta duration;
  
  std::vector<uint8_t> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EncodedAudioBuffer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EncodedAudioBuffer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EncodedAudioBuffer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EncodedAudioBuffer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AacAudioEncoderConfigPtr AacAudioEncoderConfig::Clone() const {
  return New(
      mojo::Clone(format)
  );
}

template <typename T, AacAudioEncoderConfig::EnableIfSame<T>*>
bool AacAudioEncoderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->format, other_struct.format))
    return false;
  return true;
}

template <typename T, AacAudioEncoderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.format < rhs.format)
    return true;
  if (rhs.format < lhs.format)
    return false;
  return false;
}
template <typename StructPtrType>
AudioEncoderConfigPtr AudioEncoderConfig::Clone() const {
  return New(
      mojo::Clone(codec),
      mojo::Clone(channel_count),
      mojo::Clone(sample_rate),
      mojo::Clone(bitrate),
      mojo::Clone(aac)
  );
}

template <typename T, AudioEncoderConfig::EnableIfSame<T>*>
bool AudioEncoderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->codec, other_struct.codec))
    return false;
  if (!mojo::Equals(this->channel_count, other_struct.channel_count))
    return false;
  if (!mojo::Equals(this->sample_rate, other_struct.sample_rate))
    return false;
  if (!mojo::Equals(this->bitrate, other_struct.bitrate))
    return false;
  if (!mojo::Equals(this->aac, other_struct.aac))
    return false;
  return true;
}

template <typename T, AudioEncoderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.codec < rhs.codec)
    return true;
  if (rhs.codec < lhs.codec)
    return false;
  if (lhs.channel_count < rhs.channel_count)
    return true;
  if (rhs.channel_count < lhs.channel_count)
    return false;
  if (lhs.sample_rate < rhs.sample_rate)
    return true;
  if (rhs.sample_rate < lhs.sample_rate)
    return false;
  if (lhs.bitrate < rhs.bitrate)
    return true;
  if (rhs.bitrate < lhs.bitrate)
    return false;
  if (lhs.aac < rhs.aac)
    return true;
  if (rhs.aac < lhs.aac)
    return false;
  return false;
}
template <typename StructPtrType>
EncodedAudioBufferPtr EncodedAudioBuffer::Clone() const {
  return New(
      mojo::Clone(params),
      mojo::Clone(timestamp),
      mojo::Clone(duration),
      mojo::Clone(data)
  );
}

template <typename T, EncodedAudioBuffer::EnableIfSame<T>*>
bool EncodedAudioBuffer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, EncodedAudioBuffer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.params < rhs.params)
    return true;
  if (rhs.params < lhs.params)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.duration < rhs.duration)
    return true;
  if (rhs.duration < lhs.duration)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::AacAudioEncoderConfig::DataView,
                                         ::media::mojom::AacAudioEncoderConfigPtr> {
  static bool IsNull(const ::media::mojom::AacAudioEncoderConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::AacAudioEncoderConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::AacAudioEncoderConfig::format) format(
      const ::media::mojom::AacAudioEncoderConfigPtr& input) {
    return input->format;
  }

  static bool Read(::media::mojom::AacAudioEncoderConfig::DataView input, ::media::mojom::AacAudioEncoderConfigPtr* output);
};


template <>
struct  StructTraits<::media::mojom::AudioEncoderConfig::DataView,
                                         ::media::mojom::AudioEncoderConfigPtr> {
  static bool IsNull(const ::media::mojom::AudioEncoderConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::AudioEncoderConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::AudioEncoderConfig::codec) codec(
      const ::media::mojom::AudioEncoderConfigPtr& input) {
    return input->codec;
  }

  static decltype(::media::mojom::AudioEncoderConfig::channel_count) channel_count(
      const ::media::mojom::AudioEncoderConfigPtr& input) {
    return input->channel_count;
  }

  static decltype(::media::mojom::AudioEncoderConfig::sample_rate) sample_rate(
      const ::media::mojom::AudioEncoderConfigPtr& input) {
    return input->sample_rate;
  }

  static decltype(::media::mojom::AudioEncoderConfig::bitrate) bitrate(
      const ::media::mojom::AudioEncoderConfigPtr& input) {
    return input->bitrate;
  }

  static const decltype(::media::mojom::AudioEncoderConfig::aac)& aac(
      const ::media::mojom::AudioEncoderConfigPtr& input) {
    return input->aac;
  }

  static bool Read(::media::mojom::AudioEncoderConfig::DataView input, ::media::mojom::AudioEncoderConfigPtr* output);
};


template <>
struct  StructTraits<::media::mojom::EncodedAudioBuffer::DataView,
                                         ::media::mojom::EncodedAudioBufferPtr> {
  static bool IsNull(const ::media::mojom::EncodedAudioBufferPtr& input) { return !input; }
  static void SetToNull(::media::mojom::EncodedAudioBufferPtr* output) { output->reset(); }

  static const decltype(::media::mojom::EncodedAudioBuffer::params)& params(
      const ::media::mojom::EncodedAudioBufferPtr& input) {
    return input->params;
  }

  static const decltype(::media::mojom::EncodedAudioBuffer::timestamp)& timestamp(
      const ::media::mojom::EncodedAudioBufferPtr& input) {
    return input->timestamp;
  }

  static const decltype(::media::mojom::EncodedAudioBuffer::duration)& duration(
      const ::media::mojom::EncodedAudioBufferPtr& input) {
    return input->duration;
  }

  static const decltype(::media::mojom::EncodedAudioBuffer::data)& data(
      const ::media::mojom::EncodedAudioBufferPtr& input) {
    return input->data;
  }

  static bool Read(::media::mojom::EncodedAudioBuffer::DataView input, ::media::mojom::EncodedAudioBufferPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_AUDIO_ENCODER_MOJOM_H_