// media/mojo/mojom/audio_decoder.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_TEST_UTILS_H_

#include "media/mojo/mojom/audio_decoder.mojom.h"


namespace media::mojom {


class  AudioDecoderInterceptorForTesting : public AudioDecoder {
  virtual AudioDecoder* GetForwardingInterface() = 0;
  void GetSupportedConfigs(GetSupportedConfigsCallback callback) override;
  void Construct(::mojo::PendingAssociatedRemote<AudioDecoderClient> client, ::mojo::PendingRemote<::media::mojom::MediaLog> media_log) override;
  void Initialize(const ::media::AudioDecoderConfig& config, const std::optional<::base::UnguessableToken>& cdm_id, InitializeCallback callback) override;
  void SetDataSource(::mojo::ScopedDataPipeConsumerHandle receive_pipe) override;
  void Decode(::media::mojom::DecoderBufferPtr buffer, DecodeCallback callback) override;
  void Reset(ResetCallback callback) override;
};
class  AudioDecoderAsyncWaiter {
 public:
  explicit AudioDecoderAsyncWaiter(AudioDecoder* proxy);

  AudioDecoderAsyncWaiter(const AudioDecoderAsyncWaiter&) = delete;
  AudioDecoderAsyncWaiter& operator=(const AudioDecoderAsyncWaiter&) = delete;

  ~AudioDecoderAsyncWaiter();
  void GetSupportedConfigs(
      std::vector<::media::SupportedAudioDecoderConfig>* out_supported_configs);
  std::vector<::media::SupportedAudioDecoderConfig> GetSupportedConfigs();
  void Initialize(
      const ::media::AudioDecoderConfig& config, const std::optional<::base::UnguessableToken>& cdm_id, ::media::DecoderStatus* out_success, bool* out_needs_bitstream_conversion, ::media::AudioDecoderType* out_decoder_type);
  
  void Decode(
      ::media::mojom::DecoderBufferPtr buffer, ::media::DecoderStatus* out_status);
  ::media::DecoderStatus Decode(::media::mojom::DecoderBufferPtr buffer);
  void Reset(
      );
  

 private:
  AudioDecoder* const proxy_;
};


class  AudioDecoderClientInterceptorForTesting : public AudioDecoderClient {
  virtual AudioDecoderClient* GetForwardingInterface() = 0;
  void OnBufferDecoded(::media::mojom::AudioBufferPtr buffer) override;
  void OnWaiting(::media::WaitingReason reason) override;
};
class  AudioDecoderClientAsyncWaiter {
 public:
  explicit AudioDecoderClientAsyncWaiter(AudioDecoderClient* proxy);

  AudioDecoderClientAsyncWaiter(const AudioDecoderClientAsyncWaiter&) = delete;
  AudioDecoderClientAsyncWaiter& operator=(const AudioDecoderClientAsyncWaiter&) = delete;

  ~AudioDecoderClientAsyncWaiter();

 private:
  AudioDecoderClient* const proxy_;
};




}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_TEST_UTILS_H_