// media/midi/midi_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MIDI_MIDI_SERVICE_MOJOM_TEST_UTILS_H_
#define MEDIA_MIDI_MIDI_SERVICE_MOJOM_TEST_UTILS_H_

#include "media/midi/midi_service.mojom.h"


namespace midi::mojom {


class  MidiSessionClientInterceptorForTesting : public MidiSessionClient {
  virtual MidiSessionClient* GetForwardingInterface() = 0;
  void AddInputPort(PortInfoPtr info) override;
  void AddOutputPort(PortInfoPtr info) override;
  void SetInputPortState(uint32_t port, PortState state) override;
  void SetOutputPortState(uint32_t port, PortState state) override;
  void SessionStarted(Result result) override;
  void AcknowledgeSentData(uint32_t bytes) override;
  void DataReceived(uint32_t port, const std::vector<uint8_t>& data, ::base::TimeTicks timestamp) override;
};
class  MidiSessionClientAsyncWaiter {
 public:
  explicit MidiSessionClientAsyncWaiter(MidiSessionClient* proxy);

  MidiSessionClientAsyncWaiter(const MidiSessionClientAsyncWaiter&) = delete;
  MidiSessionClientAsyncWaiter& operator=(const MidiSessionClientAsyncWaiter&) = delete;

  ~MidiSessionClientAsyncWaiter();

 private:
  MidiSessionClient* const proxy_;
};


class  MidiSessionProviderInterceptorForTesting : public MidiSessionProvider {
  virtual MidiSessionProvider* GetForwardingInterface() = 0;
  void StartSession(::mojo::PendingReceiver<MidiSession> receiver, ::mojo::PendingRemote<MidiSessionClient> client) override;
};
class  MidiSessionProviderAsyncWaiter {
 public:
  explicit MidiSessionProviderAsyncWaiter(MidiSessionProvider* proxy);

  MidiSessionProviderAsyncWaiter(const MidiSessionProviderAsyncWaiter&) = delete;
  MidiSessionProviderAsyncWaiter& operator=(const MidiSessionProviderAsyncWaiter&) = delete;

  ~MidiSessionProviderAsyncWaiter();

 private:
  MidiSessionProvider* const proxy_;
};


class  MidiSessionInterceptorForTesting : public MidiSession {
  virtual MidiSession* GetForwardingInterface() = 0;
  void SendData(uint32_t port, const std::vector<uint8_t>& data, ::base::TimeTicks timestamp) override;
};
class  MidiSessionAsyncWaiter {
 public:
  explicit MidiSessionAsyncWaiter(MidiSession* proxy);

  MidiSessionAsyncWaiter(const MidiSessionAsyncWaiter&) = delete;
  MidiSessionAsyncWaiter& operator=(const MidiSessionAsyncWaiter&) = delete;

  ~MidiSessionAsyncWaiter();

 private:
  MidiSession* const proxy_;
};




}  // midi::mojom

#endif  // MEDIA_MIDI_MIDI_SERVICE_MOJOM_TEST_UTILS_H_