// media/capture/mojom/video_capture.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/capture/mojom/video_capture.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/capture/mojom/video_capture.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* VideoCaptureStateToStringHelper(VideoCaptureState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoCaptureState::STARTED:
      return "STARTED";
    case VideoCaptureState::PAUSED:
      return "PAUSED";
    case VideoCaptureState::RESUMED:
      return "RESUMED";
    case VideoCaptureState::STOPPED:
      return "STOPPED";
    case VideoCaptureState::ENDED:
      return "ENDED";
    default:
      return nullptr;
  }
}

std::string VideoCaptureStateToString(VideoCaptureState value) {
  const char *str = VideoCaptureStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoCaptureState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoCaptureState value) {
  return os << VideoCaptureStateToString(value);
}

namespace internal {
// static
bool VideoCaptureResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const VideoCaptureResult_Data* object = static_cast<const VideoCaptureResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case VideoCaptureResult_Tag::kState: {


      if (!::media::mojom::internal::VideoCaptureState_Data
            ::Validate(object->data.f_state, validation_context))
        return false;
      return true;
    }
    case VideoCaptureResult_Tag::kErrorCode: {


      if (!::media::mojom::internal::VideoCaptureError_Data
            ::Validate(object->data.f_error_code, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in VideoCaptureResult");
      return false;
    }
  }
}


// static
bool VideoCaptureObserver_OnStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureObserver_OnStateChanged_Params_Data* object =
      static_cast<const VideoCaptureObserver_OnStateChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

VideoCaptureObserver_OnStateChanged_Params_Data::VideoCaptureObserver_OnStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureObserver_OnNewBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureObserver_OnNewBuffer_Params_Data* object =
      static_cast<const VideoCaptureObserver_OnNewBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->buffer_handle, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->buffer_handle, validation_context))
    return false;

  return true;
}

VideoCaptureObserver_OnNewBuffer_Params_Data::VideoCaptureObserver_OnNewBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureObserver_OnBufferReady_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureObserver_OnBufferReady_Params_Data* object =
      static_cast<const VideoCaptureObserver_OnBufferReady_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer, validation_context))
    return false;

  return true;
}

VideoCaptureObserver_OnBufferReady_Params_Data::VideoCaptureObserver_OnBufferReady_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureObserver_OnBufferDestroyed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureObserver_OnBufferDestroyed_Params_Data* object =
      static_cast<const VideoCaptureObserver_OnBufferDestroyed_Params_Data*>(data);

  return true;
}

VideoCaptureObserver_OnBufferDestroyed_Params_Data::VideoCaptureObserver_OnBufferDestroyed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureObserver_OnFrameDropped_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureObserver_OnFrameDropped_Params_Data* object =
      static_cast<const VideoCaptureObserver_OnFrameDropped_Params_Data*>(data);


  if (!::media::mojom::internal::VideoCaptureFrameDropReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

VideoCaptureObserver_OnFrameDropped_Params_Data::VideoCaptureObserver_OnFrameDropped_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureObserver_OnNewCaptureVersion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureObserver_OnNewCaptureVersion_Params_Data* object =
      static_cast<const VideoCaptureObserver_OnNewCaptureVersion_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->capture_version, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->capture_version, validation_context))
    return false;

  return true;
}

VideoCaptureObserver_OnNewCaptureVersion_Params_Data::VideoCaptureObserver_OnNewCaptureVersion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_Start_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureHost_Start_Params_Data* object =
      static_cast<const VideoCaptureHost_Start_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoCaptureHost_Start_Params_Data::VideoCaptureHost_Start_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_Stop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureHost_Stop_Params_Data* object =
      static_cast<const VideoCaptureHost_Stop_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  return true;
}

VideoCaptureHost_Stop_Params_Data::VideoCaptureHost_Stop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_Pause_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureHost_Pause_Params_Data* object =
      static_cast<const VideoCaptureHost_Pause_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  return true;
}

VideoCaptureHost_Pause_Params_Data::VideoCaptureHost_Pause_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_Resume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureHost_Resume_Params_Data* object =
      static_cast<const VideoCaptureHost_Resume_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

VideoCaptureHost_Resume_Params_Data::VideoCaptureHost_Resume_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_RequestRefreshFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureHost_RequestRefreshFrame_Params_Data* object =
      static_cast<const VideoCaptureHost_RequestRefreshFrame_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  return true;
}

VideoCaptureHost_RequestRefreshFrame_Params_Data::VideoCaptureHost_RequestRefreshFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_ReleaseBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureHost_ReleaseBuffer_Params_Data* object =
      static_cast<const VideoCaptureHost_ReleaseBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->feedback, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->feedback, validation_context))
    return false;

  return true;
}

VideoCaptureHost_ReleaseBuffer_Params_Data::VideoCaptureHost_ReleaseBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_GetDeviceSupportedFormats_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureHost_GetDeviceSupportedFormats_Params_Data* object =
      static_cast<const VideoCaptureHost_GetDeviceSupportedFormats_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_id, validation_context))
    return false;

  return true;
}

VideoCaptureHost_GetDeviceSupportedFormats_Params_Data::VideoCaptureHost_GetDeviceSupportedFormats_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data* object =
      static_cast<const VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->formats_supported, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& formats_supported_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->formats_supported, validation_context,
                                         &formats_supported_validate_params)) {
    return false;
  }

  return true;
}

VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data::VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_GetDeviceFormatsInUse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureHost_GetDeviceFormatsInUse_Params_Data* object =
      static_cast<const VideoCaptureHost_GetDeviceFormatsInUse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_id, validation_context))
    return false;

  return true;
}

VideoCaptureHost_GetDeviceFormatsInUse_Params_Data::VideoCaptureHost_GetDeviceFormatsInUse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data* object =
      static_cast<const VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->formats_in_use, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& formats_in_use_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->formats_in_use, validation_context,
                                         &formats_in_use_validate_params)) {
    return false;
  }

  return true;
}

VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data::VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_OnLog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureHost_OnLog_Params_Data* object =
      static_cast<const VideoCaptureHost_OnLog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

VideoCaptureHost_OnLog_Params_Data::VideoCaptureHost_OnLog_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCaptureState>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoCaptureState value) {
  return std::move(context).WriteString(::media::mojom::VideoCaptureStateToString(value));
}

} // namespace perfetto